/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.metatree;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.das2.qds.QDataSet;
import org.das2.qds.util.PropertiesTreeModel;

public class NameValueTreeModel
implements TreeModel {
    final Object root;
    List nodes;

    static Object createNode(String name, Object value) {
        if (value == null) {
            return new StringPropertyNode(name, "null");
        }
        if (value.getClass().isArray()) {
            return new ArrayPropertyNode(name, value);
        }
        if (value instanceof String) {
            String svalue = (String)value;
            if (svalue.length() > 800) {
                svalue = svalue.substring(0, 797) + "...";
            }
            return new StringPropertyNode(name, svalue);
        }
        if (value instanceof Map) {
            return new MapPropertyNode(name, (Map)value);
        }
        if (value instanceof QDataSet) {
            PropertiesTreeModel model = new PropertiesTreeModel((QDataSet)value, 100);
            return new TreeNodeAdapter(name, (javax.swing.tree.TreeNode)model.getRoot());
        }
        return new StringPropertyNode(name, String.valueOf(value));
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (parent == this.root) {
            return this.nodes.get(index);
        }
        TreeNode p = (TreeNode)parent;
        return p.getChild(index);
    }

    @Override
    public int getChildCount(Object parent) {
        if (parent == this.root) {
            return this.nodes.size();
        }
        TreeNode p = (TreeNode)parent;
        return p.childCount();
    }

    @Override
    public boolean isLeaf(Object parent) {
        if (parent == this.root) {
            return false;
        }
        if (parent instanceof TreeNode) {
            TreeNode p = (TreeNode)parent;
            return p.isLeaf();
        }
        return true;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return 0;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
    }

    private NameValueTreeModel(Object root, List nodes) {
        this.nodes = nodes;
        this.root = root;
    }

    public static NameValueTreeModel create(Object root, List names, List values) {
        ArrayList<Object> nodes = new ArrayList<Object>(names.size());
        for (int i = 0; i < names.size(); ++i) {
            nodes.add(NameValueTreeModel.createNode((String)names.get(i), values.get(i)));
        }
        return new NameValueTreeModel(root, nodes);
    }

    public static NameValueTreeModel create(Object root, Map map) {
        ArrayList<Object> nodes;
        if (map != null) {
            nodes = new ArrayList<Object>(map.size());
            for (Map.Entry e : map.entrySet()) {
                nodes.add(NameValueTreeModel.createNode(String.valueOf(e.getKey()), e.getValue()));
            }
        } else {
            nodes = Collections.EMPTY_LIST;
        }
        return new NameValueTreeModel(root, nodes);
    }

    public String toString() {
        return String.valueOf(this.root) + "(" + this.nodes.size() + "key/value pairs)";
    }

    static class ArrayPropertyNode
    implements TreeNode {
        String name;
        Object value;
        boolean hasKids;

        ArrayPropertyNode(String name, Object value) {
            this.name = name;
            this.value = value;
            this.hasKids = true;
        }

        @Override
        public String toString() {
            return "" + this.name + "=[" + Array.getLength(this.value) + "]";
        }

        @Override
        public int childCount() {
            return Array.getLength(this.value);
        }

        @Override
        public Object getChild(int i) {
            return NameValueTreeModel.createNode("[" + i + "]", Array.get(this.value, i));
        }

        @Override
        public boolean isLeaf() {
            return !this.hasKids;
        }
    }

    static class MapPropertyNode
    implements TreeNode {
        String name;
        Map value;
        boolean hasKids;
        String[] keys;

        MapPropertyNode(String name, Map<String, Object> value) {
            this.name = name;
            this.value = value;
            this.keys = this.value.keySet().toArray(new String[value.size()]);
            this.hasKids = this.keys.length > 0;
        }

        @Override
        public String toString() {
            return "" + this.name;
        }

        @Override
        public int childCount() {
            return this.value.size();
        }

        @Override
        public Object getChild(int i) {
            String key = this.keys[i];
            return NameValueTreeModel.createNode(key, this.value.get(key));
        }

        @Override
        public boolean isLeaf() {
            return !this.hasKids;
        }
    }

    static class StringPropertyNode
    implements TreeNode {
        private static final int LINE_LEN = 133;
        String name;
        String value;
        List<Integer> splits;
        boolean hasKids;

        StringPropertyNode(String name, String value) {
            this.name = name;
            this.value = value = value.trim();
            if (value.length() > 133 || value.contains("\n")) {
                this.splits = new ArrayList<Integer>();
                int ii = 0;
                while (ii < value.length()) {
                    int i = value.indexOf(10, ii);
                    ii = i - ii > 133 || i == -1 ? (value.length() - ii < 133 ? value.length() : ((i = value.lastIndexOf(32, ii + 133)) == -1 ? (ii += 133) : (i > ii ? i + 1 : value.length()))) : i + 1;
                    if (ii >= value.length()) continue;
                    this.splits.add(ii);
                }
            }
            this.hasKids = this.splits != null;
        }

        @Override
        public String toString() {
            if (!this.hasKids) {
                return "" + this.name + "=" + this.value;
            }
            return "" + this.name + "=" + this.value.substring(0, this.splits.get(0)) + " ...";
        }

        @Override
        public int childCount() {
            return this.hasKids ? this.splits.size() + 1 : 0;
        }

        @Override
        public Object getChild(int i) {
            if (i == 0) {
                return this.value.substring(0, this.splits.get(i));
            }
            if (i == this.splits.size()) {
                return this.value.substring(this.splits.get(i - 1));
            }
            return this.value.substring(this.splits.get(i - 1), this.splits.get(i));
        }

        @Override
        public boolean isLeaf() {
            return !this.hasKids;
        }
    }

    public static interface TreeNode {
        public int childCount();

        public Object getChild(int var1);

        public boolean isLeaf();

        public String toString();
    }

    static class TreeNodeAdapter
    implements TreeNode {
        javax.swing.tree.TreeNode node;
        String name;

        TreeNodeAdapter(String name, javax.swing.tree.TreeNode node) {
            this.node = node;
            this.name = name;
        }

        @Override
        public int childCount() {
            return this.node.getChildCount();
        }

        @Override
        public Object getChild(int i) {
            return new TreeNodeAdapter(null, this.node.getChildAt(i));
        }

        @Override
        public boolean isLeaf() {
            return this.node.isLeaf();
        }

        @Override
        public String toString() {
            if (this.name != null) {
                return this.name + "=" + this.node.toString();
            }
            return this.node.toString();
        }
    }
}

