/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.metatree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.metatree.IstpMetadataModel;
import org.autoplot.metatree.SpaseMetadataModel;
import org.das2.datum.LoggerManager;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.w3c.dom.Node;

public class MetadataUtil {
    private static final Logger logger = LoggerManager.getLogger("apdss");

    public static Map<String, Object> toMetaTree(Node node) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            Object value = child.hasChildNodes() ? MetadataUtil.toMetaTree(child) : child.getNodeValue();
            result.put(child.getNodeName(), value);
        }
        return result;
    }

    public static Node getNode(Node node, String[] path) {
        int i = 0;
        Node child = node.getFirstChild();
        while (i < path.length) {
            if (child == null) {
                throw new IllegalArgumentException("couldn't find node");
            }
            if (child.getNodeName().equals(path[i])) {
                node = child;
                child = node.getFirstChild();
                ++i;
                continue;
            }
            child = child.getNextSibling();
        }
        return node;
    }

    public static Object getNode(Map<String, Object> tree, String[] path) {
        int i = 0;
        Object child = tree.get(path[0]);
        ++i;
        while (i < path.length) {
            if (child == null) {
                return null;
            }
            if (!(child instanceof Map)) {
                return null;
            }
            child = ((Map)child).get(path[i]);
            ++i;
        }
        return child;
    }

    public static Map<String, Object> sliceProperties(Map<String, Object> properties, int sliceDimension) {
        return DataSetOps.sliceProperties(properties, sliceDimension);
    }

    public static Map<String, Object> transposeProperties(Map<String, Object> properties) {
        String[] ss;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (String s : ss = DataSetUtil.dimensionProperties()) {
            Object val = properties.get(s);
            if (val == null) continue;
            result.put(s, val);
        }
        if (properties.get("DEPEND_0") != null) {
            result.put("DEPEND_1", properties.get("DEPEND_0"));
        }
        if (properties.get("DEPEND_1") != null) {
            result.put("DEPEND_0", properties.get("DEPEND_1"));
        }
        return result;
    }

    public static Map<String, Object> sprocess(String c, Map<String, Object> properties) {
        int i = c.indexOf(124);
        if (i > 0) {
            c = c.substring(i);
        }
        Scanner s = new Scanner(c);
        s.useDelimiter("[\\(\\),]");
        while (s.hasNext()) {
            String cmd = s.next();
            if (cmd.trim().length() == 0) continue;
            if (cmd.equals("|slices")) {
                Pattern skipPattern = Pattern.compile("\\':?\\'");
                ArrayList<Object> args = new ArrayList<Object>();
                while (s.hasNextInt() || s.hasNext(skipPattern)) {
                    if (s.hasNextInt()) {
                        args.add(s.nextInt());
                        continue;
                    }
                    args.add(s.next());
                }
                for (int idim = args.size() - 1; idim >= 0; --idim) {
                    if (!(args.get(idim) instanceof Integer)) continue;
                    properties = MetadataUtil.sliceProperties(properties, idim);
                }
                continue;
            }
            if (cmd.startsWith("|slice")) {
                int dim = cmd.charAt(6) - 48;
                s.next();
                properties = MetadataUtil.sliceProperties(properties, dim);
                continue;
            }
            if (cmd.startsWith("|collapse")) {
                int dim = cmd.charAt(9) - 48;
                properties = MetadataUtil.sliceProperties(properties, dim);
                if (!s.hasNextInt()) continue;
                int st = s.nextInt();
                int en = s.nextInt();
                logger.fine("not using st and en: " + st + "," + en);
                continue;
            }
            if (cmd.startsWith("|total") && cmd.length() == 7) {
                int dim = cmd.charAt(6) - 48;
                properties = MetadataUtil.sliceProperties(properties, dim);
                continue;
            }
            if (cmd.startsWith("|total") && cmd.length() == 6) {
                int dim = s.nextInt();
                properties = MetadataUtil.sliceProperties(properties, dim);
                continue;
            }
            if (cmd.startsWith("|collapse") && cmd.length() == 10) {
                int dim = cmd.charAt(9) - 48;
                properties = MetadataUtil.sliceProperties(properties, dim);
                continue;
            }
            if (cmd.equals("|autoHistogram")) {
                HashMap<String, Object> newproperties = new HashMap<String, Object>();
                newproperties.put("DEPEND_0", properties);
                properties = newproperties;
                continue;
            }
            if (cmd.equals("|transpose")) {
                properties = MetadataUtil.transposeProperties(properties);
                continue;
            }
            if (cmd.equals("|smooth") || cmd.equals("|trim") || cmd.equals("|detrend") || cmd.equals("|medianFilter") || cmd.equals("|nop") || cmd.equals("|copy")) continue;
            return new HashMap<String, Object>();
        }
        return properties;
    }

    public static MetadataModel getMetadataModel(String t) {
        if (t == null) {
            return null;
        }
        if (t.equals("ISTP-CDF")) {
            return new IstpMetadataModel();
        }
        if (t.equals("SPASE")) {
            return new SpaseMetadataModel();
        }
        return null;
    }
}

