/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.jythonsupport.JythonUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class Util {
    private static final Logger logger = LoggerManager.getLogger("jython");

    protected static Map<String, JythonUtil.Param> getParams(URI uri, ProgressMonitor mon) throws IOException {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String furi = params.containsKey("script") ? (String)params.get("script") : split.resourceUri.toString();
        File src = DataSetURI.getFile(furi, mon);
        List<JythonUtil.Param> r2 = JythonUtil.getGetParams(new FileReader(src));
        LinkedHashMap<String, JythonUtil.Param> result = new LinkedHashMap<String, JythonUtil.Param>();
        for (JythonUtil.Param r : r2) {
            result.put(r.name, r);
        }
        return result;
    }

    protected static Map<String, JythonUtil.Param> getParams(String src, ProgressMonitor mon) throws IOException {
        return Util.getParams(src, new HashMap<String, String>(), mon);
    }

    protected static Map<String, JythonUtil.Param> getParams(String src, Map<String, String> params, ProgressMonitor mon) throws IOException {
        return Util.getParams(null, src, params, mon);
    }

    public static Map<String, JythonUtil.Param> getParams(Map<String, Object> env, String src, Map<String, String> params, ProgressMonitor mon) throws IOException {
        logger.finer("enter getParams");
        List<JythonUtil.Param> r2 = JythonUtil.getGetParams(env, src, params);
        LinkedHashMap<String, JythonUtil.Param> result = new LinkedHashMap<String, JythonUtil.Param>();
        for (JythonUtil.Param r : r2) {
            result.put(r.name, r);
        }
        return result;
    }
}

