/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.WindowManager;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.util.PythonInterpreter;

public class ParametersFormPanel {
    FormData fd = new FormData();
    Map<String, String> params;
    private static final Logger logger = LoggerManager.getLogger("jython");

    private static boolean isBoolean(List<Object> parms) {
        return parms.size() == 2 && parms.contains("T") && parms.contains("F");
    }

    private static JComponent getSpacer() {
        JLabel spacer = new JLabel("  ");
        spacer.setSize(new Dimension(20, 16));
        spacer.setMinimumSize(new Dimension(20, 16));
        spacer.setPreferredSize(new Dimension(20, 16));
        return spacer;
    }

    public static void resetVariables(FormData fd, Map<String, String> params) {
        block4: for (int j = 0; j < fd.paramsList.size(); ++j) {
            String value;
            String name = fd.paramsList.get(j);
            JComponent jc = fd.tflist.get(j);
            if (jc instanceof JTextField) {
                value = ((JTextField)jc).getText();
            } else if (jc instanceof DataSetSelector) {
                value = ((DataSetSelector)jc).getValue();
            } else if (jc instanceof JComboBox) {
                value = String.valueOf(((JComboBox)jc).getSelectedItem());
            } else if (jc instanceof JCheckBox) {
                value = ((JCheckBox)jc).isSelected() ? "T" : "F";
            } else {
                throw new IllegalArgumentException("the code needs attention: component for " + name + " not supported ");
            }
            String deft = fd.deftsList.get(j);
            char type = fd.typesList.get(j).charValue();
            if (value.equals(deft) && !params.containsKey(name)) continue;
            switch (type) {
                case 'A': {
                    value = value.replaceAll("'", "");
                    if (!value.startsWith("'") || !value.endsWith("'")) {
                        value = "'" + value + "'";
                    }
                    params.put(name, value);
                    continue block4;
                }
                case 'L': 
                case 'R': {
                    if (!value.startsWith("'") || !value.endsWith("'")) {
                        value = "'" + value + "'";
                    }
                    params.put(name, value);
                    continue block4;
                }
                default: {
                    params.put(name, value);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormData doVariables(Map<String, Object> env, File f, Map<String, String> params, JPanel paramsPanel) throws IOException {
        StringBuilder build = new StringBuilder();
        try (BufferedReader r = new BufferedReader(new FileReader(f));){
            String line = r.readLine();
            while (line != null) {
                build.append(line).append("\n");
                line = r.readLine();
            }
        }
        return this.doVariables(env, build.toString(), params, paramsPanel);
    }

    public void redoVariables(Map<String, Object> env, String src, Map<String, String> params, JPanel paramsPanel) {
        paramsPanel.removeAll();
        ParametersFormPanel.resetVariables(this.fd, params);
        this.doVariables(env, src, params, paramsPanel);
        paramsPanel.revalidate();
        paramsPanel.repaint();
    }

    private JComponent getSpacer(int size) {
        JLabel spacer = new JLabel(" ");
        spacer.setSize(new Dimension(size, 16));
        spacer.setMinimumSize(new Dimension(size, 16));
        spacer.setPreferredSize(new Dimension(size, 16));
        return spacer;
    }

    public FormData doVariables(String src, Map<String, String> params, JPanel zparamsPanel) {
        return this.doVariables(null, src, params, zparamsPanel);
    }

    public FormData doVariables(final Map<String, Object> env, final String src, Map<String, String> params, final JPanel zparamsPanel) {
        if (params == null) {
            params = Collections.emptyMap();
        }
        this.params = new HashMap<String, String>(params);
        this.fd.tflist = new ArrayList();
        this.fd.paramsList = new ArrayList();
        this.fd.deftsList = new ArrayList();
        this.fd.deftObjectList = new ArrayList();
        this.fd.typesList = new ArrayList();
        JScrollPane jp = new JScrollPane();
        if (zparamsPanel != null) {
            zparamsPanel.add(jp);
        }
        final JPanel paramsPanel = new JPanel();
        jp.getViewport().add(paramsPanel);
        paramsPanel.setLayout(new BoxLayout(paramsPanel, 1));
        try {
            boolean hasVars;
            Map<String, JythonUtil.Param> parms = org.autoplot.jythonsupport.ui.Util.getParams(env, src, this.params, new NullProgressMonitor());
            paramsPanel.add(new JLabel("<html>This script has the following input parameters.  Buttons on the right show default values.<br><br></html>"));
            for (Map.Entry<String, JythonUtil.Param> e : parms.entrySet()) {
                JComponent ctf;
                String label;
                String colon;
                boolean isBool;
                JythonUtil.Param parm = e.getValue();
                String vname = parm.name;
                if (parm.enums != null && parm.deft.getClass() != parm.enums.get(0).getClass()) {
                    logger.warning("type of enumeration doesn't match default value.");
                }
                boolean bl = isBool = parm.enums != null && ParametersFormPanel.isBoolean(parm.enums);
                if (parm.enums != null) {
                    boolean okay = false;
                    if (!Py.java2py((Object)parm.enums.get(0)).getClass().isAssignableFrom(Py.java2py((Object)parm.deft).getClass())) {
                        logger.log(Level.WARNING, "parameter enumeration does not match type of default (" + parm.enums.get(0).getClass() + ") for \"{0}\"", vname);
                    } else {
                        for (Object o : parm.enums) {
                            if (!parm.deft.equals(o)) continue;
                            okay = true;
                        }
                        if (!okay) {
                            logger.log(Level.WARNING, "parameter enumeration does contain the default for \"{0}\"", vname);
                        }
                    }
                }
                String string = colon = isBool ? "" : ":";
                if (parm.doc == null) {
                    label = vname + colon;
                } else {
                    String doc = parm.doc;
                    if (doc.startsWith("'")) {
                        doc = doc.substring(1, doc.length() - 1);
                    }
                    if (!parm.label.equals(parm.name)) {
                        doc = doc + " (" + parm.label + " inside the script)";
                    }
                    label = doc.length() > 0 ? "<html>" + parm.name + ", <i>" + doc + "</i>" + colon + "</html>" : "<html>" + parm.name + colon + "</html>";
                }
                if (!isBool) {
                    JPanel labelPanel = new JPanel();
                    labelPanel.setLayout(new BoxLayout(labelPanel, 0));
                    JLabel l = new JLabel(label);
                    labelPanel.add(ParametersFormPanel.getSpacer());
                    labelPanel.add(l);
                    labelPanel.setAlignmentX(0.0f);
                    paramsPanel.add(labelPanel);
                } else {
                    paramsPanel.add(Box.createVerticalStrut(paramsPanel.getFont().getSize() / 2));
                }
                JPanel valuePanel = new JPanel();
                valuePanel.setLayout(new BoxLayout(valuePanel, 0));
                if (!isBool) {
                    valuePanel.add(ParametersFormPanel.getSpacer());
                }
                switch (parm.type) {
                    case 'R': {
                        String val = params.get(vname);
                        if (val != null) {
                            if (val.startsWith("'")) {
                                val = val.substring(1);
                            }
                            if (val.endsWith("'")) {
                                val = val.substring(0, val.length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, val);
                        }
                        final String fval = val;
                        DataSetSelector sel = new DataSetSelector();
                        sel.setHidePlayButton(true);
                        sel.setSuggestFiles(true);
                        final JTextField tf = new JTextField();
                        Dimension x = tf.getPreferredSize();
                        x.width = Integer.MAX_VALUE;
                        tf.setMaximumSize(x);
                        tf.setUI(tf.getUI());
                        ImageIcon fileIcon = new ImageIcon(org.autoplot.jythonsupport.ui.Util.class.getResource("/org/autoplot/datasource/jython/file2.png"));
                        JButton filesButton = new JButton(fileIcon);
                        filesButton.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                int r;
                                JFileChooser c = new JFileChooser();
                                URISplit split2 = URISplit.parse(fval);
                                if (split2.scheme.equals("file")) {
                                    c.setSelectedFile(new File(split2.file.substring(7)));
                                }
                                if ((r = c.showOpenDialog(paramsPanel)) == 0) {
                                    tf.setText("file://" + c.getSelectedFile().toString());
                                }
                            }
                        });
                        tf.setAlignmentX(0.0f);
                        tf.setText(val);
                        ctf = tf;
                        valuePanel.add(ctf);
                        filesButton.setAlignmentX(0.0f);
                        valuePanel.add(filesButton);
                        break;
                    }
                    case 'U': {
                        String val;
                        DataSetSelector sel = new DataSetSelector();
                        sel.setPlotItButtonVisible(false);
                        if (params.get(vname) != null) {
                            val = params.get(vname);
                            if (val.startsWith("'")) {
                                val = val.substring(1);
                            }
                            if (val.endsWith("'")) {
                                val = val.substring(0, val.length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, val);
                        }
                        sel.setRecent(DataSetSelector.getDefaultRecent());
                        sel.setValue(val);
                        valuePanel.add(this.getSpacer(7));
                        valuePanel.add(sel);
                        sel.setValue(val);
                        valuePanel.add(this.getSpacer(10));
                        ctf = sel;
                        break;
                    }
                    case 'L': {
                        String val;
                        DataSetSelector sel = new DataSetSelector();
                        sel.setPlotItButtonVisible(false);
                        if (params.get(vname) != null) {
                            val = params.get(vname);
                            if (val.startsWith("'")) {
                                val = val.substring(1);
                            }
                            if (val.endsWith("'")) {
                                val = val.substring(0, val.length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, val);
                        }
                        sel.setRecent(DataSetSelector.getDefaultRecent());
                        sel.setValue(val);
                        valuePanel.add(this.getSpacer(7));
                        valuePanel.add(sel);
                        sel.setValue(val);
                        valuePanel.add(this.getSpacer(10));
                        ctf = sel;
                        break;
                    }
                    case 'T': {
                        String val;
                        if (params.get(vname) != null) {
                            val = params.get(vname);
                            if (val.startsWith("'")) {
                                val = val.substring(1);
                            }
                            if (val.endsWith("'")) {
                                val = val.substring(0, val.length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, val);
                        }
                        final JTextField tf = new JTextField();
                        Dimension x = tf.getPreferredSize();
                        x.width = Integer.MAX_VALUE;
                        tf.setMaximumSize(x);
                        tf.setAlignmentX(0.0f);
                        tf.setText(val);
                        ctf = tf;
                        ImageIcon fileIcon = new ImageIcon(org.autoplot.jythonsupport.ui.Util.class.getResource("/org/autoplot/datasource/calendar.png"));
                        JButton button = new JButton(fileIcon);
                        button.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                TimeRangeTool tt = new TimeRangeTool();
                                tt.setSelectedRange(tf.getText());
                                int r = WindowManager.showConfirmDialog(paramsPanel, tt, "Select Time Range", 2);
                                if (r == 0) {
                                    tf.setText(tt.getSelectedRange());
                                }
                            }
                        });
                        button.setToolTipText("Time Range Tool");
                        valuePanel.add(ctf);
                        button.setAlignmentX(0.0f);
                        valuePanel.add(button);
                        break;
                    }
                    default: {
                        Dimension x;
                        JTextField tf;
                        String val;
                        if (params.get(vname) != null) {
                            val = params.get(vname);
                            if (val.startsWith("'")) {
                                val = val.substring(1);
                            }
                            if (val.endsWith("'")) {
                                val = val.substring(0, val.length() - 1);
                            }
                        } else {
                            val = String.valueOf(parm.deft);
                            params.put(vname, val);
                        }
                        if (parm.enums != null && parm.enums.size() > 0) {
                            JComponent jcb;
                            if (ParametersFormPanel.isBoolean(parm.enums)) {
                                jcb = new JCheckBox(label);
                                ((AbstractButton)jcb).setSelected(val.equals("T"));
                                ((AbstractButton)jcb).addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        ParametersFormPanel.this.redoVariables(env, src, ParametersFormPanel.this.params, zparamsPanel);
                                    }
                                });
                                ctf = jcb;
                            } else {
                                jcb = new JComboBox<Object>(parm.enums.toArray());
                                ((JComboBox)jcb).setEditable(false);
                                Object oval = parm.deft instanceof Long ? Long.valueOf(val) : (parm.deft instanceof Integer ? Integer.valueOf(val) : (parm.deft instanceof Double ? Double.valueOf(val) : (parm.deft instanceof Float ? Float.valueOf(val) : val)));
                                ((JComboBox)jcb).setSelectedItem(oval);
                                if (!((JComboBox)jcb).getSelectedItem().equals(oval)) {
                                    logger.fine("uh-oh.");
                                }
                                ctf = jcb;
                                ((JComboBox)jcb).addActionListener(new ActionListener(){

                                    @Override
                                    public void actionPerformed(ActionEvent e) {
                                        ParametersFormPanel.this.redoVariables(env, src, ParametersFormPanel.this.params, zparamsPanel);
                                    }
                                });
                                Dimension x2 = ctf.getPreferredSize();
                                x2.width = Integer.MAX_VALUE;
                                ctf.setMaximumSize(x2);
                                ctf.setAlignmentX(0.0f);
                            }
                        } else {
                            tf = new JTextField();
                            x = tf.getPreferredSize();
                            x.width = Integer.MAX_VALUE;
                            tf.setMaximumSize(x);
                            tf.setAlignmentX(0.0f);
                            tf.setText(val);
                            ctf = tf;
                        }
                        valuePanel.add(ctf);
                        break;
                    }
                }
                boolean shortLabel = parm.type == 'R' || String.valueOf(parm.deft).length() > 22;
                String fdeft = shortLabel ? "default" : String.valueOf(parm.deft);
                final String fvalue = String.valueOf(parm.deft);
                final JComponent ftf = ctf;
                JButton defaultButton = new JButton(new AbstractAction(fdeft){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (ftf instanceof DataSetSelector) {
                            ((DataSetSelector)ftf).setValue(fvalue);
                        } else if (ftf instanceof JComboBox) {
                            JComboBox jcb = (JComboBox)ftf;
                            for (int i = 0; i < jcb.getItemCount(); ++i) {
                                if (!fvalue.equals(jcb.getItemAt(i).toString())) continue;
                                jcb.setSelectedIndex(i);
                            }
                        } else if (ftf instanceof JCheckBox) {
                            ((JCheckBox)ftf).setSelected(fvalue.equals("T"));
                        } else {
                            ((JTextField)ftf).setText(fvalue);
                        }
                    }
                });
                defaultButton.setToolTipText(shortLabel ? String.valueOf(parm.deft) : "Click to reset to default");
                valuePanel.add(defaultButton);
                valuePanel.add(ParametersFormPanel.getSpacer());
                valuePanel.setAlignmentX(0.0f);
                paramsPanel.add(valuePanel);
                this.fd.tflist.add(ctf);
                this.fd.paramsList.add(parm.name);
                this.fd.deftsList.add(String.valueOf(parm.deft));
                this.fd.deftObjectList.add(parm.deft);
                this.fd.typesList.add(Character.valueOf(parm.type));
            }
            boolean bl = hasVars = parms.size() > 0;
            if (!hasVars) {
                JLabel l = new JLabel("<html><i>(no input parameters)</i></html>");
                l.setToolTipText("This looks through the code for getParam calls, and no conforming calls were found");
                paramsPanel.add(l);
            }
            paramsPanel.add(Box.createVerticalStrut(paramsPanel.getFont().getSize() * 2));
            paramsPanel.revalidate();
            this.fd.count = this.fd.paramsList.size();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        return this.fd;
    }

    public FormData getFormData() {
        return this.fd;
    }

    public static class FormData {
        ArrayList<JComponent> tflist;
        ArrayList<String> paramsList;
        ArrayList<String> deftsList;
        ArrayList<Object> deftObjectList;
        ArrayList<Character> typesList;
        public int count;

        public void implement(PythonInterpreter interp, String param, String value) throws ParseException {
            PyDictionary paramsDictionary = (PyDictionary)interp.get("params");
            for (int i = 0; i < this.paramsList.size(); ++i) {
                if (!this.paramsList.get(i).equals(param)) continue;
                Object deft = this.deftObjectList.get(i);
                if (this.typesList.get(i).equals(Character.valueOf('T')) && value.length() > 1 && value.charAt(0) != '\'' && value.charAt(value.length() - 1) != '\'') {
                    paramsDictionary.__setitem__(param, Py.java2py((Object)value));
                } else if (this.typesList.get(i).equals(Character.valueOf('D'))) {
                    paramsDictionary.__setitem__(param, Py.java2py((Object)((Datum)deft).getUnits().parse(value)));
                } else if (this.typesList.get(i).equals(Character.valueOf('S'))) {
                    paramsDictionary.__setitem__(param, Py.java2py((Object)DatumRangeUtil.parseDatumRange(value, (DatumRange)deft)));
                } else if (this.typesList.get(i).equals(Character.valueOf('U'))) {
                    try {
                        paramsDictionary.__setitem__(param, Py.java2py((Object)new URI(value)));
                    }
                    catch (URISyntaxException ex) {
                        throw new ParseException("URI is not formed properly", 0);
                    }
                } else if (this.typesList.get(i).equals(Character.valueOf('A'))) {
                    value = Util.popString(value);
                    paramsDictionary.__setitem__(param, Py.java2py((Object)value));
                } else if (this.typesList.get(i).equals(Character.valueOf('R'))) {
                    value = Util.popString(value);
                    try {
                        paramsDictionary.__setitem__(param, Py.java2py((Object)new URI(value)));
                    }
                    catch (URISyntaxException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                } else {
                    interp.exec(String.format("params['%s']=%s", param, value));
                }
                return;
            }
            logger.log(Level.WARNING, "unable to find variable ''{0}''", param);
        }
    }
}

