/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import jsyntaxpane.DefaultSyntaxKit;
import jsyntaxpane.SyntaxDocument;
import jsyntaxpane.SyntaxStyles;
import jsyntaxpane.TokenType;
import jsyntaxpane.actions.ActionUtils;
import jsyntaxpane.actions.IndentAction;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.WindowManager;
import org.autoplot.jythonsupport.JythonUtil;
import org.autoplot.jythonsupport.PyQDataSet;
import org.autoplot.jythonsupport.SimplifyScriptSupport;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.das2.DasApplication;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.jythoncompletion.CompletionContext;
import org.das2.jythoncompletion.CompletionSettings;
import org.das2.jythoncompletion.CompletionSupport;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.Utilities;
import org.das2.qds.ArrayDataSet;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;
import org.das2.util.LoggerManager;
import org.python.core.PyObject;
import org.python.parser.SimpleNode;

public class EditorTextPane
extends JEditorPane {
    private static final Logger logger = LoggerManager.getLogger("jython.editor");
    protected static final String PROP_FONT = "font";
    private EditorAnnotationsSupport support = new EditorAnnotationsSupport(this);
    private boolean initialized = false;
    JEditorPane completionsEditorPane = null;

    public EditorTextPane() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                final UndoManager undo = new UndoManager();
                EditorTextPane.this.getActionMap().put("undo", new AbstractAction(undo.getUndoPresentationName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (undo.canUndo()) {
                            undo.undo();
                        }
                    }
                });
                EditorTextPane.this.getActionMap().put("redo", new AbstractAction(undo.getRedoPresentationName()){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            if (undo.canRedo()) {
                                undo.redo();
                            }
                        }
                        catch (CannotRedoException cannotRedoException) {
                            // empty catch block
                        }
                    }
                });
                EditorTextPane.this.getActionMap().put("biggerFont", new AbstractAction("Text Size Bigger"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Font f = EditorTextPane.this.getFont();
                        float size = f.getSize2D();
                        float step = size < 14.0f ? 1.0f : 2.0f;
                        EditorTextPane.this.setFont(f.deriveFont(Math.min(40.0f, size + step)));
                    }
                });
                EditorTextPane.this.getActionMap().put("smallerFont", new AbstractAction("Text Size Smaller"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Font f = EditorTextPane.this.getFont();
                        float size = f.getSize2D();
                        float step = size < 14.0f ? 1.0f : 2.0f;
                        EditorTextPane.this.setFont(f.deriveFont(Math.max(4.0f, size - step)));
                    }
                });
                EditorTextPane.this.getActionMap().put("settings", new AbstractAction("settings"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        CompletionSettings settings = JythonCompletionProvider.getInstance().settings();
                        PropertyEditor p = new PropertyEditor(settings);
                        p.showModalDialog(EditorTextPane.this);
                    }
                });
                EditorTextPane.this.getActionMap().put("plotItem", new AbstractAction("plotItem"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent(e);
                        String doThis = EditorTextPane.this.getSelectedText();
                        if (doThis == null) {
                            return;
                        }
                        try {
                            EditorTextPane.this.plotSoon(doThis);
                        }
                        catch (IllegalArgumentException ex) {
                            JOptionPane.showMessageDialog(EditorTextPane.this, "<html>A debugging session must be active.  Insert stop to halt script execution.</html>");
                        }
                    }
                });
                EditorTextPane.this.getActionMap().put("developer1", new AbstractAction("developer1"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent(e);
                        EditorTextPane.this.showCompletionsView();
                    }
                });
                EditorTextPane.this.getActionMap().put("usages", new AbstractAction("usages"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        LoggerManager.logGuiEvent(e);
                        EditorTextPane.this.showUsages();
                    }
                });
                Toolkit tk = Toolkit.getDefaultToolkit();
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(90, tk.getMenuShortcutKeyMask()), "undo");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(89, tk.getMenuShortcutKeyMask()), "redo");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(61, tk.getMenuShortcutKeyMask()), "biggerFont");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(45, tk.getMenuShortcutKeyMask()), "smallerFont");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(116, 64), "settings");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(67, 192), "plotItem");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(85, 192), "usages");
                EditorTextPane.this.getInputMap().put(KeyStroke.getKeyStroke(123, 192), "developer1");
                EditorTextPane.this.doLayout();
                DefaultSyntaxKit.initKit();
                SyntaxStyles.getInstance().getStyle(TokenType.DELIMITER).isDrawTabs();
                JPopupMenu oldPopup = EditorTextPane.this.getComponentPopupMenu();
                EditorTextPane.this.setContentType("text/python");
                String v = System.getProperty("java.version");
                if (!v.startsWith("1.8") && !v.startsWith("1.7")) {
                    ((SyntaxDocument)EditorTextPane.this.getDocument()).setUndoManager(new UndoManager());
                }
                if (!JythonCompletionProvider.getInstance().settings().isTabIsCompletion()) {
                    Action get = ActionUtils.getAction((JTextComponent)EditorTextPane.this, IndentAction.class);
                    if (get == null) {
                        logger.warning("Expected to find IndentAction");
                    } else {
                        ((IndentAction)get).setInsertTab(true);
                    }
                }
                EditorTextPane.this.getDocument().addUndoableEditListener(undo);
                if (oldPopup != null) {
                    EditorTextPane.this.setComponentPopupMenu(oldPopup);
                }
                String sf = JythonCompletionProvider.getInstance().settings().getEditorFont();
                EditorTextPane.this.setFont(Font.decode(sf));
                EditorTextPane.this.initialized = true;
            }
        };
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            SwingUtilities.invokeLater(run);
        }
    }

    public void showCompletionsView() {
        String doThis = this.getSelectedText();
        if (doThis == null || doThis.length() == 0) {
            doThis = this.getText();
        }
        try {
            JDialog d;
            JEditorPane a;
            String scriptPrime = SimplifyScriptSupport.simplifyScriptToCompletions(doThis);
            if (this.completionsEditorPane == null) {
                this.completionsEditorPane = a = new JEditorPane();
                DefaultSyntaxKit.initKit();
                SyntaxStyles.getInstance().getStyle(TokenType.DELIMITER).isDrawTabs();
                a.setContentType("text/python");
                d = new JDialog();
                d.setTitle("Completions Peek Editor");
                a.setMinimumSize(new Dimension(600, 800));
                a.setPreferredSize(new Dimension(600, 800));
                d.getContentPane().add(new JScrollPane(a));
                d.pack();
            } else {
                a = this.completionsEditorPane;
                d = (JDialog)SwingUtilities.getWindowAncestor(this.completionsEditorPane);
            }
            a.setText(scriptPrime);
            d.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, ex.toString());
        }
    }

    @Override
    public void setDocument(Document doc) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.fine("called from off the event queue.");
        }
        super.setDocument(doc);
    }

    private void showUsages() {
        String script = this.getText();
        String var = this.getSelectedText();
        if (var == null || var.length() == 0) {
            var = EditorAnnotationsSupport.getSymbolAt(this);
        }
        this.support.clearAnnotations();
        List<SimpleNode> usages = JythonUtil.showUsage(script, var);
        for (SimpleNode n : usages) {
            this.support.annotateChars(n.beginLine, n.beginColumn, n.beginColumn + var.length(), "usage", var, null);
        }
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        return this.support.getToolTipText(event);
    }

    public void setEditorAnnotationsSupport(EditorAnnotationsSupport support) {
        this.support = support;
    }

    public EditorAnnotationsSupport getEditorAnnotationsSupport() {
        return this.support;
    }

    protected void inspectURI() {
        try {
            int pos = this.getCaretPosition();
            int i0 = Utilities.getRowStart(this, pos);
            int i2 = Utilities.getRowEnd(this, pos);
            int lineStart = i0;
            String line = this.getText(i0, i2 - i0);
            int i1 = i0;
            i2 = pos -= i0;
            i1 -= i0;
            i0 = 0;
            CompletionContext cc = CompletionSupport.getCompletionContext(line, pos, i0, i1, i2);
            if (cc == null) {
                JOptionPane.showMessageDialog(this, "<html>String URI argument must start with vap+cdaweb:, vap+inline:,etc", "URI needed", 1);
                return;
            }
            String oldUri = cc.completable;
            if (oldUri.startsWith("'")) {
                oldUri = oldUri.substring(1);
            }
            if (oldUri.endsWith("'")) {
                oldUri = oldUri.substring(0, oldUri.length() - 1);
            }
            if (oldUri.startsWith("\"")) {
                oldUri = oldUri.substring(1);
            }
            if (oldUri.endsWith("\"")) {
                oldUri = oldUri.substring(0, oldUri.length() - 1);
            }
            if (oldUri.length() == 0 || !oldUri.contains(":")) {
                JOptionPane.showMessageDialog(this, "<html>String URI argument must start with vap+cdaweb:, vap+inline:,etc", "URI needed", 1);
                return;
            }
            int uri0 = line.indexOf(oldUri);
            int uri1 = uri0 + oldUri.length();
            JPanel parent = new JPanel();
            parent.setLayout(new BorderLayout());
            DataSourceEditorPanel p = DataSourceEditorPanelUtil.getDataSourceEditorPanel(parent, oldUri);
            ImageIcon icon = new ImageIcon(this.getClass().getResource("/org/autoplot/datasource/fileMag.png"));
            if (0 == WindowManager.showConfirmDialog(this, parent, "Editing URI", 2, 3, icon)) {
                String newUri = p.getURI();
                this.setSelectionStart(lineStart + uri0);
                this.setSelectionEnd(lineStart + uri1);
                this.replaceSelection(newUri);
            }
        }
        catch (BadLocationException ex) {
            Logger.getLogger(EditorTextPane.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void plot(String doThis) {
        block15: {
            EditorAnnotationsSupport.ExpressionLookup l = EditorAnnotationsSupport.getExpressionLookup();
            if (l == null) {
                throw new IllegalArgumentException("No interpreter available to evaluate expression");
            }
            try {
                PyObject po = l.lookup(doThis);
                if (po instanceof PyQDataSet) {
                    try {
                        PyQDataSet pds = (PyQDataSet)po;
                        File tmpDir = File.createTempFile("autoplot", ".qds").getParentFile();
                        File tmpfile = new File(tmpDir, "autoplot.qds");
                        String cmd = "plot( 'file:" + tmpfile.toString() + "' );";
                        ArrayDataSet mpds = ArrayDataSet.copy(pds.getQDataSet());
                        String oldTitle = (String)mpds.property("TITLE");
                        mpds.putProperty("TITLE", oldTitle == null ? doThis : doThis + ": " + oldTitle);
                        try (FileOutputStream fout = new FileOutputStream(tmpfile);){
                            new SimpleStreamFormatter().format(mpds, fout, true);
                        }
                        Socket s = new Socket("localhost", 12345);
                        try (OutputStream out = s.getOutputStream();){
                            out.write((cmd + "\n").getBytes());
                            break block15;
                        }
                    }
                    catch (StreamException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (IOException ex) {
                        if (ex instanceof ConnectException) {
                            JOptionPane.showMessageDialog(this, "<html>Unable to connect to socket 12345.  Start a second Autoplot and enable the Server feature.</html>");
                            return;
                        }
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    break block15;
                }
                JOptionPane.showMessageDialog(this, "Selected item is not a dataset");
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this, "Selected item caused exception: " + e.toString());
            }
        }
    }

    void plotSoon(final String doThis) {
        EditorAnnotationsSupport.ExpressionLookup l = EditorAnnotationsSupport.getExpressionLookup();
        if (l == null) {
            throw new IllegalArgumentException("Session is not running.  There must be an active debugger to plot variables.");
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                EditorTextPane.this.plot(doThis);
            }
        };
        new Thread(run, "plotExpression").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadFileToString(File f) throws FileNotFoundException, IOException {
        StringBuilder buf = new StringBuilder();
        try (BufferedReader r = null;){
            r = new BufferedReader(new InputStreamReader(new FileInputStream(f)));
            String s = r.readLine();
            while (s != null) {
                buf.append(s).append("\n");
                s = r.readLine();
            }
        }
        return buf.toString();
    }

    public void loadFile(File f) throws FileNotFoundException, IOException {
        try {
            final String s = EditorTextPane.loadFileToString(f);
            if (this.initialized) {
                Document d = this.getDocument();
                d.remove(0, d.getLength());
                d.insertString(0, s, null);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Document d = EditorTextPane.this.getDocument();
                            d.remove(0, d.getLength());
                            d.insertString(0, s, null);
                        }
                        catch (BadLocationException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                });
            }
        }
        catch (BadLocationException ex) {
            throw new RuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String[] jumpToList() {
        ArrayList<String> jumpToList = new ArrayList<String>();
        jumpToList.add("1:top");
        try {
            Document d = this.getDocument();
            String s = d.getText(0, d.getLength());
            LineNumberReader reader = new LineNumberReader(new StringReader(s));
            String line = "";
            int length = -1;
            try {
                while (line != null) {
                    if (line.startsWith("def ") && line.contains("(")) {
                        int i = line.indexOf("(");
                        jumpToList.add(reader.getLineNumber() + ":" + line.substring(0, i));
                    }
                    length = reader.getLineNumber() + 1;
                    line = reader.readLine();
                }
            }
            finally {
                reader.close();
            }
            jumpToList.add(String.format(Locale.US, "%d:bottom", length));
            return jumpToList.toArray(new String[jumpToList.size()]);
        }
        catch (IOException ex) {
            return jumpToList.toArray(new String[jumpToList.size()]);
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return jumpToList.toArray(new String[jumpToList.size()]);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
    }
}

