/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import jsyntaxpane.components.Markers;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.SquigglePainter;
import org.das2.util.LoggerManager;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySyntaxError;
import org.python.util.PythonInterpreter;

public class EditorAnnotationsSupport {
    private static final Logger logger = LoggerManager.getLogger("autoplot.jython");
    public static final String ANNO_ERROR = "error";
    public static final String ANNO_PROGRAM_COUNTER = "programCounter";
    public static final String ANNO_WARNING = "warning";
    public static final String ANNO_USAGE = "usage";
    private final JEditorPane editorPanel;
    SortedMap<Integer, Annotation> annotations = new TreeMap<Integer, Annotation>();
    private static ExpressionLookup expressionLookup;

    public static String getSymbolAt(EditorTextPane editor) {
        int i = editor.getCaretPosition();
        String s = editor.getText();
        if (i >= 1 && !Character.isJavaIdentifierPart(s.charAt(i)) && Character.isJavaIdentifierPart(s.charAt(i - 1))) {
            --i;
        }
        while (i >= 0 && Character.isJavaIdentifierPart(s.charAt(i))) {
            --i;
        }
        if (!Character.isJavaIdentifierPart(s.charAt(i))) {
            ++i;
        }
        int i0 = i;
        while (i < s.length() && Character.isJavaIdentifierPart(s.charAt(i))) {
            ++i;
        }
        return s.substring(i0, i);
    }

    EditorAnnotationsSupport(JEditorPane editorPanel) {
        this.editorPanel = editorPanel;
        final DocumentListener annoList = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                EditorAnnotationsSupport.this.clearAnnotations(e.getOffset());
            }
        };
        editorPanel.getDocument().addDocumentListener(annoList);
        this.editorPanel.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    ((Document)evt.getOldValue()).removeDocumentListener(annoList);
                }
                ((Document)evt.getNewValue()).addDocumentListener(annoList);
            }
        });
        editorPanel.setToolTipText("this will contain annotations");
    }

    public void clearAnnotations() {
        if (SwingUtilities.isEventDispatchThread()) {
            Markers.removeMarkers((JTextComponent)this.editorPanel);
            this.editorPanel.getHighlighter().removeAllHighlights();
            this.annotations = new TreeMap<Integer, Annotation>();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Markers.removeMarkers((JTextComponent)EditorAnnotationsSupport.this.editorPanel);
                    EditorAnnotationsSupport.this.editorPanel.getHighlighter().removeAllHighlights();
                    EditorAnnotationsSupport.this.annotations = new TreeMap<Integer, Annotation>();
                }
            });
        }
    }

    public void clearAnnotations(int pos) {
        final Annotation ann = this.annotationAt(pos);
        if (ann != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Markers.removeMarkers((JTextComponent)EditorAnnotationsSupport.this.editorPanel, (Markers.SimpleMarker)ann.marker);
                    EditorAnnotationsSupport.this.annotations.remove(ann.offset);
                    if (ann.highlightInfo != null) {
                        EditorAnnotationsSupport.this.editorPanel.getHighlighter().removeHighlight(ann.highlightInfo);
                    }
                }
            });
        }
    }

    private Annotation annotationAt(int offset) {
        SortedMap<Integer, Annotation> head = this.annotations.headMap(offset);
        if (head.size() == 0) {
            return null;
        }
        int annoOffset = head.lastKey();
        Annotation ann = (Annotation)this.annotations.get(annoOffset);
        if (ann.len > offset - ann.offset) {
            return ann;
        }
        return null;
    }

    public void annotateError(PyException ex, int offset) throws BadLocationException {
        if (ex instanceof PySyntaxError) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            int lineno = offset + ((PyInteger)ex.value.__getitem__(1).__getitem__(1)).getValue();
            this.annotateLine(lineno, ANNO_ERROR, ex.toString());
        } else {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.annotateLine(offset + ex.traceback.tb_lineno, ANNO_ERROR, ex.toString());
        }
    }

    public void annotateLine(int line, String name, String text) throws BadLocationException {
        this.annotateLine(line, name, text, null);
    }

    public void annotateLine(int lline, final String name, String ltext, final PythonInterpreter interp) {
        if (lline < 1) {
            new IllegalArgumentException("no such line: " + lline).printStackTrace();
            lline = 1;
            ltext = ltext + "\n(line number was " + lline + ", see stderr)";
        }
        final int line = lline;
        final String text = ltext;
        Element root = this.editorPanel.getDocument().getDefaultRootElement();
        root.getElementCount();
        if (line > root.getElementCount() + 1) {
            System.err.println("*** can't annotate line: " + lline);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int i1;
                int i0;
                Document doc = EditorAnnotationsSupport.this.editorPanel.getDocument();
                Element root = EditorAnnotationsSupport.this.editorPanel.getDocument().getDefaultRootElement();
                if (root.getElementCount() == 1) {
                    return;
                }
                if (line > root.getElementCount() + 1) {
                    throw new IllegalArgumentException("no such line: " + line);
                }
                if (line <= root.getElementCount()) {
                    i0 = root.getElement(line - 1).getStartOffset();
                    i1 = root.getElement(line - 1).getEndOffset();
                } else {
                    i0 = Math.max(0, doc.getLength() - 2);
                    i1 = doc.getLength();
                }
                EditorAnnotationsSupport.this.annotateChars(i0, i1, name, text, interp);
            }
        });
    }

    public int[] getLinePosition(int line) {
        int i1;
        int i0;
        Document doc = this.editorPanel.getDocument();
        Element root = this.editorPanel.getDocument().getDefaultRootElement();
        if (root.getElementCount() == 1) {
            return new int[]{0, 0};
        }
        if (line > root.getElementCount() + 1) {
            throw new IllegalArgumentException("no such line: " + line);
        }
        if (line <= root.getElementCount()) {
            i0 = root.getElement(line - 1).getStartOffset();
            i1 = root.getElement(line - 1).getEndOffset();
        } else {
            i0 = Math.max(0, doc.getLength() - 2);
            i1 = doc.getLength();
        }
        return new int[]{i0, i1};
    }

    public void annotateChars(final int line, final int i0, final int i1, final String name, final String text, final PythonInterpreter interp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Document doc = EditorAnnotationsSupport.this.editorPanel.getDocument();
                Element root = EditorAnnotationsSupport.this.editorPanel.getDocument().getDefaultRootElement();
                if (root.getElementCount() == 1) {
                    return;
                }
                if (line > root.getElementCount() + 1) {
                    throw new IllegalArgumentException("no such line: " + line);
                }
                int lineStart = line <= root.getElementCount() ? root.getElement(line - 1).getStartOffset() : Math.max(0, doc.getLength() - 2);
                EditorAnnotationsSupport.this.annotateChars(lineStart + i0 - 1, lineStart + i1 - 1, name, text, interp);
            }
        });
    }

    public void annotateChars(final int i0, final int i1, final String name, final String text, PythonInterpreter interp) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object highlightInfo = null;
                Markers.SimpleMarker mark = name.equals(EditorAnnotationsSupport.ANNO_WARNING) ? new Markers.SimpleMarker(Color.YELLOW) : (name.equals(EditorAnnotationsSupport.ANNO_USAGE) ? new Markers.SimpleMarker(Color.YELLOW.brighter()) : (name.equals(EditorAnnotationsSupport.ANNO_ERROR) ? new Markers.SimpleMarker(Color.PINK) : (name.equals(EditorAnnotationsSupport.ANNO_PROGRAM_COUNTER) ? new Markers.SimpleMarker(new Color(0, 255, 0, 80)) : new Markers.SimpleMarker(Color.GRAY))));
                if (name.equals(EditorAnnotationsSupport.ANNO_ERROR)) {
                    SquigglePainter red = new SquigglePainter(Color.RED);
                    try {
                        highlightInfo = EditorAnnotationsSupport.this.editorPanel.getHighlighter().addHighlight(i0, i1, red);
                    }
                    catch (BadLocationException ex) {
                        Logger.getLogger(EditorAnnotationsSupport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                } else {
                    Markers.markText((JTextComponent)EditorAnnotationsSupport.this.editorPanel, (int)i0, (int)i1, (Markers.SimpleMarker)mark);
                }
                Annotation ann = new Annotation();
                ann.len = i1 - i0;
                ann.offset = i0;
                ann.text = text;
                ann.marker = mark;
                ann.highlightInfo = highlightInfo;
                EditorAnnotationsSupport.this.annotations.put(ann.offset, ann);
            }
        });
    }

    private String htmlify(String text) {
        StringBuilder buff = new StringBuilder();
        buff.append("<html>");
        String[] ss = text.split("\n", -2);
        for (int i = 0; i < ss.length - 1; ++i) {
            buff.append(ss[i]).append("<br>");
        }
        buff.append(ss[ss.length - 1]);
        buff.append("</html>");
        return buff.toString();
    }

    public static void setExpressionLookup(ExpressionLookup l) {
        expressionLookup = l;
    }

    public static ExpressionLookup getExpressionLookup() {
        return expressionLookup;
    }

    public ExpressionLookup getForInterp(final PythonInterpreter interp) {
        return new ExpressionLookup(){

            @Override
            public PyObject lookup(String expr) {
                if (expr == null) {
                    return new PyString("<html>highlite an expression");
                }
                try {
                    PyObject po = interp.eval(expr);
                    return po;
                }
                catch (Exception e) {
                    int i;
                    String msg = e.getMessage();
                    if (msg == null && (i = (msg = e.toString()).lastIndexOf("?\n")) > -1) {
                        msg = msg.substring(i + 2).trim();
                    }
                    return new PyString("<html>highlite an expression<br>" + msg);
                }
            }
        };
    }

    public String getToolTipText(MouseEvent me) {
        int offset = this.editorPanel.viewToModel(me.getPoint());
        if (this.editorPanel.getSelectionStart() <= offset && offset <= this.editorPanel.getSelectionEnd()) {
            String expr = this.editorPanel.getSelectedText();
            if (expressionLookup != null) {
                if (expr != null) {
                    PyObject po = expressionLookup.lookup(expr);
                    String peek = String.valueOf(po.__str__());
                    if (peek.startsWith("<html>")) {
                        return peek;
                    }
                    if (po instanceof PyJavaInstance) {
                        try {
                            return "<html>" + expr + "=" + peek + "<br>" + ((PyJavaInstance)po).instclass.safeRepr();
                        }
                        catch (Exception ex) {
                            return "<html>" + expr + "=" + peek + "<br>" + po.getType();
                        }
                    }
                    return "<html>" + expr + "=" + peek + "<br>" + po.getType();
                }
            } else {
                return "Interpreter is not active";
            }
        }
        if (offset > 0) {
            Annotation ann = this.annotationAt(offset);
            if (ann != null) {
                return this.htmlify(ann.text);
            }
            return null;
        }
        return null;
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 250);
    }

    private static class Annotation {
        String text;
        int offset;
        int len;
        Markers.SimpleMarker marker;
        Object highlightInfo;

        private Annotation() {
        }
    }

    public static interface ExpressionLookup {
        public PyObject lookup(String var1);
    }
}

