/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.jythonsupport.JythonUtil;
import org.das2.util.LoggerManager;
import org.python.core.PySyntaxError;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.Call;
import org.python.parser.ast.ClassDef;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Print;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.VisitorBase;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;

public class SimplifyScriptSupport {
    private static final Logger logger = LoggerManager.getLogger("jython");
    private static final String GETDATASET_CODE = "def getDataSet( uri, timerange='', monitor='' ):\n    'return a dataset for the given URI'\n    return dataset(0)\n\n";
    private static final String[] okay = new String[]{"range,", "xrange,", "getParam,", "getDataSet,", "lower,", "upper,", "URI,", "URL,", "DatumRangeUtil,", "TimeParser", "str,", "int,", "long,", "float,", "datum,", "datumRange,", "dataset,", "findgen,", "dindgen,", "ones,", "zeros,", "linspace,", "dblarr,", "fltarr,", "ripples,", "color,", "colorFromString,"};
    private static final Set<String> okaySet = new HashSet<String>();

    public static String removeSideEffects(String script) {
        Module n = (Module)parser.parse((String)script, (String)"exec");
        String[] ss = script.split("\n");
        HashSet variableNames = new HashSet();
        int lastLine = ss.length;
        return SimplifyScriptSupport.simplifyScriptToGetCompletions(ss, n.body, variableNames, 1, lastLine, 0);
    }

    private static StringBuilder appendToResult(StringBuilder result, String line) {
        result.append(line);
        return result;
    }

    public static String simplifyScriptToCompletions(String script) throws PySyntaxError {
        String closeParenCheck;
        String[] ss = script.split("\n");
        int lastLine = ss.length;
        while (ss.length > lastLine + 1 && ss[lastLine].trim().length() > 0 && Character.isWhitespace(ss[lastLine].charAt(0))) {
            ++lastLine;
        }
        if (lastLine < ss.length && ((closeParenCheck = ss[lastLine].trim()).equals(")") || closeParenCheck.equals("]"))) {
            ++lastLine;
        }
        HashSet<String> variableNames = new HashSet<String>();
        variableNames.add("getParam");
        variableNames.add("getDataSet");
        variableNames.add("str");
        variableNames.add("int");
        variableNames.add("long");
        variableNames.add("float");
        variableNames.add("datum");
        variableNames.add("datumRange");
        variableNames.add("dataset");
        variableNames.add("URI");
        variableNames.add("URL");
        Module n = null;
        PySyntaxError ex0 = null;
        for (int count = 4; lastLine > 0 && count > 0; --count) {
            try {
                n = (Module)parser.parse((String)script, (String)"exec");
                break;
            }
            catch (PySyntaxError ex) {
                if (ex0 == null) {
                    ex0 = ex;
                }
                script = JythonUtil.join(Arrays.copyOf(ss, --lastLine), "\n");
                continue;
            }
        }
        if (n == null) {
            throw ex0;
        }
        String s = SimplifyScriptSupport.simplifyScriptToGetCompletions(ss, n.body, variableNames, 1, lastLine, 0);
        s = GETDATASET_CODE + s;
        s = "PWD='file:/tmp/'\n" + s;
        return s;
    }

    private static String getIfBlock(String[] ss, If iff, stmtType[] body, HashSet variableNames, int firstLine, int lastLine1, int depth) {
        StringBuilder result = new StringBuilder();
        String ss1 = SimplifyScriptSupport.simplifyScriptToGetCompletions(ss, body, variableNames, firstLine, lastLine1, depth + 1);
        if (ss1.length() == 0) {
            if (firstLine == 0 && iff.beginLine > 0) {
                String line = ss[body[0].beginLine - 1];
            } else {
                String line = ss[iff.beginLine];
            }
            Pattern p = Pattern.compile("(\\s*)(\\S*).*");
            Matcher m = p.matcher(ss[firstLine - 1]);
            String indent = m.matches() ? m.group(1) : "";
            result.append(indent).append("pass  ## huphup130 \n");
            logger.fine("things have probably gone wrong...");
        } else {
            SimplifyScriptSupport.appendToResult(result, ss1);
        }
        return result.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String simplifyScriptToGetCompletions(String[] ss, stmtType[] stmts, HashSet variableNames, int beginLine, int lastLine, int depth) {
        int acceptLine = -1;
        int currentLine = beginLine;
        StringBuilder result = new StringBuilder();
        for (int istatement = 0; istatement < stmts.length; ++istatement) {
            stmtType o = stmts[istatement];
            logger.log(Level.FINER, "line {0}: {1}", new Object[]{o.beginLine, o.beginLine > 0 ? ss[o.beginLine - 1] : "(bad line number)"});
            if (o.beginLine > 0) {
                if (beginLine < 0 && istatement == 0) {
                    acceptLine = o.beginLine;
                }
                beginLine = o.beginLine;
            } else {
                acceptLine = beginLine;
            }
            if (beginLine > lastLine) continue;
            if (o instanceof If) {
                int lastLine1;
                boolean includeBlock;
                if (acceptLine > -1) {
                    for (int i = acceptLine; i < beginLine; ++i) {
                        SimplifyScriptSupport.appendToResult(result, ss[i - 1]).append("\n");
                    }
                }
                If iff = (If)o;
                if (SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)iff.test, variableNames)) {
                    for (int i = beginLine; i < iff.body[0].beginLine; ++i) {
                        if (i <= 0 || i - 1 >= ss.length) continue;
                        result.append(ss[i - 1]).append("\n");
                    }
                    includeBlock = true;
                } else {
                    includeBlock = false;
                }
                if (iff.orelse != null && iff.orelse.length > 0) {
                    if (iff.orelse[0].beginLine > 0) {
                        lastLine1 = iff.orelse[0].beginLine - 2;
                    } else {
                        if (!(iff.orelse[0] instanceof If)) {
                            logger.warning("failure to deal with another day...");
                            throw new RuntimeException("this case needs to be dealt with...");
                        }
                        lastLine1 = ((If)iff.orelse[0]).test.beginLine - 1;
                    }
                } else {
                    lastLine1 = istatement + 1 < stmts.length ? stmts[istatement + 1].beginLine - 1 : lastLine;
                }
                if (includeBlock) {
                    String ss1 = SimplifyScriptSupport.getIfBlock(ss, iff, iff.body, variableNames, beginLine + 1, lastLine1, depth + 1);
                    SimplifyScriptSupport.appendToResult(result, ss1);
                    if (iff.orelse != null) {
                        lastLine1 = istatement + 1 >= stmts.length ? lastLine : stmts[istatement + 1].beginLine - 1;
                        if (iff.orelse[0].beginLine == 0) {
                            SimplifyScriptSupport.appendToResult(result, ss[beginLine + 1] + " # huphup");
                        } else {
                            beginLine = iff.orelse[0].beginLine;
                        }
                        String ss2 = SimplifyScriptSupport.getIfBlock(ss, iff, iff.orelse, variableNames, beginLine, lastLine1, depth + 1);
                        if (iff.orelse[0].beginLine > 2) {
                            SimplifyScriptSupport.appendToResult(result, ss[iff.orelse[0].beginLine - 2]);
                        }
                        result.append("\n");
                        SimplifyScriptSupport.appendToResult(result, ss2);
                    }
                }
                currentLine = lastLine1;
                acceptLine = -1;
                continue;
            }
            if (SimplifyScriptSupport.simplifyScriptToGetCompletionsOkay(o, variableNames)) {
                if (acceptLine >= 0) continue;
                acceptLine = o.beginLine;
                for (int i = currentLine + 1; i < acceptLine; ++i) {
                    result.append("\n");
                    currentLine = acceptLine;
                }
                continue;
            }
            if (acceptLine <= -1) continue;
            int thisLine = o.beginLine;
            for (int i = acceptLine; i < thisLine; ++i) {
                SimplifyScriptSupport.appendToResult(result, ss[i - 1]).append("\n");
            }
            SimplifyScriptSupport.appendToResult(result, "\n");
            currentLine = thisLine;
            acceptLine = -1;
        }
        if (acceptLine > -1) {
            int thisLine = lastLine;
            for (int i = acceptLine; i <= thisLine; ++i) {
                SimplifyScriptSupport.appendToResult(result, ss[i - 1]).append("\n");
            }
        }
        return result.toString();
    }

    private static boolean simplifyScriptToGetCompletionsCanResolve(SimpleNode o, HashSet<String> variableNames) {
        if (o instanceof Name) {
            Name c = (Name)o;
            if (!variableNames.contains(c.id)) {
                logger.finest(String.format("%04d canResolve->false: %s", o.beginLine, o.toString()));
                return false;
            }
        }
        if (o instanceof Attribute) {
            Attribute at = (Attribute)o;
            while (at.value instanceof Attribute || at.value instanceof Subscript) {
                if (at.value instanceof Attribute) {
                    at = (Attribute)at.value;
                    continue;
                }
                Subscript s = (Subscript)at.value;
                if (s.value instanceof Attribute) {
                    at = (Attribute)s.value;
                    continue;
                }
                return false;
            }
            if (at.value instanceof Name) {
                Name n = (Name)at.value;
                if (!variableNames.contains(n.id)) {
                    return false;
                }
            }
        }
        MyVisitorBase vb = new MyVisitorBase(variableNames);
        try {
            o.traverse(vb);
            logger.finest(String.format(" %04d canResolve->%s: %s", o.beginLine, vb.visitNameFail, o));
            return vb.looksOkay || !vb.visitNameFail;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            logger.finest(String.format("!! %04d canResolve->false: %s", o.beginLine, o));
            return false;
        }
    }

    private static boolean simplifyScriptToGetCompletionsOkay(stmtType o, HashSet<String> variableNames) {
        logger.log(Level.FINEST, "simplify script line: {0}", o.beginLine);
        if (o instanceof ImportFrom) {
            return true;
        }
        if (o instanceof Import) {
            return true;
        }
        if (o instanceof ClassDef) {
            return true;
        }
        if (o instanceof FunctionDef) {
            return true;
        }
        if (o instanceof Assign) {
            Assign a = (Assign)o;
            if (SimplifyScriptSupport.simplifyScriptToGetCompletionsOkayNoCalls((SimpleNode)a.value, variableNames)) {
                if (!SimplifyScriptSupport.simplifyScriptToGetCompletionsCanResolve((SimpleNode)a.value, variableNames)) {
                    return false;
                }
                for (exprType target : a.targets) {
                    exprType et = target;
                    if (et instanceof Name) {
                        String id = ((Name)target).id;
                        variableNames.add(id);
                        logger.log(Level.FINEST, "assign to variable {0}", id);
                        continue;
                    }
                    if (!(et instanceof Attribute)) continue;
                    Attribute at = (Attribute)et;
                    while (at.value instanceof Attribute || at.value instanceof Subscript) {
                        if (at.value instanceof Attribute) {
                            at = (Attribute)at.value;
                            continue;
                        }
                        Subscript s = (Subscript)at.value;
                        if (s.value instanceof Attribute) {
                            at = (Attribute)s.value;
                            continue;
                        }
                        return false;
                    }
                    if (!(at.value instanceof Name)) continue;
                    Name n = (Name)at.value;
                    if (variableNames.contains(n.id)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o instanceof If) {
            return SimplifyScriptSupport.simplifyScriptToGetCompletionsOkayNoCalls((SimpleNode)o, variableNames);
        }
        if (o instanceof Print) {
            return false;
        }
        logger.log(Level.FINEST, "not okay to simplify: {0}", o);
        return false;
    }

    private static boolean simplifyScriptToGetCompletionsOkayNoCalls(SimpleNode o, HashSet<String> variableNames) {
        Call c;
        if (o instanceof Call && !SimplifyScriptSupport.trivialFunctionCall((SimpleNode)(c = (Call)o)) && !SimplifyScriptSupport.trivialConstructorCall((SimpleNode)c)) {
            logger.finest(String.format("%04d simplify->false: %s", o.beginLine, o.toString()));
            return false;
        }
        MyVisitorBase vb = new MyVisitorBase(variableNames);
        try {
            o.traverse(vb);
            logger.finest(String.format(" %04d simplify->%s: %s", o.beginLine, vb.looksOkay(), o));
            return vb.looksOkay();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            logger.finest(String.format("!! %04d simplify->false: %s", o.beginLine, o));
            return false;
        }
    }

    private static final String getFunctionName(exprType t) {
        if (t instanceof Name) {
            return ((Name)t).id;
        }
        if (t instanceof Attribute) {
            Attribute a = (Attribute)t;
            return SimplifyScriptSupport.getFunctionName(a.value) + "." + a.attr;
        }
        return t.toString();
    }

    private static boolean trivialFunctionCall(SimpleNode sn) {
        if (sn instanceof Call) {
            Call c = (Call)sn;
            boolean klugdyOkay = false;
            String ss = c.func.toString();
            for (String s : okay) {
                if (!ss.contains(s)) continue;
                klugdyOkay = true;
            }
            if (!klugdyOkay && ss.contains("TimeUtil") && ss.contains("now")) {
                klugdyOkay = true;
            }
            logger.log(Level.FINER, "trivialFunctionCall={0} for {1}", new Object[]{klugdyOkay, c.func.toString()});
            return klugdyOkay;
        }
        return false;
    }

    private static boolean trivialConstructorCall(SimpleNode sn) {
        if (sn instanceof Call) {
            Call c = (Call)sn;
            if (c.func instanceof Name) {
                String funcName = ((Name)c.func).id;
                return Character.isUpperCase(funcName.charAt(0));
            }
            if (c.func instanceof Attribute) {
                String funcName = ((Attribute)c.func).attr;
                return Character.isUpperCase(funcName.charAt(0));
            }
            return false;
        }
        return false;
    }

    static {
        for (String o : okay) {
            okaySet.add(o.substring(0, o.length() - 1));
        }
    }

    private static class MyVisitorBase<R>
    extends VisitorBase {
        boolean looksOkay = true;
        boolean visitNameFail = false;
        HashSet names;

        MyVisitorBase(HashSet names) {
            this.names = names;
        }

        public Object visitName(Name node) throws Exception {
            if (!this.names.contains(node.id)) {
                this.visitNameFail = true;
            }
            return super.visitName(node);
        }

        public Object visitCall(Call node) throws Exception {
            return super.visitCall(node);
        }

        protected Object unhandled_node(SimpleNode sn) throws Exception {
            return sn;
        }

        public void traverse(SimpleNode sn) throws Exception {
            if (sn instanceof Call) {
                this.looksOkay = SimplifyScriptSupport.trivialFunctionCall(sn) || SimplifyScriptSupport.trivialConstructorCall(sn);
            } else if (sn instanceof Assign) {
                Assign a = (Assign)sn;
                exprType et = a.value;
                if (et instanceof Call) {
                    this.looksOkay = SimplifyScriptSupport.trivialFunctionCall((SimpleNode)et) || SimplifyScriptSupport.trivialConstructorCall(sn);
                }
            } else if (sn instanceof Name) {
                String t = ((Name)sn).id;
                if (!this.names.contains(t) && !okaySet.contains(t)) {
                    this.looksOkay = false;
                }
            } else if (sn instanceof Attribute) {
                this.traverse((SimpleNode)((Attribute)sn).value);
            } else if (sn instanceof Subscript) {
                Subscript ss = (Subscript)sn;
                exprType et = ss.value;
                if (et instanceof Name) {
                    this.traverse((SimpleNode)((Name)et));
                }
            } else if (sn instanceof BinOp) {
                BinOp bo = (BinOp)sn;
                this.traverse((SimpleNode)bo.left);
                this.traverse((SimpleNode)bo.right);
            } else if (!(sn instanceof Num)) {
                logger.log(Level.FINE, "unchecked: {0}", sn);
            }
        }

        public boolean looksOkay() {
            return this.looksOkay;
        }

        public boolean visitNameFail() {
            return this.visitNameFail;
        }
    }
}

