/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.jythonsupport.BinaryInfixOps;
import org.autoplot.jythonsupport.PyDatum;
import org.autoplot.jythonsupport.PyQDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetIterator;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IndexListDataSetIterator;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.TrimStrideWrapper;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.CoerceUtil;
import org.das2.qds.ops.Ops;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyIterator;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyReflectedFunction;
import org.python.core.PySequence;
import org.python.core.PySlice;
import org.python.core.PyString;

public class PyQDataSet
extends PyJavaInstance {
    private static final Logger logger = Logger.getLogger("jython");
    WritableDataSet ds;
    MutablePropertyDataSet mpds;
    QDataSet rods;
    Units units;
    int serialNumber = _seq.incrementAndGet();
    private static AtomicInteger _seq = new AtomicInteger(1000);
    private static final Map<String, PyReflectedFunction> binaryInfixMethods = new HashMap<String, PyReflectedFunction>();

    public PyQDataSet(QDataSet ds) {
        super((Object)ds);
        if (ds instanceof WritableDataSet && !((WritableDataSet)ds).isImmutable()) {
            this.ds = (WritableDataSet)ds;
            this.mpds = (MutablePropertyDataSet)ds;
            this.rods = ds;
        } else if (ds instanceof MutablePropertyDataSet && !((MutablePropertyDataSet)ds).isImmutable()) {
            this.ds = null;
            this.mpds = (MutablePropertyDataSet)ds;
            this.rods = ds;
        } else if (ds.rank() == 0) {
            this.ds = null;
            this.rods = ds;
        } else {
            logger.fine("read-only dataset will not support writing.");
            this.ds = null;
            this.rods = ds;
        }
        this.units = (Units)ds.property("UNITS");
    }

    public QDataSet getQDataSet() {
        return this.rods;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public PyQDataSet __add__(PyObject arg0) {
        if (arg0 instanceof PyInteger && !arg0.__nonzero__()) {
            return this;
        }
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.add(this.rods, that));
    }

    public PyObject __radd__(PyObject arg0) {
        return this.__add__(arg0);
    }

    public PyObject __sub__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.subtract(this.rods, that));
    }

    public PyObject __rsub__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.subtract(that, this.rods));
    }

    public PyObject __mul__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.multiply(this.rods, that));
    }

    public PyObject __rmul__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.multiply(that, this.rods));
    }

    public PyObject __div__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.divide(this.rods, that));
    }

    public PyObject __rdiv__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.divide(that, this.rods));
    }

    public PyObject __floordiv__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.div(this.rods, that));
    }

    public PyObject __mod__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.mod(this.rods, that));
    }

    public PyObject __rfloordiv__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.div(that, this.rods));
    }

    public PyObject __rmod__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.mod(that, this.rods));
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __neg__() {
        return new PyQDataSet(Ops.negate(this.rods));
    }

    public PyObject __abs__() {
        return new PyQDataSet(Ops.abs(this.rods));
    }

    public PyObject __pow__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.pow(this.rods, that));
    }

    public PyObject __rpow__(PyObject arg0) {
        QDataSet that = this.coerce_ds(arg0);
        return new PyQDataSet(Ops.pow(that, this.rods));
    }

    public PyObject __int__() {
        if (this.rods.rank() > 0) {
            throw Py.TypeError((String)("PyQDataSet with rank=" + this.rods.rank() + " found where rank 0 was expected"));
        }
        return Py.newInteger((int)((int)this.rods.value()));
    }

    public PyFloat __float__() {
        if (this.rods.rank() > 0) {
            throw Py.TypeError((String)("PyQDataSet with rank=" + this.rods.rank() + " found where rank 0 was expected"));
        }
        return Py.newFloat((double)this.rods.value());
    }

    public PyLong __long__() {
        if (this.rods.rank() > 0) {
            throw Py.TypeError((String)("PyQDataSet with rank=" + this.rods.rank() + " found where rank 0 was expected"));
        }
        return Py.newLong((int)((int)this.rods.value()));
    }

    public PyObject __ge__(PyObject o) {
        PyObject r = BinaryInfixOps.ge((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .ge operator");
        }
        return r;
    }

    public PyObject __gt__(PyObject o) {
        PyObject r = BinaryInfixOps.gt((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .gt operator");
        }
        return r;
    }

    public PyObject __le__(PyObject o) {
        PyObject r = BinaryInfixOps.le((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .le operator");
        }
        return r;
    }

    public PyObject __lt__(PyObject o) {
        PyObject r = BinaryInfixOps.lt((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .lt operator");
        }
        return r;
    }

    public PyObject __eq__(PyObject o) {
        PyObject r = BinaryInfixOps.eq((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .eq operator");
        }
        return r;
    }

    public PyObject __ne__(PyObject o) {
        PyObject r = BinaryInfixOps.ne((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .ne operator");
        }
        return r;
    }

    public PyObject __and__(PyObject o) {
        PyObject r = BinaryInfixOps.and((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .and operator");
        }
        return r;
    }

    public PyObject __or__(PyObject o) {
        PyObject r = BinaryInfixOps.or((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .or operator");
        }
        return r;
    }

    public PyObject __findattr__(String name) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func;
        }
        return super.__findattr__(name);
    }

    public void __delattr__(String attr) {
        if (binaryInfixMethods.remove(attr) == null) {
            super.__delattr__(attr);
        }
    }

    public void __setattr__(String name, PyObject value) {
        if (binaryInfixMethods.containsKey(name)) {
            binaryInfixMethods.remove(name);
        }
        super.__setattr__(name, value);
    }

    public PyObject invoke(String name) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this);
        }
        return super.invoke(name);
    }

    public PyObject invoke(String name, PyObject arg1) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this, arg1);
        }
        if (name.equals("property")) {
            if (arg1 instanceof PyString) {
                return Py.java2py((Object)this.rods.property(arg1.toString()));
            }
            return super.invoke(name, arg1);
        }
        return super.invoke(name, arg1);
    }

    private void makeMutable() {
        logger.log(Level.FINE, "makeMutable called using: {0}", this.rods);
        if (this.ds == null) {
            this.ds = Ops.copy(this.rods);
            this.mpds = this.ds;
            this.rods = this.ds;
        } else {
            this.ds = Ops.copy(this.ds);
            this.mpds = this.ds;
            this.rods = this.ds;
        }
    }

    public PyObject invoke(String name, PyObject arg1, PyObject arg2) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this, arg1, arg2);
        }
        switch (name) {
            case "putProperty": {
                if (this.mpds == null || this.mpds.isImmutable()) {
                    this.makeMutable();
                }
                this.putProperty((PyString)arg1, arg2);
                return Py.None;
            }
            case "property": {
                if (arg1 instanceof PyString && arg2 instanceof PyInteger) {
                    return Py.java2py((Object)this.rods.property(arg1.toString(), ((PyInteger)arg2).getValue()));
                }
                return super.invoke(name, arg1, arg2);
            }
        }
        return super.invoke(name, arg1, arg2);
    }

    public PyObject invoke(String name, PyObject[] args, String[] keywords) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this, args, keywords);
        }
        return super.invoke(name, args, keywords);
    }

    public PyObject invoke(String name, PyObject[] args) {
        PyReflectedFunction func = binaryInfixMethods.get(name);
        if (func != null) {
            return func.__call__((PyObject)this);
        }
        return super.invoke(name, args);
    }

    protected static Number getNumber(Object po) {
        if (po instanceof QDataSet) {
            QDataSet qpo = (QDataSet)po;
            if (qpo.rank() == 0) {
                return qpo.value();
            }
            throw Py.TypeError((String)"QDataSet with rank>0 found where number was expected");
        }
        if (po instanceof PyQDataSet) {
            PyQDataSet pqd = (PyQDataSet)((Object)po);
            QDataSet qpo = pqd.rods;
            if (qpo.rank() == 0) {
                return qpo.value();
            }
            throw Py.TypeError((String)"PyQDataSet with rank>0 found where number was expected");
        }
        if (po instanceof PyObject) {
            Object result = ((PyObject)po).__tojava__(Number.class);
            if (result == Py.NoConversion) {
                throw Py.TypeError((String)("can't convert to number: " + ((PyObject)po).__repr__()));
            }
            return (Number)result;
        }
        if (po instanceof Number) {
            return (Number)po;
        }
        throw Py.TypeError((String)("can't convert to number: " + po));
    }

    public int __len__() {
        return this.rods.length();
    }

    private PyObject maybeAdaptList(PyObject arg0) {
        PyList list;
        if (arg0 instanceof PyList && (list = (PyList)arg0).size() > 0) {
            Object o = list.get(0);
            if (o instanceof Number) {
                arg0 = new PyQDataSet(PyQDataSetAdapter.adaptList(list));
            } else if (o instanceof QDataSet || o instanceof Datum) {
                arg0 = new PyQDataSet(PyQDataSetAdapter.adaptList(list));
            } else if (o instanceof PyInteger || o instanceof PyFloat || o instanceof PyLong) {
                arg0 = new PyQDataSet(PyQDataSetAdapter.adaptList(list));
            }
        }
        return arg0;
    }

    public PyObject __getitem__(PyObject arg0) {
        Object o;
        if (arg0 instanceof PyList) {
            arg0 = this.maybeAdaptList((PyObject)((PyList)arg0));
        }
        if ((o = arg0.__tojava__(QDataSet.class)) == null || o == Py.NoConversion) {
            if (arg0 instanceof PySlice) {
                PySlice slice = (PySlice)arg0;
                Number start = PyQDataSet.getNumber(slice.start);
                Number stop = PyQDataSet.getNumber(slice.stop);
                Number step = PyQDataSet.getNumber(slice.step);
                if (step == null || step.equals(1)) {
                    if (start == null) {
                        start = 0;
                    }
                    if (stop == null) {
                        stop = this.rods.length();
                    }
                    if (start.intValue() < 0) {
                        start = this.rods.length() + start.intValue();
                    }
                    if (stop.intValue() < 0) {
                        stop = this.rods.length() + stop.intValue();
                    }
                    return new PyQDataSet(this.rods.trim(start.intValue(), stop.intValue()));
                }
                TrimStrideWrapper wds = new TrimStrideWrapper(this.rods);
                wds.setTrim(0, start, stop, step);
                return new PyQDataSet(wds);
            }
            if (arg0.isNumberType()) {
                int idx = ((Number)arg0.__tojava__(Number.class)).intValue();
                if (idx < 0) {
                    idx = this.rods.length() + idx;
                }
                QDataSet sds = this.rods.slice(idx);
                return new PyQDataSet(sds);
            }
            if (arg0.isSequenceType()) {
                PySequence slices = (PySequence)arg0;
                if (slices.__len__() == 2 && slices.__getitem__(1) instanceof PyInteger && slices.__getitem__(0) instanceof PySlice) {
                    int index = ((Number)slices.__getitem__(1).__tojava__(Number.class)).intValue();
                    if (index < 0) {
                        index = this.rods.length(0) + index;
                    }
                    QDataSet unb1 = DataSetOps.unbundle(this.rods, index, false);
                    PySlice slice = (PySlice)slices.__getitem__(0);
                    if (slice.start instanceof PyNone && slice.stop instanceof PyNone && slice.step instanceof PyNone) {
                        return new PyQDataSet(unb1);
                    }
                    if (slice.step instanceof PyNone || ((Number)slice.step.__tojava__(Number.class)).intValue() == 1) {
                        int stop;
                        int start = slice.start.isNumberType() ? ((Number)slice.start.__tojava__(Number.class)).intValue() : 0;
                        int n = stop = slice.stop.isNumberType() ? ((Number)slice.stop.__tojava__(Number.class)).intValue() : unb1.length();
                        if (start < 0) {
                            start = unb1.length() + start;
                        }
                        if (stop < 0) {
                            stop = unb1.length() + stop;
                        }
                        return new PyQDataSet(unb1.trim(start, stop));
                    }
                }
                if (slices.__len__() > this.rods.rank()) {
                    throw new IllegalArgumentException("rank " + slices.__len__() + " access on a rank " + this.rods.rank() + " dataset");
                }
                HashMap<String, Object> bundleProps = new HashMap<String, Object>();
                QubeDataSetIterator iter = new QubeDataSetIterator(this.rods);
                for (int i = 0; i < slices.__len__(); ++i) {
                    QubeDataSetIterator.DimensionIteratorFactory fit;
                    PyObject a = slices.__getitem__(i);
                    if (a instanceof PySlice) {
                        PySlice slice = (PySlice)a;
                        Number start = PyQDataSet.getNumber(slice.start);
                        Number stop = PyQDataSet.getNumber(slice.stop);
                        Number step = PyQDataSet.getNumber(slice.step);
                        fit = new QubeDataSetIterator.StartStopStepIteratorFactory(start, stop, step);
                    } else if (a instanceof PyQDataSet) {
                        Object o2 = a.__tojava__(QDataSet.class);
                        QDataSet that = (QDataSet)o2;
                        if (that.rank() == 0) {
                            int idx = (int)that.value();
                            fit = new QubeDataSetIterator.SingletonIteratorFactory(idx);
                        } else {
                            fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
                        }
                    } else if (a.isNumberType()) {
                        QDataSet bds;
                        int idx = PyQDataSet.getNumber(a).intValue();
                        fit = new QubeDataSetIterator.SingletonIteratorFactory(idx);
                        if (i == this.rods.rank() - 1 && (bds = (QDataSet)this.rods.property("BUNDLE_" + i)) != null && this.rods.property("DEPEND_" + i) == null) {
                            DataSetUtil.sliceProperties(bds, idx, bundleProps);
                        }
                    } else {
                        QDataSet that = this.coerce_ds(a);
                        fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
                    }
                    iter.setIndexIteratorFactory(i, fit);
                }
                DDataSet result = iter.createEmptyDs();
                QubeDataSetIterator resultIter = new QubeDataSetIterator(result);
                while (iter.hasNext()) {
                    iter.next();
                    double d = iter.getValue(this.rods);
                    resultIter.next();
                    resultIter.putValue(result, d);
                }
                DataSetUtil.copyDimensionProperties(this.rods, result);
                if (!bundleProps.isEmpty()) {
                    DataSetUtil.putProperties(bundleProps, result);
                }
                return new PyQDataSet(result);
            }
            throw Py.TypeError((String)("invalid index type: " + arg0));
        }
        QDataSet that = (QDataSet)o;
        QubeDataSetIterator iter = new QubeDataSetIterator(this.rods);
        QDataSet dep0 = null;
        if (that.rank() > 1 && (SemanticOps.isBundle(that) || SemanticOps.isLegacyBundle(that))) {
            for (int j = 0; j < that.length(0); ++j) {
                QDataSet that1 = DataSetOps.unbundle(that, j);
                QubeDataSetIterator.IndexListIteratorFactory fit = new QubeDataSetIterator.IndexListIteratorFactory(that1);
                try {
                    iter.setIndexIteratorFactory(j, fit);
                    if (j != 0 || (dep0 = (QDataSet)this.rods.property("DEPEND_0")) == null) continue;
                    dep0 = DataSetOps.applyIndex(dep0, 0, that1, false);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    ArrayIndexOutOfBoundsException ex1 = new ArrayIndexOutOfBoundsException("array index is out of bounds because of expression like accumS[r] where r is rank 2 list of indeces.");
                    throw ex1;
                }
            }
        } else {
            if (that.rank() == 0) {
                QDataSet sds = this.rods.slice((int)that.value());
                return new PyQDataSet(sds);
            }
            QubeDataSetIterator.IndexListIteratorFactory fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
            iter.setIndexIteratorFactory(0, fit);
            dep0 = (QDataSet)this.rods.property("DEPEND_0");
            if (dep0 != null) {
                dep0 = DataSetOps.applyIndex(dep0, 0, that, false);
            }
        }
        DDataSet result = iter.createEmptyDs();
        QubeDataSetIterator resultIter = new QubeDataSetIterator(result);
        while (iter.hasNext()) {
            iter.next();
            double d = iter.getValue(this.rods);
            resultIter.next();
            resultIter.putValue(result, d);
        }
        if (dep0 != null && dep0.length() == result.length()) {
            result.putProperty("DEPEND_0", dep0);
        }
        DataSetUtil.copyDimensionProperties(this.rods, result);
        return new PyQDataSet(result);
    }

    public void __setitem__(PyObject arg0, PyObject arg1) {
        UnitsConverter uc;
        if (this.ds == null || this.ds.isImmutable()) {
            this.makeMutable();
        }
        DataSetIterator iter = new QubeDataSetIterator(this.ds);
        if (arg0 instanceof PyList) {
            arg0 = this.maybeAdaptList((PyObject)((PyList)arg0));
        }
        if (!arg0.isSequenceType()) {
            QubeDataSetIterator.DimensionIteratorFactory fit;
            PyObject a = arg0;
            if (a instanceof PySlice) {
                PySlice slice = (PySlice)a;
                Integer start = slice.start == Py.None ? null : Integer.valueOf(PyQDataSet.getInteger(slice.start));
                Integer stop = slice.stop == Py.None ? null : Integer.valueOf(PyQDataSet.getInteger(slice.stop));
                Integer step = slice.step == Py.None ? null : Integer.valueOf(PyQDataSet.getInteger(slice.step));
                fit = new QubeDataSetIterator.StartStopStepIteratorFactory(start, stop, step);
            } else if (a.isNumberType()) {
                int idx = ((Number)a.__tojava__(Number.class)).intValue();
                fit = new QubeDataSetIterator.SingletonIteratorFactory(idx);
            } else {
                Object o = a.__tojava__(QDataSet.class);
                QDataSet that = (QDataSet)o;
                fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
            }
            ((QubeDataSetIterator)iter).setIndexIteratorFactory(0, fit);
        } else if (arg0 instanceof PyQDataSet) {
            Object o = arg0.__tojava__(QDataSet.class);
            QDataSet that = (QDataSet)o;
            if (this.ds.rank() > 1) {
                iter = new IndexListDataSetIterator(that);
            } else {
                QubeDataSetIterator.IndexListIteratorFactory fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
                ((QubeDataSetIterator)iter).setIndexIteratorFactory(0, fit);
            }
        } else {
            PySequence slices = (PySequence)arg0;
            QDataSet[] lists = new QDataSet[slices.__len__()];
            boolean allLists = true;
            int[] qubedims = DataSetUtil.qubeDims(this.ds);
            for (int i = 0; i < slices.__len__(); ++i) {
                PyObject a = slices.__getitem__(i);
                if (!(a instanceof PyQDataSet || a instanceof PyInteger || a instanceof PyFloat)) {
                    allLists = false;
                    continue;
                }
                if (a instanceof PyInteger || a instanceof PyFloat) {
                    int idx = a instanceof PyInteger ? ((PyInteger)a).getValue() : (int)((PyFloat)a).getValue();
                    if (idx < 0 && (i == 0 || qubedims != null)) {
                        idx = i == 0 ? this.ds.length() + idx : qubedims[i] + idx;
                    }
                    lists[i] = DataSetUtil.asDataSet(idx);
                    continue;
                }
                lists[i] = ((PyQDataSet)a).rods;
            }
            if (allLists) {
                int i;
                QDataSet val = this.coerceDsInternal(arg1);
                QDataSet[] ll = new QDataSet[2];
                ll[0] = lists[0];
                for (i = 1; i < slices.__len__(); ++i) {
                    ll[1] = lists[i];
                    CoerceUtil.coerce(ll[0], ll[1], false, ll);
                    lists[0] = ll[0];
                    lists[i] = ll[1];
                }
                for (i = 1; i < slices.__len__(); ++i) {
                    ll[1] = lists[i];
                    CoerceUtil.coerce(ll[0], ll[1], false, ll);
                    lists[0] = ll[0];
                    lists[i] = ll[1];
                }
                CoerceUtil.coerce(ll[0], val, false, ll);
                val = ll[1];
                QubeDataSetIterator it = new QubeDataSetIterator(val);
                if (lists[0].rank() == 0) {
                    switch (this.ds.rank()) {
                        case 1: {
                            it.next();
                            this.ds.putValue((int)lists[0].value(), it.getValue(val));
                            break;
                        }
                        case 2: {
                            it.next();
                            this.ds.putValue((int)lists[0].value(), (int)lists[1].value(), it.getValue(val));
                            break;
                        }
                        case 3: {
                            it.next();
                            this.ds.putValue((int)lists[0].value(), (int)lists[1].value(), (int)lists[2].value(), it.getValue(val));
                            break;
                        }
                        case 4: {
                            it.next();
                            this.ds.putValue((int)lists[0].value(), (int)lists[1].value(), (int)lists[2].value(), (int)lists[3].value(), it.getValue(val));
                            break;
                        }
                    }
                } else {
                    int n = lists[0].length();
                    switch (this.ds.rank()) {
                        case 1: {
                            for (int i2 = 0; i2 < n; ++i2) {
                                it.next();
                                this.ds.putValue((int)lists[0].value(i2), it.getValue(val));
                            }
                            break;
                        }
                        case 2: {
                            for (int i3 = 0; i3 < n; ++i3) {
                                it.next();
                                this.ds.putValue((int)lists[0].value(i3), (int)lists[1].value(i3), it.getValue(val));
                            }
                            break;
                        }
                        case 3: {
                            for (int i4 = 0; i4 < n; ++i4) {
                                it.next();
                                this.ds.putValue((int)lists[0].value(i4), (int)lists[1].value(i4), (int)lists[2].value(i4), it.getValue(val));
                            }
                            break;
                        }
                        case 4: {
                            for (int i5 = 0; i5 < n; ++i5) {
                                it.next();
                                this.ds.putValue((int)lists[0].value(i5), (int)lists[1].value(i5), (int)lists[2].value(i5), (int)lists[3].value(i5), it.getValue(val));
                            }
                            break;
                        }
                    }
                }
                if (this.units == null) {
                    logger.fine("resetting units based on values assigned");
                    Units u = SemanticOps.getUnits(val);
                    if (u != Units.dimensionless) {
                        this.ds.putProperty("UNITS", u);
                    }
                    this.units = u;
                }
                return;
            }
            int[] qubeDims = DataSetUtil.qubeDims(this.ds);
            for (int i = 0; i < slices.__len__(); ++i) {
                QubeDataSetIterator.DimensionIteratorFactory fit;
                PyObject a = slices.__getitem__(i);
                if (a instanceof PySlice) {
                    PySlice slice = (PySlice)a;
                    Integer start = (Integer)slice.start.__tojava__(Integer.class);
                    Integer stop = (Integer)slice.stop.__tojava__(Integer.class);
                    Integer step = (Integer)slice.step.__tojava__(Integer.class);
                    fit = new QubeDataSetIterator.StartStopStepIteratorFactory(start, stop, step);
                } else if (a.isNumberType() && !(a instanceof PyQDataSet)) {
                    if (a instanceof PyFloat) {
                        throw new IllegalArgumentException("float used to index array");
                    }
                    int idx = (Integer)a.__tojava__(Integer.class);
                    if (idx < 0) {
                        if (i == 0 || qubeDims != null) {
                            idx = i == 0 ? this.ds.length() + idx : qubeDims[i] + idx;
                        } else {
                            throw new IllegalArgumentException("negative index not supported for non-qube.");
                        }
                    }
                    fit = new QubeDataSetIterator.SingletonIteratorFactory(idx);
                } else {
                    QDataSet that = this.coerce_ds(a);
                    fit = new QubeDataSetIterator.IndexListIteratorFactory(that);
                }
                ((QubeDataSetIterator)iter).setIndexIteratorFactory(i, fit);
            }
        }
        QDataSet val = this.coerceDsInternal(arg1);
        if (this.units == null) {
            logger.fine("resetting units based on values assigned");
            Units u = SemanticOps.getUnits(val);
            if (u != Units.dimensionless) {
                this.ds.putProperty("UNITS", u);
            }
            this.units = u;
        }
        try {
            uc = SemanticOps.getUnits(val).getConverter(this.units);
        }
        catch (InconvertibleUnitsException ex) {
            uc = UnitsConverter.IDENTITY;
        }
        if (val.rank() == 0) {
            double d = uc.convert(val.value());
            while (iter.hasNext()) {
                iter.next();
                iter.putValue(this.ds, d);
            }
        } else {
            if (val.rank() != iter.rank()) {
                throw new IllegalArgumentException("not supported, couldn't reconcile ranks in set[" + val + "]=" + iter);
            }
            QubeDataSetIterator it = new QubeDataSetIterator(val);
            while (it.hasNext()) {
                it.next();
                double d = uc.convert(it.getValue(val));
                iter.next();
                iter.putValue(this.ds, d);
            }
        }
    }

    private static int getInteger(PyObject obj) {
        if (obj instanceof PyQDataSet) {
            PyQDataSet pds = (PyQDataSet)obj;
            if (pds.rods.rank() != 0) {
                throw new IllegalArgumentException("QDataSet cannot be interpreted as integer, because its rank is greater than 0");
            }
            return (int)pds.rods.value();
        }
        return ((Number)obj.__tojava__(Number.class)).intValue();
    }

    private static Object convertPropertyValue(QDataSet context, String name, Object value) {
        if (value == null) {
            return value;
        }
        if (value instanceof PyObject) {
            PyObject pyvalue = (PyObject)value;
            value = value instanceof PyQDataSet ? pyvalue.__tojava__(QDataSet.class) : (value instanceof PyDatum ? pyvalue.__tojava__(Datum.class) : (value instanceof PyInteger ? pyvalue.__tojava__(Integer.class) : (value instanceof PyFloat ? pyvalue.__tojava__(Float.class) : (value instanceof PyLong ? pyvalue.__tojava__(Long.class) : (value instanceof PyString ? pyvalue.__tojava__(String.class) : pyvalue.__tojava__(Object.class))))));
        }
        value = Ops.convertPropertyValue(context, name, value);
        return value;
    }

    public void putProperty(PyString prop, Object value) {
        if (this.mpds == null || this.mpds.isImmutable()) {
            throw new RuntimeException("putProperty on dataset that could not be made into mutable, use copy.");
        }
        String sprop = prop.toString();
        if (value.equals(Py.None)) {
            value = null;
        }
        value = PyQDataSet.convertPropertyValue(this.rods, prop.toString(), value);
        this.mpds.putProperty(sprop, value);
    }

    public void putProperty(PyString prop, int index, Object value) {
        if (this.mpds == null || this.mpds.isImmutable()) {
            throw new RuntimeException("putProperty on dataset that could not be made into mutable, use copy.");
        }
        String sprop = prop.toString();
        if (value.equals(Py.None)) {
            value = null;
        } else if (value instanceof PyObject) {
            Class clas = DataSetUtil.getPropertyClass(prop.toString());
            PyObject po = (PyObject)value;
            value = po.__tojava__(clas);
        }
        this.mpds.putProperty(sprop, index, value);
    }

    public void putValue(double value) {
        if (this.ds == null) {
            throw new RuntimeException("putProperty on dataset that could not be made into mutable, use copy.");
        }
        this.ds.putValue(value);
    }

    public void putValue(int i0, double value) {
        if (this.ds == null) {
            throw new RuntimeException("putProperty on dataset that could not be made into mutable, use copy.");
        }
        this.ds.putValue(i0, value);
    }

    public void putValue(int i0, int i1, double value) {
        if (this.ds == null) {
            throw new RuntimeException("putProperty on dataset that could not be made into mutable, use copy.");
        }
        this.ds.putValue(i0, i1, value);
    }

    public void putValue(int i0, int i1, int i2, double value) {
        if (this.ds == null) {
            throw new RuntimeException("putProperty on dataset that could not be made into mutable, use copy.");
        }
        this.ds.putValue(i0, i1, i2, value);
    }

    public void putValue(int i0, int i1, int i2, int i3, double value) {
        if (this.ds == null) {
            throw new RuntimeException("putProperty on dataset that could not be made into mutable, use copy.");
        }
        this.ds.putValue(i0, i1, i2, i3, value);
    }

    private QDataSet coerceDsInternal(PyObject arg0) {
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            if (arg0.isNumberType()) {
                QDataSet do2;
                Object o2 = arg0.__tojava__(Object.class);
                if (o2 instanceof Number) {
                    double d = ((Number)o2).doubleValue();
                    return DataSetUtil.asDataSet(d);
                }
                if (o2 instanceof TimeUtil.TimeStruct) {
                    do2 = DataSetUtil.asDataSet(TimeUtil.toDatum((TimeUtil.TimeStruct)o2));
                } else if (o2 instanceof Datum) {
                    do2 = DataSetUtil.asDataSet((Datum)o2);
                } else if (o2 instanceof DatumRange) {
                    do2 = DataSetUtil.asDataSet((DatumRange)o2);
                } else {
                    throw new ClassCastException("unable to convert: " + arg0);
                }
                return do2;
            }
            if (arg0 instanceof PyString) {
                try {
                    return DataSetUtil.asDataSet(DatumUtil.parse(arg0.toString()));
                }
                catch (ParseException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            if (arg0.isSequenceType()) {
                return PyQDataSetAdapter.adaptList((PyList)arg0);
            }
            throw Py.TypeError((String)("unable to coerce: " + arg0));
        }
        QDataSet lds = (QDataSet)o;
        if (lds.rank() == 0) {
            return lds;
        }
        return lds;
    }

    public QDataSet gt(Object o) {
        logger.fine(String.valueOf(o));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PyQDataSet append(PyObject arg0) {
        DDataSet result;
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            if (arg0.isNumberType()) {
                double d = (Double)arg0.__tojava__(Double.class);
                result = (DDataSet)ArrayDataSet.copy(Double.TYPE, this.rods);
                result = (DDataSet)ArrayDataSet.append(result, DDataSet.wrap(new double[]{d}));
                return new PyQDataSet(result);
            } else {
                if (!arg0.isSequenceType()) throw Py.TypeError((String)("unable to coerce: " + arg0));
                result = (DDataSet)ArrayDataSet.copy(Double.TYPE, this.rods);
                result = (DDataSet)ArrayDataSet.append(result, DDataSet.copy(PyQDataSetAdapter.adaptList((PyList)arg0)));
            }
            return new PyQDataSet(result);
        } else {
            QDataSet lds = (QDataSet)o;
            result = (DDataSet)ArrayDataSet.copy(Double.TYPE, this.rods);
            result = (DDataSet)ArrayDataSet.append(result, DDataSet.copy(lds));
        }
        return new PyQDataSet(result);
    }

    private QDataSet coerce_ds(PyObject arg0) {
        return this.coerceDsInternal(arg0);
    }

    public Object __coerce_ex__(PyObject arg0) {
        return this.coerceDsInternal(arg0);
    }

    public PyObject __iter__() {
        return new PyIterator(){
            int i = 0;

            public PyObject __iternext__() {
                if (this.i < PyQDataSet.this.rods.length()) {
                    PyQDataSet result = new PyQDataSet(PyQDataSet.this.rods.slice(this.i));
                    ++this.i;
                    return result;
                }
                return null;
            }
        };
    }

    public Object __tojava__(Class c) {
        if (c.isArray() && c.getComponentType() == Double.TYPE && this.rods.rank() == 1) {
            double[] result = new double[this.rods.length()];
            for (int i = 0; i < this.rods.length(); ++i) {
                result[i] = this.rods.value(i);
            }
            return result;
        }
        if (c.isAssignableFrom(QDataSet.class)) {
            return this.rods;
        }
        if (c.isAssignableFrom(MutablePropertyDataSet.class)) {
            return this.mpds;
        }
        if (c.isAssignableFrom(WritableDataSet.class)) {
            return this.ds;
        }
        return super.__tojava__(c);
    }

    public String toString() {
        return "" + this.rods.toString() + " (pyqds)";
    }

    public boolean isNumberType() {
        return this.rods.rank() == 0;
    }

    static {
        binaryInfixMethods.put("gt", new PyReflectedFunction("gt"));
        for (Method m : BinaryInfixOps.class.getMethods()) {
            PyReflectedFunction func = binaryInfixMethods.get(m.getName());
            if (func == null) {
                func = new PyReflectedFunction(m.getName());
                binaryInfixMethods.put(m.getName(), func);
            }
            func.addMethod(m);
        }
    }
}

