/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.util.logging.Logger;
import org.autoplot.jythonsupport.BinaryInfixOps;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.PyQDataSet;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.qds.DataSetUtil;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyString;

public class PyDatum
extends PyJavaInstance {
    private static final Logger logger = Logger.getLogger("jython");
    Datum datum;

    public PyDatum(Datum d) {
        super((Object)d);
        this.datum = d;
    }

    public PyObject __add__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return new PyDatum(this.datum.add(((PyDatum)arg0).datum));
        }
        if (arg0 instanceof PyQDataSet) {
            return arg0.__radd__((PyObject)this);
        }
        if (arg0.isNumberType()) {
            return new PyDatum(this.datum.add(this.datum.getUnits().createDatum(arg0.__float__().getValue())));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__add__(arg0);
    }

    public PyObject __radd__(PyObject arg0) {
        return this.__add__(arg0);
    }

    public PyObject __sub__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return new PyDatum(this.datum.subtract(((PyDatum)arg0).datum));
        }
        if (arg0 instanceof PyQDataSet) {
            return arg0.__rsub__((PyObject)this);
        }
        if (arg0.isNumberType()) {
            return new PyDatum(this.datum.subtract(this.datum.getUnits().createDatum(arg0.__float__().getValue())));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__sub__(arg0);
    }

    public PyObject __rsub__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return new PyDatum(((PyDatum)arg0).datum.subtract(this.datum));
        }
        if (arg0.isNumberType()) {
            return new PyDatum(this.datum.getUnits().createDatum(arg0.__float__().getValue()).subtract(this.datum));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__rsub__(arg0);
    }

    public PyObject __mul__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return new PyDatum(this.datum.multiply(((PyDatum)arg0).datum));
        }
        if (arg0 instanceof PyQDataSet) {
            return arg0.__rmul__((PyObject)this);
        }
        if (arg0.isNumberType()) {
            return new PyDatum(this.datum.multiply(Units.dimensionless.createDatum(arg0.__float__().getValue())));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__mul__(arg0);
    }

    public PyObject __rmul__(PyObject arg0) {
        return this.__mul__(arg0);
    }

    public PyObject __div__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return new PyDatum(this.datum.divide(((PyDatum)arg0).datum));
        }
        if (arg0 instanceof PyQDataSet) {
            return arg0.__rdiv__((PyObject)this);
        }
        if (arg0.isNumberType()) {
            return new PyDatum(this.datum.divide(Units.dimensionless.createDatum(arg0.__float__().getValue())));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__div__(arg0);
    }

    public PyObject __rdiv__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return new PyDatum(((PyDatum)arg0).datum.divide(this.datum));
        }
        if (arg0.isNumberType()) {
            return new PyDatum(Units.dimensionless.createDatum(arg0.__float__().getValue()).divide(this.datum));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__rdiv__(arg0);
    }

    public PyObject __floordiv__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            double d = this.datum.doubleValue(this.datum.getUnits());
            double divisor = ((PyDatum)arg0).datum.doubleValue(this.datum.getUnits());
            d = Math.floor(d / divisor);
            return new PyDatum(Units.dimensionless.createDatum(d));
        }
        if (arg0.isNumberType()) {
            double d = this.datum.doubleValue(this.datum.getUnits());
            double divisor = arg0.__float__().getValue();
            d = Math.floor(d / divisor);
            return new PyDatum(this.datum.getUnits().createDatum(d));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__floordiv__(arg0);
    }

    public PyObject __rfloordiv__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            double divisor = this.datum.doubleValue(this.datum.getUnits());
            double d = ((PyDatum)arg0).datum.doubleValue(this.datum.getUnits());
            d = Math.floor(d / divisor);
            return new PyDatum(Units.dimensionless.createDatum(d));
        }
        if (arg0.isNumberType()) {
            double divisor = this.datum.doubleValue(this.datum.getUnits());
            double d = arg0.__float__().getValue();
            d = Math.floor(d / divisor);
            return new PyDatum(this.datum.getUnits().createDatum(d));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__rfloordiv__(arg0);
    }

    public PyObject __mod__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            Datum d1 = this.datum;
            Units u1 = d1.getUnits().getOffsetUnits();
            Datum d2 = ((PyDatum)arg0).datum;
            Units u2 = d2.getUnits();
            UnitsConverter uc = u1.getConverter(u2);
            double base = 0.0;
            double d = uc.convert(d1.value() - 0.0) % d2.value();
            return new PyDatum(u2.createDatum(d));
        }
        if (arg0.isNumberType()) {
            Datum d1 = this.datum;
            double base = 0.0;
            double d = (d1.value() - 0.0) % arg0.__float__().getValue();
            return new PyDatum(Units.dimensionless.createDatum(d));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__mod__(arg0);
    }

    public PyObject __rmod__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            Datum d2 = this.datum;
            Units u2 = d2.getUnits().getOffsetUnits();
            Datum d1 = ((PyDatum)arg0).datum;
            Units u1 = d1.getUnits();
            UnitsConverter uc = u1.getConverter(u2);
            double base = 0.0;
            double d = uc.convert(d1.value() - 0.0) % d2.value();
            return new PyDatum(u2.createDatum(d));
        }
        if (arg0.isNumberType()) {
            Datum d1 = this.datum;
            double divisor = d1.value();
            double d = arg0.__float__().getValue() % divisor;
            return new PyDatum(Units.dimensionless.createDatum(d));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__rmod__(arg0);
    }

    public PyObject __pos__() {
        return this;
    }

    public PyObject __neg__() {
        return new PyDatum(this.datum.negative());
    }

    public PyObject __abs__() {
        return new PyDatum(this.datum.abs());
    }

    public PyObject __pow__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return new PyDatum(this.datum.power(((PyDatum)arg0).datum));
        }
        if (arg0.isNumberType()) {
            double darg = arg0.__float__().getValue();
            return new PyDatum(this.datum.power(darg));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__pow__(arg0);
    }

    public PyObject __rpow__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return new PyDatum(((PyDatum)arg0).datum.power(this.datum));
        }
        if (arg0.isNumberType()) {
            double darg = arg0.__float__().getValue();
            return new PyDatum(Units.dimensionless.createDatum(darg).power(this.datum));
        }
        return new PyQDataSet(DataSetUtil.asDataSet(this.datum)).__rpow__(arg0);
    }

    public PyObject __int__() {
        return Py.newInteger((int)((int)this.datum.value()));
    }

    public PyFloat __float__() {
        return Py.newFloat((double)this.datum.value());
    }

    public PyLong __long__() {
        return Py.newLong((int)((int)this.datum.value()));
    }

    private static PyObject toPyBoolean(boolean r) {
        return new PyInteger(r ? 1 : 0);
    }

    public PyObject __ge__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return PyDatum.toPyBoolean(this.datum.ge(((PyDatum)arg0).datum));
        }
        if (arg0.isNumberType()) {
            return PyDatum.toPyBoolean(this.datum.ge(this.datum.getUnits().createDatum(arg0.__float__().getValue())));
        }
        return PyDatum.toPyBoolean(this.datum.ge(JythonOps.datum(arg0)));
    }

    public PyObject __gt__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return PyDatum.toPyBoolean(this.datum.gt(((PyDatum)arg0).datum));
        }
        if (arg0.isNumberType()) {
            return PyDatum.toPyBoolean(this.datum.gt(this.datum.getUnits().createDatum(arg0.__float__().getValue())));
        }
        return PyDatum.toPyBoolean(this.datum.gt(JythonOps.datum(arg0)));
    }

    public PyObject __le__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return PyDatum.toPyBoolean(this.datum.le(((PyDatum)arg0).datum));
        }
        if (arg0.isNumberType()) {
            return PyDatum.toPyBoolean(this.datum.le(this.datum.getUnits().createDatum(arg0.__float__().getValue())));
        }
        return PyDatum.toPyBoolean(this.datum.le(JythonOps.datum(arg0)));
    }

    public PyObject __lt__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return PyDatum.toPyBoolean(this.datum.lt(((PyDatum)arg0).datum));
        }
        if (arg0.isNumberType()) {
            return PyDatum.toPyBoolean(this.datum.lt(this.datum.getUnits().createDatum(arg0.__float__().getValue())));
        }
        return PyDatum.toPyBoolean(this.datum.lt(JythonOps.datum(arg0)));
    }

    public PyObject __eq__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return PyDatum.toPyBoolean(this.datum.equals(((PyDatum)arg0).datum));
        }
        return PyDatum.toPyBoolean(this.datum.equals(JythonOps.datum(arg0)));
    }

    public PyObject __ne__(PyObject arg0) {
        if (arg0 instanceof PyDatum) {
            return PyDatum.toPyBoolean(!this.datum.equals(((PyDatum)arg0).datum));
        }
        return PyDatum.toPyBoolean(!this.datum.equals(JythonOps.datum(arg0)));
    }

    public PyObject __and__(PyObject o) {
        PyObject r = BinaryInfixOps.and((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .and operator");
        }
        return r;
    }

    public PyObject __or__(PyObject o) {
        PyObject r = BinaryInfixOps.or((PyObject)this, o);
        if (r instanceof PyQDataSet) {
            throw new IllegalArgumentException("use .or operator");
        }
        return r;
    }

    public Object __tojava__(Class c) {
        return super.__tojava__(c);
    }

    public PyString __str__() {
        return new PyString(this.datum.toString());
    }
}

