/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.jythonsupport.DatasetCommand;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.PyDatumAdapter;
import org.autoplot.jythonsupport.PyQDataSetAdapter;
import org.autoplot.jythonsupport.Util;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.FileUtil;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySyntaxError;
import org.python.core.PySystemState;
import org.python.core.adapter.PyObjectAdapter;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.Call;
import org.python.parser.ast.If;
import org.python.parser.ast.Import;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Print;
import org.python.parser.ast.Subscript;
import org.python.parser.ast.VisitorBase;
import org.python.parser.ast.VisitorIF;
import org.python.parser.ast.exprType;
import org.python.parser.ast.stmtType;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class JythonUtil {
    private static final Logger logger = LoggerManager.getLogger("jython");
    private static boolean haveloadedAdapters = false;
    private static final String[] okay = new String[]{"range,", "xrange,", "getParam,", "lower,", "upper,", "URI,", "URL,", "DatumRangeUtil,", "TimeParser", "str,", "int,", "long,", "float,", "datum,"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InteractiveInterpreter createInterpreter(boolean sandbox) throws IOException {
        String[] loadClasses;
        if (PySystemState.cachedir == null) {
            System.setProperty("python.cachedir", System.getProperty("user.home") + "/autoplot_data/pycache");
        }
        PySystemState pySys = new PySystemState();
        for (String pysrc : loadClasses = new String[]{"glob.py", "autoplot2017.py", "autoplotapp2017.py"}) {
            String f;
            if (pysrc.equals("glob.py")) {
                URL jarUrl = InteractiveInterpreter.class.getResource("/" + pysrc);
                if (jarUrl != null) {
                    String f2 = JythonUtil.getLocalJythonLib();
                    pySys.path.insert(0, (PyObject)new PyString(f2));
                    continue;
                }
                logger.log(Level.WARNING, "Couldn''t find jar containing {0}.  See https://sourceforge.net/p/autoplot/bugs/576/", pysrc);
                continue;
            }
            if (pysrc.equals("autoplotapp2017.py")) {
                f = JythonUtil.getLocalJythonAutoplotAppLib();
                if (pySys.path.contains((Object)new PyString(f))) continue;
                pySys.path.insert(0, (PyObject)new PyString(f));
                continue;
            }
            f = JythonUtil.getLocalJythonAutoplotLib();
            if (pySys.path.contains((Object)new PyString(f))) continue;
            pySys.path.insert(0, (PyObject)new PyString(f));
        }
        InteractiveInterpreter interp = new InteractiveInterpreter(null, pySys);
        boolean loadAutoplotStuff = true;
        if (loadAutoplotStuff) {
            JythonUtil.maybeLoadAdapters();
            if (Util.isLegacyImports()) {
                URL imports = JythonOps.class.getResource("/imports2017.py");
                if (imports == null) {
                    throw new RuntimeException("unable to locate imports2017.py on classpath");
                }
                logger.log(Level.FINE, "loading imports2017.py from {0}", imports);
                InputStream in = imports.openStream();
                byte[] bimports = FileUtil.readBytes((InputStream)in);
                String simports = new String(bimports);
                logger.log(Level.FINE, simports);
                try {
                    interp.execfile((InputStream)new ByteArrayInputStream(bimports), "/imports2017.py");
                }
                finally {
                    in.close();
                }
            }
        }
        interp.set("dataset", (PyObject)new DatasetCommand());
        interp.set("monitor", (Object)new NullProgressMonitor());
        return interp;
    }

    public static void setupInterp(PythonInterpreter interp, String pwd, String resourceUri, Map<String, String> paramsl, ProgressMonitor mon) {
        interp.set("PWD", (Object)pwd);
        interp.exec("import autoplot2017 as autoplot");
        interp.exec("autoplot.params=dict()");
        for (Map.Entry<String, String> e : paramsl.entrySet()) {
            String s = e.getKey();
            if (s.equals("arg_0") || s.equals("script")) continue;
            String sval = e.getValue();
            sval = JythonUtil.maybeQuoteString(sval);
            logger.log(Level.FINE, "autoplot.params[''{0}'']={1}", new Object[]{s, sval});
            interp.exec("autoplot.params['" + s + "']=" + sval);
        }
        if (resourceUri != null) {
            interp.set("resourceURI", (Object)resourceUri);
            interp.exec("autoplot.params['resourceURI']=" + JythonUtil.maybeQuoteString(resourceUri));
        }
        interp.set("monitor", (Object)mon);
        try (InputStream in = JythonOps.class.getResource("/autoplot2017.py").openStream();){
            interp.execfile(in, "/autoplot2017.py");
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void transferStream(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[2048];
        try {
            int n = in.read(buf);
            while (n > -1) {
                out.write(buf, 0, n);
                n = in.read(buf);
            }
        }
        finally {
            out.close();
            in.close();
        }
    }

    private static boolean makeHomeFor(File file) {
        File f = file.getParentFile();
        if (!f.exists()) {
            return f.mkdirs();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalJythonLib() throws IOException {
        File ff2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File ff3 = new File(ff2.toString() + "/jython");
        File ff4 = new File(ff2.toString() + "/jython/zlib.py");
        if (ff4.exists()) {
            return ff3.toString();
        }
        Class<JythonUtil> clazz = JythonUtil.class;
        synchronized (JythonUtil.class) {
            if (!ff3.exists() && !ff3.mkdirs()) {
                throw new IOException("Unable to mkdirs " + ff3);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (JythonUtil.class.getResource("/pylisting.txt") == null) {
                throw new IllegalArgumentException("unable to find pylisting.txt in application, which is needed to install Jython codes.");
            }
            logger.log(Level.FINE, "unpacking jython codes in {0}", JythonUtil.class.getResourceAsStream("/pylisting.txt"));
            try (BufferedReader r = new BufferedReader(new InputStreamReader(JythonUtil.class.getResourceAsStream("/pylisting.txt")));){
                String s = r.readLine();
                while (s != null) {
                    File ff5 = new File(ff3, s);
                    logger.log(Level.FINER, "copy to local folder python code: {0}", s);
                    InputStream in = JythonUtil.class.getResourceAsStream("/" + s);
                    if (in == null) {
                        throw new IllegalArgumentException("unable to find jython code which should be embedded in application: " + s);
                    }
                    if (s.contains("/") && !JythonUtil.makeHomeFor(ff5)) {
                        throw new IOException("Unable to makeHomeFor " + ff5);
                    }
                    try (FileOutputStream out = new FileOutputStream(ff5);){
                        JythonUtil.transferStream(in, out);
                    }
                    finally {
                        in.close();
                        if (!new File(ff3, s).setReadOnly()) {
                            logger.log(Level.FINER, "set read-only on file {0} failed", s);
                        }
                        if (!new File(ff3, s).setWritable(true, true)) {
                            logger.log(Level.FINER, "set write for user only on file {0} failed", s);
                        }
                    }
                    s = r.readLine();
                }
            }
            logger.fine("   ...done");
            return ff3.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLocalJythonAutoplotAppLib() throws IOException {
        File ff2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File ff3 = new File(ff2.toString() + "/jython");
        File ff4 = new File(ff3.toString(), "pylistingapp2017.txt");
        if (ff4.exists()) {
            return ff3.toString();
        }
        Class<JythonUtil> clazz = JythonUtil.class;
        synchronized (JythonUtil.class) {
            if (!ff3.exists() && !ff3.mkdirs()) {
                throw new IOException("Unable to mkdirs " + ff3);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (JythonUtil.class.getResource("/pylistingapp2017.txt") == null) {
                logger.log(Level.FINE, "unable to find pylistingapp2017.txt in application, assuming this is not the Autoplot client application.");
            } else {
                logger.log(Level.FINE, "unpacking jython codes in {0}", JythonUtil.class.getResourceAsStream("/pylistingapp2017.txt"));
                try (BufferedReader r = new BufferedReader(new InputStreamReader(JythonUtil.class.getResourceAsStream("/pylistingapp2017.txt")));){
                    String s = r.readLine();
                    while (s != null) {
                        int i = s.indexOf("#");
                        if (i > -1) {
                            s = s.substring(0, i);
                        }
                        if ((s = s.trim()).length() > 0) {
                            File ff5 = new File(ff3, s);
                            logger.log(Level.FINER, "copy to local folder python code: {0}", s);
                            if (s.contains("/") && !JythonUtil.makeHomeFor(ff5)) {
                                throw new IOException("Unable to makeHomeFor " + ff5);
                            }
                            if (ff5.exists()) {
                                logger.fine("already have file, skip...");
                                s = r.readLine();
                                continue;
                            }
                            InputStream in = JythonUtil.class.getResourceAsStream("/" + s);
                            if (in == null) {
                                throw new IllegalArgumentException("unable to find jython code which should be embedded in application: " + s);
                            }
                            try (FileOutputStream out = new FileOutputStream(ff5);){
                                JythonUtil.transferStream(in, out);
                            }
                            finally {
                                in.close();
                                if (!new File(ff3, s).setReadOnly()) {
                                    logger.log(Level.FINER, "set read-only on file {0} failed", s);
                                }
                                if (!new File(ff3, s).setWritable(true, true)) {
                                    logger.log(Level.FINER, "set write for user only on file {0} failed", s);
                                }
                            }
                        }
                        s = r.readLine();
                    }
                }
            }
            return ff3.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static String getLocalJythonAutoplotLib() throws IOException {
        Object r;
        File ff2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"));
        File ff3 = new File(ff2.toString() + "/jython");
        File ff4 = new File(ff3, "autoplot2017.py");
        String vers = "";
        double currentVersion = 1.6;
        if (ff4.exists()) {
            r = new BufferedReader(new FileReader(ff4));
            String[] stringArray = null;
            try {
                Pattern versPattern;
                Matcher m;
                String line = ((BufferedReader)r).readLine();
                if (line != null && (m = (versPattern = Pattern.compile("# autoplot2017.py v([\\d\\.]+) .*")).matcher(line)).matches()) {
                    vers = m.group(1);
                }
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
            finally {
                if (r != null) {
                    if (stringArray != null) {
                        try {
                            ((BufferedReader)r).close();
                        }
                        catch (Throwable throwable) {
                            stringArray.addSuppressed(throwable);
                        }
                    } else {
                        ((BufferedReader)r).close();
                    }
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("== JythonUtil getLocalJythonAutoplotLib ==");
            logger.log(Level.FINE, "ff4.exists()={0}", ff4.exists());
            logger.log(Level.FINE, "vers={0}", vers);
            logger.log(Level.FINE, "currentVersion={0}", currentVersion);
        }
        if (!ff4.exists() || vers.equals("") || Double.parseDouble(vers) < currentVersion) {
            String[] ss;
            logger.log(Level.FINE, "looking for version={0} of {1}, but didn''t find it.", new Object[]{currentVersion, ff4});
            logger.log(Level.FINE, "doesn't seem like we have the right file, downloading...");
            r = JythonUtil.class;
            // MONITORENTER : org.autoplot.jythonsupport.JythonUtil.class
            if (!ff3.exists() && !ff3.mkdir()) {
                throw new IOException("Unable to mkdir " + ff3);
            }
            // MONITOREXIT : r
            for (String s : ss = new String[]{"autoplot2017.py", "autoplotapp2017.py"}) {
                InputStream in = JythonUtil.class.getResourceAsStream("/" + s);
                FileOutputStream out = new FileOutputStream(new File(ff3, s));
                try {
                    JythonUtil.transferStream(in, out);
                }
                finally {
                    out.close();
                    in.close();
                }
                if (!new File(ff3, s).setReadOnly()) {
                    logger.log(Level.FINER, "set read-only on file {0} failed", s);
                }
                if (new File(ff3, s).setWritable(true, true)) continue;
                logger.log(Level.FINER, "set write for user only on file {0} failed", s);
            }
        }
        logger.fine("   ...done");
        return ff3.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean pythonLint(URI uri, List<String> errs) throws IOException {
        File src = DataSetURI.getFile(uri, (ProgressMonitor)new NullProgressMonitor());
        try (LineNumberReader reader = new LineNumberReader(new BufferedReader(new FileReader(src)));){
            String vnarg = "\\s*([a-zA-Z_][a-zA-Z0-9_]*)\\s*";
            Pattern assign = Pattern.compile(vnarg + "=.*");
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true);
            String line = reader.readLine();
            while (line != null) {
                Matcher m = assign.matcher(line);
                if (m.matches()) {
                    String vname = m.group(1);
                    try {
                        PyObject po = interp.eval(vname);
                        errs.add("" + reader.getLineNumber() + ": " + vname + "=" + po.__repr__());
                    }
                    catch (PyException pyException) {
                        // empty catch block
                    }
                }
                line = reader.readLine();
            }
        }
        return errs.size() > 0;
    }

    private static synchronized void maybeLoadAdapters() {
        if (!haveloadedAdapters) {
            Py.getAdapter().addPostClass((PyObjectAdapter)new PyQDataSetAdapter());
            Py.getAdapter().addPostClass((PyObjectAdapter)new PyDatumAdapter());
            haveloadedAdapters = true;
        }
    }

    public static Map<String, String> getDocumentation(BufferedReader reader) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        String s = reader.readLine();
        Pattern p = Pattern.compile("#\\s*([a-zA-Z]+)\\s*:(.*)");
        while (s != null) {
            Matcher m = p.matcher(s);
            if (m.matches()) {
                String prop = m.group(1).toUpperCase();
                String value = m.group(2).trim();
                if (prop.equals("LABEL") || prop.equals("TITLE") || prop.equals("DESCRIPTION")) {
                    result.put(prop, value);
                }
            }
            s = reader.readLine();
        }
        reader.close();
        return result;
    }

    private static boolean trivialFunctionCall(SimpleNode sn) {
        if (sn instanceof Call) {
            Call c = (Call)sn;
            boolean klugdyOkay = false;
            String ss = c.func.toString();
            for (String s : okay) {
                if (!ss.contains(s)) continue;
                klugdyOkay = true;
            }
            if (ss.startsWith("Attribute[")) {
                klugdyOkay = true;
            }
            if (!klugdyOkay && ss.contains("TimeUtil") && ss.contains("now")) {
                klugdyOkay = true;
            }
            logger.log(Level.FINER, "trivialFunctionCall={0} for {1}", new Object[]{klugdyOkay, c.func.toString()});
            return klugdyOkay;
        }
        return false;
    }

    private static boolean simplifyScriptToGetParamsOkayNoCalls(SimpleNode o, HashSet<String> variableNames) {
        Call c;
        if (o instanceof Call && !JythonUtil.trivialFunctionCall((SimpleNode)(c = (Call)o))) {
            logger.finest(String.format("%04d simplify->false: %s", o.beginLine, o.toString()));
            return false;
        }
        MyVisitorBase vb = new MyVisitorBase(variableNames);
        try {
            o.traverse(vb);
            logger.finest(String.format(" %04d simplify->%s: %s", o.beginLine, vb.looksOkay(), o));
            return vb.looksOkay();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            logger.finest(String.format("!! %04d simplify->false: %s", o.beginLine, o));
            return false;
        }
    }

    private static boolean simplifyScriptToGetParamsCanResolve(SimpleNode o, HashSet<String> variableNames) {
        if (o instanceof Name) {
            Name c = (Name)o;
            if (!variableNames.contains(c.id)) {
                logger.finest(String.format("%04d canResolve->false: %s", o.beginLine, o.toString()));
                return false;
            }
        }
        if (o instanceof Attribute) {
            Attribute at = (Attribute)o;
            while (at.value instanceof Attribute || at.value instanceof Subscript) {
                if (at.value instanceof Attribute) {
                    at = (Attribute)at.value;
                    continue;
                }
                Subscript s = (Subscript)at.value;
                if (s.value instanceof Attribute) {
                    at = (Attribute)s.value;
                    continue;
                }
                return false;
            }
            if (at.value instanceof Name) {
                Name n = (Name)at.value;
                if (!variableNames.contains(n.id)) {
                    return false;
                }
            }
        }
        MyVisitorBase vb = new MyVisitorBase(variableNames);
        try {
            o.traverse(vb);
            logger.finest(String.format(" %04d canResolve->%s: %s", o.beginLine, vb.visitNameFail, o));
            return !vb.visitNameFail;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            logger.finest(String.format("!! %04d canResolve->false: %s", o.beginLine, o));
            return false;
        }
    }

    public static String maybeQuoteString(String sval) {
        boolean isNumber = false;
        try {
            Double.parseDouble(sval);
        }
        catch (NumberFormatException ex) {
            isNumber = false;
        }
        if (!(sval.length() <= 0 || isNumber || sval.equals("True") || sval.equals("False") || sval.startsWith("'") && sval.endsWith("'"))) {
            sval = String.format("'%s'", sval);
        }
        return sval;
    }

    public static String maybeUnquoteString(String sval) {
        if (sval.startsWith("'") && sval.endsWith("'") || sval.startsWith("\"") && sval.endsWith("\"")) {
            return sval.substring(1, sval.length() - 1);
        }
        return sval;
    }

    public static void setParams(PythonInterpreter interp, Map<String, String> paramsl) {
        interp.exec("import autoplot2017 as autoplot");
        interp.exec("autoplot.params=dict()");
        for (Map.Entry<String, String> e : paramsl.entrySet()) {
            String s = e.getKey();
            if (s.length() == 0) {
                throw new IllegalArgumentException("param name is \"\": " + s);
            }
            if (s.equals("arg_0") || s.equals("script")) continue;
            try {
                String sval = e.getValue();
                sval = JythonUtil.maybeQuoteString(sval);
                logger.log(Level.FINE, "autoplot.params[''{0}'']={1}", new Object[]{s, sval});
                interp.exec("autoplot.params['" + s + "']=" + sval);
            }
            catch (Exception ex) {
                logger.warning(ex.getMessage());
            }
        }
    }

    private static boolean simplifyScriptToGetParamsOkay(stmtType o, HashSet<String> variableNames) {
        if (o instanceof ImportFrom) {
            return true;
        }
        if (o instanceof Import) {
            return true;
        }
        if (o instanceof Assign) {
            Assign a = (Assign)o;
            if (JythonUtil.simplifyScriptToGetParamsOkayNoCalls((SimpleNode)a.value, variableNames)) {
                if (!JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)a.value, variableNames)) {
                    return false;
                }
                for (exprType target : a.targets) {
                    exprType et = target;
                    if (et instanceof Name) {
                        String id = ((Name)target).id;
                        variableNames.add(id);
                        logger.log(Level.FINEST, "assign to variable {0}", id);
                        continue;
                    }
                    if (!(et instanceof Attribute)) continue;
                    Attribute at = (Attribute)et;
                    while (at.value instanceof Attribute || at.value instanceof Subscript) {
                        if (at.value instanceof Attribute) {
                            at = (Attribute)at.value;
                            continue;
                        }
                        Subscript s = (Subscript)at.value;
                        if (s.value instanceof Attribute) {
                            at = (Attribute)s.value;
                            continue;
                        }
                        return false;
                    }
                    if (!(at.value instanceof Name)) continue;
                    Name n = (Name)at.value;
                    if (variableNames.contains(n.id)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (o instanceof If) {
            return JythonUtil.simplifyScriptToGetParamsOkayNoCalls((SimpleNode)o, variableNames);
        }
        if (o instanceof Print) {
            return false;
        }
        logger.log(Level.FINEST, "not okay to simplify: {0}", o);
        return false;
    }

    private static void maybeAppendSort(String theLine, StringBuilder result) {
        int i = theLine.indexOf("getParam");
        if (i != -1) {
            i = theLine.indexOf("=");
            String v = theLine.substring(0, i).trim();
            int indent = theLine.indexOf(v);
            if (indent > 0) {
                result.append(theLine.substring(0, indent));
            }
            result.append("sort_.append( '").append(v).append("')\n");
        }
    }

    private static StringBuilder appendToResult(StringBuilder result, String line) {
        result.append(line);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static String simplifyScriptToGetParams(String[] ss, stmtType[] stmts, HashSet variableNames, int beginLine, int lastLine, int depth) {
        int acceptLine = -1;
        int currentLine = 0;
        StringBuilder result = new StringBuilder();
        for (int istatement = 0; istatement < stmts.length; ++istatement) {
            stmtType o = stmts[istatement];
            logger.log(Level.FINER, "line {0}: {1}", new Object[]{o.beginLine, o.beginLine > 0 ? ss[o.beginLine - 1] : "(bad line number)"});
            if (o.beginLine > 0) {
                beginLine = o.beginLine;
            } else {
                acceptLine = beginLine;
            }
            if (beginLine > lastLine) continue;
            if (o instanceof If) {
                int lastLine1;
                boolean includeBlock;
                if (acceptLine > -1) {
                    for (int i = acceptLine; i < beginLine; ++i) {
                        JythonUtil.appendToResult(result, ss[i - 1]).append("\n");
                    }
                }
                If iff = (If)o;
                if (JythonUtil.simplifyScriptToGetParamsCanResolve((SimpleNode)iff.test, variableNames)) {
                    for (int i = beginLine; i < iff.body[0].beginLine; ++i) {
                        result.append(ss[i - 1]).append("\n");
                    }
                    includeBlock = true;
                } else {
                    includeBlock = false;
                }
                if (iff.orelse != null && iff.orelse.length > 0) {
                    if (iff.orelse[0].beginLine > 0) {
                        lastLine1 = iff.orelse[0].beginLine - 2;
                    } else {
                        if (!(iff.orelse[0] instanceof If)) {
                            logger.warning("failure to deal with another day...");
                            throw new RuntimeException("this case needs to be dealt with...");
                        }
                        lastLine1 = ((If)iff.orelse[0]).test.beginLine - 1;
                    }
                } else {
                    lastLine1 = istatement + 1 < stmts.length ? stmts[istatement + 1].beginLine - 1 : lastLine;
                }
                if (includeBlock) {
                    Object ss2;
                    String ss1 = JythonUtil.simplifyScriptToGetParams(ss, iff.body, variableNames, -1, lastLine1, depth + 1);
                    if (ss1.length() == 0) {
                        String line = iff.beginLine == 0 && beginLine > 0 && iff.body[0].beginLine > 0 ? ss[iff.body[0].beginLine - 1] : ss[iff.beginLine];
                        ss2 = line.split("\\S", -2);
                        String indent = ss2[0];
                        result.append(indent).append("pass\n");
                        logger.fine("things have probably gone wrong...");
                    } else {
                        JythonUtil.appendToResult(result, ss1);
                    }
                    if (iff.orelse != null) {
                        JythonUtil.appendToResult(result, ss[lastLine1]);
                        int lastLine2 = istatement + 1 < stmts.length ? stmts[istatement + 1].beginLine - 1 : lastLine;
                        ss2 = JythonUtil.simplifyScriptToGetParams(ss, iff.orelse, variableNames, lastLine1 + 2, lastLine2, depth + 1);
                        if (((String)ss2).length() > 0) {
                            result.append("\n");
                        }
                        JythonUtil.appendToResult(result, (String)ss2);
                        if (((String)ss2).length() == 0) {
                            String line = ss[iff.orelse[0].beginLine - 1];
                            String[] ss3 = line.split("\\S", -2);
                            String indent = ss3[0];
                            result.append("\n").append(indent).append("pass\n");
                        } else {
                            result.append("\n");
                        }
                    }
                }
                acceptLine = -1;
                continue;
            }
            if (JythonUtil.simplifyScriptToGetParamsOkay(o, variableNames)) {
                if (acceptLine >= 0) continue;
                acceptLine = o.beginLine;
                for (int i = currentLine + 1; i < acceptLine; ++i) {
                    result.append("\n");
                    currentLine = acceptLine;
                }
                continue;
            }
            if (acceptLine <= -1) continue;
            int thisLine = o.beginLine;
            for (int i = acceptLine; i < thisLine; ++i) {
                JythonUtil.appendToResult(result, ss[i - 1]).append("\n");
            }
            JythonUtil.appendToResult(result, "\n");
            currentLine = thisLine;
            acceptLine = -1;
        }
        if (acceptLine > -1) {
            int thisLine = lastLine;
            for (int i = acceptLine; i <= thisLine; ++i) {
                JythonUtil.appendToResult(result, ss[i - 1]).append("\n");
            }
        }
        return result.toString();
    }

    public static List<SimpleNode> showUsage(String script, String symbol) {
        Module n = (Module)parser.parse((String)script, (String)"exec");
        VisitNamesVisitorBase vb = new VisitNamesVisitorBase(symbol);
        for (stmtType st : n.body) {
            try {
                st.traverse(vb);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return vb.getNames();
    }

    public static String simplifyScriptToGetParams(String script, boolean addSort) throws PySyntaxError {
        String closeParenCheck;
        String[] ss = script.split("\n");
        int lastLine = -1;
        for (int i = 0; i < ss.length; ++i) {
            String line = ss[i];
            int ich = line.indexOf(35);
            if (ich > -1) {
                line = line.substring(0, ich);
            }
            if (!line.contains("getParam")) continue;
            lastLine = i + 1;
        }
        if (lastLine == -1) {
            return "";
        }
        while (ss.length > lastLine + 1 && ss[lastLine].trim().length() > 0 && Character.isWhitespace(ss[lastLine].charAt(0))) {
            ++lastLine;
        }
        if (lastLine < ss.length && ((closeParenCheck = ss[lastLine].trim()).equals(")") || closeParenCheck.equals("]"))) {
            ++lastLine;
        }
        HashSet<String> variableNames = new HashSet<String>();
        variableNames.add("getParam");
        variableNames.add("str");
        variableNames.add("int");
        variableNames.add("long");
        variableNames.add("float");
        variableNames.add("datum");
        Module n = (Module)parser.parse((String)script, (String)"exec");
        return JythonUtil.simplifyScriptToGetParams(ss, n.body, variableNames, 1, lastLine, 0);
    }

    public static List<Param> getGetParams(Reader reader) throws IOException, PySyntaxError {
        return JythonUtil.getGetParams(JythonUtil.readScript(reader));
    }

    public static String readScript(Reader reader) throws IOException {
        StringBuilder build = new StringBuilder();
        try (BufferedReader breader = new BufferedReader(reader);){
            String s = breader.readLine();
            while (s != null) {
                build.append(s).append("\n");
                s = breader.readLine();
            }
        }
        return build.toString();
    }

    public static List<Param> getGetParams(String script) throws PyException {
        return JythonUtil.getGetParams(script, new HashMap<String, String>());
    }

    public static List<Param> getGetParams(String script, Map<String, String> params) throws PyException {
        return JythonUtil.getGetParams(null, script, params);
    }

    public static List<Param> getGetParams(Map<String, Object> env, String script, Map<String, String> params) throws PyException {
        InteractiveInterpreter interp;
        String prog = JythonUtil.simplifyScriptToGetParams(script, true);
        logger.log(Level.FINER, "Simplified script: {0}", prog);
        try {
            interp = JythonUtil.createInterpreter(true);
        }
        catch (IOException ex) {
            return new ArrayList<Param>();
        }
        if (env != null) {
            for (Map.Entry<String, Object> ent : env.entrySet()) {
                if (ent.getKey() == null) {
                    logger.log(Level.WARNING, "parameter name was null");
                    continue;
                }
                if (ent.getValue() == null) {
                    if (ent.getKey().equals("dom")) {
                        logger.log(Level.FINE, "parameter \"dom\" value was set to null");
                        continue;
                    }
                    logger.log(Level.WARNING, "parameter value was null");
                    continue;
                }
                interp.set(ent.getKey(), ent.getValue());
            }
        }
        JythonUtil.setParams((PythonInterpreter)interp, params);
        try {
            prog = JythonRefactory.fixImports(prog);
        }
        catch (IOException ex) {
            Logger.getLogger(JythonUtil.class.getName()).log(Level.SEVERE, null, ex);
        }
        interp.exec(prog);
        interp.exec("import autoplot2017 as autoplot\n");
        PyList sort = (PyList)interp.eval("autoplot._paramSort");
        boolean altWhy = false;
        if (sort.isEmpty()) {
            try {
                sort = (PyList)interp.eval("_paramSort");
                if (sort.size() > 0) {
                    logger.warning("things are suddenly in the wrong space.  This is because things are incorrectly imported.");
                    altWhy = true;
                }
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
        ArrayList<Param> result = new ArrayList<Param>();
        for (int i = 0; i < sort.__len__(); ++i) {
            PyList oo = (PyList)interp.eval("autoplot._paramMap['" + (String)sort.get(i) + "']");
            if (altWhy) {
                oo = (PyList)interp.eval("_paramMap['" + (String)sort.get(i) + "']");
            }
            Param p = new Param();
            p.label = (String)sort.get(i);
            if (p.label.startsWith("__")) continue;
            p.name = oo.__getitem__(0).toString();
            p.deft = oo.__getitem__(1);
            p.doc = oo.__getitem__(2).toString();
            if (oo.__getitem__(3) instanceof PyList) {
                PyList pyList = (PyList)oo.__getitem__(3);
                ArrayList<Object> enums = new ArrayList<Object>(pyList.size());
                for (int j = 0; j < pyList.size(); ++j) {
                    enums.add(j, pyList.get(j));
                }
                p.enums = enums;
            }
            if (p.name.equals("resourceUri")) {
                p.name = "resourceURI";
            }
            switch (p.name) {
                case "resourceURI": {
                    p.type = (char)82;
                    p.deft = p.deft.toString();
                    break;
                }
                case "timerange": {
                    p.type = (char)84;
                    p.deft = p.deft.toString();
                    break;
                }
                default: {
                    if (p.deft instanceof String) {
                        p.type = (char)65;
                        p.deft = p.deft.toString();
                        break;
                    }
                    if (p.deft instanceof PyString) {
                        p.type = (char)65;
                        p.deft = p.deft.toString();
                        break;
                    }
                    if (p.deft instanceof PyInteger) {
                        p.type = (char)70;
                        p.deft = ((PyInteger)p.deft).__tojava__(Integer.TYPE);
                        break;
                    }
                    if (p.deft instanceof PyFloat) {
                        p.type = (char)70;
                        p.deft = ((PyFloat)p.deft).__tojava__(Double.TYPE);
                        break;
                    }
                    if (!(p.deft instanceof PyJavaInstance)) break;
                    Object pp = ((PyJavaInstance)p.deft).__tojava__(URI.class);
                    if (pp == Py.NoConversion) {
                        pp = ((PyJavaInstance)p.deft).__tojava__(Datum.class);
                        if (pp == Py.NoConversion) {
                            pp = ((PyJavaInstance)p.deft).__tojava__(DatumRange.class);
                            if (pp == Py.NoConversion) {
                                pp = ((PyJavaInstance)p.deft).__tojava__(URL.class);
                                p.type = (char)76;
                                p.deft = pp;
                                break;
                            }
                            p.type = (char)83;
                            p.deft = pp;
                            break;
                        }
                        p.type = (char)68;
                        p.deft = pp;
                        break;
                    }
                    p.type = (char)85;
                    p.deft = pp;
                }
            }
            result.add(p);
        }
        return result;
    }

    public static Map<String, String> getGetDataSet(Map<String, Object> env, String script, Map<String, String> params) throws PyException {
        InteractiveInterpreter interp;
        String[] ss = script.split("\n");
        for (int i = ss.length - 1; i >= 0 && !ss[i].contains("getDataSet"); --i) {
            ss[i] = "";
        }
        StringBuilder prog1 = new StringBuilder(ss[0]);
        prog1.append("\n");
        for (int i = 1; i < ss.length; ++i) {
            prog1.append(ss[i]).append("\n");
        }
        String prog = prog1.toString();
        logger.log(Level.FINER, "Simplified script: {0}", prog);
        try {
            interp = JythonUtil.createInterpreter(true);
        }
        catch (IOException ex) {
            return Collections.emptyMap();
        }
        if (env != null) {
            for (Map.Entry<String, Object> ent : env.entrySet()) {
                if (ent.getKey() == null) {
                    logger.log(Level.WARNING, "parameter name was null");
                    continue;
                }
                if (ent.getValue() == null) {
                    logger.log(Level.WARNING, "parameter value was null");
                    continue;
                }
                interp.set(ent.getKey(), ent.getValue());
            }
        }
        if (params != null) {
            JythonUtil.setParams((PythonInterpreter)interp, params);
        }
        interp.set("timerange", (Object)"timerange");
        String redefineGDS = "gds={}\nngds=0\ndef getDataSet( uri, timerange='', map=0 ):\n  global ngds\n  global gdsi\n  gds[ngds]=uri+' '+timerange\n  ngds=ngds+1\n";
        interp.exec(redefineGDS);
        try {
            interp.exec(prog);
        }
        catch (PyException ex) {
            logger.log(Level.WARNING, null, ex);
            throw ex;
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        PyDictionary r = (PyDictionary)interp.get("gds");
        for (Object k : r.keys()) {
            result.put(k.toString(), r.get(Py.java2py(k)).toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLocals(BufferedReader reader) throws IOException {
        try {
            String s = reader.readLine();
            Pattern assignPattern = Pattern.compile("\\s*([_a-zA-Z][_a-zA-Z0-9]*)\\s*=.*(#(.*))?");
            Pattern defPattern = Pattern.compile("def .*");
            boolean inDef = false;
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            while (s != null) {
                Matcher m;
                Matcher defm;
                if (!inDef) {
                    defm = defPattern.matcher(s);
                    if (defm.matches()) {
                        inDef = true;
                    }
                } else if (s.length() > 0 && !Character.isWhitespace(s.charAt(0))) {
                    defm = defPattern.matcher(s);
                    inDef = defm.matches();
                }
                if (!inDef && (m = assignPattern.matcher(s)).matches()) {
                    if (m.group(3) != null) {
                        result.put(m.group(1), m.group(3));
                    } else {
                        result.put(m.group(1), s);
                    }
                }
                s = reader.readLine();
            }
            LinkedHashMap<String, String> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String removeSideEffects(String eval) {
        BufferedReader reader = new BufferedReader(new StringReader(eval));
        StringBuilder result = new StringBuilder();
        try {
            String s = reader.readLine();
            Pattern assignPattern = Pattern.compile("\\s*([_a-zA-Z][_a-zA-Z0-9]*)\\s*=.*(#(.*))?");
            Pattern defPattern = Pattern.compile("def .*");
            Pattern importPattern1 = Pattern.compile("from .*");
            Pattern importPattern2 = Pattern.compile("import .*");
            boolean inDef = false;
            while (s != null) {
                Matcher defm;
                int comment = s.indexOf("#");
                if (comment > -1) {
                    s = s.substring(0, comment);
                }
                boolean sideEffect = true;
                if (s.length() > 1 && Character.isWhitespace(s.charAt(0))) {
                    s = reader.readLine();
                    continue;
                }
                if (!inDef) {
                    defm = defPattern.matcher(s);
                    if (defm.matches()) {
                        inDef = true;
                        sideEffect = false;
                    }
                } else {
                    defm = defPattern.matcher(s);
                    if (defm.matches() && sideEffect) {
                        result.append("  pass\n");
                    }
                    if (s.length() > 0 && !Character.isWhitespace(s.charAt(0)) && (inDef = defm.matches())) {
                        sideEffect = false;
                    }
                    if (inDef && s.trim().equals("pass")) {
                        sideEffect = false;
                    }
                }
                if (!inDef) {
                    Matcher m = assignPattern.matcher(s);
                    if (m.matches()) {
                        sideEffect = false;
                    } else if (importPattern1.matcher(s).matches()) {
                        sideEffect = false;
                    } else if (importPattern2.matcher(s).matches()) {
                        sideEffect = false;
                    }
                }
                if (!sideEffect) {
                    result.append(s).append("\n");
                }
                s = reader.readLine();
            }
            if (inDef) {
                result.append("  pass\n");
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        return result.toString();
    }

    public static String join(String[] list, String delim) {
        return JythonUtil.join(Arrays.asList(list), delim);
    }

    public static String join(List<String> list, String delim) {
        if (list.isEmpty()) {
            return "";
        }
        StringBuilder result = new StringBuilder(list.get(0));
        for (int i = 1; i < list.size(); ++i) {
            result.append(delim).append(list.get(i));
        }
        return result.toString();
    }

    private static class MyVisitorBase<R>
    extends VisitorBase {
        boolean looksOkay = true;
        boolean visitNameFail = false;
        HashSet names = new HashSet();

        MyVisitorBase(HashSet names) {
            this.names = names;
        }

        public Object visitName(Name node) throws Exception {
            if (!this.names.contains(node.id)) {
                this.visitNameFail = true;
            }
            return super.visitName(node);
        }

        public Object visitCall(Call node) throws Exception {
            return super.visitCall(node);
        }

        protected Object unhandled_node(SimpleNode sn) throws Exception {
            return sn;
        }

        public void traverse(SimpleNode sn) throws Exception {
            if (sn instanceof Call) {
                this.looksOkay = JythonUtil.trivialFunctionCall(sn);
            } else if (sn instanceof Assign) {
                Assign a = (Assign)sn;
                exprType et = a.value;
                if (et instanceof Call) {
                    this.looksOkay = JythonUtil.trivialFunctionCall((SimpleNode)et);
                }
            } else if (sn instanceof Name) {
                // empty if block
            }
        }

        public boolean looksOkay() {
            return this.looksOkay;
        }

        public boolean visitNameFail() {
            return this.visitNameFail;
        }
    }

    public static class Param {
        public String name;
        public String label;
        public Object deft;
        public String doc;
        public List<Object> enums;
        public char type;

        public String toString() {
            return this.name + "=" + this.deft;
        }
    }

    private static class VisitNamesVisitorBase<R>
    extends VisitorBase {
        String name;
        List<SimpleNode> names;

        VisitNamesVisitorBase(String name) {
            this.name = name;
            this.names = new ArrayList<SimpleNode>();
        }

        public Object visitName(Name node) throws Exception {
            if (this.name.equals(node.id)) {
                this.names.add((SimpleNode)node);
            }
            return super.visitName(node);
        }

        public Object visitCall(Call node) throws Exception {
            return super.visitCall(node);
        }

        protected Object unhandled_node(SimpleNode sn) throws Exception {
            return sn;
        }

        public void traverse(SimpleNode sn) throws Exception {
            sn.traverse((VisitorIF)this);
        }

        public List<SimpleNode> getNames() {
            return this.names;
        }
    }
}

