/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.jythonsupport.JythonUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.parser;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Assign;
import org.python.parser.ast.Attribute;
import org.python.parser.ast.BinOp;
import org.python.parser.ast.Call;
import org.python.parser.ast.Compare;
import org.python.parser.ast.Continue;
import org.python.parser.ast.Expr;
import org.python.parser.ast.For;
import org.python.parser.ast.FunctionDef;
import org.python.parser.ast.If;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Module;
import org.python.parser.ast.Name;
import org.python.parser.ast.Num;
import org.python.parser.ast.Print;
import org.python.parser.ast.Str;
import org.python.parser.ast.VisitorBase;
import org.python.parser.ast.exprType;

public class JythonToJavaConverter {
    public static String convert(String script) throws Exception {
        Module n = (Module)parser.parse((String)script, (String)"exec");
        StringBuilder b = new StringBuilder();
        JythonToJavaConverter.convert(b, n);
        return b.toString();
    }

    private static void convert(StringBuilder sb, Module n) throws Exception {
        MyVisitorBase vb = new MyVisitorBase(sb);
        n.traverse(vb);
    }

    public static void main(String[] args) throws Exception {
        String furi = "/home/jbf/project/autoplot/script/addLabelToPng.jy";
        File src = DataSetURI.getFile(furi, (ProgressMonitor)new NullProgressMonitor());
        try (FileReader reader = new FileReader(src);){
            String code = JythonUtil.readScript(new BufferedReader(reader));
            System.err.println(JythonToJavaConverter.convert(code));
        }
    }

    private static class MyVisitorBase<R>
    extends VisitorBase {
        boolean looksOkay = true;
        boolean visitNameFail = false;
        StringBuilder builder;
        int lineNumber = 1;
        boolean includeLineNumbers = false;
        private static final Map<Integer, String> ops = new HashMap<Integer, String>();

        MyVisitorBase(StringBuilder builder) {
            this.builder = builder;
        }

        public Object visitName(Name node) throws Exception {
            return super.visitName(node);
        }

        public Object visitCall(Call node) throws Exception {
            return super.visitCall(node);
        }

        protected Object unhandled_node(SimpleNode sn) throws Exception {
            return sn;
        }

        public void traverse(SimpleNode sn) throws Exception {
            this.traverse("", sn, false);
        }

        public void traverse(String indent, SimpleNode sn, boolean inline) throws Exception {
            if (this.includeLineNumbers && (this.builder.length() == 0 || this.builder.charAt(this.builder.length() - 1) == '\n')) {
                this.builder.append(String.format("%04d: ", this.lineNumber));
            }
            while (sn.beginLine > this.lineNumber) {
                this.builder.append("\n");
                ++this.lineNumber;
                if (!this.includeLineNumbers) continue;
                this.builder.append(String.format("%04d: ", this.lineNumber));
            }
            if (sn instanceof FunctionDef) {
                int i;
                FunctionDef fd = (FunctionDef)sn;
                this.builder.append("private void ").append(fd.name).append("(");
                for (i = 0; i < fd.args.args.length; ++i) {
                    if (i > 0) {
                        this.builder.append(",");
                    }
                    this.builder.append("").append(fd.args.args[i].getImage().toString());
                }
                this.builder.append(") {\n");
                ++this.lineNumber;
                for (i = 0; i < fd.body.length; ++i) {
                    this.traverse("\t", (SimpleNode)fd.body[i], false);
                    if (inline) continue;
                    this.builder.append(";\n");
                    ++this.lineNumber;
                }
                this.builder.append("}\n");
                ++this.lineNumber;
            } else if (sn instanceof Expr) {
                Expr ex = (Expr)sn;
                this.traverse("", (SimpleNode)ex.value, true);
                if (!inline) {
                    this.builder.append(";\n");
                    ++this.lineNumber;
                }
            } else if (sn instanceof Print) {
                Print pr = (Print)sn;
                this.builder.append(indent);
                this.builder.append("System.err.println(");
                for (int i = 0; i < pr.values.length; ++i) {
                    if (i > 0) {
                        this.builder.append(",");
                    }
                    this.traverse("", (SimpleNode)pr.values[i], false);
                }
                this.builder.append(");");
            } else if (sn instanceof ImportFrom) {
                ImportFrom ff = (ImportFrom)sn;
                for (int i = 0; i < ff.names.length; ++i) {
                    this.builder.append("import ").append(ff.module).append('.').append(ff.names[i].name).append(";\n");
                    ++this.lineNumber;
                }
            } else if (sn instanceof Str) {
                Str ss = (Str)sn;
                this.builder.append("\"");
                this.builder.append(ss.s);
                this.builder.append("\"");
            } else if (sn instanceof Num) {
                Num ex = (Num)sn;
                this.builder.append(ex.n);
            } else if (sn instanceof BinOp) {
                BinOp as = (BinOp)sn;
                this.builder.append(indent);
                if (as.left instanceof Str && as.op == 5) {
                    this.builder.append("String.format(");
                    this.traverse("", (SimpleNode)as.left, true);
                    this.builder.append(",");
                    this.traverse("", (SimpleNode)as.right, true);
                    this.builder.append(")");
                } else {
                    this.traverse("", (SimpleNode)as.left, true);
                    String sop = ops.get(as.op);
                    if (sop == null) {
                        sop = " ?? ";
                    }
                    this.builder.append(sop);
                    this.traverse("", (SimpleNode)as.right, true);
                }
            } else if (sn instanceof Assign) {
                Assign as = (Assign)sn;
                this.builder.append(indent);
                for (int i = 0; i < as.targets.length; ++i) {
                    if (i > 0) {
                        this.builder.append(",");
                    }
                    this.traverse("", (SimpleNode)as.targets[i], false);
                }
                this.builder.append("=");
                this.traverse("", (SimpleNode)as.value, false);
            } else if (sn instanceof Name) {
                this.builder.append(((Name)sn).id);
            } else if (sn instanceof Call) {
                Call cc = (Call)sn;
                if (cc.func instanceof Name && Character.isUpperCase(((Name)cc.func).id.charAt(0))) {
                    this.builder.append("new").append(" ");
                }
                this.traverse("", (SimpleNode)cc.func, true);
                this.builder.append("(");
                for (int i = 0; i < cc.args.length; ++i) {
                    if (i > 0) {
                        this.builder.append(",");
                    }
                    this.traverse("", (SimpleNode)cc.args[i], true);
                }
                this.builder.append(")");
                if (!inline) {
                    this.builder.append(";\n");
                    ++this.lineNumber;
                }
            } else if (sn instanceof For) {
                For ff = (For)sn;
                this.builder.append(indent).append("for ( Object ");
                this.traverse("", (SimpleNode)ff.target, false);
                this.builder.append(" : ");
                this.traverse("", (SimpleNode)ff.iter, false);
                this.builder.append(" ) {\n");
                ++this.lineNumber;
                for (int i = 0; i < ff.body.length; ++i) {
                    this.builder.append(indent).append(indent);
                    this.traverse(indent + indent, (SimpleNode)ff.body[i], false);
                }
                this.builder.append(indent).append("}\n");
                ++this.lineNumber;
            } else if (sn instanceof If) {
                If ff = (If)sn;
                this.builder.append(indent).append("if ( ");
                this.traverse("", (SimpleNode)ff.test, false);
                this.builder.append(" ) {\n");
                ++this.lineNumber;
                for (int i = 0; i < ff.body.length; ++i) {
                    this.builder.append(indent).append(indent);
                    this.traverse(indent + indent, (SimpleNode)ff.body[i], false);
                    this.builder.append(";");
                }
                this.builder.append(indent).append("}\n");
                ++this.lineNumber;
            } else if (sn instanceof Compare) {
                Compare cp = (Compare)sn;
                this.traverse("", (SimpleNode)cp.left, false);
                this.builder.append("?in?");
                for (exprType t : cp.comparators) {
                    this.traverse("", (SimpleNode)t, false);
                }
            } else if (sn instanceof Continue) {
                this.builder.append("continue");
            } else if (sn instanceof Attribute) {
                Attribute at = (Attribute)sn;
                this.traverse("", (SimpleNode)at.value, false);
                this.builder.append(".");
                this.builder.append(at.attr);
            } else {
                this.builder.append(sn.toString()).append("\n");
                ++this.lineNumber;
            }
        }

        public boolean looksOkay() {
            return this.looksOkay;
        }

        public boolean visitNameFail() {
            return this.visitNameFail;
        }

        static {
            ops.put(1, "+");
            ops.put(2, "-");
            ops.put(3, "*");
            ops.put(4, "/");
            ops.put(6, "^");
            ops.put(12, "/floordiv/");
        }
    }
}

