/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.autoplot.datasource.URISplit;
import org.autoplot.jythonsupport.PyDatum;
import org.autoplot.jythonsupport.PyQDataSet;
import org.autoplot.jythonsupport.PyQDataSetAdapter;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.ops.Ops;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyDictionary;
import org.python.core.PyFloat;
import org.python.core.PyFunction;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;

public class JythonOps {
    private static final Logger logger = Logger.getLogger("jython");

    public static QDataSet applyLambda(QDataSet ds, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds);
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(ds));
        while (it.hasNext()) {
            it.next();
            double d = it.getValue(ds);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d));
            it.putValue(result, r.getValue());
        }
        return result;
    }

    public static QDataSet applyLambda(QDataSet ds1, QDataSet ds2, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds1);
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(ds1));
        while (it.hasNext()) {
            it.next();
            double d1 = it.getValue(ds1);
            double d2 = it.getValue(ds2);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d1), (PyObject)new PyFloat(d2));
            it.putValue(result, r.getValue());
        }
        return result;
    }

    public static QDataSet applyLambda(QDataSet ds1, QDataSet ds2, QDataSet ds3, PyFunction f) {
        QubeDataSetIterator it = new QubeDataSetIterator(ds1);
        DDataSet result = DDataSet.create(DataSetUtil.qubeDims(ds1));
        while (it.hasNext()) {
            it.next();
            double d1 = it.getValue(ds1);
            double d2 = it.getValue(ds2);
            double d3 = it.getValue(ds3);
            PyFloat r = (PyFloat)f.__call__((PyObject)new PyFloat(d1), (PyObject)new PyFloat(d2), (PyObject)new PyFloat(d3));
            it.putValue(result, r.getValue());
        }
        return result;
    }

    public static QDataSet coerceToDs(PyObject arg0) {
        return JythonOps.dataset(arg0);
    }

    public static QDataSet dataset(PyObject arg0) {
        if (arg0 instanceof PyQDataSet) {
            return ((PyQDataSet)arg0).rods;
        }
        if (arg0 instanceof PyDatum) {
            return DataSetUtil.asDataSet(((PyDatum)arg0).datum);
        }
        if (arg0 instanceof PyList) {
            return PyQDataSetAdapter.adaptList((PyList)arg0);
        }
        if (arg0 instanceof PyArray) {
            return PyQDataSetAdapter.adaptArray((PyArray)arg0);
        }
        if (arg0 instanceof PyInteger) {
            return DataSetUtil.asDataSet((Double)arg0.__tojava__(Double.class));
        }
        if (arg0 instanceof PyLong) {
            return DataSetUtil.asDataSet((Double)arg0.__tojava__(Double.class));
        }
        if (arg0 instanceof PyFloat) {
            return DataSetUtil.asDataSet((Double)arg0.__tojava__(Double.class));
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(Datum.class) instanceof Datum) {
            return DataSetUtil.asDataSet((Datum)((PyJavaInstance)arg0).__tojava__(Datum.class));
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(DatumRange.class) instanceof DatumRange) {
            return DataSetUtil.asDataSet((DatumRange)((PyJavaInstance)arg0).__tojava__(DatumRange.class));
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(QDataSet.class) instanceof QDataSet) {
            return DataSetUtil.asDataSet(((PyJavaInstance)arg0).__tojava__(QDataSet.class));
        }
        if (arg0 instanceof PyString) {
            try {
                return Ops.dataset(arg0.toString());
            }
            catch (IllegalArgumentException ex) {
                throw Py.SyntaxError((String)("unable to parse string: " + arg0));
            }
        }
        if (arg0 instanceof PyNone) {
            return null;
        }
        throw Py.TypeError((String)("JythonOps is unable to coerce " + arg0 + " to QDataSet"));
    }

    public static QDataSet dataset(PyObject arg0, Units u) {
        if (arg0 instanceof PyQDataSet) {
            return ((PyQDataSet)arg0).rods;
        }
        if (arg0 instanceof PyList) {
            return Ops.putProperty(PyQDataSetAdapter.adaptList((PyList)arg0), "UNITS", (Object)u);
        }
        if (arg0 instanceof PyArray) {
            return Ops.putProperty(PyQDataSetAdapter.adaptArray((PyArray)arg0), "UNITS", (Object)u);
        }
        if (arg0 instanceof PyInteger) {
            return DataSetUtil.asDataSet((Double)arg0.__tojava__(Double.class), u);
        }
        if (arg0 instanceof PyLong) {
            return DataSetUtil.asDataSet((Double)arg0.__tojava__(Double.class), u);
        }
        if (arg0 instanceof PyFloat) {
            return DataSetUtil.asDataSet((Double)arg0.__tojava__(Double.class), u);
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(Datum.class) instanceof Datum) {
            return DataSetUtil.asDataSet((Datum)((PyJavaInstance)arg0).__tojava__(Datum.class));
        }
        if (arg0 instanceof PyJavaInstance && ((PyJavaInstance)arg0).__tojava__(DatumRange.class) instanceof DatumRange) {
            return DataSetUtil.asDataSet((DatumRange)((PyJavaInstance)arg0).__tojava__(DatumRange.class));
        }
        if (arg0 instanceof PyString) {
            try {
                return DataSetUtil.asDataSet(u.parse(arg0.toString()));
            }
            catch (ParseException ex) {
                throw Py.SyntaxError((String)("unable to parse string: " + arg0));
            }
            catch (IllegalArgumentException ex) {
                throw Py.SyntaxError((String)("unable to parse string: " + arg0));
            }
        }
        if (arg0 instanceof PyNone) {
            return null;
        }
        throw Py.TypeError((String)("JythonOps is unable to coerce " + arg0 + " to QDataSet"));
    }

    public static Datum datum(PyObject arg0) {
        if (arg0 instanceof PyQDataSet) {
            QDataSet ds = ((PyQDataSet)arg0).rods;
            if (ds.rank() > 0) {
                throw new IllegalArgumentException("QDataSet is not rank zero and cannot be converted to datum: " + ds);
            }
            return DataSetUtil.asDatum(ds);
        }
        if (arg0 instanceof PyDatum) {
            return ((PyDatum)arg0).datum;
        }
        if (arg0 instanceof PyInteger) {
            return Units.dimensionless.createDatum(((PyInteger)arg0).getValue());
        }
        if (arg0 instanceof PyFloat) {
            return Units.dimensionless.createDatum(((PyFloat)arg0).getValue());
        }
        if (arg0 instanceof PyJavaInstance) {
            return Ops.datum(((PyJavaInstance)arg0).__tojava__(Object.class));
        }
        if (arg0 instanceof PyString) {
            return Ops.datum(arg0.toString());
        }
        throw Py.TypeError((String)("unable to coerce " + arg0 + " to Datum"));
    }

    public static DatumRange datumRange(PyObject arg0) {
        if (arg0 instanceof PyQDataSet) {
            QDataSet ds = ((PyQDataSet)arg0).rods;
            if (ds.rank() > 1) {
                throw new IllegalArgumentException("QDataSet is not rank one and cannot be converted to datumRange: " + ds);
            }
            return DataSetUtil.asDatumRange(ds);
        }
        if (arg0 instanceof PyList) {
            PyObject p1 = ((PyList)arg0).__getitem__(0);
            PyObject p2 = ((PyList)arg0).__getitem__(1);
            return new DatumRange(JythonOps.datum(p1), JythonOps.datum(p2));
        }
        if (arg0 instanceof PyArray) {
            PyObject p1 = ((PyArray)arg0).__getitem__(0);
            PyObject p2 = ((PyArray)arg0).__getitem__(1);
            return new DatumRange(JythonOps.datum(p1), JythonOps.datum(p2));
        }
        if (arg0 instanceof PyJavaInstance) {
            return Ops.datumRange(((PyJavaInstance)arg0).__tojava__(Object.class));
        }
        if (arg0 instanceof PyString) {
            return Ops.datumRange(arg0.toString());
        }
        throw Py.TypeError((String)("unable to coerce " + arg0 + " to DatumRange"));
    }

    public static DatumRange datumRange(PyObject arg0, Units context) {
        DatumRange newRange = JythonOps.datumRange(arg0);
        if (!context.isConvertibleTo(newRange.getUnits())) {
            newRange = DatumRange.newDatumRange(newRange.min().value(), newRange.max().value(), context);
        } else if (context != newRange.getUnits()) {
            newRange = new DatumRange(newRange.min().convertTo(context), newRange.max().convertTo(context));
        }
        return newRange;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Color color(PyObject val) {
        Color c = null;
        if (val.__tojava__(Color.class) != Py.NoConversion) {
            return (Color)val.__tojava__(Color.class);
        }
        if (val instanceof PyFloat) {
            return new Color((int)((PyFloat)val).getValue());
        }
        if (val instanceof PyInteger) {
            return new Color(((PyInteger)val).getValue());
        }
        if (val instanceof PyQDataSet) {
            return new Color((int)((PyQDataSet)val).getQDataSet().value());
        }
        if (val instanceof PyTuple) {
            String sval = val.toString();
            if ((sval = sval.substring(1, sval.length() - 1)) == null) throw new IllegalArgumentException("can't identify color");
            return Ops.colorFromString(sval);
        }
        String sval = (String)val.__str__().__tojava__(String.class);
        if (sval == null) throw new IllegalArgumentException("can't identify color");
        return Ops.colorFromString(sval);
    }

    public static String addToSearchPath(PyList syspath, String path, ProgressMonitor mon) throws IOException, URISyntaxException {
        if (System.getProperty("javawebstart.version") != null) {
            logger.warning("Jython addToSearchPath will probably fail because this is not supported with Webstart.");
        }
        if (path.endsWith(".jar")) {
            File jarFile = org.autoplot.datasource.FileSystemUtil.doDownload(path, mon);
            File destDir = FileSystem.settings().getLocalCacheDir();
            destDir = new File(destDir, "jar");
            String ss = path.replace("://", "/");
            destDir = new File(destDir, ss);
            FileSystemUtil.unzipFile(jarFile, destDir);
            syspath.append((PyObject)new PyString(destDir.toString()));
            return destDir.toString();
        }
        throw new IllegalArgumentException("only jar files can be added.");
    }

    public static String formUri(String vapScheme, String resourceUri, Object args) {
        LinkedHashMap<String, Object> jargs = new LinkedHashMap<String, Object>();
        if (args != null) {
            if (args instanceof PyDictionary) {
                PyDictionary pd = (PyDictionary)args;
                for (Object k : pd.keys()) {
                    jargs.put(String.valueOf(k), String.valueOf(pd.get((PyObject)new PyString(String.valueOf(k)))));
                }
            } else if (args instanceof Map) {
                Map m = (Map)args;
                for (Object k : ((Map)args).keySet()) {
                    jargs.put(String.valueOf(k), m.get(k));
                }
            } else {
                throw new IllegalArgumentException("args cannot be converted to Map");
            }
        }
        return URISplit.format(vapScheme, resourceUri, jargs);
    }

    public static MutablePropertyDataSet putProperty(QDataSet ds, String name, Object value) {
        return Ops.putProperty(ds, name, value);
    }

    public static void invokeSometime(final PyObject func) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                func.__call__();
            }
        };
        new Thread(run).start();
    }

    public static void invokeSometime(final PyObject func, final PyObject arg) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                func.__call__(arg);
            }
        };
        new Thread(run).start();
    }
}

