/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.jythonsupport;

import java.util.logging.Logger;
import org.autoplot.jythonsupport.FunctionSupport;
import org.autoplot.jythonsupport.JythonOps;
import org.autoplot.jythonsupport.PyQDataSet;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.python.core.Py;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaInstance;
import org.python.core.PyObject;
import org.python.core.PyString;

public class DatasetCommand
extends PyObject {
    private static final Logger logger = LoggerManager.getLogger("jython.commands.datset");
    public static final PyString __doc__ = new PyString("<html><H2>dataset(ds,[named parameters])</H2>dataset creates datasets from arrays and adds metadata.\nSee http://autoplot.org/help.datasetCommand<br>\n<br><b>named parameters:</b>\n<table><tr><td>title </td><td>title for the data, which could be used above a plot.</td></tr>\n<tr><td>label </td><td>label for the data, which could be used as an axis label.</td></tr>\n<tr><td>name </td><td>name for the data, which should be a legal Jython variable name.</td></tr>\n<tr><td>units </td><td>units for the data, which string representing the units of the data.</td></tr>\n<tr><td>validMin validMax</td><td>range of valid values for the data.</td></tr>\n<tr><td>typicalMin typicalMax</td><td>typical range dataset, used for suggesting axis ranges.</td></tr>\n<tr><td>scaleType</td><td>'log' or 'linear'</td></tr>\n</table></html>");

    private static QDataSet datasetValue(PyObject arg0) {
        Object o = arg0.__tojava__(QDataSet.class);
        if (o == null || o == Py.NoConversion) {
            return JythonOps.dataset(arg0);
        }
        QDataSet ds = (QDataSet)o;
        if (ds.rank() == 0) {
            return ds;
        }
        return ds;
    }

    private static boolean booleanValue(PyObject arg0) {
        if (arg0.isNumberType()) {
            return arg0.__nonzero__();
        }
        String s = String.valueOf(arg0);
        return s.equals("True") || s.equals("T") || s.equals("1");
    }

    private static Number numberValue(PyObject arg0) {
        if (arg0 instanceof PyInteger) {
            return ((PyInteger)arg0).getValue();
        }
        if (arg0 instanceof PyFloat) {
            return ((PyFloat)arg0).getValue();
        }
        if (arg0 instanceof PyString) {
            return Double.parseDouble(String.valueOf(arg0));
        }
        return arg0.__float__().getValue();
    }

    public PyObject __call__(PyObject[] args, String[] keywords) {
        FunctionSupport fs = new FunctionSupport("dataset", new String[]{"ds", "title", "label", "name", "units", "fillValue", "validMin", "validMax", "typicalMin", "typicalMax", "scaleType"}, new PyObject[]{Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None, Py.None});
        fs.args(args, keywords);
        int nparm = args.length - keywords.length;
        if (nparm == 0) {
            throw new IllegalArgumentException("dataset needs at least one argument");
        }
        QDataSet result = JythonOps.dataset(args[0]);
        if (nparm == 2) {
            if (args[1] instanceof PyJavaInstance) {
                PyJavaInstance pji = (PyJavaInstance)args[1];
                Object o = pji.__tojava__(Units.class);
                if (o == Py.NoConversion) {
                    throw new IllegalArgumentException("second argument must be units or string identifying units.");
                }
                result = Ops.putProperty(result, "UNITS", o);
            } else if (args[1] instanceof PyString) {
                result = Ops.putProperty(result, "UNITS", (Object)((PyString)args[1]).toString());
            }
        }
        block22: for (int i = nparm; i < args.length; ++i) {
            String kw = keywords[i - nparm];
            PyObject val = args[i];
            String sval = (String)val.__str__().__tojava__(String.class);
            switch (kw) {
                case "title": 
                case "label": 
                case "name": {
                    result = Ops.putProperty(result, kw.toUpperCase(), (Object)sval);
                    continue block22;
                }
                case "units": {
                    if (val.__tojava__(Units.class) != Py.NoConversion) {
                        result = Ops.putProperty(result, kw.toUpperCase(), val.__tojava__(Units.class));
                        continue block22;
                    }
                    result = Ops.putProperty(result, kw.toUpperCase(), (Object)sval);
                    continue block22;
                }
                case "validMin": {
                    result = Ops.putProperty(result, "VALID_MIN", (Object)DatasetCommand.numberValue(val));
                    continue block22;
                }
                case "validMax": {
                    result = Ops.putProperty(result, "VALID_MAX", (Object)DatasetCommand.numberValue(val));
                    continue block22;
                }
                case "typicalMin": {
                    result = Ops.putProperty(result, "TYPICAL_MIN", (Object)DatasetCommand.numberValue(val));
                    continue block22;
                }
                case "typicalMax": {
                    result = Ops.putProperty(result, "TYPICAL_MAX", (Object)DatasetCommand.numberValue(val));
                    continue block22;
                }
                case "fillValue": {
                    result = Ops.putProperty(result, "FILL_VALUE", (Object)DatasetCommand.numberValue(val));
                    continue block22;
                }
                case "scaleType": {
                    result = Ops.putProperty(result, "SCALE_TYPE", (Object)sval);
                    continue block22;
                }
                default: {
                    throw new IllegalArgumentException("bad keyword");
                }
            }
        }
        return new PyQDataSet(result);
    }
}

