/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.imagedatasource;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.qds.DataSetOps;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.util.monitor.ProgressMonitor;

public class ImageDataSourceFormat
implements DataSourceFormat {
    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        String ext;
        int j;
        int i;
        int h;
        int w;
        QDataSet b;
        QDataSet g;
        QDataSet r;
        BufferedImage im;
        MutablePropertyDataSet alpha = null;
        if (data.length() == 3) {
            im = new BufferedImage(data.length(0), data.length(0, 0), 1);
            r = data.slice(0);
            g = data.slice(1);
            b = data.slice(2);
            w = data.length(0);
            h = data.length(0, 0);
        } else if (data.length(0, 0) == 4) {
            im = new BufferedImage(data.length(), data.length(0), 2);
            alpha = DataSetOps.slice2(data, 0);
            r = DataSetOps.slice2(data, 1);
            g = DataSetOps.slice2(data, 2);
            b = DataSetOps.slice2(data, 3);
            w = data.length();
            h = data.length(0);
        } else {
            im = new BufferedImage(data.length(), data.length(0), 1);
            r = DataSetOps.slice2(data, 0);
            g = DataSetOps.slice2(data, 1);
            b = DataSetOps.slice2(data, 2);
            w = data.length();
            h = data.length(0);
        }
        URISplit split = URISplit.parse(uri);
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        boolean warn = true;
        while (it.hasNext()) {
            it.next();
            double v = it.getValue(data);
            if (!warn || !(v < 0.0) && !(v >= 256.0)) continue;
            System.err.println("element out of range 0-255: " + v);
            warn = false;
        }
        if (alpha == null) {
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    im.setRGB(i, h - j - 1, (int)r.value(i, j) * 256 * 256 + (int)g.value(i, j) * 256 + (int)b.value(i, j));
                }
            }
        } else {
            for (i = 0; i < w; ++i) {
                for (j = 0; j < h; ++j) {
                    im.setRGB(i, h - j - 1, (int)alpha.value(i, j) * 256 * 256 * 256 + (int)r.value(i, j) * 256 * 256 + (int)g.value(i, j) * 256 + (int)b.value(i, j));
                }
            }
        }
        if (!ImageIO.write((RenderedImage)im, ext = split.file.substring((i = split.file.lastIndexOf(".")) + 1), new File(split.resourceUri))) {
            throw new IOException("unable to find writer for " + ext);
        }
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        return ds.rank() == 3 && (ds.length() < 5 || ds.length(0, 0) < 5);
    }

    @Override
    public String getDescription() {
        return "Image Format";
    }
}

