/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.imagedatasource;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.exif.GpsDirectory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.imagedatasource.ImageDataSet;
import org.autoplot.metatree.MetadataUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.ImageUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Node;

class ImageDataSource
extends AbstractDataSource {
    public static final int CHANNEL_HUE = 1;
    public static final int CHANNEL_SATURATION = 2;
    public static final int CHANNEL_VALUE = 3;

    public ImageDataSource(URI uri) {
        super(uri);
    }

    private double toHSV(int rgb, int channel) {
        double sat;
        double r = (rgb & 0xFF0000) >> 16;
        double g = (rgb & 0xFF00) >> 8;
        double b = rgb & 0xFF;
        double minVal = Math.min(Math.min(r /= 255.0, g /= 255.0), b /= 255.0);
        double maxVal = Math.max(Math.max(r, g), b);
        double delta = maxVal - minVal;
        double value = maxVal;
        if (channel == 3) {
            return value * 100.0;
        }
        double hue = 0.0;
        if (delta == 0.0) {
            hue = 0.0;
            sat = 0.0;
        } else {
            sat = delta / maxVal;
            double del_R = ((maxVal - r) / 6.0 + delta / 2.0) / delta;
            double del_G = ((maxVal - g) / 6.0 + delta / 2.0) / delta;
            double del_B = ((maxVal - b) / 6.0 + delta / 2.0) / delta;
            if (r == maxVal) {
                hue = del_B - del_G;
            } else if (g == maxVal) {
                hue = 0.0 + del_R - del_B;
            } else if (b == maxVal) {
                hue = 0.0 + del_G - del_R;
            }
            if (hue < 0.0) {
                hue += 1.0;
            }
            if (hue > 1.0) {
                hue -= 1.0;
            }
            hue *= 360.0;
            sat *= 100.0;
        }
        if (channel == 1) {
            return hue;
        }
        return sat;
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        String plotInfo;
        String yaxis;
        String xaxis;
        String fog;
        String blur;
        mon.started();
        File ff = DataSetURI.getFile(this.uri, mon.getSubtaskMonitor("get file"));
        if (ff.length() == 0L) {
            throw new IllegalArgumentException("Image file is empty: " + ff);
        }
        BufferedImage image = ImageIO.read(ff);
        String rot = this.getParam("rotate", "0");
        if (!rot.equals("0")) {
            int h = image.getHeight();
            int w = image.getWidth();
            double drot = Double.parseDouble(rot);
            AffineTransform at = AffineTransform.getTranslateInstance((double)w / 2.0, (double)h / 2.0);
            at.concatenate(AffineTransform.getRotateInstance(Math.PI * drot / 180.0));
            at.concatenate(AffineTransform.getTranslateInstance((double)(-w) / 2.0, (double)(-h) / 2.0));
            BufferedImage dest = new BufferedImage(w, h, image.getType());
            ((Graphics2D)dest.getGraphics()).drawImage(image, at, null);
            image = dest;
        }
        if (!(blur = this.getParam("blur", "1")).equals("1")) {
            BufferedImage blurredImage;
            int iblur = Integer.parseInt(blur);
            if (iblur < 1 || iblur > 51) {
                throw new IllegalArgumentException("blur must be between 1 and 51");
            }
            BufferedImage dest = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
            int n = iblur * iblur;
            float[] matrix = new float[n];
            for (int i = 0; i < matrix.length; ++i) {
                matrix[i] = 1.0f / (float)n;
            }
            ConvolveOp op = new ConvolveOp(new Kernel(iblur, iblur, matrix));
            image = blurredImage = op.filter(image, dest);
        }
        if (!(fog = this.getParam("fog", "0")).equals("0")) {
            int ifog = Integer.parseInt(fog);
            if (ifog < 0 || ifog > 100) {
                throw new IllegalArgumentException("fog must be between 1 and 100");
            }
            BufferedImage dest = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            int color = image.getRGB(0, 0);
            Graphics2D g = (Graphics2D)dest.getGraphics();
            g.drawImage(image, new AffineTransform(), null);
            g.setColor(new Color((color & 0xFF0000) >> 16, (color & 0xFF00) >> 8, color & 0xFF, ifog * 255 / 100));
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            image = dest;
        }
        String channel = (String)this.params.get("channel");
        Color c = null;
        ImageDataSet.ColorOp op = null;
        if (channel != null) {
            if (channel.equals("red")) {
                c = Color.red;
            } else if (channel.equals("green")) {
                c = Color.green;
            } else if (channel.equals("blue")) {
                c = Color.blue;
            } else {
                if (channel.equals("alpha")) {
                    if (image.getSampleModel().getNumBands() < 4) {
                        throw new IllegalArgumentException("this image has less than three bands, which is interpretted to mean no alpha");
                    }
                    DDataSet ds = DDataSet.createRank2(image.getWidth(), image.getHeight());
                    int n = ds.length(0);
                    for (int i = 0; i < ds.length(); ++i) {
                        for (int j = 0; j < ds.length(0); ++j) {
                            ds.putValue(i, j, image.getAlphaRaster().getSample(i, n - j - 1, 0));
                        }
                    }
                    ds.putProperty("LABEL", "alpha");
                    return ds;
                }
                if (channel.equals("greyscale")) {
                    op = new ImageDataSet.ColorOp(){

                        @Override
                        public double value(int rgb) {
                            int r = rgb & 0xFF;
                            int g = rgb & 0xFF;
                            int b = rgb & 0xFF;
                            return 0.3 * (double)r + 0.59 * (double)g + 0.11 * (double)b;
                        }
                    };
                } else if (channel.equals("hue")) {
                    op = new ImageDataSet.ColorOp(){

                        @Override
                        public double value(int rgb) {
                            return ImageDataSource.this.toHSV(rgb, 1);
                        }
                    };
                } else if (channel.equals("saturation")) {
                    op = new ImageDataSet.ColorOp(){

                        @Override
                        public double value(int rgb) {
                            return ImageDataSource.this.toHSV(rgb, 2);
                        }
                    };
                } else if (channel.equals("value")) {
                    op = new ImageDataSet.ColorOp(){

                        @Override
                        public double value(int rgb) {
                            return ImageDataSource.this.toHSV(rgb, 3);
                        }
                    };
                } else {
                    throw new IllegalArgumentException("unsupported channel: " + channel);
                }
            }
        }
        ImageDataSet result = new ImageDataSet(image, c, op);
        if (channel == null) {
            result.putProperty("RENDER_TYPE", "image");
        }
        if ((xaxis = this.getParam("xaxis", null)) != null) {
            Datum[] transform = ImageDataSource.tryParseArray(xaxis);
            if (transform[1].getUnits() != Units.dimensionless) {
                throw new IllegalArgumentException("xaxis second and last components must be dimensionless.");
            }
            if (transform[3].subtract(transform[1]).value() < 0.0) {
                throw new IllegalArgumentException("xaxis=[datamin,pixmin,datamax,pixmax] pixmin must be less than pixmax value");
            }
            Units xunits = transform[0].getUnits();
            QDataSet xx = Ops.findgen(result.length());
            xx = Ops.subtract((Object)xx, transform[1]);
            xx = Ops.multiply((Object)xx, transform[2].subtract(transform[0]).doubleValue(xunits.getOffsetUnits()) / transform[3].subtract(transform[1]).value());
            xx = Ops.add((Object)Ops.putProperty(xx, "UNITS", (Object)xunits.getOffsetUnits()), transform[0]);
            if (UnitsUtil.isIntervalMeasurement(xunits)) {
                ((MutablePropertyDataSet)xx).putProperty("TYPICAL_MIN", transform[0].doubleValue(xunits));
                ((MutablePropertyDataSet)xx).putProperty("TYPICAL_MAX", transform[2].doubleValue(xunits));
            } else {
                ((MutablePropertyDataSet)xx).putProperty("TYPICAL_MIN", transform[0].value());
                ((MutablePropertyDataSet)xx).putProperty("TYPICAL_MAX", transform[2].value());
            }
            result.putProperty("DEPEND_0", xx);
        }
        if ((yaxis = this.getParam("yaxis", null)) != null) {
            Datum[] transform = ImageDataSource.tryParseArray(yaxis);
            if (transform[1].getUnits() != Units.dimensionless) {
                throw new IllegalArgumentException("yaxis second and last components must be dimensionless.");
            }
            if (transform[3].subtract(transform[1]).value() < 0.0) {
                throw new IllegalArgumentException("yaxis=[datamin,pixmin,datamax,pixmax] pixmin must be less than pixmax value");
            }
            Units yunits = transform[0].getUnits();
            QDataSet yy = Ops.findgen(result.length(0));
            yy = Ops.subtract((Object)yy, transform[1]);
            yy = Ops.multiply((Object)yy, transform[2].subtract(transform[0]).doubleValue(yunits.getOffsetUnits()) / transform[3].subtract(transform[1]).value());
            yy = Ops.add((Object)Ops.putProperty(yy, "UNITS", (Object)yunits.getOffsetUnits()), transform[0]);
            if (UnitsUtil.isIntervalMeasurement(yunits)) {
                ((MutablePropertyDataSet)yy).putProperty("TYPICAL_MIN", transform[0].doubleValue(yunits));
                ((MutablePropertyDataSet)yy).putProperty("TYPICAL_MAX", transform[2].doubleValue(yunits));
            } else {
                ((MutablePropertyDataSet)yy).putProperty("TYPICAL_MIN", transform[0].value());
                ((MutablePropertyDataSet)yy).putProperty("TYPICAL_MAX", transform[2].value());
            }
            result.putProperty("DEPEND_1", yy);
        }
        if (!(plotInfo = this.getParam("plotInfo", "")).equals("")) {
            String json = ImageUtil.getJSONMetadata(ff);
            if (json != null) {
                boolean ylog;
                boolean xlog;
                JSONObject jo = new JSONObject(json);
                JSONArray plots = jo.getJSONArray("plots");
                JSONObject plot = plots.getJSONObject(Integer.parseInt(plotInfo));
                JSONObject x = plot.getJSONObject("xaxis");
                QDataSet xrange = this.getRange(x);
                Units xunits = SemanticOps.getUnits(xrange);
                double dxmin = xrange.value(0);
                double dxmax = xrange.value(1);
                QDataSet xx = Ops.findgen(result.length());
                boolean bl = xlog = x.has("type") && x.get("type").equals("log");
                if (xlog) {
                    dxmin = Math.log10(dxmin);
                }
                if (xlog) {
                    dxmax = Math.log10(dxmax);
                }
                xx = Ops.subtract((Object)xx, x.getDouble("left"));
                xx = Ops.multiply((Object)xx, (dxmax - dxmin) / (double)(x.getInt("right") - x.getInt("left")));
                xx = Ops.add((Object)xx, dxmin);
                if (xlog) {
                    xx = Ops.exp10(xx);
                }
                ((MutablePropertyDataSet)xx).putProperty("TYPICAL_MIN", xrange.value(0));
                ((MutablePropertyDataSet)xx).putProperty("TYPICAL_MAX", xrange.value(1));
                ((MutablePropertyDataSet)xx).putProperty("UNITS", xunits);
                result.putProperty("DEPEND_0", xx);
                JSONObject y = plot.getJSONObject("yaxis");
                QDataSet yrange = this.getRange(y);
                Units yunits = SemanticOps.getUnits(yrange);
                QDataSet yy = Ops.findgen(result.length(0));
                double dymin = yrange.value(0);
                double dymax = yrange.value(1);
                boolean bl2 = ylog = y.has("type") && y.get("type").equals("log");
                if (ylog) {
                    dymin = Math.log10(dymin);
                }
                if (ylog) {
                    dymax = Math.log10(dymax);
                }
                yy = Ops.subtract((Object)yy, y.getDouble("top"));
                yy = Ops.multiply((Object)yy, (dymax - dymin) / (double)(y.getInt("bottom") - y.getInt("top")));
                yy = Ops.add((Object)yy, dymin);
                if (ylog) {
                    yy = Ops.exp10(yy);
                }
                ((MutablePropertyDataSet)yy).putProperty("TYPICAL_MIN", yrange.value(0));
                ((MutablePropertyDataSet)yy).putProperty("TYPICAL_MAX", yrange.value(1));
                ((MutablePropertyDataSet)yy).putProperty("UNITS", yunits);
                result.putProperty("DEPEND_1", yy);
            } else {
                throw new IllegalArgumentException("png contains no rich metadata.");
            }
        }
        if (channel != null) {
            if (channel.equals("greyscale")) {
                result.putProperty("RENDER_TYPE", "spectrogram>colorTable=black_white");
            } else if (channel.equals("red")) {
                result.putProperty("RENDER_TYPE", "spectrogram>colorTable=black_red");
            } else if (channel.equals("green")) {
                result.putProperty("RENDER_TYPE", "spectrogram>colorTable=black_green");
            } else if (channel.equals("blue")) {
                result.putProperty("RENDER_TYPE", "spectrogram>colorTable=black_blue");
            }
        }
        mon.finished();
        return result;
    }

    public QDataSet getRange(JSONObject axis) throws JSONException, ParseException {
        boolean xlog;
        String sxmin = axis.getString("min");
        String sxmax = axis.getString("max");
        boolean bl = xlog = axis.has("type") && axis.get("type").equals("log");
        Units units = axis.has("units") ? (axis.get("units").equals("UTC") ? Units.us2000 : Units.lookupUnits(axis.getString("units"))) : Units.dimensionless;
        DatumRange result = DatumRangeUtil.union(units.parse(sxmin), units.parse(sxmax));
        QDataSet ds = DataSetUtil.asDataSet(result);
        if (xlog) {
            ds = Ops.putProperty(ds, "SCALE_TYPE", (Object)"log");
        }
        return ds;
    }

    private static Datum[] tryParseArray(String s) {
        if ((s = s.trim()).startsWith("[") && s.endsWith("]")) {
            s = s.substring(1, s.length() - 1);
        }
        if (s.startsWith("(") && s.endsWith(")")) {
            s = s.substring(1, s.length() - 1);
        }
        String[] ss = s.split(",");
        Datum[] result = new Datum[ss.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                result[i] = DatumUtil.parse(ss[i]);
                continue;
            }
            catch (ParseException ex) {
                throw new IllegalArgumentException("unable to parse: " + ss[i]);
            }
        }
        return result;
    }

    public Map<String, Object> getJpegExifMetaData(ProgressMonitor mon) throws Exception {
        InputStream in = DataSetURI.getInputStream(this.uri, mon);
        Metadata metadata = JpegMetadataReader.readMetadata((InputStream)in);
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        Directory exifDirectory = metadata.getDirectory(ExifSubIFDDirectory.class);
        if (exifDirectory != null) {
            for (Tag t : exifDirectory.getTags()) {
                map.put(t.getTagName(), t.getDescription());
            }
        }
        if ((exifDirectory = metadata.getDirectory(ExifIFD0Directory.class)) != null) {
            for (Tag t : exifDirectory.getTags()) {
                map.put(t.getTagName(), t.getDescription());
            }
        }
        if ((exifDirectory = metadata.getDirectory(GpsDirectory.class)) != null) {
            for (Tag t : exifDirectory.getTags()) {
                map.put(t.getTagName(), t.getDescription());
            }
        }
        return map;
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        String ext = this.getExt(this.resourceURI).toLowerCase();
        if (ext.equals(".jpg")) {
            return this.getJpegExifMetaData(mon);
        }
        File f = DataSetURI.getFile(this.uri, (ProgressMonitor)new NullProgressMonitor());
        ImageReader jpegImageReader = ImageIO.getImageReadersByFormatName(ext.substring(1)).next();
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(f);
        boolean seekForwardOnly = true;
        boolean ignoreMetadata = false;
        jpegImageReader.setInput(imageInputStream, seekForwardOnly, ignoreMetadata);
        IIOMetadata imageMetadata = jpegImageReader.getImageMetadata(0);
        Node metaDataRoot = imageMetadata.getAsTree(imageMetadata.getNativeMetadataFormatName());
        Map<String, Object> map = MetadataUtil.toMetaTree(metaDataRoot);
        return map;
    }
}

