/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.idlsupport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public final class WriteIDLSav {
    public static final int DATATYPE_DOUBLE = 5;
    public static final int RECTYPE_ENDMARKER = 6;
    public static final int RECTYPE_TIMESTAMP = 10;
    public static final int RECTYPE_VARIABLE = 2;
    public static final int RECTYPE_VERSION = 14;
    public static final int VARFLAG_ARRAY = 4;
    private LinkedHashMap<String, Object> variables = new LinkedHashMap();

    private String nameFor(int type) {
        if (type == 2) {
            return "VARIABLE";
        }
        if (type == 10) {
            return "TIMESTAMP";
        }
        if (type == 14) {
            return "VERSION";
        }
        if (type == 6) {
            return "ENDMARKER";
        }
        return "" + type;
    }

    private ByteBuffer timestamp() {
        String shost;
        ByteBuffer date = this.writeString(new Date().toString());
        ByteBuffer user = this.writeString(System.getProperty("user.name"));
        try {
            shost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            shost = "localhost";
        }
        ByteBuffer host = this.writeString(shost);
        ByteBuffer result = ByteBuffer.allocateDirect(1028 + date.limit() + user.limit() + host.limit());
        for (int i = 0; i < 1028; ++i) {
            result.put((byte)0);
        }
        result.put(date);
        result.put(user);
        result.put(host);
        result.flip();
        return result;
    }

    private ByteBuffer version() {
        ByteBuffer format = ByteBuffer.allocateDirect(4);
        format.order(ByteOrder.BIG_ENDIAN);
        format.putInt(9);
        format.flip();
        ByteBuffer arch = this.writeString(System.getProperty("os.arch"));
        ByteBuffer os = this.writeString(System.getProperty("os.name"));
        ByteBuffer release = this.writeString("(Autoplot)");
        ByteBuffer result = ByteBuffer.allocateDirect(8 + arch.limit() + os.limit() + release.limit());
        result.putInt(0);
        result.put(format);
        result.put(arch);
        result.put(os);
        result.put(release);
        result.flip();
        return result;
    }

    static ByteBuffer getBytesStr(String s) {
        return ByteBuffer.wrap(s.getBytes());
    }

    static ByteBuffer getBytesByte(byte b) {
        return ByteBuffer.wrap(new byte[]{b});
    }

    private ByteBuffer writeString(String s) {
        int len = 4 * (int)Math.ceil((double)(s.length() + 4) / 4.0);
        ByteBuffer result = ByteBuffer.allocateDirect(len);
        result.order(ByteOrder.BIG_ENDIAN);
        result.putInt(s.length());
        try {
            result.put(s.getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
        for (int i = result.position(); i < result.limit(); ++i) {
            result.put((byte)0);
        }
        result.flip();
        return result;
    }

    private ByteBuffer writeArrayDesc(Object data) {
        int nmax = 8;
        int capacity = (8 + nmax) * 4;
        int eleLen = 8;
        int ndims = 1;
        ByteBuffer result = ByteBuffer.allocateDirect(capacity);
        result.order(ByteOrder.BIG_ENDIAN);
        result.putInt(8);
        result.putInt(eleLen);
        result.putInt(Array.getLength(data) * eleLen);
        result.putInt(Array.getLength(data));
        result.putInt(ndims);
        result.putInt(0);
        result.putInt(0);
        result.putInt(nmax);
        for (int i = 0; i < nmax; ++i) {
            result.putInt(i == 0 ? Array.getLength(data) : 1);
        }
        result.flip();
        return result;
    }

    private int dataTypeCode(Object data) {
        if (data.getClass() == Short.class) {
            return 2;
        }
        if (data.getClass() == Integer.class) {
            return 3;
        }
        if (data.getClass() == Float.class) {
            return 4;
        }
        if (data.getClass() == Double.class) {
            return 5;
        }
        throw new IllegalArgumentException("unsupported type: " + data.getClass());
    }

    private ByteBuffer writeScalarDesc(Object data) {
        ByteBuffer result = ByteBuffer.allocateDirect(8);
        result.order(ByteOrder.BIG_ENDIAN);
        result.putInt(this.dataTypeCode(data));
        result.putInt(0);
        result.flip();
        return result;
    }

    private ByteBuffer writeTypeDesc(Object data) {
        if (data.getClass().isArray()) {
            return this.writeArrayDesc(data);
        }
        if (data.getClass() == Short.class) {
            return this.writeScalarDesc(data);
        }
        if (data.getClass() == Integer.class) {
            return this.writeScalarDesc(data);
        }
        if (data.getClass() == Float.class) {
            return this.writeScalarDesc(data);
        }
        if (data.getClass() == Double.class) {
            return this.writeScalarDesc(data);
        }
        throw new RuntimeException("not implemented");
    }

    private ByteBuffer writeDoubleArray(double[] data) {
        ByteBuffer buf = ByteBuffer.allocateDirect(data.length * 8);
        buf.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < data.length; ++i) {
            buf.putDouble(data[i]);
        }
        buf.flip();
        return buf;
    }

    private ByteBuffer writeLongArray(long[] data) {
        ByteBuffer buf = ByteBuffer.allocateDirect(data.length * 8);
        buf.order(ByteOrder.BIG_ENDIAN);
        for (int i = 0; i < data.length; ++i) {
            buf.putLong(data[i]);
        }
        buf.flip();
        return buf;
    }

    private ByteBuffer writeShort(short data) {
        ByteBuffer buf = ByteBuffer.allocateDirect(4);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putShort((short)0);
        buf.putShort(data);
        buf.flip();
        return buf;
    }

    private ByteBuffer writeTypeDescArray(Object data) {
        ByteBuffer arrayDesc = this.writeArrayDesc(data);
        ByteBuffer result = ByteBuffer.allocateDirect(8 + arrayDesc.limit());
        result.order(ByteOrder.BIG_ENDIAN);
        result.putInt(5);
        result.putInt(4);
        result.put(arrayDesc);
        result.flip();
        return result;
    }

    private ByteBuffer variable(String name, Object data, long pos) {
        ByteBuffer varData;
        this.checkVariableType(name, data);
        ByteBuffer nameBuf = this.writeString(name.toUpperCase());
        ByteBuffer typedesc = this.writeTypeDesc(data);
        if (data.getClass().isArray() && data.getClass().getComponentType() == Double.TYPE) {
            varData = this.writeDoubleArray((double[])data);
        } else if (data.getClass().isArray() && data.getClass().getComponentType() == Long.TYPE) {
            varData = this.writeLongArray((long[])data);
        } else if (data.getClass() == Short.class) {
            varData = this.writeShort((Short)data);
        } else {
            throw new RuntimeException("not supported " + data.getClass());
        }
        ByteBuffer result = ByteBuffer.allocateDirect(4 + nameBuf.limit() + 8 + typedesc.limit() + 4 + varData.limit());
        result.order(ByteOrder.BIG_ENDIAN);
        result.put(ByteBuffer.allocateDirect(4));
        result.put(nameBuf);
        result.putInt(5);
        result.putInt(20);
        result.put(typedesc);
        result.putInt(7);
        result.put(varData);
        result.flip();
        return result;
    }

    private ByteBuffer endMarker() {
        ByteBuffer result = ByteBuffer.allocate(4);
        for (int i = 0; i < 4; ++i) {
            result.put((byte)0);
        }
        result.flip();
        return result;
    }

    private int writeRecord(WritableByteChannel ch, int recType, ByteBuffer buf, int pos) throws IOException {
        int len = (int)(4.0 * Math.ceil(((double)buf.limit() + 12.0) / 4.0));
        ByteBuffer rec = ByteBuffer.allocateDirect(len);
        rec.order(ByteOrder.BIG_ENDIAN);
        rec.putInt(recType);
        if (recType == 6) {
            rec.putInt(0);
        } else {
            rec.putInt(pos + len);
        }
        rec.putInt(0);
        rec.put(buf);
        int padBytes = 0;
        for (int i = rec.position(); i < rec.limit(); ++i) {
            rec.put((byte)0);
            ++padBytes;
        }
        rec.flip();
        ch.write(rec);
        return pos += rec.limit();
    }

    public void checkVariableType(String name, Object data) {
        Class<?> c = data.getClass();
        if ((!c.isArray() || c.getComponentType() != Double.TYPE && c.getComponentType() != Long.TYPE) && c != Short.class) {
            throw new IllegalArgumentException("\"" + name + "\" is unsupported data type: " + data.getClass());
        }
    }

    public void addVariable(String name, Object data) {
        this.checkVariableType(name, data);
        this.variables.put(name, data);
    }

    public void write(OutputStream out) throws IOException {
        WritableByteChannel ch = Channels.newChannel(out);
        ch.write(WriteIDLSav.getBytesStr("SR"));
        ch.write(WriteIDLSav.getBytesByte((byte)0));
        ch.write(WriteIDLSav.getBytesByte((byte)4));
        int pos = 4;
        pos = this.writeRecord(ch, 10, this.timestamp(), pos);
        pos = this.writeRecord(ch, 14, this.version(), pos);
        for (Map.Entry<String, Object> var : this.variables.entrySet()) {
            pos = this.writeRecord(ch, 2, this.variable(var.getKey(), var.getValue(), pos), pos);
        }
        pos = this.writeRecord(ch, 6, this.endMarker(), pos);
        ch.close();
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(new File("/tmp/test.autoplot.idlsav"));
        WriteIDLSav widls = new WriteIDLSav();
        widls.addVariable("myvar", new double[]{120.0, 100.0, 120.0, 45.0, 46.0, 47.0, 48.0, 49.0, 120.0, 100.0, 120.0});
        widls.addVariable("second", new double[]{-1.0, -1.0, -2.0, -3.0, -3.0, 4.0, 5.0, 6.0, 7.0, 7.0, 8.0, 9.0, 9.0, 10.0});
        widls.addVariable("mylong", new long[]{-1L, 100000L, 100000000000L});
        widls.write(fos);
        fos.close();
    }
}

