/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.idlsupport;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.autoplot.datasource.DataSetSelectorSupport;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.DataSourceEditorPanelUtil;
import org.autoplot.datasource.DataSourceRegistry;
import org.das2.qds.QDataSet;
import org.das2.util.AboutUtil;
import org.das2.util.monitor.NullProgressMonitor;

public class Util {
    public static boolean isMap(Object o) {
        return o instanceof Map;
    }

    public static boolean isQDataSet(Object o) {
        return o instanceof QDataSet;
    }

    public static String getPlugins() {
        return DataSetSelectorSupport.getPluginsText();
    }

    public static String getVersions() {
        return AboutUtil.getAboutHtml();
    }

    public static void silenceLoggers() {
        Logger.getLogger("das2.system").setLevel(Level.WARNING);
        Logger.getLogger("das2.gui").setLevel(Level.WARNING);
        Logger.getLogger("das2.graphics").setLevel(Level.WARNING);
        Logger.getLogger("das2.graphics.renderer").setLevel(Level.WARNING);
        Logger.getLogger("das2.dataOperations").setLevel(Level.WARNING);
        Logger.getLogger("das2.filesystem").setLevel(Level.WARNING);
        Logger.getLogger("das2.dasml").setLevel(Level.WARNING);
        Logger.getLogger("das2").setLevel(Level.WARNING);
        Logger.getAnonymousLogger().setLevel(Level.WARNING);
    }

    public static void verboseLoggers() {
        Logger.getLogger("das2.system").setLevel(Level.ALL);
        Logger.getLogger("das2.gui").setLevel(Level.ALL);
        Logger.getLogger("das2.graphics").setLevel(Level.ALL);
        Logger.getLogger("das2.graphics.renderer").setLevel(Level.ALL);
        Logger.getLogger("das2.dataOperations").setLevel(Level.ALL);
        Logger.getLogger("das2.filesystem").setLevel(Level.ALL);
        Logger.getLogger("das2.dasml").setLevel(Level.ALL);
        Logger.getLogger("das2").setLevel(Level.ALL);
        Logger.getAnonymousLogger().setLevel(Level.ALL);
    }

    public String[] getDiscoverySources() {
        DataSourceRegistry registry = DataSourceRegistry.getInstance();
        List<String> exts = registry.getSourceEditorExtensions();
        ArrayList<String> result = new ArrayList<String>();
        for (String ext : exts) {
            String uri = "vap+" + ext.substring(1) + ":";
            try {
                DataSourceEditorPanel p = DataSourceEditorPanelUtil.getEditorByExt(ext);
                if (p.reject(uri)) {
                    System.err.printf("           (nope) %s: %s\n", ext, p);
                    continue;
                }
                result.add(uri);
            }
            catch (Exception ex) {
                System.err.printf("           (exception) %s  %s\n", ext, ex);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public String enterEditor(String uri) throws Exception {
        DataSourceEditorPanel p = DataSourceEditorPanelUtil.getDataSourceEditorPanel(uri);
        if (p.reject(uri)) {
            System.err.printf("           (nope) %s: %s\n", uri, p);
            return uri;
        }
        p.prepare(uri, null, new NullProgressMonitor());
        p.setURI(uri);
        JOptionPane.showMessageDialog(null, p.getPanel());
        return p.getURI();
    }
}

