/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.idlsupport;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.datasource.DataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.jdesktop.layout.GroupLayout;

public class IdlsavDataSourceFormatEditorPanel
extends JPanel
implements DataSourceFormatEditorPanel {
    String file;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox typeComboBox;

    public IdlsavDataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.typeComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel1.setText("Time Units:");
        this.typeComboBox.setEditable(true);
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"t1970", "t2000", "cdfTT2000", "seconds since 2010-02-03T00:00"}));
        this.jLabel2.setText("Presently only 1-D data can be exported to IDLSav files.");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2, -1, 376, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.typeComboBox, 0, 292, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2).add(7, 7, 7).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.typeComboBox, -2, -1, -2)).addContainerGap(237, Short.MAX_VALUE)));
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    private String getParam(Map<String, String> args, String name, String defl) {
        String s = args.get(name);
        if (s == null) {
            return defl;
        }
        return s;
    }

    @Override
    public void setURI(String uri) {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
        String s = this.getParam(args, "tunits", "t1970");
        this.typeComboBox.setSelectedItem(s);
        this.file = split.file;
    }

    @Override
    public String getURI() {
        String result = this.file;
        HashMap<String, String> args = new HashMap<String, String>();
        String s = (String)this.typeComboBox.getSelectedItem();
        if (!s.equals("t1970")) {
            args.put("tunits", s);
        }
        String params = URISplit.formatParams(args);
        if (result == null) {
            result = "file:///";
        }
        URISplit ss = URISplit.parse(result);
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format(ss);
    }
}

