/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.idlsupport;

import java.io.File;
import java.io.FileOutputStream;
import org.autoplot.datasource.AbstractDataSourceFormat;
import org.autoplot.idlsupport.WriteIDLSav;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

public class IdlsavDataSourceFormat
extends AbstractDataSourceFormat {
    private void doOne(WriteIDLSav write, QDataSet data, String guessName) {
        String su = this.getParam("tunits", "t1970");
        QDataSet wds = Ops.valid(data);
        double[] dd = new double[data.length()];
        for (int i = 0; i < dd.length; ++i) {
            dd[i] = wds.value(i) == 0.0 ? Double.NaN : data.value(i);
        }
        Units dep0u = SemanticOps.getUnits(data);
        if (UnitsUtil.isTimeLocation(dep0u)) {
            Units targetUnits = Units.lookupUnits(su.replaceAll("_", " ").replaceAll("\\+", " "));
            UnitsConverter uc = UnitsConverter.IDENTITY;
            if (UnitsUtil.isTimeLocation(dep0u)) {
                uc = UnitsConverter.getConverter(dep0u, targetUnits);
            }
            for (int i = 0; i < dd.length; ++i) {
                dd[i] = uc.convert(data.value(i));
            }
        }
        write.addVariable(Ops.guessName(data, guessName), dd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void formatRank2Bundle(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        this.setUri(uri);
        WriteIDLSav write = new WriteIDLSav();
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 != null) {
            this.doOne(write, dep0, "dep0");
        }
        for (int i = 0; i < data.length(0); ++i) {
            QDataSet ds1 = Ops.unbundle(data, i);
            this.doOne(write, ds1, "data" + i);
        }
        this.setUri(uri);
        File f = new File(this.getResourceURI().toURL().getFile());
        try (FileOutputStream fos = new FileOutputStream(f);){
            write.write(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        this.setUri(uri);
        if (data.rank() != 1) {
            if (SemanticOps.isBundle(data)) {
                this.formatRank2Bundle(uri, data, mon);
                return;
            }
            throw new IllegalArgumentException("not supported, rank " + data.rank());
        }
        WriteIDLSav write = new WriteIDLSav();
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 != null) {
            this.doOne(write, dep0, "dep0");
        }
        this.doOne(write, data, "data");
        QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
        if (dep1 != null) {
            this.doOne(write, dep1, "dep1");
        }
        this.setUri(uri);
        File f = new File(this.getResourceURI().toURL().getFile());
        try (FileOutputStream fos = new FileOutputStream(f);){
            write.write(fos);
        }
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        return ds.rank() == 1 || ds.rank() == 2 && SemanticOps.isBundle(ds);
    }

    @Override
    public String getDescription() {
        return "IDL Saveset";
    }
}

