/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.idlsupport;

import java.net.URI;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.idlsupport.QDataSetBridge;
import org.das2.qds.QDataSet;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class APDataSet
extends QDataSetBridge {
    private String surl;
    private static final Logger logger = Logger.getLogger("qdataset.bridge");

    public APDataSet() {
        System.err.println("APDataSet v1.6.1");
        String j = System.getProperty("java.version");
        System.err.println("Java Version " + j);
        logger.fine("disabling HTTP certificate checks.");
        try {
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
        }
        catch (KeyManagementException | NoSuchAlgorithmException ex) {
            Logger.getLogger(APDataSet.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public synchronized void setDataSetURL(String surl) {
        this.surl = surl;
        this.datasets.clear();
        this.names.clear();
    }

    public synchronized void setDataSetURI(String suri) {
        logger.log(Level.FINE, "setDataSetURI({0})", suri);
        this.surl = suri;
        this.datasets.clear();
        this.names.clear();
    }

    public int loadDataSet(String uri) {
        logger.log(Level.FINE, "loadDataSet({0})", uri);
        this.setDataSetURI(uri);
        this.doGetDataSet();
        if (this.exception != null) {
            return 1;
        }
        return 0;
    }

    public int loadDataSet(String uri, ProgressMonitor mon) {
        logger.log(Level.FINE, "loadDataSet({0},mon)", uri);
        this.setDataSetURI(uri);
        this.doGetDataSet(mon);
        if (this.exception != null) {
            return 1;
        }
        return 0;
    }

    @Override
    protected QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        ArrayList<String> problems;
        logger.fine("getDataSet");
        if (this.surl == null) {
            throw new IllegalStateException("uri has not been set.");
        }
        URI uri = DataSetURI.getURI(this.surl);
        DataSourceFactory f = DataSetURI.getDataSourceFactory(uri, new NullProgressMonitor());
        if (f.reject(this.surl, problems = new ArrayList<String>(), mon)) {
            throw new Exception("URI was rejected by the datasource: " + this.surl + " rejected by " + f);
        }
        DataSource dsource = f.getDataSource(uri);
        QDataSet result = dsource.getDataSet(mon);
        if (result == null) {
            throw new Exception("getDataSet did not result in dataset: " + this.surl);
        }
        return result;
    }

    public String toString() {
        if (this.surl == null) {
            return "(uninitialized)";
        }
        QDataSet d = (QDataSet)this.datasets.get(this.name);
        StringBuilder s = new StringBuilder();
        s.append(this.surl);
        if (this.filter.length() > 0) {
            s.append(this.filter);
        }
        for (Map.Entry e : this.datasets.entrySet()) {
            String name1 = (String)e.getKey();
            QDataSet qds = (QDataSet)e.getValue();
            s.append("\n").append(name1).append(": ").append(qds.toString());
            for (int i = 0; i < 4; ++i) {
                if (d.property("DEPEND_" + i) == qds) {
                    s.append(" (DEPEND_").append(i).append(")");
                }
                if (d.property("BUNDLE_" + i) != qds) continue;
                s.append(" (BUNDLE_").append(i).append(")");
            }
        }
        for (Map.Entry e : this.sliceDep.entrySet()) {
            String n = (String)e.getKey();
            QDataSet ds1 = (QDataSet)((QDataSet)this.datasets.get(this.name)).slice(0).property((String)e.getValue());
            s.append("\nvia slice(0): ").append(n).append(": ").append(ds1).append(" (").append((String)this.sliceDep.get(n)).append(")");
        }
        return s.toString();
    }

    public static void main(String[] args) {
        APDataSet qds = new APDataSet();
        qds.setDataSetURI("http://autoplot.org/data/autoplot.dat");
        qds.doGetDataSet(new NullProgressMonitor());
        String n = qds.name();
        System.err.println(n);
    }
}

