/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import org.autoplot.datasource.AbstractDataSourceFormat;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.util.monitor.ProgressMonitor;

public class HtmlTableFormat
extends AbstractDataSourceFormat {
    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        if (data.rank() == 2) {
            this.formatDataRank2(uri, data, mon);
        } else if (data.rank() == 1) {
            this.formatDataRank1(uri, data, mon);
        }
    }

    public void formatDataRank2(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        this.setUri(uri);
        File f = new File(this.getResourceURI());
        BufferedWriter w = new BufferedWriter(new FileWriter(f));
        QDataSet bds = (QDataSet)data.property("BUNDLE_1");
        w.write("<body><table>\n");
        for (int j = 0; j < bds.length(); ++j) {
            String h;
            w.append("<th>");
            Units u = (Units)bds.property("UNITS", j);
            if (u == null) {
                u = Units.dimensionless;
            }
            if ((h = (String)bds.property("LABEL", j)) != null) {
                w.append(h);
            }
            if (u != Units.dimensionless) {
                w.append("(");
                w.append(u.toString());
                w.append(")");
            }
            w.append("</th>\n");
        }
        w.append("</tr>\n");
        for (int i = 0; i < data.length(); ++i) {
            StringBuilder b = new StringBuilder();
            b.append("<tr>");
            for (int j = 0; j < data.length(0); ++j) {
                b.append("<td>");
                Units u = (Units)bds.property("UNITS", j);
                if (u == null) {
                    u = Units.dimensionless;
                }
                Datum d = u.createDatum(data.value(i, j));
                b.append(d.getFormatter().format(d, u));
                b.append("</td>\n");
            }
            b.append("</tr>\n");
            w.write(b.toString());
        }
        w.write("</table></body>");
        w.close();
    }

    public void formatDataRank1(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        QDataSet dep0 = SemanticOps.xtagsDataSet(data);
        this.setUri(uri);
        File f = new File(this.getResourceURI());
        BufferedWriter w = new BufferedWriter(new FileWriter(f));
        w.write("<body><table>\n");
        w.append("<th>");
        Units u = SemanticOps.getUnits(dep0);
        String h = (String)dep0.property("LABEL");
        if (h != null) {
            w.append(h);
        }
        if (u != Units.dimensionless) {
            w.append("(");
            w.append(u.toString());
            w.append(")");
        }
        w.append("</th>\n");
        w.append("<th>");
        u = SemanticOps.getUnits(data);
        h = (String)data.property("LABEL");
        if (h != null) {
            w.append(h);
        }
        if (u != Units.dimensionless) {
            w.append("(");
            w.append(u.toString());
            w.append(")");
        }
        w.append("</th>");
        w.append("</tr>\n");
        for (int i = 0; i < data.length(); ++i) {
            StringBuilder b = new StringBuilder();
            b.append("<tr>");
            b.append("<td>");
            u = SemanticOps.getUnits(dep0);
            if (u == null) {
                u = Units.dimensionless;
            }
            Datum d = u.createDatum(dep0.value(i));
            b.append(d.getFormatter().format(d, u));
            b.append("</td>");
            b.append("<td>");
            u = SemanticOps.getUnits(data);
            d = u.createDatum(data.value(i));
            b.append(d.getFormatter().format(d, u));
            b.append("</td>");
            b.append("</tr>\n");
            w.write(b.toString());
        }
        w.write("</table></body>\n");
        w.close();
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        return ds.rank() == 2 || ds.rank() == 1;
    }

    @Override
    public String getDescription() {
        return "HTML Table";
    }
}

