/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.URISplit;
import org.autoplot.html.HtmlTableDataSource;
import org.das2.util.monitor.ProgressMonitor;

public class HtmlTableDataSourceFactory
extends AbstractDataSourceFactory {
    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        return new HtmlTableDataSource(uri);
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "column=", "the name (or number) of the column to plot"));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "table=", "the table name (or number) of the table"));
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        if (params.get("column") == null) {
            return true;
        }
        return params.get("table") == null;
    }
}

