/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.html.parser.ParserDelegator;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.capability.Streaming;
import org.autoplot.html.AsciiTableStreamer;
import org.autoplot.html.HtmlParserCallback;
import org.autoplot.html.HtmlParserStreamer;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class HtmlTableDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerManager.getLogger("apdss.html");
    public static final String PARAM_COLUMN = "column";
    public static final String PARAM_TABLE = "table";
    public static final String PARAM_UNITS = "units";

    public HtmlTableDataSource(URI uri) {
        super(uri);
        this.addCapability(Streaming.class, new AsciiTableStreamingSource());
    }

    public QDataSet getTable(ProgressMonitor mon) throws IOException {
        File f = this.getHtmlFile(this.resourceURI.toURL(), mon);
        try (BufferedReader reader = new BufferedReader(new FileReader(f));){
            QDataSet ds;
            String stable;
            HtmlParserCallback callback = new HtmlParserCallback();
            String units = this.getParam(PARAM_UNITS, null);
            if (units != null) {
                callback.setUnits(URLDecoder.decode(units, "UTF-8"));
            }
            if ((stable = this.getParams().get(PARAM_TABLE)) != null) {
                callback.setTable(stable);
            }
            new ParserDelegator().parse(reader, callback, true);
            QDataSet qDataSet = ds = callback.getDataSet();
            return qDataSet;
        }
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws IOException {
        QDataSet ds = this.getTable(mon);
        String column = this.getParams().get(PARAM_COLUMN);
        if (column == null) {
            return ds;
        }
        try {
            int icol = Integer.parseInt(column);
            return DataSetOps.unbundle(ds, icol);
        }
        catch (NumberFormatException ex) {
            return DataSetOps.unbundle(ds, column);
        }
    }

    public List<String> getTables() throws IOException {
        File f = this.getHtmlFile(this.resourceURI.toURL(), new NullProgressMonitor());
        BufferedReader reader = new BufferedReader(new FileReader(f));
        HtmlParserCallback callback = new HtmlParserCallback();
        String stable = this.getParams().get(PARAM_TABLE);
        if (stable != null) {
            callback.setTable(stable);
        }
        new ParserDelegator().parse(reader, callback, true);
        ArrayList<String> tables = new ArrayList<String>(callback.getTables());
        return tables;
    }

    private class AsciiTableStreamingSource
    implements Streaming {
        @Override
        public Iterator<QDataSet> streamDataSet(ProgressMonitor mon) throws Exception {
            String stable;
            AsciiTableStreamer result = new AsciiTableStreamer();
            final File f = HtmlTableDataSource.this.getHtmlFile(HtmlTableDataSource.this.resourceURI.toURL(), mon);
            final BufferedReader reader = new BufferedReader(new FileReader(f));
            final HtmlParserStreamer callback = new HtmlParserStreamer();
            callback.ascii = result;
            String units = HtmlTableDataSource.this.getParam(HtmlTableDataSource.PARAM_UNITS, null);
            if (units != null) {
                callback.setUnits(URLDecoder.decode(units, "UTF-8"));
            }
            if ((stable = (String)HtmlTableDataSource.this.getParams().get(HtmlTableDataSource.PARAM_TABLE)) != null) {
                callback.setTable(stable);
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        new ParserDelegator().parse(reader, callback, true);
                        logger.log(Level.FINE, "Done parsing {0}", f);
                    }
                    catch (IOException ex) {
                    }
                    finally {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            logger.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                }
            };
            new Thread(run, "HtmlTableDataStreamer").start();
            return result;
        }
    }
}

