/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.html;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import org.autoplot.html.AsciiTableMaker;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;

public class HtmlParserCallback
extends HTMLEditorKit.ParserCallback {
    private static final Logger logger = Logger.getLogger("apdss.html");
    int tableCount = -1;
    int itable = 0;
    String stable = null;
    boolean inTable = false;
    List<String> currentRow;
    int fieldCount = -1;
    boolean inField = false;
    String fieldText = "";
    int recordCount = -1;
    boolean isHeader = false;
    int icolspan;
    AsciiTableMaker ascii = new AsciiTableMaker();
    List<String> tables = new ArrayList<String>();
    private List<String> currentTableName = new ArrayList<String>();
    int nest = 0;

    void setTable(String name) {
        int i = name.indexOf(":");
        if (i > -1) {
            name = name.substring(0, i);
        }
        this.stable = name;
        try {
            this.itable = Integer.parseInt(name);
        }
        catch (NumberFormatException ex) {
            this.itable = -1;
        }
    }

    void setUnits(String units) {
        this.ascii.setUnits(units);
    }

    @Override
    public void handleText(char[] data, int pos) {
        if (this.inField) {
            this.fieldText = this.fieldText + new String(data);
            if (this.fieldText.length() > 30) {
                this.fieldText = this.fieldText.substring(0, 27) + "...";
            }
        }
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        logger.log(Level.FINE, "startTag {0} @{1}", new Object[]{t, pos});
        if (t == HTML.Tag.TABLE) {
            ++this.tableCount;
            ++this.nest;
            this.recordCount = 0;
            String tableName = (String)a.getAttribute("id");
            if (tableName == null) {
                tableName = "" + this.tableCount;
            }
            this.currentTableName.add(tableName);
            if (this.itable > -1) {
                if (this.tableCount == this.itable) {
                    this.inTable = true;
                }
            } else if (this.stable.equals(a.getAttribute("id"))) {
                this.inTable = true;
            }
        } else if (this.inTable) {
            if (t == HTML.Tag.TR) {
                this.currentRow = new ArrayList<String>();
            } else if (t == HTML.Tag.TH) {
                String colspan = (String)a.getAttribute(HTML.Attribute.COLSPAN);
                this.icolspan = colspan != null ? Integer.parseInt(colspan) : 1;
                this.inField = true;
                this.fieldText = "";
                this.isHeader = true;
            } else if (t == HTML.Tag.TD) {
                this.inField = true;
                this.fieldText = "";
                this.isHeader = false;
            }
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        logger.log(Level.FINE, "endTag {0} @{1}", new Object[]{t, pos});
        if (t == HTML.Tag.TABLE) {
            --this.nest;
            String dim = this.fieldCount > -1 ? this.recordCount + " rows, " + this.fieldCount + " colums" : this.recordCount + " rows";
            if (this.currentTableName.isEmpty()) {
                throw new IllegalArgumentException("table html syntax");
            }
            this.tables.add(this.currentTableName.remove(0) + ": " + dim);
            if (this.inTable) {
                this.inTable = false;
            }
        } else if (this.inTable) {
            if (t == HTML.Tag.TR) {
                if (this.fieldCount == -1) {
                    this.fieldCount = this.currentRow.size();
                }
                if (this.currentRow.size() != this.fieldCount) {
                    logger.fine("skipping row because of field count");
                    return;
                }
                if (this.isHeader) {
                    this.ascii.addHeader(this.currentRow);
                } else if (!this.ascii.hasHeader()) {
                    ArrayList<String> values = new ArrayList<String>();
                    boolean haveNumber = false;
                    for (int i = 0; i < this.currentRow.size(); ++i) {
                        values.add("field" + i);
                        try {
                            Double.parseDouble(this.currentRow.get(i));
                            haveNumber = true;
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    if (!haveNumber) {
                        this.ascii.addHeader(this.currentRow);
                    } else {
                        this.ascii.addHeader(values);
                    }
                } else {
                    ++this.recordCount;
                    this.ascii.addRecord(this.currentRow);
                }
            } else if (t == HTML.Tag.TH) {
                this.inField = false;
                this.currentRow.add(this.fieldText);
                for (int i = 1; i < this.icolspan; ++i) {
                    this.currentRow.add(this.fieldText);
                }
                this.fieldText = "";
            } else if (t == HTML.Tag.TD) {
                this.inField = false;
                this.currentRow.add(this.fieldText);
                this.fieldText = "";
            }
        }
    }

    public QDataSet getDataSet() {
        DDataSet result = this.ascii.getDataSet();
        if (this.itable == -1) {
            result.putProperty("NAME", this.stable);
        }
        return result;
    }

    public List<String> getTables() {
        return new ArrayList<String>(this.tables);
    }
}

