/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.DefaultDatumFormatterFactory;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FloatReadAccess;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.AsciiTimeTransferType;
import org.das2.qstream.DoubleTransferType;
import org.das2.qstream.IntegerTransferType;
import org.das2.qstream.TransferType;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HapiDataSourceFormat
implements DataSourceFormat {
    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        Number f2;
        Object j1;
        int i;
        String format;
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String s = split.file;
        if (!s.startsWith("file://")) {
            throw new IllegalArgumentException("uri must start with file://");
        }
        s = s.substring(7);
        int ix = s.lastIndexOf(".hapi");
        if (ix == -1) {
            throw new IllegalArgumentException("uri must end in .hapi");
        }
        File hapiDir = new File(s.substring(0, ix));
        String id = (String)params.get("id");
        if (id == null || id.length() == 0) {
            id = "data";
        }
        if ((format = (String)params.get("format")) == null || format.length() == 0) {
            format = "csv";
        }
        File infoFile = new File(new File(hapiDir, "info"), id + ".json");
        JSONObject jo = new JSONObject();
        jo.put("HAPI", (Object)"1.1");
        jo.put("createdAt", (Object)TimeUtil.now().toString());
        JSONArray parameters = new JSONArray();
        ArrayList<QDataSet> dss = new ArrayList<QDataSet>();
        ArrayList<FloatReadAccess> ffds = new ArrayList<FloatReadAccess>();
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 == null) {
            throw new IllegalArgumentException("data must have a DEPEND_0");
        }
        dss.add(dep0);
        ffds.add(null);
        boolean dep1IsOrdinal = false;
        QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
        if (dep1 != null && dep1.rank() == 1) {
            if (UnitsUtil.isOrdinalMeasurement(SemanticOps.getUnits(dep1))) {
                dep1IsOrdinal = true;
            } else {
                dep1IsOrdinal = true;
                for (int i2 = 0; dep1IsOrdinal && i2 < dep1.length(); ++i2) {
                    if (dep1.value(i2) == (double)(i2 + 1)) continue;
                    dep1IsOrdinal = false;
                }
            }
        }
        FloatReadAccess fra = data.capability(FloatReadAccess.class);
        if ((dep1IsOrdinal || data.property("DEPEND_1") == null) && SemanticOps.isBundle(data)) {
            for (i = 0; i < data.length(0); ++i) {
                dss.add(Ops.unbundle(data, i));
                ffds.add(fra);
            }
        } else {
            dss.add(data);
            ffds.add(fra);
        }
        String groupTitle = (String)data.property("TITLE");
        if (groupTitle == null) {
            groupTitle = (String)data.property("LABEL");
        }
        if (groupTitle == null) {
            groupTitle = Ops.guessName(data);
        }
        i = 0;
        for (QDataSet ds : dss) {
            Units u = SemanticOps.getUnits(ds);
            if (UnitsUtil.isTimeLocation(u)) {
                JSONObject time = new JSONObject();
                time.put("length", 24);
                time.put("name", (Object)"Time");
                time.put("type", (Object)"isotime");
                time.put("fill", (Object)"NaN");
                parameters.put(i, (Object)time);
            } else {
                j1 = new JSONObject();
                j1.put("name", (Object)Ops.guessName(ds, "data" + i));
                j1.put("description", ds.property("TITLE"));
                if (u != null && u != Units.dimensionless) {
                    j1.put("units", (Object)SemanticOps.getUnits(ds));
                }
                j1.put("type", (Object)"double");
                if (ds.rank() > 1) {
                    j1.put("size", (Object)DataSetUtil.qubeDims(ds.slice(0)));
                }
                if ((f2 = (Number)ds.property("FILL_VALUE")) != null) {
                    j1.put("fill", (Object)f2);
                } else {
                    j1.put("fill", (Object)"NaN");
                }
                if (ds.rank() >= 2) {
                    j1.put("bins", (Object)this.getBinsFor(ds));
                }
                parameters.put(i, j1);
            }
            ++i;
        }
        DatumRange dr = DataSetUtil.asDatumRange(Ops.extent(dep0));
        jo.put("startDate", (Object)dr.min().toString());
        jo.put("stopDate", (Object)dr.max().toString());
        jo.put("sampleStartDate", (Object)dr.min().toString());
        jo.put("sampleStopDate", (Object)dr.max().toString());
        jo.put("parameters", (Object)parameters);
        File parentFile = infoFile.getParentFile();
        if (parentFile == null) {
            throw new IllegalArgumentException("info has no parent");
        }
        if (!parentFile.exists() && !parentFile.mkdirs()) {
            throw new IllegalArgumentException("unable to make folder for info file.");
        }
        FileWriter fw = new FileWriter(infoFile);
        j1 = null;
        try {
            fw.write(jo.toString(4));
        }
        catch (Throwable f2) {
            j1 = f2;
            throw f2;
        }
        finally {
            if (fw != null) {
                if (j1 != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable f2) {
                        ((Throwable)j1).addSuppressed(f2);
                    }
                } else {
                    fw.close();
                }
            }
        }
        this.updateCatalog(hapiDir, id, groupTitle);
        File capabilitiesFile = new File(hapiDir, "capabilities.json");
        JSONObject c = new JSONObject();
        c.put("HAPI", (Object)"1.1");
        f2 = new JSONArray();
        f2.put(0, "csv");
        f2.put(1, "binary");
        c.put("outputFormats", (Object)f2);
        try (FileWriter fw2 = new FileWriter(capabilitiesFile);){
            c.write((Writer)fw2);
            fw2.write(c.toString(4));
        }
        String ext = format.equals("binary") ? ".binary" : ".csv";
        File dataFile = new File(new File(hapiDir, "data"), id + ext);
        if (!dataFile.getParentFile().exists()) {
            dataFile.getParentFile().mkdirs();
        }
        if (format.equals("binary")) {
            Object u;
            TransferType[] tts = new TransferType[dss.size()];
            int nbytes = 0;
            for (int ids = 0; ids < dss.size(); ++ids) {
                QDataSet ds = (QDataSet)dss.get(ids);
                u = SemanticOps.getUnits(ds);
                tts[ids] = UnitsUtil.isTimeLocation((Units)u) ? new AsciiTimeTransferType(24, (Units)u) : (UnitsUtil.isNominalMeasurement((Units)u) ? new IntegerTransferType() : new DoubleTransferType());
                nbytes += tts[ids].sizeBytes();
            }
            int nrec = ((QDataSet)dss.get(0)).length();
            FileOutputStream out = new FileOutputStream(dataFile);
            u = null;
            try {
                FileChannel channel = out.getChannel();
                ByteBuffer buf = ByteBuffer.allocate(nbytes);
                buf.order(ByteOrder.LITTLE_ENDIAN);
                for (int irec = 0; irec < nrec; ++irec) {
                    for (int ids = 0; ids < dss.size(); ++ids) {
                        QDataSet ds = (QDataSet)dss.get(ids);
                        TransferType tt = tts[ids];
                        if (ds.rank() == 1) {
                            tt.write(ds.value(irec), buf);
                            continue;
                        }
                        if (ds.rank() == 2) {
                            for (int j = 0; j < ds.length(0); ++j) {
                                tt.write(ds.value(irec, j), buf);
                            }
                            continue;
                        }
                        if (ds.rank() <= 2) continue;
                        QDataSet ds1 = ds.slice(irec);
                        QubeDataSetIterator iter = new QubeDataSetIterator(ds1);
                        while (iter.hasNext()) {
                            iter.next();
                            double d = iter.getValue(ds1);
                            tt.write(d, buf);
                        }
                    }
                    buf.flip();
                    channel.write(buf);
                    buf.flip();
                }
            }
            catch (Throwable channel) {
                u = channel;
                throw channel;
            }
            finally {
                if (out != null) {
                    if (u != null) {
                        try {
                            out.close();
                        }
                        catch (Throwable channel) {
                            ((Throwable)u).addSuppressed(channel);
                        }
                    } else {
                        out.close();
                    }
                }
            }
        }
        DatumFormatter[] dfs = new DatumFormatter[dss.size()];
        for (int ids = 0; ids < dss.size(); ++ids) {
            QDataSet ds = (QDataSet)dss.get(ids);
            Units u = SemanticOps.getUnits(ds);
            dfs[ids] = UnitsUtil.isTimeLocation(u) ? DataSetUtil.bestFormatter(ds) : (UnitsUtil.isNominalMeasurement(u) ? DataSetUtil.bestFormatter(ds) : DefaultDatumFormatterFactory.getInstance().defaultFormatter());
        }
        int nrec = ((QDataSet)dss.get(0)).length();
        try (FileWriter fw3 = new FileWriter(dataFile);){
            for (int irec = 0; irec < nrec; ++irec) {
                String delim = "";
                for (int ids = 0; ids < dss.size(); ++ids) {
                    QDataSet ds = (QDataSet)dss.get(ids);
                    DatumFormatter df = dfs[ids];
                    Units u = SemanticOps.getUnits(ds);
                    if (ids > 0) {
                        delim = ",";
                    }
                    boolean uIsOrdinal = UnitsUtil.isOrdinalMeasurement(u);
                    fra = (FloatReadAccess)ffds.get(ids);
                    if (ds.rank() == 1) {
                        if (ids > 0) {
                            fw3.write(delim);
                        }
                        if (fra != null) {
                            fw3.write(String.valueOf(fra.fvalue(irec)));
                            continue;
                        }
                        fw3.write(df.format(u.createDatum(ds.value(irec)), u));
                        continue;
                    }
                    if (ds.rank() == 2) {
                        if (fra != null) {
                            for (int j = 0; j < ds.length(0); ++j) {
                                if (ids > 0) {
                                    fw3.write(delim);
                                }
                                fw3.write(String.valueOf(fra.fvalue(irec, j)));
                            }
                            continue;
                        }
                        for (int j = 0; j < ds.length(0); ++j) {
                            if (ids > 0) {
                                fw3.write(delim);
                            }
                            fw3.write(df.format(u.createDatum(ds.value(irec, j)), u));
                        }
                        continue;
                    }
                    if (ds.rank() <= 2) continue;
                    QDataSet ds1 = ds.slice(irec);
                    QubeDataSetIterator iter = new QubeDataSetIterator(ds1);
                    while (iter.hasNext()) {
                        iter.next();
                        double d = iter.getValue(ds1);
                        if (ids > 0) {
                            fw3.write(delim);
                        }
                        if (uIsOrdinal) {
                            fw3.write("\"");
                            fw3.write(df.format(u.createDatum(d), u));
                            fw3.write("\"");
                            continue;
                        }
                        fw3.write(df.format(u.createDatum(d), u));
                    }
                }
                fw3.write("\n");
            }
        }
    }

    private void updateCatalog(File hapiDir, String id, String groupTitle) throws JSONException, IOException {
        JSONObject item;
        JSONArray catalogArray;
        JSONObject catalog;
        File catalogFile = new File(hapiDir, "catalog.json");
        if (catalogFile.exists()) {
            StringBuilder builder = new StringBuilder();
            try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(catalogFile)));){
                String line = in.readLine();
                while (line != null) {
                    builder.append(line);
                    line = in.readLine();
                }
            }
            catalog = new JSONObject(builder.toString());
            catalogArray = catalog.getJSONArray("catalog");
        } else {
            catalog = new JSONObject();
            catalog.put("HAPI", (Object)"1.1");
            catalogArray = new JSONArray();
            catalog.put("catalog", (Object)catalogArray);
        }
        int itemIndex = -1;
        for (int j = 0; j < catalogArray.length(); ++j) {
            JSONObject item1 = catalogArray.getJSONObject(j);
            if (!item1.get("id").equals(id)) continue;
            itemIndex = j;
        }
        if (itemIndex == -1) {
            item = new JSONObject();
            item.put("id", (Object)id);
            item.put("title", (Object)groupTitle);
            catalogArray.put(catalogArray.length(), (Object)item);
        } else {
            item = catalogArray.getJSONObject(itemIndex);
            item.put("id", (Object)id);
            item.put("title", (Object)groupTitle);
        }
        try (FileWriter fw = new FileWriter(catalogFile);){
            fw.write(catalog.toString(4));
        }
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        return !SemanticOps.isJoin(ds);
    }

    @Override
    public String getDescription() {
        return "HAPI Info response";
    }

    private JSONArray getBinsFor(QDataSet ds) throws JSONException {
        JSONArray binsArray = new JSONArray();
        int[] qube = DataSetUtil.qubeDims(ds);
        for (int i = 1; i < ds.rank(); ++i) {
            int j;
            JSONObject jo;
            Units u;
            String n;
            QDataSet dep = (QDataSet)ds.property("DEPEND_" + i);
            if (dep == null) {
                dep = Ops.findgen(qube[i]);
            }
            if (dep.rank() == 2) {
                if (SemanticOps.isBins(dep)) {
                    n = Ops.guessName(dep, "dep" + i);
                    u = SemanticOps.getUnits(dep);
                    jo = new JSONObject();
                    jo.put("name", (Object)n);
                    jo.put("units", (Object)u.toString());
                    JSONArray ranges = new JSONArray();
                    for (j = 0; j < qube[i]; ++j) {
                        JSONArray range = new JSONArray();
                        range.put(0, dep.value(j, 0));
                        range.put(1, dep.value(j, 1));
                        ranges.put(j, (Object)range);
                    }
                    jo.put("ranges", (Object)ranges);
                    binsArray.put(i - 1, (Object)jo);
                    continue;
                }
                throw new IllegalArgumentException("independent variable must be a simple 1-D array");
            }
            n = Ops.guessName(dep, "dep" + i);
            u = SemanticOps.getUnits(dep);
            jo = new JSONObject();
            jo.put("name", (Object)n);
            jo.put("units", (Object)u.toString());
            JSONArray centers = new JSONArray();
            for (j = 0; j < qube[i]; ++j) {
                centers.put(j, dep.value(j));
            }
            jo.put("centers", (Object)centers);
            QDataSet binMax = (QDataSet)dep.property("BIN_MAX");
            QDataSet binMin = (QDataSet)dep.property("BIN_MIN");
            if (binMin != null && binMax != null) {
                JSONArray ranges = new JSONArray();
                for (int j2 = 0; j2 < qube[i]; ++j2) {
                    JSONArray range = new JSONArray();
                    range.put(0, binMin.value(j2, 0));
                    range.put(1, binMax.value(j2, 1));
                    ranges.put(j2, (Object)range);
                }
                jo.put("ranges", (Object)ranges);
            }
            binsArray.put(i - 1, (Object)jo);
        }
        return binsArray;
    }
}

