/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.RecentComboBox;
import org.autoplot.datasource.TimeRangeTool;
import org.autoplot.datasource.URISplit;
import org.autoplot.hapi.HapiCacheManager;
import org.autoplot.hapi.HapiDataSource;
import org.autoplot.hapi.HapiServer;
import org.autoplot.hapi.JSONArrayIterator;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.util.LoggerManager;
import org.das2.util.TickleTimer;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HapiDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = LoggerManager.getLogger("apdss.hapi");
    private JSONArray idsJSON;
    private URL defaultServer;
    private Datum myValidTime;
    private String currentParameters = null;
    private URL currentServer = null;
    private DatumRange currentRange = null;
    private String currentId = null;
    private String currentExtra = null;
    private int lastParamIndex = -1;
    private String providedTimeRange = null;
    TickleTimer resetVariableTimer = new TickleTimer(100L, new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            try {
                String s = (String)HapiDataSourceEditorPanel.this.idsList2.getSelectedValue();
                if (s != null) {
                    HapiDataSourceEditorPanel.this.resetVariable(new URL((String)HapiDataSourceEditorPanel.this.serversComboBox.getSelectedItem()), (String)HapiDataSourceEditorPanel.this.idsList2.getSelectedValue());
                } else {
                    HapiDataSourceEditorPanel.this.parametersPanel.removeAll();
                    HapiDataSourceEditorPanel.this.parametersPanel.add(new JLabel(" "));
                    HapiDataSourceEditorPanel.this.titleLabel.setText(" ");
                }
            }
            catch (MalformedURLException ex) {
                JOptionPane.showMessageDialog(HapiDataSourceEditorPanel.this.parametersPanel, ex.toString());
            }
        }
    });
    private JCheckBox binaryCB;
    private JButton cachedFileButton;
    private JButton clearAllB;
    private JButton clearButton;
    private JCheckBox disableCacheCheckBox;
    private JComboBox<String> exampleTimeRangesCB;
    private JButton extraInfoButton;
    private RecentComboBox filtersComboBox;
    private JList<String> idsList2;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane4;
    private JSplitPane jSplitPane1;
    private JLabel messagesLabel;
    private JPanel parametersPanel;
    private JComboBox<String> serversComboBox;
    private JButton setAllB;
    private RecentComboBox timeRangeComboBox;
    private JLabel titleLabel;
    private static final int MAX_LENGTH_CHARACTERS = 100000;

    private DatumRange getRange(JSONObject info) {
        try {
            if (info.has("firstDate") && info.has("lastDate")) {
                String firstDate = info.getString("firstDate");
                String lastDate = info.getString("lastDate");
                if (firstDate != null && lastDate != null) {
                    Datum t2;
                    Datum t1 = Units.us2000.parse(firstDate);
                    if (t1.le(t2 = Units.us2000.parse(lastDate))) {
                        return new DatumRange(t1, t2);
                    }
                    logger.warning("firstDate and lastDate are out of order, ignoring.");
                }
            } else if (info.has("startDate")) {
                String startDate = info.getString("startDate");
                String stopDate = info.has("stopDate") ? info.getString("stopDate") : null;
                if (startDate != null) {
                    Datum t2;
                    Datum t1 = Units.us2000.parse(startDate);
                    Datum datum = t2 = stopDate == null ? this.myValidTime : Units.us2000.parse(stopDate);
                    if (t1.le(t2)) {
                        return new DatumRange(t1, t2);
                    }
                    logger.warning("firstDate and lastDate are out of order, ignoring.");
                }
            }
        }
        catch (ParseException | JSONException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        return null;
    }

    public HapiDataSourceEditorPanel() {
        try {
            this.myValidTime = TimeUtil.create("2200-01-01T00:00");
        }
        catch (ParseException ex) {
            Logger.getLogger(HapiDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
        try {
            List<String> servers = HapiServer.getKnownServers();
            this.defaultServer = new URL(servers.get(servers.size() - 1));
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        this.initComponents();
        this.filtersComboBox.setPreferenceNode("hapi.filters");
        this.timeRangeComboBox.setPreferenceNode("timerange");
        this.jScrollPane4.getVerticalScrollBar().setUnitIncrement(this.parametersPanel.getFont().getSize());
        this.parametersPanel.setLayout(new BoxLayout(this.parametersPanel, 1));
        this.serversComboBox.setEnabled(false);
        this.serversComboBox.setModel(new DefaultComboBoxModel<String>(HapiServer.getKnownServersArray()));
        this.loadKnownServersSoon();
        this.idsList2.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (HapiDataSourceEditorPanel.this.idsList2.getSelectedValue() != null && !((String)HapiDataSourceEditorPanel.this.idsList2.getSelectedValue()).equals(HapiDataSourceEditorPanel.this.currentId)) {
                        HapiDataSourceEditorPanel.this.currentParameters = null;
                    }
                    if (HapiDataSourceEditorPanel.this.idsList2.getSelectedValue() != null) {
                        HapiDataSourceEditorPanel.this.currentId = (String)HapiDataSourceEditorPanel.this.idsList2.getSelectedValue();
                        if (HapiDataSourceEditorPanel.this.currentId.startsWith("Error:")) {
                            return;
                        }
                    }
                    if (HapiDataSourceEditorPanel.this.currentId != null) {
                        HapiDataSourceEditorPanel.this.titleLabel.setText("Retrieving info for " + HapiDataSourceEditorPanel.this.currentId + "...");
                    } else {
                        HapiDataSourceEditorPanel.this.titleLabel.setText(" ");
                    }
                    HapiDataSourceEditorPanel.this.parametersPanel.removeAll();
                    HapiDataSourceEditorPanel.this.parametersPanel.revalidate();
                    HapiDataSourceEditorPanel.this.parametersPanel.repaint();
                    HapiDataSourceEditorPanel.this.resetVariableTimer.tickle();
                }
            }
        });
        this.filtersComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                final String search = (String)HapiDataSourceEditorPanel.this.filtersComboBox.getEditor().getItem();
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        HapiDataSourceEditorPanel.this.resetServerCatalog(HapiDataSourceEditorPanel.this.currentServer, search);
                    }
                };
                new Thread(run, "resetServerCatalog").start();
            }
        });
    }

    public void loadKnownServersImmediately() {
        final String[] servers = HapiServer.listHapiServersArray();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                HapiDataSourceEditorPanel.this.serversComboBox.setModel(new DefaultComboBoxModel<String>(servers));
                try {
                    HapiDataSourceEditorPanel.this.defaultServer = new URL(servers[0]);
                }
                catch (MalformedURLException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                if (HapiDataSourceEditorPanel.this.currentServer != null) {
                    HapiDataSourceEditorPanel.this.serversComboBox.setSelectedItem(HapiDataSourceEditorPanel.this.currentServer.toString());
                } else {
                    HapiDataSourceEditorPanel.this.serversComboBox.setSelectedIndex(0);
                }
                HapiDataSourceEditorPanel.this.serversComboBox.setEnabled(true);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public void loadKnownServersSoon() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                HapiDataSourceEditorPanel.this.loadKnownServersImmediately();
            }
        };
        new Thread(run, "loadKnownServers").start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.serversComboBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jButton1 = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jScrollPane4 = new JScrollPane();
        this.parametersPanel = new JPanel();
        this.clearAllB = new JButton();
        this.setAllB = new JButton();
        this.extraInfoButton = new JButton();
        this.titleLabel = new JLabel();
        this.cachedFileButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.idsList2 = new JList();
        this.clearButton = new JButton();
        this.filtersComboBox = new RecentComboBox();
        this.messagesLabel = new JLabel();
        this.binaryCB = new JCheckBox();
        this.timeRangeComboBox = new RecentComboBox();
        this.exampleTimeRangesCB = new JComboBox();
        this.disableCacheCheckBox = new JCheckBox();
        this.jLabel1.setText("HAPI Server:");
        this.serversComboBox.setEditable(true);
        this.serversComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"http://tsds.org/get/IMAGE/PT1M/hapi", " "}));
        this.serversComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.serversComboBoxActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Time Range: ");
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/hapi/calendar.png")));
        this.jButton1.setToolTipText("Time Range Tool");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(210);
        this.parametersPanel.setMinimumSize(new Dimension(100, 0));
        GroupLayout parametersPanelLayout = new GroupLayout(this.parametersPanel);
        this.parametersPanel.setLayout(parametersPanelLayout);
        parametersPanelLayout.setHorizontalGroup(parametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 482, Short.MAX_VALUE));
        parametersPanelLayout.setVerticalGroup(parametersPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 195, Short.MAX_VALUE));
        this.jScrollPane4.setViewportView(this.parametersPanel);
        this.clearAllB.setText("Clear All");
        this.clearAllB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.clearAllBActionPerformed(evt);
            }
        });
        this.setAllB.setText("Set All");
        this.setAllB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.setAllBActionPerformed(evt);
            }
        });
        this.extraInfoButton.setText("Extra Info");
        this.extraInfoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.extraInfoButtonActionPerformed(evt);
            }
        });
        this.titleLabel.setText(" ");
        this.cachedFileButton.setText("Cached Files...");
        this.cachedFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.cachedFileButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane4, -1, 486, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.clearAllB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.setAllB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cachedFileButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.extraInfoButton)).addComponent(this.titleLabel, -1, -1, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.titleLabel, -2, 17, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 188, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearAllB).addComponent(this.setAllB).addComponent(this.extraInfoButton).addComponent(this.cachedFileButton))));
        this.jSplitPane1.setRightComponent(this.jPanel3);
        this.jScrollPane2.setVerticalScrollBarPolicy(22);
        this.jScrollPane2.setMinimumSize(new Dimension(100, 22));
        this.idsList2.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.idsList2);
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/hapi/clearTextButton.png")));
        this.clearButton.setToolTipText("clear search bar");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.filtersComboBox.setToolTipText("search bar");
        this.filtersComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HapiDataSourceEditorPanel.this.filtersComboBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.filtersComboBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearButton)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, -1, 183, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearButton).addComponent(this.filtersComboBox, -2, -1, -2)).addGap(0, 216, Short.MAX_VALUE)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.jScrollPane2, -1, 214, Short.MAX_VALUE))));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.messagesLabel.setText("(messages here)");
        this.binaryCB.setText("Use Binary");
        this.binaryCB.setToolTipText("Some servers support binary data transfers, and this will use binary to transfer data.");
        this.binaryCB.setEnabled(false);
        this.exampleTimeRangesCB.setModel(new DefaultComboBoxModel<String>(new String[]{"Example Time Ranges"}));
        this.exampleTimeRangesCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                HapiDataSourceEditorPanel.this.exampleTimeRangesCBItemStateChanged(evt);
            }
        });
        this.disableCacheCheckBox.setText("Disable Cache");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1, -1, 707, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.serversComboBox, 0, 1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeRangeComboBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exampleTimeRangesCB, -2, 224, -2)).addGroup(layout.createSequentialGroup().addComponent(this.messagesLabel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableCacheCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.binaryCB))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.serversComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messagesLabel).addComponent(this.binaryCB, -1, 25, Short.MAX_VALUE).addComponent(this.disableCacheCheckBox)).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.timeRangeComboBox, -2, -1, -2)).addComponent(this.jButton1).addComponent(this.exampleTimeRangesCB, -2, -1, -2)).addContainerGap()));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        TimeRangeTool tt = new TimeRangeTool();
        tt.setSelectedRange(this.timeRangeComboBox.getText());
        int r = JOptionPane.showConfirmDialog(this, tt, "Select Time Range", 2);
        if (r == 0) {
            this.timeRangeComboBox.setText(tt.getSelectedRange());
        }
    }

    private void serversComboBoxActionPerformed(ActionEvent evt) {
        try {
            final URL url = new URL((String)this.serversComboBox.getSelectedItem());
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        HapiDataSourceEditorPanel.this.resetServer(url);
                    }
                    catch (IOException | JSONException ex) {
                        logger.log(Level.SEVERE, null, ex);
                        DefaultListModel<String> m = new DefaultListModel<String>();
                        m.add(0, "Error: unable to connect");
                        HapiDataSourceEditorPanel.this.idsList2.setModel(m);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                HapiDataSourceEditorPanel.this.serversComboBox.setSelectedItem("http://datashop.elasticbeanstalk.com/hapi");
                            }
                        };
                    }
                }
            };
            new Thread(run, "resetServer").start();
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void clearAllBActionPerformed(ActionEvent evt) {
        boolean first = !this.currentServer.toString().contains("https://cdaweb.gsfc.nasa.gov/registry/hdp/hapi");
        for (Component c : this.parametersPanel.getComponents()) {
            if (!(c instanceof JCheckBox)) continue;
            if (first) {
                ((JCheckBox)c).setSelected(true);
                first = false;
                continue;
            }
            ((JCheckBox)c).setSelected(false);
        }
    }

    private void setAllBActionPerformed(ActionEvent evt) {
        for (Component c : this.parametersPanel.getComponents()) {
            if (!(c instanceof JCheckBox)) continue;
            ((JCheckBox)c).setSelected(true);
        }
    }

    private void extraInfoButtonActionPerformed(ActionEvent evt) {
        final JEditorPane jep = new JEditorPane();
        jep.setContentType("text/html");
        jep.setText(this.currentExtra);
        jep.setEditable(false);
        jep.setOpaque(false);
        jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    Desktop desktop = Desktop.getDesktop();
                    try {
                        desktop.browse(hle.getURL().toURI());
                    }
                    catch (IOException | URISyntaxException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
            }
        });
        final JScrollPane p = new JScrollPane(jep);
        p.setPreferredSize(new Dimension(800, 400));
        p.setMaximumSize(new Dimension(800, 400));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jep.setCaretPosition(0);
                p.getVerticalScrollBar().setValue(0);
            }
        });
        JOptionPane.showMessageDialog(this, p, "Extra Info", 1);
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        this.filtersComboBox.setSelectedItem("");
    }

    private void filtersComboBoxActionPerformed(ActionEvent evt) {
        final String filter = this.filtersComboBox.getSelectedItem().toString();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                HapiDataSourceEditorPanel.this.resetServerCatalog(HapiDataSourceEditorPanel.this.currentServer, filter);
            }
        };
        new Thread(run, "resetServerCatalog2").start();
    }

    private void exampleTimeRangesCBItemStateChanged(ItemEvent evt) {
        String s = (String)this.exampleTimeRangesCB.getSelectedItem();
        if (!s.startsWith("Example")) {
            this.timeRangeComboBox.setSelectedItem(s);
        }
    }

    private void cachedFileButtonActionPerformed(ActionEvent evt) {
        LinkedHashMap<String, DatumRange> ff;
        String[] params = this.getParameters(true).split(",");
        String str = (String)this.timeRangeComboBox.getSelectedItem();
        try {
            DatumRange tr = str == null ? this.currentRange : DatumRangeUtil.parseTimeRange(str);
            if (tr == null) {
                JOptionPane.showMessageDialog(this, "id doesn't provide range");
                return;
            }
            ff = HapiDataSource.getCacheFiles(this.currentServer, this.currentId, params, tr);
        }
        catch (ParseException ex) {
            JOptionPane.showMessageDialog(this, "Unable to parse timerange: " + str);
            return;
        }
        if (ff == null) {
            JOptionPane.showMessageDialog(this, "No cache files found in the interval");
            return;
        }
        File cacheFolder = HapiDataSource.cacheFolder(this.currentServer, "/data/" + this.currentId);
        HapiCacheManager mm = new HapiCacheManager();
        String[] ss = ff.keySet().toArray(new String[ff.size()]);
        mm.setFiles(cacheFolder, ss);
        if (JOptionPane.showConfirmDialog(this, mm, "Manage Cached Data", 2) == 0) {
            System.err.println("cacheFolder: " + cacheFolder);
            for (String s : ff.keySet()) {
                File f1 = new File(cacheFolder, s);
                if (f1.delete()) continue;
                logger.log(Level.INFO, "unable to delete {0}", f1);
            }
        }
    }

    @Override
    public boolean reject(String uri) throws Exception {
        return false;
    }

    @Override
    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        URISplit split = URISplit.parse(uri);
        if (split.file == null || split.file.equals("file:///")) {
            split.file = this.defaultServer.toString();
        }
        try {
            this.idsJSON = HapiServer.getCatalog(new URL(split.file));
        }
        catch (IOException ex) {
            this.messagesLabel.setText("Unable to connect to server");
        }
        return true;
    }

    private void setParameters(String parameters) {
        for (Component c : this.parametersPanel.getComponents()) {
            if (!(c instanceof JCheckBox)) continue;
            ((JCheckBox)c).setSelected(false);
        }
        if (parameters.length() > 0) {
            String[] ss = parameters.split(",");
            for (Component c : this.parametersPanel.getComponents()) {
                if (!(c instanceof JCheckBox)) continue;
                String name = ((JCheckBox)c).getName();
                ((JCheckBox)c).setSelected(false);
                for (String s : ss) {
                    if (!s.equals(name)) continue;
                    ((JCheckBox)c).setSelected(true);
                }
            }
        } else {
            for (Component c : this.parametersPanel.getComponents()) {
                if (!(c instanceof JCheckBox)) continue;
                ((JCheckBox)c).setSelected(true);
            }
        }
    }

    private String getParameters(boolean enumerate) {
        StringBuilder b = new StringBuilder();
        boolean areAllTrue = true;
        for (Component c : this.parametersPanel.getComponents()) {
            if (!(c instanceof JCheckBox)) continue;
            if (((JCheckBox)c).isSelected()) {
                b.append(",").append(c.getName());
                continue;
            }
            areAllTrue = false;
        }
        if (areAllTrue && !enumerate) {
            return "";
        }
        return b.substring(1);
    }

    @Override
    public void setURI(String uri) {
        String timerange;
        URISplit split = URISplit.parse(uri);
        if (split.file == null || split.file.equals("file:///")) {
            split.file = this.defaultServer.toString();
        } else {
            try {
                this.currentServer = new URL(split.file);
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        this.serversComboBox.setSelectedItem(split.file);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        String id = (String)params.get("id");
        if (id != null) {
            try {
                id = URLDecoder.decode(id, "UTF-8");
                this.idsList2.setSelectedValue(id, true);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
            this.currentId = id;
        }
        if ((timerange = (String)params.get("timerange")) != null) {
            this.timeRangeComboBox.setText(timerange);
        }
        this.providedTimeRange = timerange;
        String parameters = (String)params.get("parameters");
        if (parameters != null) {
            this.currentParameters = parameters;
            this.setParameters(this.currentParameters);
        }
        if ("binary".equals(params.get("format"))) {
            this.binaryCB.setSelected(true);
        } else {
            this.binaryCB.setSelected(false);
        }
        if (!HapiServer.useCache()) {
            this.cachedFileButton.setVisible(false);
            this.disableCacheCheckBox.setVisible(false);
        }
        this.disableCacheCheckBox.setSelected("F".equals(params.get("cache")));
    }

    @Override
    public void markProblems(List<String> problems) {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getURI() {
        String parameters = this.getParameters(false);
        String id = this.idsList2.getSelectedValue();
        if (id == null) {
            id = "";
        } else {
            try {
                id = URLEncoder.encode(id, "UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException(ex);
            }
        }
        String uri = "vap+hapi:" + this.serversComboBox.getSelectedItem().toString() + "?id=" + id + "&timerange=" + this.timeRangeComboBox.getText().replaceAll(" ", "+");
        if (this.binaryCB.isSelected() && this.binaryCB.isEnabled()) {
            uri = uri + "&format=binary";
        }
        if (this.disableCacheCheckBox.isSelected()) {
            uri = uri + "&cache=F";
        }
        if (parameters.length() > 0) {
            return uri + "&parameters=" + parameters;
        }
        return uri;
    }

    private void resetServerCatalog(URL server, String filter) {
        try {
            DefaultListModel<String> model = new DefaultListModel<String>();
            int maxCharacters = 0;
            for (JSONObject catalogEntry : new JSONArrayIterator(this.idsJSON)) {
                if (filter.length() > 0) {
                    Pattern p = Pattern.compile(filter, 2);
                    String id = catalogEntry.getString("id");
                    String title = null;
                    if (catalogEntry.has("title")) {
                        title = catalogEntry.getString("title");
                    }
                    if (!p.matcher(id).find() && (title == null || !p.matcher(title).find())) continue;
                    model.addElement(catalogEntry.getString("id"));
                    maxCharacters = Math.max(catalogEntry.getString("id").length(), maxCharacters);
                    continue;
                }
                model.addElement(catalogEntry.getString("id"));
                maxCharacters = Math.max(catalogEntry.getString("id").length(), maxCharacters);
            }
            this.idsList2.setModel(model);
            int maxLenPixels = maxCharacters * 8;
            maxLenPixels = Math.min(maxLenPixels, 600);
            maxLenPixels = Math.max(maxLenPixels, 300);
            this.jSplitPane1.setDividerLocation(maxLenPixels);
            if (!String.valueOf(server).equals(String.valueOf(this.currentServer))) {
                this.idsList2.setSelectedIndex(0);
                this.currentServer = server;
                this.idsList2.ensureIndexIsVisible(0);
            } else if (this.currentId != null) {
                this.idsList2.setSelectedValue(this.currentId, true);
            } else {
                int i = this.idsList2.getSelectedIndex();
                this.idsList2.ensureIndexIsVisible(i == -1 ? 0 : i);
            }
            boolean binaryIsEnabled = false;
            try {
                JSONObject capabilitiesDoc = HapiServer.getCapabilities(server);
                if (capabilitiesDoc.has("outputFormats")) {
                    JSONArray outputFormats = capabilitiesDoc.getJSONArray("outputFormats");
                    for (int i = 0; i < outputFormats.length(); ++i) {
                        if (!outputFormats.getString(i).equals("binary")) continue;
                        binaryIsEnabled = true;
                    }
                } else {
                    JSONArray capabilities = capabilitiesDoc.getJSONArray("capabilities");
                    for (int i = 0; i < capabilities.length(); ++i) {
                        JSONObject c = capabilities.getJSONObject(i);
                        if (!c.has("formats")) continue;
                        JSONArray formats = c.getJSONArray("formats");
                        for (int j = 0; j < formats.length(); ++j) {
                            if (!formats.getString(j).equals("binary")) continue;
                            binaryIsEnabled = true;
                        }
                    }
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            this.binaryCB.setEnabled(binaryIsEnabled);
        }
        catch (JSONException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private void resetServer(URL server) throws IOException, JSONException {
        this.idsJSON = HapiServer.getCatalog(server);
        this.resetServerCatalog(server, "");
    }

    private String getHtmlFor(Object o) throws JSONException {
        StringBuilder s = new StringBuilder();
        if (o instanceof JSONArray) {
            JSONArray joa = (JSONArray)o;
            for (int i = 0; i < joa.length(); ++i) {
                s.append(this.getHtmlFor(joa.get(i))).append("<br>");
            }
        } else if (o instanceof JSONObject) {
            JSONObject jo = (JSONObject)o;
            s.append("<table>");
            Iterator iter = jo.keys();
            while (iter.hasNext()) {
                String k = iter.next().toString();
                Object v = jo.get(k);
                String sv = this.getHtmlFor(v);
                s.append("<tr valign=top><td>").append(k).append("</td><td>").append(sv).append("</td></tr>");
            }
            s.append("</table>");
        } else if (o instanceof String) {
            Pattern p;
            String so = String.valueOf(o);
            if (so.startsWith("spase:")) {
                so = "<a href=\"http://spase.info/registry/render?id=" + so + "\">" + so + "</a>";
            } else if (so.startsWith("http://") || so.startsWith("https://") || so.startsWith("ftp://")) {
                so = "<a href=\"" + so + "\">" + so + "</a>";
            } else if (so.startsWith("doi:") || so.startsWith("DOI:")) {
                so = "<a href=\"https://doi.org/" + so.substring(4) + "\">" + so + "</a>";
            } else if (so.startsWith("10.") && so.length() > 7 && (p = Pattern.compile("(10[.][0-9]{3,}[^\\s\"/<>]*/[^\\s\"<>]+)")).matcher(so).matches()) {
                so = "<a href=\"https://doi.org/" + so + "\">" + so + "</a>";
            }
            s.append(so);
        } else {
            s.append(o.toString());
        }
        return s.toString();
    }

    private static Datum cadenceArrayToDatum(int[] array) {
        double seconds = (double)array[6] / 1.0E9;
        seconds += (double)array[5];
        seconds += (double)(array[4] * 60);
        seconds += (double)(array[3] * 3600);
        seconds += (double)(array[2] * 86400);
        seconds += (double)(array[1] * 86400 * 30);
        return Units.seconds.createDatum(seconds += (double)(array[0] * 86400 * 365));
    }

    public static String getDurationForHumans(long milliseconds) {
        if (milliseconds < 2000L) {
            return milliseconds + " milliseconds";
        }
        if (milliseconds < 120000L) {
            return String.format(Locale.US, "%.1f", (double)milliseconds / 1000.0) + " seconds";
        }
        if (milliseconds < 0x6DDD00L) {
            return String.format(Locale.US, "%.1f", (double)milliseconds / 60000.0) + " minutes";
        }
        if (milliseconds < 172800000L) {
            return String.format(Locale.US, "%.1f", (double)milliseconds / 3600000.0) + " hours";
        }
        double ddays = (double)milliseconds / 8.64E7;
        if (ddays < 48.0) {
            return String.format(Locale.US, "%.1f", ddays) + " days";
        }
        if (ddays < 400.0) {
            return String.format(Locale.US, "%.1f", ddays / 7.0) + " weeks";
        }
        return String.format(Locale.US, "%.1f", ddays / 365.0) + " years";
    }

    private void resetVariable(URL server, String id) {
        block32: {
            try {
                DatumRange range;
                JSONObject info = HapiServer.getInfo(server, id);
                for (JSONObject item : new JSONArrayIterator(this.idsJSON)) {
                    if (!item.getString("id").equals(id)) continue;
                    if (item.has("title")) {
                        String title = item.getString("title");
                        this.titleLabel.setText(title);
                        this.titleLabel.setToolTipText(title);
                        this.titleLabel.setMinimumSize(new Dimension(100, this.titleLabel.getFont().getSize()));
                        continue;
                    }
                    this.titleLabel.setText(id);
                }
                JSONArray parameters = info.getJSONArray("parameters");
                StringBuilder extra = new StringBuilder();
                extra.append("<html><table>");
                Iterator iter = info.keys();
                while (iter.hasNext()) {
                    String k = iter.next().toString();
                    Object v = info.get(k);
                    extra.append("<tr valign=top><td>").append(k).append("</td><td>");
                    String s = this.getHtmlFor(v);
                    if (v.toString().length() > 100000) {
                        extra.append("<i>(").append(v.toString().length()).append(" characters)</i>");
                    } else {
                        extra.append(s);
                    }
                    extra.append("</td></tr>");
                }
                extra.append("</table></html>");
                this.currentExtra = extra.toString();
                this.parametersPanel.removeAll();
                String[] sparams = new String[parameters.length()];
                for (int i = 0; i < parameters.length(); ++i) {
                    JSONObject parameter = parameters.getJSONObject(i);
                    sparams[i] = parameter.getString("name");
                    JCheckBox cb = new JCheckBox(sparams[i]);
                    String label = sparams[i];
                    if (parameter.has("size")) {
                        label = label + parameter.getString("size");
                    }
                    cb.setName(sparams[i]);
                    cb.setSelected(true);
                    final int fi = i;
                    cb.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if ((e.getModifiers() & 1) == 1 && HapiDataSourceEditorPanel.this.lastParamIndex > -1) {
                                if (HapiDataSourceEditorPanel.this.lastParamIndex < fi) {
                                    for (int i = HapiDataSourceEditorPanel.this.lastParamIndex; i <= fi; ++i) {
                                        ((JCheckBox)HapiDataSourceEditorPanel.this.parametersPanel.getComponent(i)).setSelected(true);
                                    }
                                } else {
                                    for (int i = fi; i <= HapiDataSourceEditorPanel.this.lastParamIndex; ++i) {
                                        ((JCheckBox)HapiDataSourceEditorPanel.this.parametersPanel.getComponent(i)).setSelected(true);
                                    }
                                }
                            }
                            HapiDataSourceEditorPanel.this.lastParamIndex = fi;
                        }
                    });
                    if (parameter.has("description")) {
                        String d = parameter.getString("description");
                        cb.setToolTipText(d);
                        cb.setText(label + ": " + d);
                    } else {
                        cb.setText(label);
                    }
                    this.parametersPanel.add(cb);
                }
                this.parametersPanel.setToolTipText("shift-click will select range of parameters");
                this.parametersPanel.revalidate();
                this.parametersPanel.repaint();
                if (this.currentParameters != null) {
                    this.setParameters(this.currentParameters);
                }
                if ((range = this.getRange(info)) == null) {
                    logger.warning("server is missing required startDate and stopDate parameters.");
                    this.messagesLabel.setText("range is not provided (non-compliant server)");
                    break block32;
                }
                DatumRange sampleRange = null;
                if (info.has("sampleStartDate") && info.has("sampleStopDate")) {
                    try {
                        sampleRange = new DatumRange(Units.us2000.parse(info.getString("sampleStartDate")), Units.us2000.parse(info.getString("sampleStopDate")));
                    }
                    catch (ParseException | JSONException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                if (sampleRange == null) {
                    Datum cadence = Units.seconds.createDatum(60);
                    if (info.has("cadence")) {
                        try {
                            int[] icadence = DatumRangeUtil.parseISO8601Duration(info.getString("cadence"));
                            cadence = HapiDataSourceEditorPanel.cadenceArrayToDatum(icadence);
                        }
                        catch (ParseException ex) {
                            logger.log(Level.WARNING, "parse error in cadence: {0}", info.getString("cadence"));
                        }
                    }
                    if (range.max().ge(this.myValidTime)) {
                        logger.warning("server is missing required stopDate parameter.");
                        this.messagesLabel.setText(range.min().toString() + " to ?");
                        sampleRange = new DatumRange(range.min(), range.min().add(1.0, Units.days));
                    } else {
                        Datum end;
                        this.messagesLabel.setText(range.toString());
                        if (cadence.ge(Units.days.createDatum(1))) {
                            end = TimeUtil.nextMidnight(range.max());
                            end = end.subtract(10.0, Units.days);
                            sampleRange = range.max().subtract(end).ge(Datum.create(1, Units.days)) ? new DatumRange(end, end.add(10.0, Units.days)) : new DatumRange(end.subtract(10.0, Units.days), end);
                        } else if (cadence.ge(Units.seconds.createDatum(1))) {
                            end = TimeUtil.prevMidnight(range.max());
                            sampleRange = range.max().subtract(end).ge(Datum.create(1, Units.hours)) ? new DatumRange(end, end.add(1.0, Units.days)) : new DatumRange(end.subtract(1.0, Units.days), end);
                        } else {
                            end = TimeUtil.prev(4, range.max());
                            sampleRange = range.max().subtract(end).ge(Datum.create(1, Units.minutes)) ? new DatumRange(end, end.add(1.0, Units.hours)) : new DatumRange(end.subtract(1.0, Units.hours), end);
                        }
                        if (!sampleRange.intersects(range)) {
                            sampleRange = sampleRange.next();
                        }
                    }
                } else {
                    String s = range.toString();
                    if (info.has("modificationDate")) {
                        try {
                            Datum tmod = Units.us2000.parse(info.getString("modificationDate"));
                            Datum ago = TimeUtil.now().subtract(tmod);
                            s = s + "   last modified " + HapiDataSourceEditorPanel.getDurationForHumans((long)ago.doubleValue(Units.milliseconds)) + " ago.";
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    this.messagesLabel.setText(s);
                }
                DefaultComboBoxModel<String> m = new DefaultComboBoxModel<String>(new String[]{"Example Time Ranges", sampleRange.toString()});
                this.exampleTimeRangesCB.setModel(m);
                if (this.providedTimeRange == null) {
                    this.timeRangeComboBox.setText(sampleRange.toString());
                }
            }
            catch (IOException | JSONException ex) {
                logger.log(Level.SEVERE, null, ex);
                this.parametersPanel.removeAll();
                this.parametersPanel.add(new JLabel("Error reported on server:"));
                String s = ex.getMessage();
                this.parametersPanel.add(new JLabel(s));
                JLabel space = new JLabel(" ");
                this.parametersPanel.add(space);
                final URL url = HapiServer.createURL(server, "info", Collections.singletonMap("id", id));
                JButton l = new JButton("Load URL in Browser");
                l.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            Desktop.getDesktop().browse(url.toURI());
                        }
                        catch (IOException | URISyntaxException ex1) {
                            logger.log(Level.SEVERE, null, ex1);
                        }
                    }
                });
                this.parametersPanel.add(l);
                this.titleLabel.setText("");
            }
        }
    }

    public static void main(String[] args) {
        JOptionPane.showConfirmDialog(null, new HapiDataSourceEditorPanel());
    }
}

