/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.hapi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DefaultTimeSeriesBrowse;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Caching;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.hapi.AbstractLineReader;
import org.autoplot.hapi.ConcatenateBufferedReader;
import org.autoplot.hapi.HapiServer;
import org.autoplot.hapi.PasteBufferedReader;
import org.autoplot.hapi.SingleFileBufferedReader;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.CacheTag;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.fsm.FileStorageModel;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SparseDataSetBuilder;
import org.das2.qds.WritableDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.qstream.TransferType;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.filesystem.HttpUtil;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class HapiDataSource
extends AbstractDataSource {
    protected static final Logger logger = LoggerManager.getLogger("apdss.hapi");
    protected static final Logger loggerUrl = LoggerManager.getLogger("das2.url");
    TimeSeriesBrowse tsb = new DefaultTimeSeriesBrowse();
    public static final double FILL_VALUE = -1.0E38;
    private static final Map<String, Datum> lastRecordFound = new HashMap<String, Datum>();
    private static final Map<String, ArrayList<String>> cache = new HashMap<String, ArrayList<String>>();

    public HapiDataSource(URI uri) {
        super(uri);
        String str = (String)this.params.get("timerange");
        if (str != null) {
            try {
                this.tsb.setURI(uri.toString());
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.addCapability(TimeSeriesBrowse.class, this.tsb);
        this.addCapability(Caching.class, new Caching(){

            @Override
            public boolean satisfies(String surl) {
                return false;
            }

            @Override
            public void resetURI(String surl) {
            }

            @Override
            public void reset() {
                cache.clear();
            }
        });
    }

    private static QDataSet getJSONBins(JSONObject binsObject) throws JSONException {
        Object uo;
        JSONArray bins = null;
        if (binsObject.has("values")) {
            logger.fine("using deprecated bins");
            bins = binsObject.getJSONArray("values");
        } else if (binsObject.has("centers")) {
            bins = binsObject.getJSONArray("centers");
        }
        JSONArray ranges = null;
        if (binsObject.has("ranges")) {
            ranges = binsObject.getJSONArray("ranges");
        }
        if (ranges == null && bins == null) {
            throw new IllegalArgumentException("ranges or centers must be specified");
        }
        int len = ranges == null ? bins.length() : ranges.length();
        DDataSet result = DDataSet.createRank1(len);
        DDataSet max = DDataSet.createRank1(len);
        DDataSet min = DDataSet.createRank1(len);
        boolean hasMin = false;
        boolean hasMax = false;
        boolean hasCenter = false;
        if (len == 0) {
            throw new IllegalArgumentException("bins must have ranges or centers specified");
        }
        if (bins != null) {
            int j;
            hasCenter = true;
            Object o = bins.get(0);
            if (o instanceof Number) {
                for (j = 0; j < len; ++j) {
                    result.putValue(j, bins.getDouble(j));
                }
            } else if (o instanceof JSONObject) {
                for (j = 0; j < len; ++j) {
                    JSONObject jo = bins.getJSONObject(j);
                    result.putValue(j, jo.getDouble("center"));
                    if (hasMin || jo.has("min")) {
                        hasMin = true;
                        min.putValue(j, jo.getDouble("min"));
                    }
                    if (!hasMax && !jo.has("max")) continue;
                    hasMax = true;
                    max.putValue(j, jo.getDouble("max"));
                }
            }
        }
        if (ranges != null) {
            for (int j = 0; j < len; ++j) {
                JSONArray ja1 = ranges.getJSONArray(j);
                hasMax = true;
                hasMin = true;
                min.putValue(j, ja1.getDouble(0));
                max.putValue(j, ja1.getDouble(1));
            }
        }
        if (binsObject.has("units") && (uo = binsObject.get("units")) instanceof String) {
            String sunits = (String)uo;
            Units u = Units.lookupUnits(sunits);
            result.putProperty("UNITS", u);
            if (hasMin && hasMax) {
                min.putProperty("UNITS", u);
                max.putProperty("UNITS", u);
            }
        }
        if (hasCenter) {
            if (hasMin && hasMax) {
                result.putProperty("BIN_MIN", min);
                result.putProperty("BIN_MAX", max);
            } else if (hasMin || hasMax) {
                logger.warning("need both min and max for bins.");
            }
        } else {
            result = (DDataSet)ArrayDataSet.copy(Double.TYPE, Ops.bundle(min, max));
            result.putProperty("BINS_1", "min,max");
        }
        if (binsObject.has("name")) {
            result.putProperty("NAME", binsObject.getString("name"));
        }
        if (binsObject.has("description")) {
            result.putProperty("TITLE", binsObject.getString("description"));
            result.putProperty("LABEL", binsObject.getString("description"));
        }
        return result;
    }

    private JSONObject getInfo() throws MalformedURLException, IOException, JSONException {
        URI server = this.resourceURI;
        String id = this.getParam("id", "");
        if (id.equals("")) {
            throw new IllegalArgumentException("missing id");
        }
        id = URLDecoder.decode(id, "UTF-8");
        return HapiServer.getInfo(server.toURL(), id);
    }

    private static String[] cacheFilesFor(URL url, ParamDescription[] pp, Datum xx) {
        String s = AutoplotSettings.settings().resolveProperty("fscache");
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        StringBuilder ub = new StringBuilder(url.getProtocol() + "/" + url.getHost() + "/" + url.getPath());
        if (url.getQuery() != null) {
            String[] querys = url.getQuery().split("\\&");
            Pattern p = Pattern.compile("id=(.+)");
            for (String q : querys) {
                Matcher m = p.matcher(q);
                if (!m.matches()) continue;
                ub.append("/").append(m.group(1));
                break;
            }
        } else {
            throw new IllegalArgumentException("query must be specified, implementation error");
        }
        TimeParser tp = TimeParser.create("$Y/$m/$Y$m$d");
        String sxx = tp.format(xx);
        String u = ub.toString();
        String[] result = new String[pp.length];
        for (int i = 0; i < pp.length; ++i) {
            result[i] = s + "/" + u + "/" + sxx + "." + pp[0].name + ".csv";
        }
        return result;
    }

    private static void writeToCachedData(URL url, ParamDescription[] pp, Datum xx, String[] ss) throws IOException {
        String f;
        File ff;
        String s = AutoplotSettings.settings().resolveProperty("fscache");
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        StringBuilder ub = new StringBuilder(url.getProtocol() + "/" + url.getHost() + url.getPath());
        if (url.getQuery() != null) {
            String[] querys = url.getQuery().split("\\&");
            Pattern p = Pattern.compile("id=(.+)");
            for (String q : querys) {
                Matcher m = p.matcher(q);
                if (!m.matches()) continue;
                ub.append("/").append(m.group(1));
                break;
            }
        } else {
            throw new IllegalArgumentException("query must be specified, implementation error");
        }
        TimeParser tp = TimeParser.create("$Y/$m/$Y$m$d");
        String sxx = tp.format(xx);
        String u = ub.toString();
        Datum t0 = lastRecordFound.get(u + "/" + sxx);
        if (t0 == null && (ff = new File(f = s + "/" + u + "/" + sxx + "." + pp[0].name + ".csv")).exists()) {
            BufferedReader read = new BufferedReader(new FileReader(ff));
            String line = read.readLine();
            String lastLine = null;
            while (line != null) {
                lastLine = line;
                line = read.readLine();
            }
            if (lastLine != null) {
                try {
                    t0 = Units.us2000.parse(lastLine);
                    lastRecordFound.put(u + "/" + sxx, t0);
                }
                catch (ParseException ex) {
                    t0 = null;
                }
            } else {
                t0 = null;
            }
        }
        if (t0 != null && t0.ge(xx)) {
            logger.log(Level.FINE, "clear all cached files for {0}", sxx);
            for (ParamDescription pp1 : pp) {
                String f2 = s + "/hapi/" + u + "/" + sxx + "." + pp1.name + ".csv";
                File ff2 = new File(f2);
                if (!ff2.exists() || ff2.delete()) continue;
                logger.log(Level.INFO, "unable to delete file: {0}", ff2);
            }
        }
        int ifield = 0;
        for (ParamDescription pp1 : pp) {
            String f3 = u + "/" + sxx + "." + pp1.name + ".csv." + Thread.currentThread().getId();
            ArrayList<String> sparam = cache.get(f3);
            if (sparam == null) {
                sparam = new ArrayList();
                cache.put(f3, sparam);
            }
            StringBuilder build = new StringBuilder();
            int length = pp1.nFields;
            for (int k = 0; k < length; ++k) {
                if (k > 0) {
                    build.append(",");
                }
                build.append(ss[ifield++]);
            }
            sparam.add(build.toString());
        }
        lastRecordFound.put(u + "/" + sxx, xx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void writeToCachedDataFinish(URL url, ParamDescription[] pp, Datum xx) throws IOException {
        String s = AutoplotSettings.settings().resolveProperty("fscache");
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        StringBuilder ub = new StringBuilder(url.getProtocol() + "/" + url.getHost() + url.getPath());
        if (url.getQuery() == null) throw new IllegalArgumentException("query must be specified, implementation error");
        String[] querys = url.getQuery().split("\\&");
        Pattern p = Pattern.compile("id=(.+)");
        for (String q : querys) {
            Matcher m = p.matcher(q);
            if (!m.matches()) continue;
            ub.append("/").append(m.group(1));
            break;
        }
        long currentTimeMillis = pp[0].modifiedDateMillis;
        TimeParser tp = TimeParser.create("$Y/$m/$Y$m$d");
        String sxx = tp.format(xx);
        String u = ub.toString();
        ParamDescription[] paramDescriptionArray = pp;
        int n = paramDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            ParamDescription pp1 = paramDescriptionArray[n2];
            String f = u + "/" + sxx + "." + pp1.name + ".csv." + Thread.currentThread().getId();
            ArrayList<String> sparam = cache.remove(f);
            File ff = new File(s + "/hapi/" + u + "/" + sxx + "." + pp1.name + ".csv.gz");
            if (!ff.getParentFile().exists() && !ff.getParentFile().mkdirs()) {
                throw new IOException("unable to mkdirs " + ff.getParent());
            }
            File ffTemp = new File(s + "/hapi/" + u + "/" + sxx + "." + pp1.name + ".csv.gz." + Thread.currentThread().getId());
            try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(ff))));){
                if (sparam != null) {
                    for (String s123 : sparam) {
                        w.write(s123);
                        w.newLine();
                    }
                }
            }
            Class<HapiDataSource> clazz = HapiDataSource.class;
            // MONITORENTER : org.autoplot.hapi.HapiDataSource.class
            ffTemp.renameTo(ff);
            if (currentTimeMillis > 0L) {
                ff.setLastModified(currentTimeMillis);
            }
            // MONITOREXIT : clazz
            ++n2;
        }
    }

    private QDataSet getDataSetCDAWeb(ProgressMonitor monitor) throws Exception {
        JSONObject o;
        URI server = this.resourceURI;
        String id = this.getParam("id", "");
        if (id.equals("")) {
            throw new IllegalArgumentException("missing id");
        }
        id = URLDecoder.decode(id, "UTF-8");
        String pp = this.getParam("parameters", "");
        if (!pp.equals("") && !pp.startsWith("Epoch,")) {
            pp = "Epoch," + pp;
        }
        if (id.equals("")) {
            throw new IllegalArgumentException("missing id");
        }
        id = URLDecoder.decode(id, "UTF-8");
        DatumRange tr = this.tsb.getTimeRange();
        URL url = HapiServer.getDataURL(server.toURL(), id, tr, pp);
        url = new URL(url.toString() + "&include=header&format=json1");
        monitor.started();
        monitor.setProgressMessage("server is preparing data");
        long t0 = System.currentTimeMillis() - 100L;
        int lineNum = 0;
        StringBuilder builder = new StringBuilder();
        logger.log(Level.FINE, "getDocument {0}", url.toString());
        loggerUrl.log(Level.FINE, "GET {0}", new Object[]{url});
        HttpURLConnection httpConnect = (HttpURLConnection)url.openConnection();
        httpConnect.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        httpConnect.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
        httpConnect = (HttpURLConnection)HttpUtil.checkRedirect(httpConnect);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(httpConnect.getInputStream()));){
            String line = in.readLine();
            ++lineNum;
            while (line != null) {
                if (System.currentTimeMillis() - t0 > 100L) {
                    monitor.setProgressMessage("reading line " + lineNum);
                    t0 = System.currentTimeMillis();
                }
                builder.append(line);
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileSystemUtil.copyStream(httpConnect.getErrorStream(), baos, new NullProgressMonitor());
            String s = baos.toString("UTF-8");
            if (s.contains("No data available")) {
                logger.log(Level.FINE, "No data available, server responded with {0}: {1}", new Object[]{httpConnect.getResponseCode(), httpConnect.getResponseMessage()});
                throw new NoDataInIntervalException("No data available");
            }
            if (s.length() < 256) {
                throw new IOException(ex.getMessage() + ": " + s);
            }
            throw ex;
        }
        httpConnect.disconnect();
        JSONObject doc = o = new JSONObject(builder.toString());
        ParamDescription[] pds = this.getParameterDescriptions(doc);
        monitor.setProgressMessage("parsing data");
        int[] nfields = new int[pds.length];
        for (int i = 0; i < pds.length; ++i) {
            nfields[i] = pds[i].size.length == 0 || pds[i].size.length == 1 && pds[i].size[0] == 1 ? 1 : DataSetUtil.product(pds[i].size);
        }
        boolean[] timeVary = new boolean[pds.length];
        QDataSet result = null;
        int ipd = 0;
        for (ParamDescription pd : pds) {
            JSONArray param;
            try {
                param = doc.getJSONArray(pd.name);
            }
            catch (JSONException ex) {
                timeVary[ipd] = false;
                continue;
            }
            timeVary[ipd] = true;
            Units u = pd.units;
            if (nfields[ipd] > 1) {
                int nf = nfields[ipd];
                DDataSet column = DDataSet.createRank2(param.length(), nfields[ipd]);
                for (int i = 0; i < param.length(); ++i) {
                    JSONObject jo = param.getJSONObject(i);
                    JSONArray joa = jo.getJSONArray("elements");
                    for (int j = 0; j < nf; ++j) {
                        column.putValue(i, j, u.parse(joa.getString(j)).doubleValue(u));
                    }
                }
                if (pd.hasFill) {
                    column.putProperty("FILL_VALUE", pd.fillValue);
                }
                column.putProperty("TITLE", pd.description);
                column.putProperty("UNITS", pd.units);
                for (int j = 0; j < nf; ++j) {
                    result = Ops.bundle(result, Ops.slice1((QDataSet)column, j));
                }
            } else {
                DDataSet column = DDataSet.createRank1(param.length());
                for (int i = 0; i < param.length(); ++i) {
                    column.putValue(i, u.parse(param.getString(i)).doubleValue(u));
                }
                if (pd.hasFill) {
                    column.putProperty("FILL_VALUE", pd.fillValue);
                }
                column.putProperty("TITLE", pd.description);
                column.putProperty("UNITS", pd.units);
                result = Ops.bundle(result, column);
            }
            ++ipd;
        }
        monitor.finished();
        int ntimeVary = 0;
        for (boolean b : timeVary) {
            if (!b) continue;
            ++ntimeVary;
        }
        ParamDescription[] newPds = new ParamDescription[ntimeVary];
        int k = 0;
        for (int j = 0; j < pds.length; ++j) {
            if (!timeVary[j]) continue;
            newPds[k++] = pds[j];
        }
        int[] sort = null;
        result = this.repackage(result, newPds, sort);
        return result;
    }

    @Override
    public synchronized QDataSet getDataSet(ProgressMonitor monitor) throws Exception {
        QDataSet ds;
        URI server = this.resourceURI;
        String format = this.getParam("format", "csv");
        String serverStr = server.toString();
        if (format.equals("json1") || serverStr.startsWith("http://cdaweb") && serverStr.endsWith("gsfc.nasa.gov/registry/hdp/hapi")) {
            return this.getDataSetCDAWeb(monitor);
        }
        monitor.setTaskSize(100L);
        monitor.started();
        monitor.setProgressMessage("reading info");
        String id = this.getParam("id", "");
        if (id.equals("")) {
            throw new IllegalArgumentException("missing id");
        }
        id = URLDecoder.decode(id, "UTF-8");
        String pp = this.getParam("parameters", "");
        JSONObject info = this.getInfo();
        monitor.setProgressMessage("got info");
        monitor.setTaskProgress(20L);
        ParamDescription[] pds = this.getParameterDescriptions(info);
        DatumRange tr = this.tsb.getTimeRange();
        Datum cadence = null;
        if (info.has("cadence")) {
            try {
                int[] ii = DatumRangeUtil.parseISO8601Duration(info.getString("cadence"));
                Datum t = TimeUtil.toDatumDuration(ii);
                tr = new DatumRange(tr.min().subtract(t), tr.max().add(t));
                cadence = t;
            }
            catch (ParseException ex) {
                logger.log(Level.WARNING, "unable to parse cadence as ISO8601 duration: {0}", info.getString("cadence"));
            }
        }
        String timeStampLocation = "CENTER";
        if (info.has("timeStampLocation")) {
            timeStampLocation = info.getString("timeStampLocation");
        }
        JSONArray parametersArray = info.getJSONArray("parameters");
        int nparam = parametersArray.length();
        if (pp.length() > 0) {
            String[] pps = pp.split(",");
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (int i = 0; i < nparam; ++i) {
                map.put(parametersArray.getJSONObject(i).getString("name"), i);
            }
            if (!pps[0].equals(parametersArray.getJSONObject(0).getString("name"))) {
                throw new IllegalArgumentException("first parameter must be \"" + parametersArray.getJSONObject(0).getString("name") + "\"");
            }
            nparam = pps.length;
            ParamDescription[] subsetPds = new ParamDescription[pps.length];
            for (int ip = 0; ip < pps.length; ++ip) {
                int i = (Integer)map.get(pps[ip]);
                subsetPds[ip] = pds[i];
            }
            pds = subsetPds;
        }
        URL url = HapiServer.getDataURL(server.toURL(), id, tr, pp);
        if (!format.equals("csv")) {
            url = new URL(url + "&format=" + format);
        }
        logger.log(Level.FINE, "getDataSet {0}", url.toString());
        int[] nfields = new int[nparam];
        for (int i = 0; i < nparam; ++i) {
            nfields[i] = pds[i].size.length == 0 || pds[i].size.length == 1 && pds[i].size[0] == 1 ? 1 : DataSetUtil.product(pds[i].size);
        }
        int totalFields = DataSetUtil.sum(nfields);
        switch (format) {
            case "binary": {
                ds = this.getDataSetViaBinary(totalFields, monitor, url, pds, tr, nparam, nfields);
                break;
            }
            case "json": {
                ds = this.getDataSetViaJSON(totalFields, monitor, url, pds, tr, nparam, nfields);
                break;
            }
            default: {
                ds = this.getDataSetViaCsv(totalFields, monitor, url, pds, tr, nparam, nfields);
            }
        }
        if (ds.length() == 0) {
            monitor.finished();
            throw new NoDataInIntervalException("no records found");
        }
        QDataSet xds = (QDataSet)(ds = this.repackage(ds, pds, null)).property("DEPEND_0");
        if (xds == null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(ds))) {
            xds = ds;
        }
        if (timeStampLocation.equals("BEGIN") || timeStampLocation.equals("END")) {
            if (cadence == null) {
                cadence = DataSetUtil.asDatum(DataSetUtil.guessCadenceNew(xds, null));
            }
            if (cadence != null) {
                if (timeStampLocation.equals("BEGIN")) {
                    xds = Ops.add((Object)xds, cadence.divide(2.0));
                } else if (timeStampLocation.equals("END")) {
                    xds = Ops.subtract((Object)xds, cadence.divide(2.0));
                }
            } else {
                logger.info("timetags are identified as BEGIN, but cadence was not available to center the data");
            }
        }
        if (xds != null) {
            ((MutablePropertyDataSet)xds).putProperty("CACHE_TAG", new CacheTag(tr, null));
        }
        monitor.setTaskProgress(100L);
        monitor.finished();
        return ds;
    }

    private QDataSet getDataSetViaCsv(int totalFields, ProgressMonitor monitor, URL url, ParamDescription[] pds, DatumRange tr, int nparam, int[] nfields) throws IllegalArgumentException, Exception, IOException {
        HttpURLConnection httpConnect;
        AbstractLineReader cacheReader;
        DataSetBuilder builder = new DataSetBuilder(2, 100, totalFields);
        monitor.setProgressMessage("reading data");
        monitor.setTaskProgress(20L);
        long t0 = System.currentTimeMillis() - 100L;
        boolean useCache = HapiServer.useCache();
        String cacheParam = this.getParam("cache", "");
        if (cacheParam.equals("F")) {
            useCache = false;
        }
        if (useCache) {
            Datum minMidnight = TimeUtil.prevMidnight(tr.min());
            Datum maxMidnight = TimeUtil.nextMidnight(tr.max());
            tr = new DatumRange(minMidnight, maxMidnight);
            URISplit split = URISplit.parse(url.toURI());
            LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
            params.put("time.min", minMidnight.toString());
            params.put("time.max", maxMidnight.toString());
            split.params = URISplit.formatParams(params);
            String surl = URISplit.format(split);
            url = new URL(surl);
        }
        if (useCache) {
            String[] parameters = new String[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                parameters[i] = pds[i].name;
            }
            cacheReader = HapiDataSource.getCacheReader(url, parameters, tr, FileSystem.settings().isOffline(), 0L);
            if (cacheReader != null) {
                logger.fine("reading from cache");
            }
        } else {
            cacheReader = null;
        }
        if (cacheReader == null) {
            if (FileSystem.settings().isOffline()) {
                throw new NoDataInIntervalException("HAPI server is offline.");
            }
            loggerUrl.log(Level.FINE, "GET {0}", new Object[]{url});
            httpConnect = (HttpURLConnection)url.openConnection();
            httpConnect.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
            httpConnect.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
            httpConnect.setRequestProperty("Accept-Encoding", "gzip");
            httpConnect = (HttpURLConnection)HttpUtil.checkRedirect(httpConnect);
            httpConnect.connect();
        } else {
            httpConnect = null;
        }
        Datum midnight = TimeUtil.prevMidnight(tr.min());
        DatumRange currentDay = new DatumRange(midnight, TimeUtil.next(3, midnight));
        boolean completeDay = tr.contains(currentDay);
        boolean gzip = cacheReader == null ? "gzip".equals(httpConnect.getContentEncoding()) : false;
        int linenumber = 0;
        try (AbstractLineReader in = cacheReader != null ? cacheReader : new SingleFileBufferedReader(new BufferedReader(new InputStreamReader(gzip ? new GZIPInputStream(httpConnect.getInputStream()) : httpConnect.getInputStream())));){
            String line = in.readLine();
            while (line != null) {
                Datum xx;
                int ifield;
                String[] ss;
                block50: {
                    ++linenumber;
                    ss = this.lineSplit(line);
                    if (ss.length != totalFields) {
                        if (line.trim().length() == 0) {
                            logger.log(Level.WARNING, "expected {0} fields, got empty line at line {1}", new Object[]{totalFields, linenumber});
                            line = in.readLine();
                            continue;
                        }
                        logger.log(Level.WARNING, "expected {0} fields, got {1} at line {2}", new Object[]{totalFields, ss.length, linenumber});
                        throw new IllegalArgumentException(String.format("expected %d fields, got %d at line {2}", totalFields, ss.length, linenumber));
                    }
                    ifield = 0;
                    try {
                        xx = pds[ifield].units.parse(ss[ifield]);
                        if (System.currentTimeMillis() - t0 <= 100L) break block50;
                        monitor.setProgressMessage("reading " + xx);
                        t0 = System.currentTimeMillis();
                        double d = DatumRangeUtil.normalize(tr, xx);
                        monitor.setTaskProgress(20 + (int)(75.0 * d));
                        if (monitor.isCancelled()) {
                            throw new CancelledOperationException("cancel was pressed");
                        }
                    }
                    catch (ParseException ex) {
                        line = in.readLine();
                        continue;
                    }
                }
                if (cacheReader == null && useCache && !currentDay.contains(xx) && tr.intersects(currentDay) && completeDay) {
                    if (pds[0].modifiedDateMillis == 0L || currentDay.middle().doubleValue(Units.ms1970) - (double)pds[0].modifiedDateMillis <= 0.0) {
                        HapiDataSource.writeToCachedDataFinish(url, pds, currentDay.middle());
                    } else {
                        logger.fine("data after modification date is not cached.");
                    }
                }
                while (!currentDay.contains(xx) && tr.intersects(currentDay)) {
                    currentDay = currentDay.next();
                    completeDay = tr.contains(currentDay);
                    if (cacheReader != null || !useCache || currentDay.contains(xx) || !tr.intersects(currentDay) || pds[0].modifiedDateMillis != 0L && !(currentDay.middle().doubleValue(Units.ms1970) - (double)pds[0].modifiedDateMillis <= 0.0)) continue;
                    HapiDataSource.writeToCachedDataFinish(url, pds, currentDay.middle());
                }
                if (!currentDay.contains(xx)) {
                    logger.fine("something's gone wrong, perhaps out-of-order timetags.");
                    completeDay = false;
                }
                if (completeDay && cacheReader == null && useCache && (pds[0].modifiedDateMillis == 0L || xx.doubleValue(Units.ms1970) - (double)pds[0].modifiedDateMillis <= 0.0)) {
                    HapiDataSource.writeToCachedData(url, pds, xx, ss);
                }
                builder.putValue(-1, ifield, xx);
                ++ifield;
                for (int i = 1; i < nparam; ++i) {
                    for (int j = 0; j < nfields[i]; ++j) {
                        try {
                            String s = ss[ifield];
                            if (pds[i].units instanceof EnumerationUnits) {
                                builder.putValue(-1, ifield, ((EnumerationUnits)pds[i].units).createDatum(s).doubleValue(pds[i].units));
                            } else {
                                builder.putValue(-1, ifield, pds[i].units.parse(s));
                            }
                        }
                        catch (ParseException ex) {
                            builder.putValue(-1, ifield, pds[i].fillValue);
                            pds[i].hasFill = true;
                        }
                        ++ifield;
                    }
                }
                builder.nextRecord();
                line = in.readLine();
            }
            while (completeDay && tr.intersects(currentDay)) {
                if (cacheReader == null && useCache && tr.intersects(currentDay) && currentDay.middle().doubleValue(Units.ms1970) - (double)pds[0].modifiedDateMillis <= 0.0) {
                    HapiDataSource.writeToCachedDataFinish(url, pds, currentDay.middle());
                }
                currentDay = currentDay.next();
                completeDay = tr.contains(currentDay);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            monitor.finished();
            if (httpConnect != null) {
                throw new IOException(String.valueOf(httpConnect.getResponseCode()) + ": " + httpConnect.getResponseMessage());
            }
            throw e;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            monitor.finished();
            throw e;
        }
        finally {
            if (httpConnect != null) {
                httpConnect.disconnect();
            }
        }
        if (cacheReader != null) {
            HashMap<String, String> cacheFiles = new HashMap<String, String>();
            cacheFiles.put("cached", "true");
            builder.putProperty("USER_PROPERTIES", cacheFiles);
        }
        monitor.setTaskProgress(95L);
        DDataSet ds = builder.getDataSet();
        return ds;
    }

    private QDataSet getDataSetViaBinary(int totalFields, ProgressMonitor monitor, URL url, ParamDescription[] pds, DatumRange tr, int nparam, int[] nfields) throws IllegalArgumentException, Exception, IOException {
        DataSetBuilder builder = new DataSetBuilder(2, 100, totalFields);
        monitor.setProgressMessage("reading data");
        monitor.setTaskProgress(20L);
        long t0 = System.currentTimeMillis() - 100L;
        loggerUrl.log(Level.FINE, "GET {0}", new Object[]{url});
        HttpURLConnection httpConnect = (HttpURLConnection)url.openConnection();
        httpConnect.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        httpConnect.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
        httpConnect.setRequestProperty("Accept-Encoding", "gzip");
        httpConnect.connect();
        boolean gzip = "gzip".equals(httpConnect.getContentEncoding());
        int recordLengthBytes = 0;
        TransferType[] tts = new TransferType[pds.length];
        for (int i = 0; i < pds.length; ++i) {
            if (pds[i].type.startsWith("time")) {
                recordLengthBytes += Integer.parseInt(pds[i].type.substring(4));
                tts[i] = TransferType.getForName(pds[i].type, Collections.singletonMap("UNITS", pds[i].units));
            } else if (pds[i].type.startsWith("string")) {
                recordLengthBytes += pds[i].length;
                final Units u = pds[i].units;
                final int length = pds[i].length;
                final byte[] bytes = new byte[length];
                tts[i] = new TransferType(){

                    @Override
                    public void write(double d, ByteBuffer buffer) {
                    }

                    @Override
                    public double read(ByteBuffer buffer) {
                        buffer.get(bytes);
                        String s = new String(bytes);
                        Datum d = ((EnumerationUnits)u).createDatum(s);
                        return d.doubleValue(u);
                    }

                    @Override
                    public int sizeBytes() {
                        return length;
                    }

                    @Override
                    public boolean isAscii() {
                        return false;
                    }

                    @Override
                    public String name() {
                        return "string" + length;
                    }
                };
            } else {
                String type = pds[i].type;
                recordLengthBytes += BufferDataSet.byteCount(type) * DataSetUtil.product(pds[i].size);
                tts[i] = TransferType.getForName(type.toString(), Collections.singletonMap("UNITS", pds[i].units));
            }
            if (tts[i] != null) continue;
            throw new IllegalArgumentException("unable to identify transfer type for \"" + pds[i].type + "\"");
        }
        totalFields = DataSetUtil.sum(nfields);
        double[] result = new double[totalFields];
        try (InputStream in = gzip ? new GZIPInputStream(httpConnect.getInputStream()) : httpConnect.getInputStream();){
            ByteBuffer buf = TransferType.allocate(recordLengthBytes, ByteOrder.LITTLE_ENDIAN);
            byte[] bytes = buf.array();
            int bytesRead = in.read(bytes);
            while (bytesRead != -1) {
                while (bytesRead < recordLengthBytes) {
                    int b = in.read(bytes, bytesRead, recordLengthBytes - bytesRead);
                    if (b == -1) {
                        throw new InterruptedIOException("expected " + recordLengthBytes + " bytes to complete a record");
                    }
                    bytesRead += b;
                }
                int ifield = 0;
                for (int i = 0; i < pds.length; ++i) {
                    for (int j = 0; j < nfields[i]; ++j) {
                        result[ifield] = tts[i].read(buf);
                        ++ifield;
                    }
                }
                if (ifield != totalFields) {
                    logger.log(Level.WARNING, "expected {0} got {1}", new Object[]{totalFields, ifield});
                }
                ifield = 0;
                Datum xx = pds[0].units.createDatum(result[0]);
                if (System.currentTimeMillis() - t0 > 100L) {
                    monitor.setProgressMessage("reading " + xx);
                    t0 = System.currentTimeMillis();
                    double d = DatumRangeUtil.normalize(tr, xx);
                    monitor.setTaskProgress(20 + (int)(75.0 * d));
                }
                builder.putValue(-1, ifield, xx);
                ++ifield;
                for (int i = 1; i < nparam; ++i) {
                    for (int j = 0; j < nfields[i]; ++j) {
                        builder.putValue(-1, ifield, result[ifield]);
                        ++ifield;
                    }
                }
                builder.nextRecord();
                buf.flip();
                bytesRead = in.read(bytes);
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            monitor.finished();
            throw new IOException(String.valueOf(httpConnect.getResponseCode()) + ":" + httpConnect.getResponseMessage());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
            monitor.finished();
            throw e;
        }
        finally {
            httpConnect.disconnect();
        }
        monitor.setTaskProgress(95L);
        DDataSet ds = builder.getDataSet();
        return ds;
    }

    private QDataSet getDataSetViaJSON(int totalFields, ProgressMonitor monitor, URL url, ParamDescription[] pds, DatumRange tr, int nparam, int[] nfields) throws IllegalArgumentException, Exception, IOException {
        monitor.started();
        monitor.setProgressMessage("server is preparing data");
        long t0 = System.currentTimeMillis() - 100L;
        int lineNum = 0;
        StringBuilder builder = new StringBuilder();
        logger.log(Level.FINE, "getDocument {0}", url.toString());
        loggerUrl.log(Level.FINE, "GET {0}", new Object[]{url});
        HttpURLConnection httpConnect = (HttpURLConnection)url.openConnection();
        httpConnect.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        httpConnect.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
        httpConnect = (HttpURLConnection)HttpUtil.checkRedirect(httpConnect);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(httpConnect.getInputStream()));){
            String line = in.readLine();
            ++lineNum;
            while (line != null) {
                if (System.currentTimeMillis() - t0 > 100L) {
                    monitor.setProgressMessage("reading line " + lineNum);
                    t0 = System.currentTimeMillis();
                }
                builder.append(line);
                line = in.readLine();
            }
        }
        catch (IOException ex) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            FileSystemUtil.copyStream(httpConnect.getErrorStream(), baos, new NullProgressMonitor());
            String s = baos.toString("UTF-8");
            if (s.contains("No data available")) {
                logger.log(Level.FINE, "No data available, server responded with {0}: {1}", new Object[]{httpConnect.getResponseCode(), httpConnect.getResponseMessage()});
                throw new NoDataInIntervalException("No data available");
            }
            if (s.length() < 256) {
                throw new IOException(ex.getMessage() + ": " + s);
            }
            throw ex;
        }
        httpConnect.disconnect();
        monitor.setProgressMessage("parsing data");
        JSONObject jo = new JSONObject(builder.toString());
        JSONArray data = jo.getJSONArray("data");
        DataSetBuilder build = new DataSetBuilder(2, data.length(), totalFields);
        for (int i = 0; i < data.length(); ++i) {
            int ipd = 0;
            int ifield = 0;
            JSONArray record = data.getJSONArray(i);
            for (ParamDescription pd : pds) {
                Units u = pd.units;
                if (nfields[ipd] > 1) {
                    JSONArray fields = record.getJSONArray(ipd);
                    int nf = nfields[ipd];
                    int lastField = nf + ifield;
                    while (ifield < lastField) {
                        build.putValue(-1, ifield, pd.units.parse(fields.getString(ipd)));
                        ++ifield;
                    }
                } else {
                    build.putValue(-1, ifield, pd.units.parse(record.getString(ipd)));
                }
                ifield += nfields[ipd];
                ++ipd;
            }
            build.nextRecord();
        }
        DDataSet result = build.getDataSet();
        return result;
    }

    private String[] lineSplit(String line) {
        String[] ss = line.split(",", -2);
        for (int i = 0; i < ss.length; ++i) {
            String s = ss[i].trim();
            if (s.startsWith("\"") && s.endsWith("\"")) {
                s = s.substring(1, s.length() - 1);
            }
            ss[i] = s;
        }
        return ss;
    }

    public static File cacheFolder(URL url, String id) {
        String cache = AutoplotSettings.settings().resolveProperty("fscache");
        if (cache.endsWith("/")) {
            cache = cache.substring(0, cache.length() - 1);
        }
        String dsroot = cache + "/hapi/" + url.getProtocol() + "/" + url.getHost() + "/" + url.getPath() + "/" + id;
        return new File(dsroot);
    }

    public static LinkedHashMap<String, DatumRange> getCacheFiles(URL url, String id, String[] parameters, DatumRange timeRange) {
        String s = AutoplotSettings.settings().resolveProperty("fscache");
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        String u = url.getProtocol() + "/" + url.getHost() + "/" + url.getPath();
        u = u + "/data/" + id;
        LinkedHashMap<String, DatumRange> result = new LinkedHashMap<String, DatumRange>();
        try {
            for (String parameter : parameters) {
                String[] ff;
                String theFile = s + "/hapi/" + u;
                FileStorageModel fsm = FileStorageModel.create(FileSystem.create("file:" + theFile), "$Y/$m/$Y$m$d." + parameter + ".csv.gz");
                for (String ff1 : ff = fsm.getNamesFor(null)) {
                    DatumRange tr1 = fsm.getRangeFor(ff1);
                    if (timeRange != null && !timeRange.intersects(tr1)) continue;
                    result.put(ff1, tr1);
                }
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            logger.log(Level.FINE, "exception in cache", ex);
            return null;
        }
        return result;
    }

    private static AbstractLineReader calculateCacheReader(File[][] files) {
        ConcatenateBufferedReader cacheReader = new ConcatenateBufferedReader();
        for (int i = 0; i < files.length; ++i) {
            boolean haveAllForDay = true;
            if (!haveAllForDay) continue;
            PasteBufferedReader r1 = new PasteBufferedReader();
            r1.setDelim(',');
            for (int j = 0; j < files[i].length; ++j) {
                try {
                    FileReader oneDayOneParam = new FileReader(files[i][j]);
                    r1.pasteBufferedReader(new SingleFileBufferedReader(new BufferedReader(oneDayOneParam)));
                    continue;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    return null;
                }
            }
            cacheReader.concatenateBufferedReader(r1);
        }
        return cacheReader;
    }

    public static AbstractLineReader maybeGetCacheReader(URL url, File[][] files, long lastModified) throws IOException {
        if (FileSystem.settings().isOffline()) {
            return null;
        }
        loggerUrl.log(Level.FINE, "GET {0}", new Object[]{url});
        HttpURLConnection httpConnect = (HttpURLConnection)url.openConnection();
        httpConnect.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
        httpConnect.setReadTimeout(FileSystem.settings().getReadTimeoutMs());
        httpConnect.setRequestProperty("Accept-Encoding", "gzip");
        String s = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss z").format(new Date(lastModified));
        httpConnect.setRequestProperty("If-Modified-Since", s);
        httpConnect = (HttpURLConnection)HttpUtil.checkRedirect(httpConnect);
        httpConnect.connect();
        if (httpConnect.getResponseCode() == 304) {
            logger.fine("using cache files because server says nothing has changed (304)");
            return HapiDataSource.calculateCacheReader(files);
        }
        boolean gzip = "gzip".equals(httpConnect.getContentEncoding());
        return new SingleFileBufferedReader(new BufferedReader(new InputStreamReader(gzip ? new GZIPInputStream(httpConnect.getInputStream()) : httpConnect.getInputStream())));
    }

    public static AbstractLineReader getCacheReader(URL url, String[] parameters, DatumRange timeRange, boolean offline, long lastModified) {
        String s = AutoplotSettings.settings().resolveProperty("fscache");
        if (s.endsWith("/")) {
            s = s.substring(0, s.length() - 1);
        }
        StringBuilder ub = new StringBuilder(url.getProtocol() + "/" + url.getHost() + "/" + url.getPath());
        if (url.getQuery() != null) {
            String[] querys = url.getQuery().split("\\&");
            Pattern p = Pattern.compile("id=(.+)");
            for (String q : querys) {
                Matcher m = p.matcher(q);
                if (!m.matches()) continue;
                ub.append("/").append(m.group(1));
                break;
            }
        } else {
            throw new IllegalArgumentException("query must be specified, implementation error");
        }
        DatumRange aday = TimeUtil.dayContaining(timeRange.min());
        List<DatumRange> trs = DatumRangeUtil.generateList(timeRange, aday);
        long timeNow = System.currentTimeMillis();
        boolean[][] hits = new boolean[trs.size()][parameters.length];
        File[][] files = new File[trs.size()][parameters.length];
        boolean staleCacheFiles = false;
        String u = ub.toString();
        if (!new File(s + "/hapi/" + u).exists()) {
            return null;
        }
        try {
            for (int i = 0; i < trs.size(); ++i) {
                DatumRange tr = trs.get(i);
                for (int j = 0; j < parameters.length; ++j) {
                    boolean isStale;
                    String parameter = parameters[j];
                    FileStorageModel fsm = FileStorageModel.create(FileSystem.create("file:" + s + "/hapi/" + u), "$Y/$m/$Y$m$d." + parameter + ".csv");
                    File[] ff = fsm.getFilesFor(tr);
                    if (ff.length == 0) {
                        FileStorageModel fsmgz = FileStorageModel.create(FileSystem.create("file:" + s + "/hapi/" + u), "$Y/$m/$Y$m$d." + parameter + ".csv.gz");
                        ff = fsmgz.getFilesFor(tr);
                    }
                    if (ff.length > 1) {
                        throw new IllegalArgumentException("implementation error, should get just one file per day.");
                    }
                    if (ff.length == 0) {
                        hits[i][j] = false;
                        continue;
                    }
                    File f = ff[0];
                    long ageMillis = timeNow - f.lastModified();
                    boolean bl = isStale = ageMillis > HapiServer.cacheAgeLimitMillis();
                    if (lastModified > 0L) {
                        boolean bl2 = isStale = f.lastModified() < lastModified;
                        if (!isStale) {
                            logger.fine("server lastModified indicates the cache file can be used");
                        } else {
                            logger.fine("server lastModified indicates the cache file should be updated");
                        }
                    }
                    if (offline || !isStale) {
                        hits[i][j] = true;
                        files[i][j] = f;
                        continue;
                    }
                    logger.log(Level.FINE, "cached file is too old to use: {0}", f);
                    hits[i][j] = false;
                    staleCacheFiles = true;
                }
            }
        }
        catch (IOException | IllegalArgumentException ex) {
            logger.log(Level.FINE, "exception in cache", ex);
            return null;
        }
        if (staleCacheFiles && !offline) {
            logger.fine("old cache files found, but new data is available and accessible");
            return null;
        }
        boolean haveSomething = false;
        boolean haveAll = true;
        for (int i = 0; i < trs.size(); ++i) {
            for (int j = 0; j < parameters.length; ++j) {
                if (hits[i][j]) continue;
                haveAll = false;
            }
            if (!haveAll) continue;
            haveSomething = true;
        }
        if (!offline && !haveAll) {
            logger.fine("some cache files missing, but we are on-line and should retrieve all of them");
            return null;
        }
        if (!haveSomething) {
            logger.fine("no cached data found");
            return null;
        }
        long timeStamp = Long.MAX_VALUE;
        for (int i = 0; i < trs.size(); ++i) {
            for (int j = 0; j < parameters.length; ++j) {
                timeStamp = Math.min(timeStamp, files[i][j].lastModified());
            }
        }
        try {
            AbstractLineReader result = HapiDataSource.maybeGetCacheReader(url, files, timeStamp);
            if (result != null) {
                return result;
            }
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, null, ex);
        }
        AbstractLineReader cacheReader = HapiDataSource.calculateCacheReader(files);
        return cacheReader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ParamDescription[] getParameterDescriptions(JSONObject doc) throws IllegalArgumentException, ParseException, JSONException {
        JSONArray parameters = doc.getJSONArray("parameters");
        int nparameters = parameters.length();
        long modificationDate = 0L;
        if (doc.has("modificationDate")) {
            String s = doc.getString("modificationDate");
            Datum d = Units.ms1970.parse(s);
            modificationDate = (long)d.doubleValue(Units.ms1970);
        }
        ParamDescription[] pds = new ParamDescription[nparameters];
        for (int i = 0; i < nparameters; ++i) {
            int n;
            int j;
            JSONArray ja;
            String type;
            JSONObject jsonObjecti = parameters.getJSONObject(i);
            String name = jsonObjecti.getString("name");
            if (name == null) {
                name = "name" + i;
                logger.log(Level.WARNING, "name not found for {0}th parameter", i);
            }
            pds[i] = new ParamDescription(name);
            pds[i].modifiedDateMillis = modificationDate;
            if (jsonObjecti.has("type")) {
                type = jsonObjecti.getString("type");
                if (type == null) {
                    type = "";
                }
            } else {
                type = "";
            }
            if (type.equals("")) {
                logger.log(Level.FINE, "type is not defined: {0}", name);
            }
            if (type.equalsIgnoreCase("isotime")) {
                if (!type.equals("isotime")) {
                    logger.log(Level.WARNING, "isotime should not be capitalized: {0}", type);
                }
                pds[i].units = Units.us2000;
                if (jsonObjecti.has("length")) {
                    pds[i].type = "time" + jsonObjecti.getInt("length");
                    pds[i].length = jsonObjecti.getInt("length");
                    continue;
                }
                logger.log(Level.FINE, "server doesn''t report length for \"{0}\", assuming 24 characters, and that it doesn''t matter", name);
                pds[i].type = "time24";
                continue;
            }
            pds[i].type = type;
            if (jsonObjecti.has("units")) {
                Object ou = jsonObjecti.get("units");
                if (ou instanceof String) {
                    String sunits = (String)ou;
                    pds[i].units = Units.lookupUnits(sunits);
                }
            } else {
                pds[i].units = Units.dimensionless;
            }
            if (type.equals("String")) {
                type = "string";
                logger.warning("String used for type instead of string (lower case)");
            }
            if (type.equals("string")) {
                pds[i].units = EnumerationUnits.create(name);
            }
            if (jsonObjecti.has("fill")) {
                String sfill = jsonObjecti.getString("fill");
                if (sfill != null && !sfill.equals("null")) {
                    if (type.equals("string")) {
                        pds[i].fillValue = ((EnumerationUnits)pds[i].units).createDatum(sfill).doubleValue(pds[i].units);
                        pds[i].hasFill = true;
                    } else {
                        pds[i].fillValue = pds[i].units.parse(sfill).doubleValue(pds[i].units);
                        pds[i].hasFill = true;
                    }
                }
            } else {
                pds[i].fillValue = -1.0E38;
            }
            if (jsonObjecti.has("description")) {
                pds[i].description = jsonObjecti.getString("description");
                if (pds[i].description == null) {
                    pds[i].description = "";
                }
            } else {
                pds[i].description = "";
            }
            if (jsonObjecti.has("label")) {
                Object olabel = jsonObjecti.get("label");
                if (olabel instanceof String) {
                    pds[i].label = (String)olabel;
                }
                if (pds[i].label == null) {
                    pds[i].label = name;
                }
            } else {
                pds[i].label = name;
            }
            if (jsonObjecti.has("length")) {
                pds[i].length = jsonObjecti.getInt("length");
            }
            if (!jsonObjecti.has("size")) continue;
            Object o = jsonObjecti.get("size");
            if (!(o instanceof JSONArray)) {
                if (o.getClass() == Integer.class) {
                    pds[i].size = new int[]{(Integer)o};
                    pds[i].nFields = (Integer)o;
                    logger.log(Level.WARNING, "size should be an int array, found int: {0}", name);
                } else {
                    if (o.getClass() != String.class) throw new IllegalArgumentException(String.format("size should be an int array: %s", name));
                    pds[i].size = new int[]{Integer.parseInt((String)o)};
                    pds[i].nFields = (Integer)o;
                    logger.log(Level.WARNING, "size should be an int array, found String: {0}", name);
                }
            } else {
                JSONArray a = (JSONArray)o;
                pds[i].size = new int[a.length()];
                int nFields = 1;
                for (int j2 = 0; j2 < a.length(); ++j2) {
                    pds[i].size[j2] = a.getInt(j2);
                    nFields *= pds[i].size[j2];
                }
                pds[i].nFields = nFields;
            }
            if (jsonObjecti.has("bins")) {
                int n2;
                o = jsonObjecti.get("bins");
                if (o instanceof JSONArray) {
                    ja = (JSONArray)o;
                    pds[i].depend = new QDataSet[ja.length()];
                    pds[i].dependName = new String[ja.length()];
                    for (j = 0; j < ja.length(); ++j) {
                        JSONObject bins = ja.getJSONObject(j);
                        if (bins.has("parameter")) {
                            n = pds[i].nFields;
                            pds[i].depend[j] = Ops.findgen(n);
                            pds[i].dependName[j] = bins.getString("parameter");
                            continue;
                        }
                        if (bins.has("ranges")) {
                            QDataSet dep;
                            pds[i].depend[j] = dep = HapiDataSource.getJSONBins(ja.getJSONObject(j));
                            pds[i].renderType = "nnSpectrogram";
                            continue;
                        }
                        if (bins.has("centers")) {
                            QDataSet dep;
                            pds[i].depend[j] = dep = HapiDataSource.getJSONBins(ja.getJSONObject(j));
                            continue;
                        }
                        n = pds[i].size[j];
                        pds[i].depend[j] = Ops.findgen(n);
                    }
                    continue;
                }
                logger.warning("bins should be an array");
                JSONObject bins = jsonObjecti.getJSONObject("bins");
                if (pds[i].depend == null) {
                    pds[i].depend = new QDataSet[1];
                }
                if (pds[i].dependName == null) {
                    pds[i].dependName = new String[1];
                }
                if (bins.has("parameter")) {
                    n2 = DataSetUtil.product(pds[i].size);
                    pds[i].depend[0] = Ops.findgen(n2);
                    pds[i].dependName[0] = bins.getString("parameter");
                    continue;
                }
                if (bins.has("values")) {
                    QDataSet dep1;
                    pds[i].depend[0] = dep1 = HapiDataSource.getJSONBins(bins);
                    continue;
                }
                n2 = DataSetUtil.product(pds[i].size);
                pds[i].depend[0] = Ops.findgen(n2);
                continue;
            }
            if (!jsonObjecti.has("binsParameter") || !((o = jsonObjecti.get("binsParameter")) instanceof JSONArray)) continue;
            ja = (JSONArray)o;
            pds[i].depend = new QDataSet[ja.length()];
            pds[i].dependName = new String[ja.length()];
            for (j = 0; j < ja.length(); ++j) {
                String s = ja.getString(j);
                n = DataSetUtil.product(pds[i].size);
                pds[i].depend[j] = Ops.findgen(n);
                pds[i].dependName[j] = s;
            }
        }
        return pds;
    }

    private QDataSet repackage(QDataSet ds, ParamDescription[] pds, int[] sort) {
        int nparameters = ds.length(0);
        boolean combineRank2Depend1 = pds.length == 3 && pds[1].dependName != null;
        WritableDataSet depend0 = Ops.copy(Ops.slice1(ds, 0));
        if (ds.length(0) == 2) {
            ds = Ops.copy(Ops.slice1(ds, 1));
            ds = Ops.putProperty(ds, "DEPEND_0", (Object)depend0);
            ds = Ops.putProperty(ds, "NAME", (Object)Ops.safeName(pds[1].name));
            ds = Ops.putProperty(ds, "LABEL", (Object)pds[1].label);
            ds = Ops.putProperty(ds, "TITLE", (Object)pds[1].description);
            ds = Ops.putProperty(ds, "UNITS", (Object)pds[1].units);
            if (pds[1].hasFill) {
                ds = Ops.putProperty(ds, "FILL_VALUE", (Object)pds[1].fillValue);
            }
        } else if (pds.length == 2) {
            ds = Ops.copy(Ops.trim1(ds, 1, ds.length(0)));
            if (pds[1].size.length > 1) {
                ds = Ops.reform(ds, ds.length(), pds[1].size);
            }
            ds = Ops.putProperty(ds, "DEPEND_0", (Object)depend0);
            ds = Ops.putProperty(ds, "NAME", (Object)Ops.safeName(pds[1].name));
            ds = Ops.putProperty(ds, "LABEL", (Object)pds[1].label);
            ds = Ops.putProperty(ds, "TITLE", (Object)pds[1].description);
            ds = Ops.putProperty(ds, "UNITS", (Object)pds[1].units);
            if (pds[1].hasFill) {
                ds = Ops.putProperty(ds, "FILL_VALUE", (Object)pds[1].fillValue);
            }
            if (pds[1].depend != null) {
                for (int j = 0; j < pds[1].size.length; ++j) {
                    ds = Ops.putProperty(ds, "DEPEND_" + (j + 1), (Object)pds[1].depend[j]);
                }
            }
            if (pds.length == 2 && "nnSpectrogram".equals(pds[1].renderType)) {
                ds = Ops.putProperty(ds, "RENDER_TYPE", (Object)pds[1].renderType);
            }
        } else {
            if (pds.length == 1) {
                return depend0;
            }
            if (combineRank2Depend1) {
                SparseDataSetBuilder[] sdsbs = new SparseDataSetBuilder[pds.length];
                int ifield = 1;
                int length1 = ds.length(0);
                for (int i = 1; i < pds.length; ++i) {
                    int j;
                    int startIndex;
                    int nfields1 = pds[i].nFields;
                    SparseDataSetBuilder sdsb = new SparseDataSetBuilder(2);
                    sdsb.setLength(nfields1);
                    int n = startIndex = sort == null ? ifield - 1 : sort[ifield] - 1;
                    if (nfields1 > 1) {
                        sdsb.putProperty("ELEMENT_NAME", startIndex, Ops.safeName(pds[i].name));
                        sdsb.putProperty("ELEMENT_LABEL", startIndex, pds[i].name);
                        for (j = 0; j < pds[i].size.length; ++j) {
                            sdsb.putValue(startIndex, j, pds[i].size[j]);
                        }
                        if (pds[i].depend != null) {
                            if (pds[i].size.length != pds[i].depend.length) {
                                throw new IllegalArgumentException("pds[i].size.length!=pds[i].depend.length");
                            }
                            for (j = 0; j < pds[i].size.length; ++j) {
                                if (pds[i].dependName[j] != null) continue;
                                sdsb.putProperty("DEPEND_" + (j + 1), startIndex, pds[i].depend[j]);
                            }
                        }
                    }
                    for (j = 0; j < nfields1; ++j) {
                        if (nfields1 > 1) {
                            sdsb.putProperty("START_INDEX", startIndex + j, startIndex);
                            sdsb.putProperty("LABEL", startIndex + j, pds[i].name + " ch" + j);
                            sdsb.putProperty("NAME", startIndex + j, Ops.safeName(pds[i].name) + "_" + j);
                        } else {
                            sdsb.putProperty("LABEL", startIndex + j, pds[i].name);
                            sdsb.putProperty("NAME", startIndex + j, Ops.safeName(pds[i].name));
                        }
                        sdsb.putProperty("TITLE", startIndex + j, pds[i].description);
                        sdsb.putProperty("UNITS", startIndex + j, pds[i].units);
                        if (pds[i].hasFill) {
                            sdsb.putProperty("FILL_VALUE", startIndex + j, pds[i].fillValue);
                        }
                        if (nfields1 > 1) {
                            sdsb.putProperty("START_INDEX", startIndex + j, startIndex);
                        }
                        ++ifield;
                    }
                    length1 = nfields1;
                    sdsbs[i] = sdsb;
                }
                int start = 1;
                WritableDataSet wds = Ops.copy(Ops.trim1(ds, start, start + length1));
                start += length1;
                wds.putProperty("DEPEND_0", depend0);
                wds.putProperty("BUNDLE_1", sdsbs[1].getDataSet());
                for (int i = 1; i < pds.length; ++i) {
                    if (pds[i].dependName == null) continue;
                    for (String dependName : pds[i].dependName) {
                        int k;
                        if (dependName == null) continue;
                        for (k = 1; k < pds.length && !pds[k].name.equals(dependName); ++k) {
                        }
                        if (k >= pds.length) continue;
                        WritableDataSet depds = Ops.copy(Ops.trim1(ds, start, start + length1));
                        depds.putProperty("DEPEND_0", depend0);
                        depds.putProperty("BUNDLE_1", sdsbs[k].getDataSet());
                        start += length1;
                        wds.putProperty("DEPEND_" + i, depds);
                    }
                }
                ds = wds;
            } else {
                SparseDataSetBuilder sdsb = new SparseDataSetBuilder(2);
                sdsb.setLength(nparameters - 1);
                int ifield = 1;
                for (int i = 1; i < pds.length; ++i) {
                    int j;
                    int startIndex;
                    int nfields1 = DataSetUtil.product(pds[i].size);
                    int n = startIndex = sort == null ? ifield - 1 : sort[ifield] - 1;
                    if (nfields1 > 1) {
                        sdsb.putProperty("ELEMENT_NAME", startIndex, Ops.safeName(pds[i].name));
                        sdsb.putProperty("ELEMENT_LABEL", startIndex, pds[i].name);
                        for (j = 0; j < pds[i].size.length; ++j) {
                            sdsb.putValue(startIndex, j, pds[i].size[j]);
                        }
                        if (pds[i].depend != null) {
                            if (pds[i].size.length != pds[i].depend.length) {
                                throw new IllegalArgumentException("pds[i].size.length!=pds[i].depend.length");
                            }
                            for (j = 0; j < pds[i].size.length; ++j) {
                                sdsb.putProperty("DEPEND_" + (j + 1), startIndex, pds[i].depend[j]);
                            }
                        }
                    }
                    for (j = 0; j < nfields1; ++j) {
                        if (nfields1 > 1) {
                            sdsb.putProperty("START_INDEX", startIndex + j, startIndex);
                            sdsb.putProperty("LABEL", startIndex + j, pds[i].name + " ch" + j);
                            sdsb.putProperty("NAME", startIndex + j, Ops.safeName(pds[i].name) + "_" + j);
                        } else {
                            sdsb.putProperty("LABEL", startIndex + j, pds[i].name);
                            sdsb.putProperty("NAME", startIndex + j, Ops.safeName(pds[i].name));
                        }
                        sdsb.putProperty("TITLE", startIndex + j, pds[i].description);
                        sdsb.putProperty("UNITS", startIndex + j, pds[i].units);
                        if (pds[i].hasFill) {
                            sdsb.putProperty("FILL_VALUE", startIndex + j, pds[i].fillValue);
                        }
                        if (nfields1 > 1) {
                            sdsb.putProperty("START_INDEX", startIndex + j, startIndex);
                        }
                        ++ifield;
                    }
                }
                ds = Ops.copy(Ops.trim1(ds, 1, ds.length(0)));
                ds = Ops.putProperty(ds, "DEPEND_0", (Object)depend0);
                ds = Ops.putProperty(ds, "BUNDLE_1", (Object)sdsb.getDataSet());
            }
        }
        return ds;
    }

    private static class ParamDescription {
        boolean hasFill = false;
        double fillValue = -1.0E38;
        Units units = Units.dimensionless;
        String name = "";
        String description = "";
        String label = "";
        String type = "";
        int[] size = new int[0];
        int nFields = 1;
        int length = 0;
        QDataSet[] depend = null;
        String[] dependName = null;
        long modifiedDateMillis = 0L;
        String renderType = null;

        private ParamDescription(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

