/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.fits;

import java.net.URI;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.fits.FitsDataSourceFactory;
import org.autoplot.fits.FitsMetadataModel;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.FDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;
import org.eso.fits.FitsData;
import org.eso.fits.FitsFile;
import org.eso.fits.FitsHDUnit;
import org.eso.fits.FitsKeyword;
import org.eso.fits.FitsMatrix;
import org.eso.fits.FitsTable;

public class FitsDataSource
extends AbstractDataSource {
    FitsDataSource(URI uri) {
        super(uri);
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        FitsFile file;
        FitsHDUnit hdu;
        FitsData fd;
        int ihdu = 0;
        Map<String, Integer> plottable = FitsDataSourceFactory.getPlottable(this.resourceURI, mon);
        String name = this.getParams().get("arg_0");
        if (name != null) {
            ihdu = plottable.get(name);
        }
        if ((fd = (hdu = (file = new FitsFile(this.getFile(mon))).getHDUnit(ihdu)).getData()) instanceof FitsMatrix) {
            FitsMatrix dm = (FitsMatrix)hdu.getData();
            int[] naxis = dm.getNaxis();
            double[] crval = dm.getCrval();
            double[] crpix = dm.getCrpix();
            double[] cdelt = dm.getCdelt();
            float[] fdata = new float[dm.getNoValues()];
            dm.getFloatValues(0, dm.getNoValues(), fdata);
            if (naxis.length == 3) {
                naxis = new int[]{naxis[2], naxis[0], naxis[1]};
                crval = new double[]{crval[2], crval[1], crval[0]};
                crpix = new double[]{crpix[2], crpix[1], crpix[0]};
                cdelt = new double[]{cdelt[2], cdelt[1], cdelt[0]};
            } else if (naxis.length == 2) {
                naxis = new int[]{naxis[1], naxis[0]};
                crval = new double[]{crval[1], crval[0]};
                crpix = new double[]{crpix[1], crpix[0]};
                cdelt = new double[]{cdelt[1], cdelt[0]};
            } else if (naxis.length == 0) {
                throw new IllegalArgumentException("Unable to use fits file");
            }
            FDataSet result = FDataSet.wrap(fdata, naxis);
            int rank = result.rank();
            if (rank == 2) {
                MutablePropertyDataSet xx = DataSetUtil.tagGenDataSet(naxis[0], crval[0] - cdelt[0] * crpix[0], cdelt[0]);
                xx.putProperty("NAME", "axis0");
                ((AbstractDataSet)result).putProperty("DEPEND_0", xx);
                xx = DataSetUtil.tagGenDataSet(naxis[1], crval[1] - cdelt[1] * crpix[1], cdelt[1]);
                xx.putProperty("NAME", "axis1");
                ((AbstractDataSet)result).putProperty("DEPEND_1", xx);
                return DataSetOps.transpose2(result);
            }
            MutablePropertyDataSet xx = DataSetUtil.tagGenDataSet(naxis[2], crval[1] - cdelt[0] * crpix[0], cdelt[0]);
            xx.putProperty("NAME", "axis0");
            ((AbstractDataSet)result).putProperty("DEPEND_2", xx);
            xx = DataSetUtil.tagGenDataSet(naxis[1], crval[1] - cdelt[1] * crpix[1], cdelt[1]);
            xx.putProperty("NAME", "axis1");
            ((AbstractDataSet)result).putProperty("DEPEND_1", xx);
            xx = DataSetUtil.indexGenDataSet(naxis[0]);
            xx.putProperty("NAME", "bundle");
            ((AbstractDataSet)result).putProperty("DEPEND_0", xx);
            return result;
        }
        if (fd instanceof FitsTable) {
            final FitsTable ft = (FitsTable)fd;
            AbstractDataSet mpds = new AbstractDataSet(){

                @Override
                public int rank() {
                    return 2;
                }

                @Override
                public double value(int i0, int i1) {
                    return ft.getColumn(i1).getReal(i0);
                }

                @Override
                public int length() {
                    return ft.getNoRows();
                }

                @Override
                public int length(int i0) {
                    return ft.getNoColumns();
                }
            };
            mpds.putProperty("QUBE", Boolean.TRUE);
            AbstractDataSet bds = new AbstractDataSet(){

                @Override
                public int rank() {
                    return 2;
                }

                @Override
                public double value(int i0, int i1) {
                    return 1.0;
                }

                @Override
                public int length() {
                    return ft.getNoColumns();
                }

                @Override
                public int length(int i) {
                    return 0;
                }

                @Override
                public Object property(String name, int i) {
                    if (name.equals("LABEL")) {
                        return ft.getColumn(i).getLabel();
                    }
                    if (name.equals("NAME")) {
                        return Ops.safeName(ft.getColumn(i).getLabel());
                    }
                    return super.property(name);
                }
            };
            mpds.putProperty("BUNDLE_1", bds);
            if (bds.length() == 1) {
                return DataSetOps.unbundle((QDataSet)mpds, 0);
            }
            return mpds;
        }
        throw new IllegalArgumentException("fitsdata type not supported: " + fd.getClass());
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        int ihdu = 0;
        Map<String, Integer> plottable = FitsDataSourceFactory.getPlottable(this.uri, mon);
        String name = this.getParams().get("arg_0");
        if (name != null) {
            ihdu = plottable.get(name);
        }
        FitsFile file = new FitsFile(this.getFile(mon));
        FitsHDUnit hdu = file.getHDUnit(ihdu);
        HashMap<String, Object> meta = new HashMap<String, Object>();
        Enumeration e = hdu.getHeader().getKeywords();
        while (e.hasMoreElements()) {
            Object val;
            FitsKeyword key = (FitsKeyword)e.nextElement();
            switch (key.getType()) {
                case 3: {
                    val = key.getBool();
                    break;
                }
                case 1: {
                    val = key.getComment();
                    break;
                }
                case 6: {
                    val = key.getDate();
                    break;
                }
                case 4: {
                    val = key.getInt();
                    break;
                }
                case 0: {
                    val = "NONE";
                    break;
                }
                case 5: {
                    val = key.getReal();
                    break;
                }
                case 2: {
                    val = key.getString();
                    break;
                }
                default: {
                    val = "????";
                }
            }
            meta.put(key.getName(), val);
        }
        return meta;
    }

    @Override
    public MetadataModel getMetadataModel() {
        return new FitsMetadataModel();
    }
}

