/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.excel;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.excel.ExcelSpreadsheetDataSource;
import org.das2.util.monitor.ProgressMonitor;

public class ExcelUtil {
    public static short getColumnNumber(HSSFSheet sheet, String id, int firstRow) {
        HSSFRow row = sheet.getRow(firstRow);
        if (row == null) {
            throw new IllegalArgumentException("no such row " + (firstRow + 1) + " in sheet");
        }
        for (short i = 0; i < row.getLastCellNum(); i = (short)(i + 1)) {
            HSSFCell cell = row.getCell(i);
            if (cell == null || cell.getCellType() != 1) continue;
            String label = cell.getStringCellValue();
            String id1 = null;
            if (label.charAt(0) == id.charAt(0)) {
                id1 = DataSourceUtil.toJavaIdentifier(label);
            }
            if (!id.equals(id1)) continue;
            return i;
        }
        if (id.length() == 1) {
            return (short)(id.charAt(0) - 65);
        }
        if (id.length() == 2 && Character.isUpperCase(id.charAt(0)) && Character.isLetter(id.charAt(0)) && Character.isUpperCase(id.charAt(1)) && Character.isLetter(id.charAt(1))) {
            return (short)((id.charAt(0) - 65 + 1) * 26 + (id.charAt(1) - 65));
        }
        throw new IllegalArgumentException("unable to find column " + id);
    }

    public static List<String> getSheets(HSSFWorkbook wb, CompletionContext cc, ProgressMonitor mon) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            String s = wb.getSheetName(i);
            result.add(s);
        }
        return result;
    }

    public static Map<Integer, String> getColumns(HSSFWorkbook wb, String ssheet, String firstRowString, ProgressMonitor mon) throws IOException {
        HSSFSheet sheet;
        LinkedHashMap<Integer, String> result = new LinkedHashMap<Integer, String>();
        if (ssheet == null) {
            sheet = wb.getSheetAt(0);
            ssheet = wb.getSheetName(0);
        } else {
            sheet = wb.getSheet(ssheet);
        }
        if (sheet == null) {
            throw new IllegalArgumentException("no such sheet \"" + ssheet + "\"");
        }
        int firstRow = firstRowString == null ? 0 : Integer.parseInt(firstRowString) - 1;
        HSSFRow row = sheet.getRow(firstRow);
        if (row == null) {
            if (firstRow == 0) {
                throw new IllegalArgumentException("(sheet \"" + ssheet + "\" contains no records)");
            }
            throw new IllegalArgumentException("(sheet \"" + ssheet + "\" doesn't have a row at " + (firstRow + 1) + ")");
        }
        int inextRow = ExcelSpreadsheetDataSource.findFirstRow(sheet, firstRow);
        HSSFRow nextRow = sheet.getRow(inextRow);
        if (nextRow != null) {
            short n = nextRow.getLastCellNum();
            for (int i = nextRow.getFirstCellNum(); i < n; ++i) {
                String name = ExcelUtil.getNameForColumn(nextRow, row, i);
                result.put(i, name);
            }
        }
        return result;
    }

    private static String getNameForColumn(HSSFRow nextRow, HSSFRow row, int icol) {
        HSSFCell nextCell = nextRow.getCell((short)icol);
        if (nextCell != null && nextCell.getCellType() == 0) {
            HSSFCell cell = row.getCell((short)icol);
            if (cell == null) {
                return "" + (char)(icol + 65);
            }
            if (cell.getCellType() == 0) {
                return "" + (char)(icol + 65);
            }
            return DataSourceUtil.toJavaIdentifier(cell.getRichStringCellValue().toString());
        }
        return "" + (char)(icol + 65);
    }
}

