/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.TimeZone;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.datum.Datum;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.DataSetWrapper;
import org.das2.qds.QDataSet;
import org.das2.util.monitor.ProgressMonitor;

public class ExcelSpreadsheetDataSourceFormat
implements DataSourceFormat {
    HSSFCellStyle dateCellStyle;
    Calendar c = Calendar.getInstance(TimeZone.getTimeZone("GMT"));

    private String labelFor(QDataSet ds, String deft) {
        String l = (String)ds.property("LABEL");
        if (l == null) {
            l = (String)ds.property("NAME");
        }
        if (l == null) {
            l = deft;
        }
        return l;
    }

    private void formatRank2(HSSFSheet sheet, String cellName, QDataSet data, ProgressMonitor mon) throws IOException {
        Units u;
        HSSFCell cell;
        boolean okay;
        HSSFRow row = null;
        QDataSet dep1 = (QDataSet)data.property("DEPEND_1");
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        short icell0 = dep0 == null ? (cellName != null ? (short)(cellName.charAt(0) - 65) : (short)0) : (cellName != null ? (short)(cellName.charAt(0) - 65) : (short)1);
        short icell = icell0;
        int irow = dep1 != null ? (cellName != null ? (int)((short)(Short.parseShort(cellName.substring(1)) - 1)) : 0) : (cellName != null ? (int)((short)(Short.parseShort(cellName.substring(1)) - 1)) : 1);
        if (irow > 0) {
            row = sheet.createRow(irow - 1);
        }
        if (!(okay = DataSetUtil.checkQube(data))) {
            throw new IllegalArgumentException("Data is not a qube.  Each record must have the same DEPEND_1.");
        }
        if (dep1 != null && dep1.rank() == 2) {
            dep1 = dep1.slice(0);
        }
        if (dep1 != null && row != null) {
            Units u2;
            if (dep0 != null && icell > 0) {
                String l = this.labelFor(dep0, "");
                if (icell > 0) {
                    cell = row.createCell((short)(icell - 1));
                    cell.setCellValue(new HSSFRichTextString(l));
                }
            }
            if ((u2 = (Units)dep1.property("UNITS")) == null) {
                u2 = Units.dimensionless;
            }
            for (int i = 0; i < dep1.length(); ++i) {
                short s = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s);
                Datum d = u2.createDatum(dep1.value(i));
                this.setCellValue(cell, d);
            }
        }
        Units u0 = null;
        if (dep0 != null && (u0 = (Units)dep0.property("UNITS")) == null) {
            u0 = Units.dimensionless;
        }
        if ((u = (Units)data.property("UNITS")) == null) {
            u = Units.dimensionless;
        }
        mon.setTaskSize(data.length());
        mon.started();
        for (int i = 0; i < data.length(); ++i) {
            mon.setTaskProgress(i);
            if (mon.isCancelled()) break;
            row = sheet.createRow(irow++);
            icell = icell0;
            if (dep0 != null && icell > 0) {
                assert (u0 != null);
                cell = row.createCell((short)(icell - 1));
                this.setCellValue(cell, u0.createDatum(dep0.value(i)));
            }
            for (int j = 0; j < data.length(i); ++j) {
                short s = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s);
                this.setCellValue(cell, u.createDatum(data.value(i, j)));
            }
        }
        mon.finished();
    }

    private void formatRank1(HSSFSheet sheet, String cellName, QDataSet data, ProgressMonitor mon) throws IOException {
        Units u;
        HSSFCell cell;
        HSSFRow row;
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        int irow = 0;
        short icell0 = dep0 == null ? (cellName != null ? (short)(cellName.charAt(0) - 65) : (short)0) : (cellName != null ? (short)(cellName.charAt(0) - 65) : (short)1);
        irow = cellName != null ? (int)((short)(Short.parseShort(cellName.substring(1)) - 1)) : 1;
        short icell = icell0;
        if (irow > 0) {
            String label;
            row = sheet.createRow(irow - 1);
            if (dep0 != null) {
                label = this.labelFor(dep0, "");
                short s = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s);
                cell.setCellValue(new HSSFRichTextString(label));
            }
            label = this.labelFor(data, "");
            short s = icell;
            icell = (short)(icell + 1);
            cell = row.createCell(s);
            cell.setCellValue(new HSSFRichTextString(label == null ? "" : label));
        }
        Units u0 = Units.dimensionless;
        if (dep0 != null && (u0 = (Units)dep0.property("UNITS")) == null) {
            u0 = Units.dimensionless;
        }
        if ((u = (Units)data.property("UNITS")) == null) {
            u = Units.dimensionless;
        }
        mon.setTaskSize(data.length());
        mon.started();
        for (int i = 0; i < data.length(); ++i) {
            mon.setTaskProgress(i);
            if (mon.isCancelled()) break;
            row = sheet.createRow(irow++);
            icell = icell0;
            if (dep0 != null) {
                short s = icell;
                icell = (short)(icell + 1);
                cell = row.createCell(s);
                this.setCellValue(cell, u0.createDatum(dep0.value(i)));
            }
            short s = icell;
            icell = (short)(icell + 1);
            cell = row.createCell(s);
            this.setCellValue(cell, u.createDatum(data.value(i)));
        }
        mon.finished();
    }

    private void setCellValue(HSSFCell cell, Datum datum) {
        Units u = datum.getUnits();
        if (UnitsUtil.isTimeLocation(u)) {
            this.c.setTimeInMillis((long)(datum.doubleValue(Units.t1970) * 1000.0));
            cell.setCellValue(this.c);
            cell.setCellStyle(this.dateCellStyle);
        } else if (UnitsUtil.isNominalMeasurement(u)) {
            cell.setCellValue(new HSSFRichTextString(datum.toString()));
        } else {
            cell.setCellValue(datum.doubleValue(u));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws IOException {
        HSSFWorkbook wb;
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        boolean append = "T".equals(params.get("append"));
        String sheetName = (String)params.get("sheet");
        if (sheetName == null) {
            sheetName = "sheet1";
        }
        String cellName = (String)params.get("cell");
        String nodep = (String)params.get("nodep");
        if ("T".equals(nodep)) {
            DataSetWrapper dsw = new DataSetWrapper(data);
            dsw.putProperty("DEPEND_0", null);
            dsw.putProperty("DEPEND_1", null);
        }
        int irow = 0;
        if (cellName != null) {
            irow = (short)(Short.parseShort(cellName.substring(1)) - 1);
        }
        if (data.length() > 65534 + irow) {
            throw new IllegalArgumentException("Data contains too many records to format to Excel spreadsheet.");
        }
        if (append) {
            try (FileInputStream in = null;){
                in = new FileInputStream(new File(split.resourceUri));
                wb = new HSSFWorkbook((InputStream)in);
            }
        } else {
            wb = new HSSFWorkbook();
        }
        try (FileOutputStream out = new FileOutputStream(new File(split.resourceUri));){
            HSSFSheet sheet = wb.getSheet(sheetName);
            if (sheet == null) {
                sheet = wb.createSheet(sheetName);
            }
            this.dateCellStyle = wb.createCellStyle();
            this.dateCellStyle.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"m/d/yy h:mm"));
            if (data.rank() == 2) {
                this.formatRank2(sheet, cellName, data, mon);
            } else if (data.rank() == 1) {
                this.formatRank1(sheet, cellName, data, mon);
            }
            HSSFRow lastRow = sheet.getRow(sheet.getLastRowNum());
            short ncol = lastRow.getLastCellNum();
            for (short i = 0; i < ncol; i = (short)(i + 1)) {
                if (lastRow.getCell(i) == null || !this.dateCellStyle.equals((Object)lastRow.getCell(i).getCellStyle())) continue;
                sheet.autoSizeColumn(i);
            }
            wb.write((OutputStream)out);
        }
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        return (ds.rank() == 1 || ds.rank() == 2) && ds.length() <= 65000;
    }

    @Override
    public String getDescription() {
        return "Excel Spreadsheet";
    }
}

