/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.URISplit;
import org.autoplot.excel.ExcelSpreadsheetDataSource;
import org.autoplot.excel.ExcelUtil;
import org.das2.util.monitor.ProgressMonitor;

public class ExcelSpreadsheetDataSourceFactory
implements DataSourceFactory {
    private static final String FIRST_ROW_DOC = "the row that contains the either the first record of data, or data column headings.  1 is the first row.";

    @Override
    public DataSource getDataSource(URI uri) throws IOException {
        return new ExcelSpreadsheetDataSource(uri);
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws IOException {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "column="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "depend0="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "plane0="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "sheet="));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "firstRow=", FIRST_ROW_DOC));
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "recCount=", "limit number of records to read"));
        } else if (cc.context == CompletionContext.CONTEXT_PARAMETER_VALUE) {
            String param = CompletionContext.get(CompletionContext.CONTEXT_PARAMETER_NAME, cc);
            if (param.equals("column")) {
                result.addAll(this.toCC(CompletionContext.CONTEXT_PARAMETER_VALUE, this.getColumns(cc, mon), null));
            } else if (param.equals("depend0")) {
                result.addAll(this.toCC(CompletionContext.CONTEXT_PARAMETER_VALUE, this.getColumns(cc, mon), null));
            } else if (param.equals("plane0")) {
                result.addAll(this.toCC(CompletionContext.CONTEXT_PARAMETER_VALUE, this.getColumns(cc, mon), null));
            } else if (param.equals("sheet")) {
                result.addAll(this.toCC(CompletionContext.CONTEXT_PARAMETER_VALUE, this.getSheets(cc, mon), "worksheet source"));
            } else if (param.equals("firstRow")) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", FIRST_ROW_DOC));
            } else if (param.equals("recCount")) {
                result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_VALUE, "<int>", FIRST_ROW_DOC));
            }
        }
        return result;
    }

    List<CompletionContext> toCC(Object context, List<String> results, String doc) {
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        for (String s : results) {
            result.add(new CompletionContext(context, URISplit.uriEncode(s), s, doc));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HSSFWorkbook getWorkbook(URI uri, ProgressMonitor mon) throws IOException {
        File file = DataSetURI.getFile(uri, mon);
        HSSFWorkbook wb = null;
        try (FileInputStream in = new FileInputStream(file);){
            POIFSFileSystem fs = new POIFSFileSystem((InputStream)in);
            wb = new HSSFWorkbook(fs);
        }
        return wb;
    }

    private List<String> getSheets(CompletionContext cc, ProgressMonitor mon) throws IOException {
        HSSFWorkbook wb = this.getWorkbook(cc.resourceURI, mon);
        return ExcelUtil.getSheets(wb, cc, mon);
    }

    private List<String> getColumns(CompletionContext cc, ProgressMonitor mon) throws IOException {
        HSSFWorkbook wb = this.getWorkbook(cc.resourceURI, mon);
        LinkedHashMap<String, String> params = URISplit.parseParams(cc.params);
        return new LinkedList<String>(ExcelUtil.getColumns(wb, (String)params.get("sheet"), (String)params.get("firstRow"), mon).values());
    }

    public MetadataModel getMetadataModel(URL url) {
        return MetadataModel.createNullModel();
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        return !surl.contains("column=");
    }

    public String urlForServer(String surl) {
        return surl;
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        return null;
    }

    @Override
    public boolean supportsDiscovery() {
        return false;
    }
}

