/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.excel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.excel.ExcelUtil;
import org.das2.datum.Units;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.QDataSet;
import org.das2.util.monitor.ProgressMonitor;

public class ExcelSpreadsheetDataSource
extends AbstractDataSource {
    POIFSFileSystem fs;
    HSSFSheet sheet;
    boolean isUsing1904DateWindowing;
    ExcelSpreadsheetDataSet data;
    static Logger logger = Logger.getLogger("org.autoplot.ExcelSpreadsheetDataSource");

    public ExcelSpreadsheetDataSource(URI uri) throws IOException {
        super(uri);
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws IOException {
        File file = this.getFile(mon);
        FileInputStream in = new FileInputStream(file);
        this.fs = new POIFSFileSystem((InputStream)in);
        HSSFWorkbook wb = new HSSFWorkbook(this.fs);
        String ssheet = (String)this.params.get("sheet");
        if (ssheet == null) {
            this.sheet = wb.getSheetAt(0);
        } else {
            ssheet = DataSetURI.maybePlusToSpace(ssheet);
            this.sheet = wb.getSheet(ssheet);
            if (this.sheet == null) {
                throw new IllegalArgumentException("no such sheet: " + ssheet);
            }
            logger.log(Level.FINE, "found sheet {0} with {1} rows", new Object[]{ssheet, this.sheet.getLastRowNum()});
        }
        if (this.sheet == null) {
            throw new IllegalArgumentException("Sheet not found: " + ssheet);
        }
        String firstRowString = (String)this.params.get("firstRow");
        int firstRow = firstRowString == null ? -1 : Integer.parseInt(firstRowString) - 1;
        String d = (String)this.params.get("column");
        int[] spec = this.parseDataSetSpec(d, Math.max(0, firstRow), -1);
        firstRow = spec[2];
        boolean labels = true;
        HSSFRow row = this.sheet.getRow(firstRow);
        for (short i = 0; labels && i < row.getLastCellNum(); i = (short)(i + 1)) {
            HSSFCell cell = row.getCell(i);
            if (cell == null) continue;
            if (cell.getCellType() == 0) {
                labels = false;
            }
            if (i != spec[0] || cell.getCellType() == 1) continue;
            labels = false;
        }
        String recCountString = (String)this.params.get("recCount");
        if (recCountString != null) {
            int recCount = Integer.parseInt(recCountString);
            spec[3] = Math.min(spec[3], spec[2] + recCount);
        }
        this.data = new ExcelSpreadsheetDataSet((short)spec[0], (short)spec[1], spec[2], spec[3], labels);
        if (firstRow == 0 && this.data.firstRow > 1) {
            firstRow = this.data.firstRow;
        }
        if (d.length() > 1) {
            this.data.putProperty("NAME", d);
        }
        if ((d = (String)this.params.get("depend0")) != null) {
            int[] spec2 = this.parseDataSetSpec(d, firstRow, -1);
            spec[0] = spec2[0];
            ExcelSpreadsheetDataSet depend0 = new ExcelSpreadsheetDataSet((short)spec[0], (short)spec[1], spec[2], spec[3], labels);
            if (d.length() > 1) {
                depend0.putProperty("NAME", d);
            }
            this.data.putProperty("DEPEND_0", depend0);
            if (this.data.getFirstRow() != depend0.getFirstRow()) {
                throw new IllegalArgumentException("rows must not contain empty cells in the first row");
            }
        }
        if ((d = (String)this.params.get("plane0")) != null) {
            int[] spec2 = this.parseDataSetSpec(d, firstRow, -1);
            spec[0] = spec2[0];
            ExcelSpreadsheetDataSet p0 = new ExcelSpreadsheetDataSet((short)spec[0], (short)spec[1], spec[2], spec[3], labels);
            if (d.length() > 1) {
                p0.putProperty("NAME", d);
            }
            this.data.putProperty("PLANE_0", p0);
            if (this.data.getFirstRow() != p0.getFirstRow()) {
                throw new IllegalArgumentException("rows must not contain empty cells in the first row");
            }
        }
        this.isUsing1904DateWindowing = false;
        return this.data;
    }

    private int[] parseDataSetSpec(String spec, int firstRow, int lastRow) {
        int columnNumber1;
        Pattern pc = Pattern.compile("([a-zA-Z_\\d]*)");
        Matcher m = pc.matcher(spec);
        if (m.matches()) {
            short columnNumber = this.getColumnNumber(m.group(1), firstRow);
            return new int[]{columnNumber, -1, Math.max(0, firstRow), this.sheet.getLastRowNum() + 1};
        }
        Pattern p = Pattern.compile("([a-zA-Z_]*)((\\d+):([a-zA-Z_]*)?(\\d+)?)?");
        m = p.matcher(spec);
        if (!m.matches()) {
            throw new IllegalArgumentException("bad spec!");
        }
        String col = m.group(1);
        if (m.group(3) == null) {
            if (firstRow == -1) {
                firstRow = 0;
            }
            if (lastRow == -1) {
                lastRow = this.sheet.getLastRowNum() + 1;
            }
        } else {
            firstRow = Integer.parseInt(m.group(3));
            if (m.group(5) == null) {
                if (lastRow == -1) {
                    lastRow = this.sheet.getLastRowNum() + 1;
                }
            } else {
                lastRow = Integer.parseInt(m.group(5)) + 1;
            }
        }
        if (m.group(4) != null) {
            String c = m.group(4);
            if (c.length() == 0) {
                c = m.group(1);
            }
            columnNumber1 = this.getColumnNumber(c, firstRow);
        } else {
            columnNumber1 = -1;
        }
        int columnNumber = this.getColumnNumber(col, firstRow);
        if (columnNumber1 > -1 && columnNumber1 == columnNumber) {
            columnNumber1 = -1;
        }
        return new int[]{columnNumber, columnNumber1, firstRow, lastRow};
    }

    private short getColumnNumber(String id, int firstRow) {
        return ExcelUtil.getColumnNumber(this.sheet, id, firstRow);
    }

    protected static int findFirstRow(HSSFSheet sheet, int firstRow) {
        int inextRow;
        int ilastRow = sheet.getPhysicalNumberOfRows();
        int dataCellCount = 0;
        for (inextRow = firstRow; inextRow < ilastRow && inextRow < firstRow + 4; ++inextRow) {
            HSSFRow nextRow = sheet.getRow(inextRow);
            if (nextRow != null) {
                short n = nextRow.getLastCellNum();
                for (int i = nextRow.getFirstCellNum(); i < n; ++i) {
                    HSSFCell nextCell = nextRow.getCell((short)i);
                    if (nextCell == null || nextCell.getCellType() != 0) continue;
                    ++dataCellCount;
                }
            }
            if (dataCellCount != 0) break;
        }
        return inextRow;
    }

    private class ExcelSpreadsheetDataSet
    extends AbstractDataSet {
        short columnNumber;
        int firstRow;
        int length;
        int length1;
        boolean isDate;
        Units units;
        boolean transpose = false;
        int rank;

        ExcelSpreadsheetDataSet(short columnNumber, short lastColumnNumber, int firstRow, int lastRow, boolean firstRowIsLabels) {
            if (firstRowIsLabels) {
                firstRow = ExcelSpreadsheetDataSource.findFirstRow(ExcelSpreadsheetDataSource.this.sheet, firstRow);
            }
            this.columnNumber = columnNumber;
            this.firstRow = firstRow;
            if (lastRow == -1 && lastColumnNumber != -1) {
                this.length = lastColumnNumber - columnNumber;
                this.transpose = true;
            } else {
                this.length = lastRow - firstRow;
            }
            if (lastRow > -1 && lastColumnNumber > -1) {
                this.rank = 2;
                if (this.transpose) {
                    this.length1 = lastRow - firstRow;
                } else if (this.length == 0) {
                    this.length = lastColumnNumber - columnNumber;
                    this.rank = 1;
                    this.transpose = true;
                } else {
                    this.length1 = lastColumnNumber - columnNumber;
                }
            } else {
                this.rank = 1;
            }
            HSSFRow row = ExcelSpreadsheetDataSource.this.sheet.getRow(this.firstRow);
            HSSFCell cell = row.getCell(columnNumber);
            if (cell == null) {
                row = null;
            }
            while (row == null && firstRow < lastRow) {
                if ((row = ExcelSpreadsheetDataSource.this.sheet.getRow(++firstRow)) != null) {
                    cell = row.getCell(columnNumber);
                }
                if (cell != null) continue;
                row = null;
            }
            if (row == null) {
                throw new IllegalArgumentException("unable to identify first row");
            }
            this.firstRow = firstRow;
            cell = row.getCell(columnNumber);
            this.units = Units.dimensionless;
            if (cell.getCellType() != 1) {
                this.isDate = HSSFDateUtil.isCellDateFormatted((HSSFCell)cell);
                if (this.isDate) {
                    if (ExcelSpreadsheetDataSource.this.isUsing1904DateWindowing) {
                        this.units = Units.lookupUnits("days since 1903-12-31T00:00Z");
                        this.properties.put("VALID_MIN", 0);
                    } else {
                        this.units = Units.lookupUnits("days since 1899-12-30T00:00Z");
                        this.properties.put("VALID_MIN", 61);
                    }
                    this.properties.put("UNITS", this.units);
                }
            } else if (cell.getCellType() == 1) {
                String s = cell.getStringCellValue();
                try {
                    Units.t1970.parse(s);
                    this.properties.put("UNITS", Units.t1970);
                    this.units = Units.t1970;
                }
                catch (ParseException ex) {
                    this.properties.put("UNITS", Units.dimensionless);
                }
            }
        }

        public int getFirstRow() {
            return this.firstRow;
        }

        @Override
        public int rank() {
            return this.rank;
        }

        @Override
        public double value(int i) {
            try {
                HSSFCell cell;
                if (this.transpose) {
                    HSSFRow row = ExcelSpreadsheetDataSource.this.sheet.getRow(this.firstRow);
                    cell = row.getCell(this.columnNumber + i);
                } else {
                    HSSFRow row = ExcelSpreadsheetDataSource.this.sheet.getRow(i + this.firstRow);
                    cell = row.getCell(this.columnNumber);
                }
                if (this.isDate) {
                    double d = cell.getNumericCellValue();
                    return d;
                }
                if (cell == null) {
                    return Double.NaN;
                }
                if (cell.getCellType() == 0) {
                    double d = cell.getNumericCellValue();
                    return d;
                }
                if (cell.getCellType() == 1) {
                    try {
                        double d = this.units.parse(cell.getStringCellValue()).doubleValue(this.units);
                        return d;
                    }
                    catch (ParseException ex) {
                        return Double.NaN;
                    }
                }
                return Double.NaN;
            }
            catch (RuntimeException e) {
                return Double.NaN;
            }
        }

        @Override
        public double value(int i, int j) {
            try {
                HSSFCell cell;
                if (this.transpose) {
                    HSSFRow row = ExcelSpreadsheetDataSource.this.sheet.getRow(j + this.firstRow);
                    cell = row.getCell(i + this.columnNumber);
                } else {
                    HSSFRow row = ExcelSpreadsheetDataSource.this.sheet.getRow(i + this.firstRow);
                    cell = row.getCell(j + this.columnNumber);
                }
                if (this.isDate) {
                    double d = cell.getNumericCellValue();
                    return d;
                }
                if (cell == null) {
                    return Double.NaN;
                }
                if (cell.getCellType() == 0) {
                    double d = cell.getNumericCellValue();
                    return d;
                }
                if (cell.getCellType() == 1) {
                    try {
                        double d = this.units.parse(cell.getStringCellValue()).doubleValue(this.units);
                        return d;
                    }
                    catch (ParseException ex) {
                        return Double.NaN;
                    }
                }
                return Double.NaN;
            }
            catch (RuntimeException e) {
                return Double.NaN;
            }
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public int length(int i) {
            return this.length1;
        }
    }
}

