/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.Row;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasRow;
import org.das2.util.LoggerManager;

public class RowController
extends DomNodeController {
    Row row;
    DasRow dasRow;
    Canvas canvas;

    RowController(Row row) {
        super(row);
        this.row = row;
        row.controller = this;
    }

    protected void createDasPeer(Canvas canvas, DasRow parent) {
        DasCanvas c = canvas.controller.getDasCanvas();
        this.dasRow = DasRow.create(c, parent, this.row.getTop(), this.row.getBottom());
        final List<String> minList = Arrays.asList("minimum", "emMinimum", "ptMinimum");
        final List<String> maxList = Arrays.asList("maximum", "emMaximum", "ptMaximum");
        PropertyChangeListener list = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                if (maxList.contains(evt.getPropertyName())) {
                    RowController.this.row.setBottom(DasDevicePosition.formatLayoutStr(RowController.this.dasRow, false));
                } else if (minList.contains(evt.getPropertyName())) {
                    RowController.this.row.setTop(DasDevicePosition.formatLayoutStr(RowController.this.dasRow, true));
                }
            }
        };
        this.dasRow.addPropertyChangeListener(list);
        list = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr((String)evt.getNewValue());
                    if (evt.getPropertyName().equals("top")) {
                        RowController.this.dasRow.setMin(dd[0], dd[1], (int)dd[2]);
                    } else if (evt.getPropertyName().equals("bottom")) {
                        RowController.this.dasRow.setMax(dd[0], dd[1], (int)dd[2]);
                    }
                }
                catch (ParseException ex) {
                    DomNodeController.logger.log(Level.WARNING, "parse exception: {0}", ex);
                    RowController.this.row.setTop(DasDevicePosition.formatLayoutStr(RowController.this.dasRow, true));
                    RowController.this.row.setBottom(DasDevicePosition.formatLayoutStr(RowController.this.dasRow, false));
                }
            }
        };
        this.row.addPropertyChangeListener("bottom", list);
        this.row.addPropertyChangeListener("top", list);
        this.canvas = canvas;
    }

    public boolean isLayoutEqual(String spec) throws ParseException {
        String[] ss = spec.split(",");
        String s1 = DasDevicePosition.formatFormatStr(DasDevicePosition.parseLayoutStr(ss[0]));
        if (!this.row.top.equals(s1)) {
            return false;
        }
        s1 = DasDevicePosition.formatFormatStr(DasDevicePosition.parseLayoutStr(ss[1]));
        return this.row.bottom.equals(s1);
    }

    public DasRow getDasRow() {
        return this.dasRow;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

