/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.das2.util.LoggerManager;

public class PropertyChangeDiff
implements Diff {
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom");
    String propertyName;
    Object oldVal;
    Object newVal;

    PropertyChangeDiff(String propertyName, Object oldVal, Object newVal) {
        this.propertyName = propertyName;
        this.oldVal = oldVal;
        this.newVal = newVal;
    }

    private static void doSet(DomNode node, String propertyName, Object oldVal1, Object newVal) {
        try {
            DomUtil.setPropertyValue(node, propertyName, newVal);
        }
        catch (IllegalAccessException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (InvocationTargetException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    @Override
    public void doDiff(DomNode node) {
        PropertyChangeDiff.doSet(node, this.propertyName, this.oldVal, this.newVal);
    }

    @Override
    public void undoDiff(DomNode node) {
        PropertyChangeDiff.doSet(node, this.propertyName, this.newVal, this.oldVal);
    }

    @Override
    public String propertyName() {
        return this.propertyName;
    }

    public String toString() {
        String s = this.propertyName + " " + this.oldVal + " to " + this.newVal;
        if (s.length() > 30) {
            s = this.newVal instanceof Boolean ? this.propertyName + "=" + this.newVal : this.propertyName;
        }
        return s;
    }

    @Override
    public String getLabel() {
        return this.toString();
    }

    @Override
    public String getDescription() {
        return this.propertyName + " " + this.oldVal + " \u2192 " + this.newVal;
    }
}

