/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.text.ParseException;
import java.util.Map;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.QDataSet;

public class PlotElementUtil {
    protected static String describe(String defaultName, QDataSet dep, int index) {
        String svalue;
        Units u;
        String name = defaultName;
        String name1 = (String)dep.property("NAME");
        if (name1 != null) {
            name = name1;
        }
        if ((u = (Units)dep.property("UNITS")) == null) {
            u = Units.dimensionless;
        }
        if (index < 0 || index >= dep.length()) {
            svalue = "(index out of bounds)";
        } else {
            Datum value = u.createDatum(dep.value(index));
            svalue = String.valueOf(value);
        }
        if (UnitsUtil.isTimeLocation(u)) {
            return "time=" + svalue;
        }
        return name + "=" + svalue;
    }

    protected static void unitsCheck(Map properties, QDataSet dataset) {
        Units u0 = (Units)dataset.property("UNITS");
        Units u1 = (Units)properties.get("UNITS");
        if (u0 == null || u1 == null || !u0.isConvertibleTo(u1)) {
            properties.put("UNITS", u0);
        }
        for (int i = 0; i < 4; ++i) {
            QDataSet dep = (QDataSet)dataset.property("DEPEND_" + i);
            Map depprops = (Map)properties.get("DEPEND_" + i);
            if (dep == null || depprops == null) continue;
            PlotElementUtil.unitsCheck(depprops, dep);
        }
    }

    public static double[] parseFillValidRangeInternal(String validRange, String sfill) throws ParseException {
        double[] result = new double[3];
        if (!"".equals(validRange.trim())) {
            DatumRange vrange = DatumRangeUtil.parseDatumRange(validRange, Units.dimensionless);
            result[0] = vrange.min().doubleValue(Units.dimensionless);
            result[1] = vrange.max().doubleValue(Units.dimensionless);
        } else {
            result[0] = -1.7976931348623157E308;
            result[1] = Double.MAX_VALUE;
        }
        result[2] = !"".equals(sfill.trim()) ? Double.parseDouble(sfill) : Double.NaN;
        return result;
    }
}

