/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.autoplot.AutoplotUtil;
import org.autoplot.MouseModuleType;
import org.autoplot.RenderType;
import org.autoplot.RenderTypeUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Axis;
import org.autoplot.dom.AxisController;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.Column;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.LabelConverter;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.autoplot.util.TickleTimer;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DateTimeDatumFormatter;
import org.das2.event.BoxZoomMouseModule;
import org.das2.event.DasMouseInputAdapter;
import org.das2.event.MouseModule;
import org.das2.event.ZoomPanMouseModule;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.graph.SeriesRenderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.TickVDescriptor;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class PlotController
extends DomNodeController {
    Application dom;
    Plot plot;
    private DasPlot dasPlot;
    private DasColorBar dasColorBar;
    private LabelConverter titleConverter;
    private DatumRange scanPrevRange = null;
    private DatumRange scanNextRange = null;
    public List<PlotElement> pdListen = new LinkedList<PlotElement>();
    private static final String PENDING_ADD_DAS_PEER = "addDasPeer";
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom.plotcontroller");
    public PropertyChangeListener rowColListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt);
            if (PlotController.this.dasPlot != null && evt.getPropertyName().equals("rowId")) {
                Row row;
                String id = (String)evt.getNewValue();
                Row row2 = row = id.length() == 0 ? null : (Row)DomUtil.getElementById(PlotController.this.dom, id);
                if (row == null) {
                    row = PlotController.this.dom.controller.getCanvas().marginRow;
                }
                DasRow dasRow = row.controller.getDasRow();
                PlotController.this.dasPlot.setRow(dasRow);
                PlotController.this.plot.getXaxis().getController().getDasAxis().setRow(dasRow);
                PlotController.this.plot.getYaxis().getController().getDasAxis().setRow(dasRow);
                PlotController.this.plot.getZaxis().getController().getDasAxis().setRow(dasRow);
            } else if (PlotController.this.dasPlot != null && evt.getPropertyName().equals("columnId")) {
                Column col;
                String id = (String)evt.getNewValue();
                Column column = col = id.length() == 0 ? null : (Column)DomUtil.getElementById(PlotController.this.dom, id);
                if (col == null) {
                    col = PlotController.this.dom.controller.getCanvas().marginColumn;
                }
                DasColumn dasColumn = col.controller.getDasColumn();
                PlotController.this.dasPlot.setColumn(dasColumn);
                PlotController.this.plot.getXaxis().getController().getDasAxis().setColumn(dasColumn);
                PlotController.this.plot.getYaxis().getController().getDasAxis().setColumn(dasColumn);
                DasColumn c = DasColorBar.getColorBarColumn(dasColumn);
                PlotController.this.dasColorBar.setColumn(c);
            }
        }
    };
    public static final String PROP_AUTOBINDING = "autoBinding";
    protected boolean autoBinding = true;
    private PropertyChangeListener labelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "labelListener");
            if (evt.getPropertyName().equals("title")) {
                PlotController.this.plot.setAutoLabel(false);
            }
        }
    };
    private PropertyChangeListener ticksURIListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "ticksURIListener");
            if (evt.getPropertyName().equals("ticksURI")) {
                if (((String)evt.getNewValue()).length() > 0) {
                    logger.log(Level.FINE, "prop_ticks_uri={0}", evt.getNewValue());
                    String dasAddress = "class:org.autoplot.tca.UriTcaSource:" + evt.getNewValue();
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDataPath(dasAddress);
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(true);
                    PlotController.this.plot.getXaxis().setLabel("%{RANGE}");
                } else {
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDataPath("");
                    PlotController.this.plot.getXaxis().getController().getDasAxis().setDrawTca(false);
                    PlotController.this.plot.getXaxis().setLabel("");
                }
            }
        }
    };
    private PropertyChangeListener idListener = new PropertyChangeListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "idListener");
            if (PlotController.this.dom.controller.isValueAdjusting()) {
                return;
            }
            ChangesSupport.DomLock lock = PlotController.this.dom.controller.mutatorLock();
            lock.lock("Changing plot id");
            try {
                for (BindingModel b : PlotController.this.dom.getBindings()) {
                    if (b.getSrcId().equals(evt.getOldValue())) {
                        b.srcId = (String)evt.getNewValue();
                    }
                    if (!b.getDstId().equals(evt.getOldValue())) continue;
                    b.dstId = (String)evt.getNewValue();
                }
                for (PlotElement pe : PlotController.this.dom.plotElements) {
                    if (!pe.getPlotId().equals(evt.getOldValue())) continue;
                    pe.setPlotId((String)evt.getNewValue());
                }
            }
            finally {
                lock.unlock();
            }
        }
    };
    private PropertyChangeListener dayOfYearListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "dayOfYearListener");
            DasAxis update = PlotController.this.plot.getXaxis().controller.dasAxis;
            PlotController.this.updateAxisFormatter(update);
        }
    };
    private PropertyChangeListener mouseModuleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "mouseModuleListener");
            DasPlot p = PlotController.this.dasPlot;
            MouseModuleType mm = (MouseModuleType)((Object)evt.getNewValue());
            MouseModule m = null;
            if (null != mm) {
                switch (mm) {
                    case boxZoom: {
                        m = p.getDasMouseInputAdapter().getModuleByLabel("Box Zoom");
                        break;
                    }
                    case crosshairDigitizer: {
                        m = p.getDasMouseInputAdapter().getModuleByLabel("Crosshair Digitizer");
                        break;
                    }
                    case zoomX: {
                        m = p.getDasMouseInputAdapter().getModuleByLabel("Zoom X");
                        break;
                    }
                }
            }
            if (m != null) {
                p.getDasMouseInputAdapter().setPrimaryModule(m);
            } else {
                logger.log(Level.WARNING, "logger note recognized: {0}", (Object)mm);
            }
        }
    };
    private PropertyChangeListener autorangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "autorangeListener");
            if (PlotController.this.dom.getController().isValueAdjusting()) {
                logger.fine("autorangeListener cannot work while isValueAdjusting");
                return;
            }
            if (PlotController.this.dom.options.autoranging) {
                if (evt.getPropertyName().equals("autoRange") && evt.getNewValue().equals(Boolean.TRUE)) {
                    PlotController.this.resetZoom(PlotController.this.getPlot().getXaxis().isAutoRange(), PlotController.this.getPlot().getYaxis().isAutoRange(), PlotController.this.getPlot().getZaxis().isAutoRange());
                } else if (evt.getPropertyName().equals("autoRangeHints")) {
                    PlotController.this.resetZoom(PlotController.this.getPlot().getXaxis().isAutoRange(), PlotController.this.getPlot().getYaxis().isAutoRange(), PlotController.this.getPlot().getZaxis().isAutoRange());
                } else if (evt.getPropertyName().equals("range") && !evt.getNewValue().equals(evt.getOldValue())) {
                    PlotController.this.redoAutoranging();
                }
            }
        }
    };
    private PropertyChangeListener listener = new PropertyChangeListener(){

        public String toString() {
            return "" + PlotController.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "listener");
            if (evt.getSource() instanceof DasAxis) {
                DasAxis axis = (DasAxis)evt.getSource();
                Axis domAxis = PlotController.this.getDomAxis(axis);
                if (domAxis == null) {
                    return;
                }
                if (evt.getPropertyName().equals("Frame.active")) {
                    return;
                }
                if ((evt.getPropertyName().equals("units") || evt.getPropertyName().equals("datumRange")) && axis.isDrawTca() && domAxis.getLabel().length() == 0) {
                    domAxis.setLabel("%{RANGE}");
                }
                if (evt.getPropertyName().equals("units") || evt.getPropertyName().equals("datumRange") || evt.getPropertyName().equals("label")) {
                    PlotController.this.updateAxisFormatter(axis);
                }
            } else if (evt.getPropertyName().equals("focusRenderer")) {
                List<PlotElement> eles = PlotController.this.dom.controller.getPlotElementsFor(PlotController.this.plot);
                PlotElement fe = null;
                for (PlotElement ele : eles) {
                    if (ele.getController().getRenderer() != evt.getNewValue()) continue;
                    fe = ele;
                }
                if (fe != null) {
                    PlotController.this.dom.controller.setPlotElement(fe);
                }
            }
        }
    };
    private final PropertyChangeListener plotDefaultsListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "plotDefaultsListener");
            PlotElement pele = (PlotElement)evt.getSource();
            List<PlotElement> pp = PlotController.this.dom.getController().getPlotElementsFor(PlotController.this.plot);
            if (!pp.contains(pele)) {
                return;
            }
            pp.remove(pele);
            if (pele.isAutoRenderType() && pp.isEmpty()) {
                PlotController.this.setAutoBinding(true);
            }
            PlotController.this.doPlotElementDefaultsChange(pele);
        }
    };
    private final PropertyChangeListener renderTypeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "renderTypeListener");
            PlotController.this.checkRenderType();
        }
    };
    PlotElement plotElement;
    private final PropertyChangeListener plotElementDataSetListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "plotElementDataSetListener");
            if (PlotController.this.plotElement == null) {
                System.err.println("whoops, getting there");
                return;
            }
            QDataSet ds1 = ((PlotController)PlotController.this).titleConverter.plotElement != null ? ((PlotController)PlotController.this).titleConverter.plotElement.getController().getDataSet() : null;
            logger.log(Level.FINE, "titleConverter should use for dataset: {0}", ds1);
            String t = (String)PlotController.this.titleConverter.convertForward(PlotController.this.plot.getTitle());
            PlotController.this.dasPlot.setTitle(t);
            PlotController.this.dasPlot.getYAxis().setLabel((String)PlotController.this.plot.getYaxis().getController().labelConverter.convertForward(PlotController.this.plot.getYaxis().getLabel()));
            PlotController.this.dasPlot.getXAxis().setLabel((String)PlotController.this.plot.getXaxis().getController().labelConverter.convertForward(PlotController.this.plot.getXaxis().getLabel()));
            QDataSet pds = PlotController.this.plotElement.getController().getDataSet();
            logger.log(Level.FINE, "{0} dataSetListener", PlotController.this.plot);
            if (pds != null && UnitsUtil.isIntervalOrRatioMeasurement(SemanticOps.getUnits(pds))) {
                PlotController.this.updateNextPrevious(PlotController.this.plot.getXaxis().getRange(), pds);
            }
        }
    };
    protected JMenuItem plotElementPropsMenuItem = null;
    public static final String PROP_PLOTELEMENTPROPSMENUITEM = "plotElementPropsMenuItem";
    private JMenuItem[] expertMenuItems;

    public PlotController(Application dom, Plot domPlot, DasPlot dasPlot, DasColorBar colorbar) {
        this(dom, domPlot);
        this.dasPlot = dasPlot;
        this.dasColorBar = colorbar;
        dasPlot.addPropertyChangeListener(this.listener);
        dasPlot.getXAxis().addPropertyChangeListener(this.listener);
        dasPlot.getYAxis().addPropertyChangeListener(this.listener);
    }

    public PlotController(Application dom, Plot plot) {
        super(plot);
        this.dom = dom;
        this.plot = plot;
        this.plot.addPropertyChangeListener("title", this.labelListener);
        this.plot.addPropertyChangeListener("ticksURI", this.ticksURIListener);
        this.plot.addPropertyChangeListener("id", this.idListener);
        this.plot.getXaxis().addPropertyChangeListener(this.autorangeListener);
        this.plot.getYaxis().addPropertyChangeListener(this.autorangeListener);
        this.plot.getZaxis().addPropertyChangeListener(this.autorangeListener);
        dom.options.addPropertyChangeListener("dayOfYear", this.dayOfYearListener);
        dom.options.addPropertyChangeListener("mouseModule", this.mouseModuleListener);
        plot.controller = this;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public boolean isAutoBinding() {
        return this.autoBinding;
    }

    public void setAutoBinding(boolean autoBinding) {
        boolean oldAutoBinding = this.autoBinding;
        this.autoBinding = autoBinding;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTOBINDING, oldAutoBinding, autoBinding);
    }

    private void redoAutoranging() {
        boolean alwaysAutorange = false;
        if (alwaysAutorange) {
            boolean mustAutoRange;
            System.err.println(String.format("line307 %s %s %s", this.getPlot().getXaxis().isAutoRange(), this.getPlot().getYaxis().isAutoRange(), this.getPlot().getZaxis().isAutoRange()));
            boolean bl = mustAutoRange = this.getPlot().getXaxis().isAutoRange() || this.getPlot().getYaxis().isAutoRange();
            if (mustAutoRange) {
                List<PlotElement> pes = this.getApplication().getController().getPlotElementsFor(this.plot);
                for (PlotElement pe : pes) {
                    try {
                        QDataSet b = AutoplotUtil.bounds(pe.getController().getDataSet(), pe.getRenderType());
                        if (this.getPlot().getYaxis().isAutoRange()) {
                            pe.getPlotDefaults().getYaxis().setRange(DataSetUtil.asDatumRange(b.slice(1)));
                        }
                        if (!this.getPlot().getXaxis().isAutoRange()) continue;
                        pe.getPlotDefaults().getXaxis().setRange(DataSetUtil.asDatumRange(b.slice(0)));
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
                this.resetZoom(this.getPlot().getXaxis().isAutoRange(), this.getPlot().getYaxis().isAutoRange(), this.getPlot().getZaxis().isAutoRange());
            }
        }
    }

    private static boolean validBounds(QDataSet bounds) {
        QDataSet wds = DataSetUtil.weightsDataSet(bounds);
        return wds.value(0) != 0.0 && wds.value(1) != 0.0;
    }

    private void updateNextPrevious(final DatumRange dr0, QDataSet ds) {
        DatumRange dr;
        block22: {
            QDataSet ds1;
            int count;
            DatumRange limit;
            QDataSet bounds;
            int STEP_LIMIT;
            block21: {
                logger.log(Level.FINE, "updateRadius: {0}", dr0);
                if (ds != null && SemanticOps.isBundle(ds)) {
                    logger.log(Level.FINE, "unbundling: {0}", ds);
                    QDataSet xds = SemanticOps.xtagsDataSet(ds);
                    ds = ds.rank() == 2 ? Ops.unbundle(ds, ds.length(0) - 1) : SemanticOps.getDependentDataSet(ds);
                    ds = Ops.link(xds, ds);
                }
                dr = dr0;
                STEP_LIMIT = 10000;
                if (ds != null && ds.rank() > 0 && UnitsUtil.isIntervalOrRatioMeasurement(SemanticOps.getUnits(ds))) {
                    try {
                        bounds = SemanticOps.bounds(ds).slice(0);
                        if (!(PlotController.validBounds(bounds) && SemanticOps.getUnits(bounds).isConvertibleTo(dr.getUnits()) && DataSetUtil.asDatumRange(bounds).contains(dr))) {
                            dr = dr.next();
                            break block21;
                        }
                        limit = DataSetUtil.asDatumRange(bounds);
                        if (!DatumRangeUtil.isAcceptable(limit, false)) {
                            throw new IllegalArgumentException("limit is not acceptable");
                        }
                        limit = DatumRangeUtil.union(limit, dr0);
                        dr = dr.next();
                        count = 0;
                        while (dr.intersects(limit)) {
                            if (++count > STEP_LIMIT) {
                                logger.warning("step limit in nextprev https://sourceforge.net/p/autoplot/bugs/1209/");
                                dr = dr0.next();
                                break;
                            }
                            ds1 = SemanticOps.trim(ds, dr, null);
                            if (ds1 == null || ds1.length() == 0) {
                                dr = dr.next();
                                continue;
                            }
                            logger.log(Level.FINE, "found next data after {0} steps", count);
                        }
                    }
                    catch (InconvertibleUnitsException ex) {
                        logger.log(Level.FINE, ex.getMessage());
                        dr = dr.next();
                    }
                    catch (IllegalArgumentException ex) {
                        logger.log(Level.FINE, ex.getMessage());
                        dr = dr.next();
                    }
                } else {
                    dr = dr.next();
                }
            }
            this.scanNextRange = dr;
            dr = dr0;
            if (ds != null && ds.rank() > 0) {
                try {
                    bounds = SemanticOps.bounds(ds).slice(0);
                    if (!(PlotController.validBounds(bounds) && SemanticOps.getUnits(bounds).isConvertibleTo(dr.getUnits()) && DataSetUtil.asDatumRange(bounds).contains(dr))) {
                        dr = dr.previous();
                        break block22;
                    }
                    limit = DataSetUtil.asDatumRange(bounds);
                    if (!DatumRangeUtil.isAcceptable(limit, false)) {
                        throw new IllegalArgumentException("limit is not acceptable");
                    }
                    limit = DatumRangeUtil.union(limit, dr0);
                    dr = dr.previous();
                    count = 0;
                    while (dr.intersects(limit)) {
                        if (++count > STEP_LIMIT) {
                            logger.warning("step limit in nextprev https://sourceforge.net/p/autoplot/bugs/1209/");
                            dr = dr0.previous();
                            break;
                        }
                        ds1 = SemanticOps.trim(ds, dr, null);
                        if (ds1 == null || ds1.length() == 0) {
                            dr = dr.previous();
                            continue;
                        }
                        logger.log(Level.FINE, "found previous data after {0} steps", count);
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    logger.log(Level.FINE, ex.getMessage());
                    dr = dr.previous();
                }
                catch (IllegalArgumentException ex) {
                    logger.log(Level.FINE, ex.getMessage());
                    dr = dr.previous();
                }
            } else {
                dr = dr.previous();
            }
        }
        this.scanPrevRange = dr;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (PlotController.this.scanNextRange.min().equals(dr0.max())) {
                    PlotController.this.getPlot().getXaxis().getController().getDasAxis().setNextActionLabel("step >>", "<html>step to next interval<br>" + PlotController.this.scanNextRange);
                } else {
                    PlotController.this.getPlot().getXaxis().getController().getDasAxis().setNextActionLabel("scan >>", "<html>scan to <br>" + PlotController.this.scanNextRange);
                }
                if (PlotController.this.scanPrevRange.max().equals(dr0.min())) {
                    PlotController.this.getPlot().getXaxis().getController().getDasAxis().setPreviousActionLabel("<< step", "<html>step to previous interval<br>" + PlotController.this.scanPrevRange);
                } else {
                    PlotController.this.getPlot().getXaxis().getController().getDasAxis().setPreviousActionLabel("<< scan", "<html>scan to <br>" + PlotController.this.scanPrevRange);
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    protected void createDasPeer(final Canvas canvas, final Row domRow, final Column domColumn) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PlotController.this.createDasPeerImmediately(canvas, domRow, domColumn);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
    }

    private void createDasPeerImmediately(Canvas canvas, Row domRow, Column domColumn) {
        Application application = this.dom;
        DatumRange x = this.plot.xaxis.range;
        DatumRange y = this.plot.yaxis.range;
        final DasAxis xaxis = new DasAxis(x.min(), x.max(), 2);
        DasAxis yaxis = new DasAxis(y.min(), y.max(), 3);
        xaxis.setEnableHistory(false);
        yaxis.setEnableHistory(false);
        final TickleTimer nextPrevTickleTimer = new TickleTimer(300L, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DatumRange dr = xaxis.getDatumRange();
                List<PlotElement> pele = PlotController.this.getApplication().getController().getPlotElementsFor(PlotController.this.plot);
                QDataSet ds = pele.size() > 0 ? pele.get(0).getController().getDataSet() : null;
                PlotController.this.updateNextPrevious(dr, ds);
            }
        });
        xaxis.addPropertyChangeListener("datumRange", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt, "xaxis datumrange");
                if (PlotController.this.dom.getOptions().isScanEnabled()) {
                    nextPrevTickleTimer.tickle();
                }
            }
        });
        xaxis.setNextAction("scan", new AbstractAction("scannext"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                List<PlotElement> pele = PlotController.this.getApplication().getController().getPlotElementsFor(PlotController.this.plot);
                DatumRange dr = xaxis.getDatumRange();
                if (pele.isEmpty() || PlotController.this.scanNextRange == null) {
                    xaxis.setDatumRange(dr.next());
                } else {
                    dr = PlotController.this.scanNextRange;
                    if (!dr.min().equals(xaxis.getDatumRange().max())) {
                        xaxis.setAnimated(true);
                        xaxis.setDataRange(dr.min(), dr.max());
                        xaxis.setAnimated(false);
                    }
                    xaxis.setDatumRange(dr);
                }
            }
        });
        xaxis.setPreviousAction("scan", new AbstractAction("scanprev"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                List<PlotElement> pele = PlotController.this.getApplication().getController().getPlotElementsFor(PlotController.this.plot);
                DatumRange dr = xaxis.getDatumRange();
                if (pele.isEmpty() || PlotController.this.scanPrevRange == null) {
                    xaxis.setDatumRange(dr.previous());
                } else {
                    dr = PlotController.this.scanPrevRange;
                    if (xaxis.isLog() && dr.min().value() <= 0.0) {
                        logger.fine("cannot scan to non-positive with log xaxis");
                        return;
                    }
                    if (!dr.max().equals(xaxis.getDatumRange().min())) {
                        xaxis.setAnimated(true);
                        xaxis.setDataRange(dr.min(), dr.max());
                        xaxis.setAnimated(false);
                    }
                    xaxis.setDatumRange(dr);
                }
            }
        });
        if (UnitsUtil.isTimeLocation(xaxis.getUnits())) {
            xaxis.setUserDatumFormatter(new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            xaxis.setUserDatumFormatter(null);
        }
        if (UnitsUtil.isTimeLocation(yaxis.getUnits())) {
            yaxis.setUserDatumFormatter(new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            yaxis.setUserDatumFormatter(null);
        }
        this.plot.setRowId(domRow.getId());
        DasRow row = domRow.controller.getDasRow();
        this.plot.addPropertyChangeListener("rowId", this.rowColListener);
        this.plot.addPropertyChangeListener("columnId", this.rowColListener);
        DasColumn col = domColumn.controller.getDasColumn();
        DasPlot dasPlot1 = new DasPlot(xaxis, yaxis);
        dasPlot1.setPreviewEnabled(true);
        DatumRange colorRange = new DatumRange(0.0, 100.0, Units.dimensionless);
        DasColorBar colorbar = new DasColorBar(colorRange.min(), colorRange.max(), false);
        colorbar.addFocusListener(application.controller.focusAdapter);
        colorbar.setFillColor(new Color(0, true));
        colorbar.setEnableHistory(false);
        DasCanvas dasCanvas = canvas.controller.getDasCanvas();
        dasCanvas.add(dasPlot1, row, col);
        dasPlot1.getXAxis().setPlot(dasPlot1);
        dasPlot1.getYAxis().setPlot(dasPlot1);
        BoxZoomMouseModule boxmm = (BoxZoomMouseModule)dasPlot1.getDasMouseInputAdapter().getModuleByLabel("Box Zoom");
        dasPlot1.getDasMouseInputAdapter().setPrimaryModule(boxmm);
        MouseModuleType m = this.dom.getOptions().getMouseModule();
        MouseModule mm = null;
        if (null != m) {
            switch (m) {
                case boxZoom: {
                    break;
                }
                case crosshairDigitizer: {
                    mm = dasPlot1.getDasMouseInputAdapter().getModuleByLabel("Crosshair Digitizer");
                    break;
                }
                case zoomX: {
                    mm = dasPlot1.getDasMouseInputAdapter().getModuleByLabel("Zoom X");
                    break;
                }
            }
        }
        if (mm != null) {
            dasPlot1.getDasMouseInputAdapter().setPrimaryModule(mm);
        }
        MyFeedback feedback = new MyFeedback();
        dasPlot1.getDasMouseInputAdapter().setFeedback(feedback);
        dasCanvas.add(colorbar, dasPlot1.getRow(), DasColorBar.getColorBarColumn(dasPlot1.getColumn()));
        ZoomPanMouseModule zoomPan = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1, dasPlot1.getXAxis(), dasPlot1.getYAxis());
        dasPlot1.getDasMouseInputAdapter().setSecondaryModule(zoomPan);
        ZoomPanMouseModule zoomPanX = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1.getXAxis(), dasPlot1.getXAxis(), null);
        dasPlot1.getXAxis().getDasMouseInputAdapter().setSecondaryModule(zoomPanX);
        dasPlot1.getXAxis().getDasMouseInputAdapter().setFeedback(feedback);
        ZoomPanMouseModule zoomPanY = new ZoomPanMouseModule((DasCanvasComponent)dasPlot1.getYAxis(), null, dasPlot1.getYAxis());
        dasPlot1.getYAxis().getDasMouseInputAdapter().setSecondaryModule(zoomPanY);
        dasPlot1.getYAxis().getDasMouseInputAdapter().setFeedback(feedback);
        ZoomPanMouseModule zoomPanZ = new ZoomPanMouseModule((DasCanvasComponent)colorbar, null, colorbar);
        colorbar.getDasMouseInputAdapter().setSecondaryModule(zoomPanZ);
        colorbar.getDasMouseInputAdapter().setFeedback(feedback);
        dasCanvas.revalidate();
        dasCanvas.repaint();
        ApplicationController ac = application.controller;
        ac.layoutListener.listenTo(dasPlot1);
        ac.layoutListener.listenTo(colorbar);
        new AxisController(application, this.plot, this.plot.getXaxis(), xaxis);
        new AxisController(application, this.plot, this.plot.getYaxis(), yaxis);
        new AxisController(application, this.plot, this.plot.getZaxis(), colorbar);
        this.bindTo(dasPlot1);
        dasPlot1.addFocusListener(ac.focusAdapter);
        dasPlot1.getXAxis().addFocusListener(ac.focusAdapter);
        dasPlot1.getYAxis().addFocusListener(ac.focusAdapter);
        dasPlot1.addPropertyChangeListener("focusRenderer", ac.rendererFocusListener);
        ac.bind(application.getOptions(), "drawGrid", dasPlot1, "drawGrid");
        ac.bind(application.getOptions(), "drawMinorGrid", dasPlot1, "drawMinorGrid");
        ac.bind(application.getOptions(), "flipColorbarLabel", this.plot.getZaxis().getController().dasAxis, "flipLabel");
        ac.bind(application.getOptions(), "flipColorbarLabel", this.plot.getYaxis().getController().dasAxis, "flipLabel");
        ac.bind(application.getOptions(), "ticklen", dasPlot1.getXAxis(), "tickLength");
        ac.bind(application.getOptions(), "ticklen", dasPlot1.getYAxis(), "tickLength");
        ac.bind(application.getOptions(), "ticklen", colorbar, "tickLength");
        ac.bind(application.getOptions(), "multiLineTextAlignment", dasPlot1, "multiLineTextAlignment");
        ac.bind(this.plot, "legendPosition", dasPlot1, "legendPosition");
        ac.bind(this.plot, "displayLegend", dasPlot1, "displayLegend");
        ac.bind(application.getOptions(), "overRendering", dasPlot1, "overSize");
        ac.bind(this.plot, "visible", dasPlot1, "plotVisible");
        ac.bind(this.plot, "colortable", colorbar, "type");
        dasPlot1.addPropertyChangeListener(this.listener);
        dasPlot1.getXAxis().addPropertyChangeListener(this.listener);
        dasPlot1.getYAxis().addPropertyChangeListener(this.listener);
        if (this.plot.getTicksURI().length() > 0) {
            logger.fine("setLabel(%{RANGE})");
            String dasAddress = "class:org.autoplot.tca.UriTcaSource:" + this.plot.getTicksURI();
            dasPlot1.getXAxis().setDataPath(dasAddress);
            dasPlot1.getXAxis().setDrawTca(true);
            this.plot.getXaxis().setLabel("%{RANGE}");
        }
        this.dasPlot = dasPlot1;
        this.dasColorBar = colorbar;
        this.dasPlot.setEnableRenderPropertiesAction(false);
        application.controller.maybeAddContextMenus(this);
        boolean headless = "true".equals(System.getProperty("java.awt.headless"));
        if (!headless && canvas.controller.getDropTargetListener() != null) {
            DropTarget dropTarget = new DropTarget();
            dropTarget.setComponent(this.dasPlot);
            try {
                dropTarget.addDropTargetListener(canvas.controller.getDropTargetListener());
            }
            catch (TooManyListenersException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            this.dasPlot.setDropTarget(dropTarget);
        }
        this.updateAxisFormatter(dasPlot1.getXAxis());
    }

    private Axis getDomAxis(DasAxis axis) {
        Axis domAxis = this.plot.xaxis.controller.dasAxis == axis ? this.plot.xaxis : (this.plot.yaxis.controller.dasAxis == axis ? this.plot.yaxis : (this.plot.zaxis.controller.dasAxis == axis ? this.plot.zaxis : null));
        return domAxis;
    }

    private void updateAxisFormatter(DasAxis axis) {
        logger.fine("updateAxisFormatter()");
        if (UnitsUtil.isTimeLocation(axis.getUnits()) && !axis.getLabel().contains("%{RANGE}")) {
            axis.setUserDatumFormatter(new DateTimeDatumFormatter(this.dom.getController().getApplication().getOptions().isDayOfYear() ? 1 : 0));
        } else {
            TickVDescriptor.setDayOfYear(this.dom.getController().getApplication().getOptions().isDayOfYear());
            axis.setTickV(null);
            axis.setUserDatumFormatter(null);
        }
    }

    public DasColorBar getDasColorBar() {
        return this.dasColorBar;
    }

    public DasPlot getDasPlot() {
        return this.dasPlot;
    }

    private static void logCheck(Axis a) {
        if (a.isLog() && a.getRange().min().doubleValue(a.getRange().getUnits()) <= 0.0) {
            a.setLog(false);
        }
    }

    private Axis resolveSettings(Axis a1, Axis a2) {
        if (!a1.isAutoRange() && a2.isAutoRange()) {
            return a2;
        }
        if (!a2.isAutoRange() && a1.isAutoRange()) {
            return a1;
        }
        Axis result = new Axis();
        result.range = DatumRangeUtil.union(a1.range, a2.range);
        result.log = a1.log == a2.log ? a1.log : result.range.min().doubleValue(result.range.getUnits()) > 0.0;
        result.autoRange = a1.autoRange && a2.isAutoRange();
        return result;
    }

    private Axis reluctantRanging(Axis axis, Axis newSettings) {
        try {
            if (axis.getRange().rescale(-1.0, 2.0).intersects(newSettings.getRange())) {
                double d1 = DatumRangeUtil.normalize(axis.getRange(), newSettings.getRange().min(), axis.isLog());
                double d2 = DatumRangeUtil.normalize(axis.getRange(), newSettings.getRange().max(), axis.isLog());
                if (Math.abs(d2 - d1) > 0.1) {
                    return axis;
                }
                return newSettings;
            }
            return newSettings;
        }
        catch (InconvertibleUnitsException ex) {
            return newSettings;
        }
    }

    public static void doHints(Axis axis, String hintsString) {
        AxisController ac;
        Datum currentCenter;
        LinkedHashMap<String, String> hints = URISplit.parseParams(hintsString);
        DatumRange range = axis.getRange();
        boolean log = axis.isLog();
        boolean includeZero = "T".equals(hints.get("includeZero"));
        String width = (String)hints.get("width");
        String widths = (String)hints.get("widths");
        String center = (String)hints.get("center");
        String logHint = (String)hints.get("log");
        if (logHint != null && UnitsUtil.isRatioMeasurement(axis.getRange().getUnits())) {
            if (logHint.equals("T") && range.min().value() <= 0.0) {
                if (range.max().value() > 0.0) {
                    double m = range.max().value();
                    range = new DatumRange(m / 1000.0, m, range.getUnits());
                } else {
                    range = new DatumRange(1.0, 1000.0, range.getUnits());
                }
            }
            log = logHint.equals("T");
        }
        if (width != null) {
            Units u = range.getUnits().getOffsetUnits();
            try {
                Datum w;
                if (log) {
                    w = Units.log10Ratio.parse(width);
                    w = w.divide(2.0);
                    currentCenter = DatumRangeUtil.rescaleLog(range, 0.5, 0.5).min();
                    range = new DatumRange(currentCenter.divide(Math.pow(10.0, w.value())), currentCenter.multiply(Math.pow(10.0, w.value())));
                } else {
                    w = u.parse(width);
                    w = w.divide(2.0);
                    currentCenter = DatumRangeUtil.rescale(range, 0.5, 0.5).min();
                    range = new DatumRange(currentCenter.subtract(w), currentCenter.add(w));
                }
            }
            catch (ParseException | InconvertibleUnitsException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        if (widths != null) {
            String[] wss = widths.split("\\,");
            Datum limit = log ? Units.log10Ratio.createDatum(Math.log10(range.max().divide(range.min()).value())) : range.width();
            Units u = range.getUnits().getOffsetUnits();
            for (String ws : wss) {
                try {
                    Datum w;
                    if (log) {
                        w = Units.log10Ratio.parse(ws);
                        if (!w.gt(limit) && !ws.equals(wss[wss.length - 1])) continue;
                        w = w.divide(2.0);
                        Datum currentCenter2 = DatumRangeUtil.rescaleLog(range, 0.5, 0.5).min();
                        range = new DatumRange(currentCenter2.divide(Math.pow(10.0, w.value())), currentCenter2.multiply(Math.pow(10.0, w.value())));
                        break;
                    }
                    w = u.parse(ws);
                    if (!w.gt(limit) && !ws.equals(wss[wss.length - 1])) continue;
                    w = w.divide(2.0);
                    Datum currentCenter3 = DatumRangeUtil.rescale(range, 0.5, 0.5).min();
                    range = new DatumRange(currentCenter3.subtract(w), currentCenter3.add(w));
                    break;
                }
                catch (ParseException | InconvertibleUnitsException ex) {
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
        if (includeZero && UnitsUtil.isRatioMeasurement(range.getUnits())) {
            Datum z = range.getUnits().createDatum(0);
            if (widths == null && width == null) {
                range = DatumRangeUtil.union(range, z);
            } else if (range.min().value() > 0.0) {
                double n = DatumRangeUtil.normalize(range, z);
                range = DatumRangeUtil.rescale(range, n, n + 1.0);
            } else if (range.max().value() < 0.0) {
                double n = DatumRangeUtil.normalize(range, z);
                range = DatumRangeUtil.rescale(range, n - 1.0, n);
            }
        }
        if (center != null) {
            Units u = range.getUnits();
            try {
                if (log) {
                    double w = Math.log10(range.max().divide(range.min()).value());
                    Datum currentCenter4 = u.parse(center);
                    range = new DatumRange(currentCenter4.divide(Math.pow(10.0, w /= 2.0)), currentCenter4.multiply(Math.pow(10.0, w)));
                } else {
                    Datum w = range.width();
                    w = w.divide(2.0);
                    currentCenter = u.parse(center);
                    range = new DatumRange(currentCenter.subtract(w), currentCenter.add(w));
                }
            }
            catch (ParseException | InconvertibleUnitsException ex) {
                logger.log(Level.WARNING, null, ex);
            }
        }
        if ((ac = axis.getController()) != null) {
            ac.setRangeAutomatically(range, log);
        } else {
            axis.setRange(range);
            axis.setLog(log);
        }
    }

    public void resetZoom(boolean x, boolean y, boolean z) {
        Axis newAxis;
        List<PlotElement> elements = this.dom.controller.getPlotElementsFor(this.plot);
        if (elements.isEmpty()) {
            return;
        }
        Plot newSettings = null;
        boolean haveTsb = false;
        boolean warnedAboutUnits = false;
        for (PlotElement p : elements) {
            DataSourceFilter dsf;
            block24: {
                Plot plot1 = p.getPlotDefaults();
                if (newSettings == null) {
                    newSettings = (Plot)plot1.copy();
                } else {
                    block23: {
                        block22: {
                            try {
                                newSettings.xaxis = this.resolveSettings(newSettings.xaxis, plot1.getXaxis());
                            }
                            catch (InconvertibleUnitsException ex) {
                                if (warnedAboutUnits) break block22;
                                logger.log(Level.FINE, "plot elements on the same xaxis have inconsistent units: {0} {1}", new Object[]{newSettings.xaxis.range.getUnits().toString(), plot1.getXaxis().getRange().getUnits().toString()});
                                warnedAboutUnits = true;
                            }
                        }
                        try {
                            newSettings.yaxis = this.resolveSettings(newSettings.yaxis, plot1.getYaxis());
                        }
                        catch (InconvertibleUnitsException ex) {
                            if (warnedAboutUnits) break block23;
                            logger.log(Level.FINE, "plot elements on the same yaxis have inconsistent units: {0} {1}", new Object[]{newSettings.yaxis.range.getUnits().toString(), plot1.getYaxis().getRange().getUnits().toString()});
                            warnedAboutUnits = true;
                        }
                    }
                    try {
                        newSettings.zaxis = this.resolveSettings(newSettings.zaxis, plot1.getZaxis());
                    }
                    catch (InconvertibleUnitsException ex) {
                        if (warnedAboutUnits) break block24;
                        logger.log(Level.FINE, "plot elements on the same zaxis have inconsistent units: {0} {1}", new Object[]{newSettings.zaxis.range.getUnits().toString(), plot1.getZaxis().getRange().getUnits().toString()});
                        warnedAboutUnits = true;
                    }
                }
            }
            if ((dsf = this.dom.controller.getDataSourceFilterFor(p)) == null || dsf.getController() == null || dsf.getController().getTsb() == null) continue;
            haveTsb = true;
        }
        if (newSettings == null) {
            this.plot.getXaxis().setAutoRange(true);
            this.plot.getYaxis().setAutoRange(true);
            this.plot.getZaxis().setAutoRange(true);
            return;
        }
        if (x) {
            PlotController.logCheck(newSettings.getXaxis());
            newAxis = newSettings.getXaxis();
            if (this.plot.getXaxis().getAutoRangeHints().length() > 0) {
                PlotController.doHints(newAxis, this.plot.getXaxis().getAutoRangeHints());
            }
            if (this.dom.options.getAutorangeType().equals("reluctant")) {
                newAxis = this.reluctantRanging(this.plot.getXaxis(), newAxis);
            }
            this.plot.getXaxis().setLog(newAxis.isLog());
            this.plot.getXaxis().setRange(newAxis.getRange());
            this.plot.getXaxis().setAutoRange(true);
            if (haveTsb) {
                this.plot.getXaxis().getController().dasAxis.setScanRange(null);
            } else {
                this.plot.getXaxis().getController().dasAxis.setScanRange(this.plot.getXaxis().getRange());
            }
        }
        if (y) {
            PlotController.logCheck(newSettings.getYaxis());
            newAxis = newSettings.getYaxis();
            if (this.plot.getYaxis().getAutoRangeHints().length() > 0) {
                PlotController.doHints(newAxis, this.plot.getYaxis().getAutoRangeHints());
            }
            if (this.dom.options.getAutorangeType().equals("reluctant")) {
                newAxis = this.reluctantRanging(this.plot.getYaxis(), newAxis);
            }
            this.plot.getYaxis().setLog(newAxis.isLog());
            this.plot.getYaxis().setRange(newAxis.getRange());
            this.plot.getYaxis().setAutoRange(true);
            this.plot.getYaxis().getController().dasAxis.setScanRange(newAxis.getRange());
        }
        if (z) {
            PlotController.logCheck(newSettings.getZaxis());
            newAxis = newSettings.getZaxis();
            if (this.plot.getZaxis().getAutoRangeHints().length() > 0) {
                PlotController.doHints(newAxis, this.plot.getZaxis().getAutoRangeHints());
            }
            if (this.dom.options.getAutorangeType().equals("reluctant")) {
                newAxis = this.reluctantRanging(this.plot.getZaxis(), newAxis);
            }
            this.plot.getZaxis().setLog(newAxis.isLog());
            this.plot.getZaxis().setRange(newAxis.getRange());
            this.plot.getZaxis().setAutoRange(true);
            this.plot.getZaxis().getController().dasAxis.setScanRange(newAxis.getRange());
        }
    }

    private void checkRenderType() {
        if (this.dom.getController().isValueAdjusting()) {
            return;
        }
        boolean needsColorbar = false;
        for (PlotElement p : this.dom.getController().getPlotElementsFor(this.plot)) {
            if (!RenderTypeUtil.needsColorbar(p.getRenderType())) continue;
            needsColorbar = true;
        }
        this.plot.getZaxis().setVisible(needsColorbar);
    }

    void addPlotElement(PlotElement p) {
        this.addPlotElement(p, true);
    }

    synchronized List<Integer> indecesOfPlotElements() {
        ArrayList<Integer> indeces = new ArrayList<Integer>(this.dom.plotElements.size());
        for (int i = 0; i < this.dom.plotElements.size(); ++i) {
            if (!this.dom.getPlotElements(i).getPlotId().equals(this.plot.getId())) continue;
            indeces.add(i);
        }
        return indeces;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void moveToStackBottom(PlotElement p) {
        ChangesSupport.DomLock lock = this.dom.getController().mutatorLock();
        lock.lock("Move to Stack Bottom");
        try {
            int ploc;
            int bottom;
            if (!p.getPlotId().equals(this.plot.getId())) {
                throw new IllegalArgumentException("this is not my plot");
            }
            PlotElement[] newPes = this.dom.getPlotElements();
            for (bottom = 0; bottom < newPes.length && !newPes[bottom].getPlotId().equals(p.getPlotId()); ++bottom) {
            }
            for (ploc = 0; ploc < newPes.length && newPes[ploc] != p; ++ploc) {
            }
            if (ploc > bottom) {
                for (int i = ploc; i > bottom; --i) {
                    newPes[i] = newPes[i - 1];
                }
                newPes[bottom] = p;
            }
            this.dom.setPlotElements(newPes);
        }
        finally {
            lock.unlock();
        }
    }

    public void toBottom(PlotElement p) {
        this.moveToStackBottom(p);
        DasPlot pp = p.getController().getDasPlot();
        Renderer r = p.getController().getRenderer();
        pp.removeRenderer(r);
        pp.addRenderer(0, r);
    }

    public void toTop(PlotElement p) {
        this.moveToStackTop(p);
        DasPlot pp = p.getController().getDasPlot();
        Renderer r = p.getController().getRenderer();
        pp.removeRenderer(r);
        pp.addRenderer(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void moveToStackTop(PlotElement p) {
        ChangesSupport.DomLock lock = this.dom.getController().mutatorLock();
        lock.lock("Move to Stack Top");
        try {
            int ploc;
            int top;
            if (!p.getPlotId().equals(this.plot.getId())) {
                throw new IllegalArgumentException("this is not my plot");
            }
            PlotElement[] newPes = this.dom.getPlotElements();
            for (top = newPes.length - 1; top >= 0 && !newPes[top].getPlotId().equals(p.getPlotId()); --top) {
            }
            for (ploc = 0; ploc < newPes.length && newPes[ploc] != p; ++ploc) {
            }
            if (ploc < top) {
                for (int i = ploc; i < top; ++i) {
                    newPes[i] = newPes[i + 1];
                }
                newPes[top] = p;
            }
            this.dom.setPlotElements(newPes);
        }
        finally {
            lock.unlock();
        }
    }

    void bindPEToColorbar(PlotElement pe) {
        if (this.plot == null) {
            throw new NullPointerException("plotController.plot is null");
        }
        if (pe.style == null) {
            throw new NullPointerException("Style pe.style is null");
        }
        this.dom.controller.bind(pe.style, "colortable", this.plot, "colortable");
    }

    synchronized void addPlotElement(PlotElement p, boolean reset) {
        boolean toTop;
        if (p == null) {
            throw new NullPointerException("PlotElement p is null");
        }
        Renderer rr = p.controller.getRenderer();
        if (rr instanceof SpectrogramRenderer) {
            ((SpectrogramRenderer)rr).setColorBar(this.getDasColorBar());
        } else if (rr instanceof SeriesRenderer) {
            ((SeriesRenderer)rr).setColorBar(this.getDasColorBar());
        }
        this.bindPEToColorbar(p);
        boolean bl = toTop = rr != null && !(rr instanceof SpectrogramRenderer);
        if (rr != null) {
            if (!toTop) {
                this.dasPlot.addRenderer(0, rr);
            } else {
                this.dasPlot.addRenderer(rr);
            }
        }
        RenderType rt = p.getRenderType();
        p.plotId = this.plot.getId();
        if (reset) {
            p.controller.doResetRenderType(rt);
        }
        if (!this.dom.controller.isValueAdjusting()) {
            this.doPlotElementDefaultsChange(p);
        } else {
            if (this.plotElement != null) {
                this.plotElement.getController().removePropertyChangeListener("dataSet", this.plotElementDataSetListener);
            }
            this.plotElement = p;
            p.getController().addPropertyChangeListener("dataSet", this.plotElementDataSetListener);
        }
        if (!this.pdListen.contains(p)) {
            p.addPropertyChangeListener("plotDefaults", this.plotDefaultsListener);
            p.addPropertyChangeListener("renderType", this.renderTypeListener);
            this.pdListen.add(p);
        }
        p.setPlotId(this.plot.getId());
        this.checkRenderType();
        if (rr != null && toTop) {
            this.moveToStackTop(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot contextOverview() {
        Plot that;
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Context Overview");
        try {
            double nmax;
            double nmin;
            Plot domPlot = this.plot;
            ApplicationController controller = this.dom.getController();
            that = controller.copyPlotAndPlotElements(domPlot, null, false, false);
            that.setTitle("");
            controller.bind(domPlot.getYaxis(), "log", that.getYaxis(), "log");
            controller.bind(domPlot.getZaxis(), "range", that.getZaxis(), "range");
            controller.bind(domPlot.getZaxis(), "log", that.getZaxis(), "log");
            controller.bind(domPlot.getZaxis(), "label", that.getZaxis(), "label");
            controller.addConnector(domPlot, that);
            controller.setPlot(that);
            AutoplotUtil.resetZoomY(this.dom);
            if (domPlot.getYaxis().isLog()) {
                nmin = DatumRangeUtil.normalizeLog(that.getYaxis().getRange(), domPlot.getYaxis().getRange().min());
                nmax = DatumRangeUtil.normalizeLog(that.getYaxis().getRange(), domPlot.getYaxis().getRange().max());
            } else {
                nmin = DatumRangeUtil.normalize(that.getYaxis().getRange(), domPlot.getYaxis().getRange().min());
                nmax = DatumRangeUtil.normalize(that.getYaxis().getRange(), domPlot.getYaxis().getRange().max());
            }
            if (nmax - nmin > 0.9) {
                that.getYaxis().setRange(domPlot.getYaxis().getRange());
            }
            AutoplotUtil.resetZoomX(this.dom);
        }
        finally {
            lock.unlock();
        }
        return that;
    }

    private void removeBindingsPEToColorbar(PlotElement pe) {
        this.dom.controller.unbind(pe.style, "colortable", this.plot, "colortable");
    }

    synchronized void removePlotElement(PlotElement p) {
        Renderer rr = p.controller.getRenderer();
        if (rr != null && this.dasPlot.containsRenderer(rr)) {
            this.dasPlot.removeRenderer(rr);
        }
        if (rr instanceof SpectrogramRenderer) {
            ((SpectrogramRenderer)rr).setColorBar(null);
        } else if (rr instanceof SeriesRenderer) {
            ((SeriesRenderer)rr).setColorBar(null);
        }
        this.doPlotElementDefaultsChange(null);
        p.removePropertyChangeListener("plotDefaults", this.plotDefaultsListener);
        p.removePropertyChangeListener("renderType", this.renderTypeListener);
        this.removeBindingsPEToColorbar(p);
        this.pdListen.remove(p);
        if (!p.getPlotId().equals("")) {
            p.setPlotId("");
        }
        this.checkRenderType();
    }

    private Plot getPlotDefaultsOneFamily(List<PlotElement> pes) {
        Plot result = null;
        if (pes.size() > 0) {
            result = pes.get(0).getPlotDefaults();
        }
        return result;
    }

    private void doPlotElementDefaultsChange(PlotElement pele) {
        List<PlotElement> pes;
        BindingModel existingBinding;
        List<BindingModel> bms;
        if (pele != null && this.isAutoBinding()) {
            this.doCheckBindings(this.plot, pele.getPlotDefaults());
        }
        if ((bms = this.dom.getController().findBindings(this.dom, "timeRange", null, "range")).contains(existingBinding = this.dom.getController().findBinding(this.dom, "timeRange", this.plot.xaxis, "range")) && bms.size() > 1) {
            this.plot.getXaxis().setAutoRange(false);
        }
        if (DomUtil.oneFamily(pes = this.dom.getController().getPlotElementsFor(this.plot))) {
            Plot defaults = this.getPlotDefaultsOneFamily(pes);
            PlotElement p = pes.get(0);
            if (!this.plot.controller.getApplication().getController().isValueAdjusting()) {
                if (!this.dom.getController().isBoundAxis(this.plot.getXaxis()) && !defaults.getXaxis().getRange().getUnits().isConvertibleTo(this.plot.getXaxis().getRange().getUnits())) {
                    this.plot.getXaxis().setAutoRange(true);
                }
                if (!this.dom.getController().isBoundAxis(this.plot.getYaxis()) && !defaults.getYaxis().getRange().getUnits().isConvertibleTo(this.plot.getYaxis().getRange().getUnits())) {
                    this.plot.getYaxis().setAutoRange(true);
                }
                if (!this.dom.getController().isBoundAxis(this.plot.getZaxis()) && !defaults.getZaxis().getRange().getUnits().isConvertibleTo(this.plot.getZaxis().getRange().getUnits())) {
                    this.plot.getZaxis().setAutoRange(true);
                }
            } else {
                logger.fine("value is adjusting, no reset autorange");
            }
            if (this.plotElement != null) {
                this.plotElement.getController().removePropertyChangeListener("dataSet", this.plotElementDataSetListener);
            }
            this.plotElement = p;
            this.plotElement.getController().addPropertyChangeListener("dataSet", this.plotElementDataSetListener);
            if (defaults != null) {
                if (this.plot.isAutoLabel()) {
                    this.plot.getController().setTitleAutomatically(defaults.getTitle());
                }
                if (this.plot.getXaxis().isAutoLabel() && defaults.getXaxis().isAutoLabel()) {
                    this.plot.getXaxis().getController().setLabelAutomatically(defaults.getXaxis().getLabel());
                }
                if (this.plot.getYaxis().isAutoLabel() && defaults.getYaxis().isAutoLabel()) {
                    this.plot.getYaxis().getController().setLabelAutomatically(defaults.getYaxis().getLabel());
                }
                if (this.plot.getZaxis().isAutoLabel() && defaults.getZaxis().isAutoLabel()) {
                    this.plot.getZaxis().getController().setLabelAutomatically(defaults.getZaxis().getLabel());
                }
                if (this.plot.getXaxis().isAutoRange() && this.plot.getYaxis().isAutoRange()) {
                    this.plot.setIsotropic(defaults.isIsotropic());
                }
            } else {
                if (this.plot.isAutoLabel()) {
                    this.plot.getController().setTitleAutomatically(p.getPlotDefaults().getTitle());
                }
                if (this.plot.getXaxis().isAutoLabel()) {
                    this.plot.getXaxis().getController().setLabelAutomatically("");
                }
                if (this.plot.getYaxis().isAutoLabel()) {
                    this.plot.getYaxis().getController().setLabelAutomatically("");
                }
                if (this.plot.getZaxis().isAutoLabel()) {
                    this.plot.getZaxis().getController().setLabelAutomatically("");
                }
            }
        }
        if (this.dom.getOptions().isAutoranging()) {
            this.resetZoom(this.plot.getXaxis().isAutoRange() && pele != null && pele.getPlotDefaults().getXaxis().isAutoRange(), this.plot.getYaxis().isAutoRange(), this.plot.getZaxis().isAutoRange());
        }
    }

    protected void doPlotElementDefaultsUnitsChange(PlotElement e) {
        boolean auto;
        DatumRange dr;
        DatumRange elerange = e.getPlotDefaults().getXaxis().getRange();
        DatumRange range = this.plot.getXaxis().getRange();
        if (elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation(elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid("2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            auto = this.plot.getXaxis().autoRange;
            this.plot.getXaxis().setRange(dr);
            this.plot.getXaxis().setAutoRange(auto);
        }
        elerange = e.getPlotDefaults().getYaxis().getRange();
        range = this.plot.getYaxis().getRange();
        if (!UnitsUtil.isTimeLocation(elerange.getUnits()) && elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation(elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid("2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            auto = this.plot.getYaxis().autoRange;
            this.plot.getYaxis().setRange(dr);
            this.plot.getYaxis().setAutoRange(auto);
        }
        elerange = e.getPlotDefaults().getZaxis().getRange();
        range = this.plot.getZaxis().getRange();
        if (!UnitsUtil.isTimeLocation(elerange.getUnits()) && elerange.getUnits() != range.getUnits() && range.getUnits() == Units.dimensionless) {
            dr = UnitsUtil.isTimeLocation(elerange.getUnits()) ? DatumRangeUtil.parseTimeRangeValid("2010-01-01") : new DatumRange(range.min().doubleValue(Units.dimensionless), range.max().doubleValue(Units.dimensionless), elerange.getUnits());
            auto = this.plot.getZaxis().autoRange;
            this.plot.getZaxis().setRange(dr);
            this.plot.getZaxis().setAutoRange(auto);
        }
    }

    private boolean shouldBindX(Axis newSettingsXaxis) {
        boolean shouldBindX = false;
        DatumRange xrange = newSettingsXaxis.getRange();
        if (this.dom.timeRange.getUnits().isConvertibleTo(xrange.getUnits()) && UnitsUtil.isTimeLocation(xrange.getUnits())) {
            if (this.dom.controller.isConnected(this.plot)) {
                logger.log(Level.FINER, "not binding because plot is connected: {0}", this.plot);
            } else if (this.dom.timeRange.intersects(xrange)) {
                try {
                    double reqOverlap = UnitsUtil.isTimeLocation(this.dom.timeRange.getUnits()) ? 0.01 : 0.8;
                    DatumRange droverlap = DatumRangeUtil.sloppyIntersection(xrange, this.dom.timeRange);
                    double overlap = droverlap.width().divide(this.dom.timeRange.width()).doubleValue(Units.dimensionless);
                    if (overlap > 1.0) {
                        overlap = 1.0 / overlap;
                    }
                    if (overlap > reqOverlap) {
                        shouldBindX = true;
                        logger.log(Level.FINER, "binding axis because there is significant overlap dom.timerange={0}", this.dom.timeRange.toString());
                        this.dom.getController().setStatus("binding axis because there is significant overlap");
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    shouldBindX = false;
                }
                catch (IllegalArgumentException ex) {
                    shouldBindX = false;
                }
            }
        }
        return shouldBindX;
    }

    private void doCheckBindings(Plot plot, Plot newSettings) {
        List<BindingModel> b;
        logger.entering("org.virbo.autoplot.PlotController", "doCheckBindings");
        boolean shouldBindX = false;
        boolean shouldSetAxisRange = false;
        List<BindingModel> bms = this.dom.getController().findBindings(this.dom, "timeRange", null, "range");
        BindingModel bm = this.dom.getController().findBinding(this.dom, "timeRange", plot.getXaxis(), "range");
        if (bm != null) {
            bms.remove(bm);
        }
        if (!plot.isAutoBinding()) {
            return;
        }
        boolean needToAutorangeAfterAll = false;
        if (!plot.getXaxis().isAutoRange()) {
            boolean bl = shouldBindX = bm != null;
            if (bm != null && !newSettings.getXaxis().getRange().getUnits().isConvertibleTo(plot.getXaxis().getRange().getUnits())) {
                shouldBindX = false;
                logger.finer("remove timerange binding that would cause inconvertable units");
            }
            if (!shouldBindX) {
                shouldBindX = this.shouldBindX(newSettings.getXaxis());
            }
            boolean bl2 = needToAutorangeAfterAll = UnitsUtil.isTimeLocation(plot.getXaxis().getRange().getUnits()) && !shouldBindX;
        }
        if (!newSettings.getXaxis().isLog() && (needToAutorangeAfterAll || plot.getXaxis().isAutoRange())) {
            if (bms.isEmpty() && UnitsUtil.isTimeLocation(newSettings.getXaxis().getRange().getUnits())) {
                logger.finer("binding axis to timeRange because no one is using it");
                DatumRange tr = plot.getXaxis().getRange();
                if (UnitsUtil.isTimeLocation(tr.getUnits())) {
                    this.dom.setTimeRange(tr);
                } else {
                    this.dom.setTimeRange(newSettings.getXaxis().getRange());
                }
                shouldBindX = true;
                shouldSetAxisRange = true;
            }
            if (!plot.getXaxis().isAutoRange()) {
                plot.getXaxis().setAutoRange(true);
            }
            shouldBindX = this.shouldBindX(newSettings.getXaxis());
        }
        if (shouldBindX && !plot.getColumnId().equals(this.dom.getCanvases(0).getMarginColumn().getId())) {
            logger.log(Level.FINER, "not binding because plot is not attached to marginRow: {0}", plot.getXaxis());
            shouldBindX = false;
            this.dom.getController().setStatus("not binding axis because plot is not attached to marginRow");
        }
        if (bm == null && shouldBindX) {
            logger.log(Level.FINER, "add binding: {0}", plot.getXaxis());
            plot.getXaxis().setLog(false);
            this.dom.getController().bind(this.dom, "timeRange", plot.getXaxis(), "range");
            b = this.dom.getController().findBinding(this.dom, "timeRange", plot, "context");
            if (b != null) {
                this.dom.getController().deleteBinding((BindingModel)((Object)b));
            }
        } else if (bm != null && !shouldBindX) {
            logger.log(Level.FINER, "remove binding: {0}", bm);
            plot.setContext(this.dom.getTimeRange());
            this.dom.getController().deleteBinding(bm);
        }
        if (needToAutorangeAfterAll) {
            plot.getXaxis().setAutoRange(true);
        }
        if (!shouldBindX) {
            b = this.dom.getController().findBindings(this.dom, "timeRange");
            if (b.isEmpty() && UnitsUtil.isTimeLocation(plot.getContext().getUnits())) {
                DatumRange dr = plot.getContext();
                this.dom.setTimeRange(dr);
            }
            this.dom.getController().bind(this.dom, "timeRange", plot, "context");
        }
        plot.setAutoBinding(false);
    }

    void deleteDasPeer() {
        final DasPlot p = this.getDasPlot();
        final DasColorBar cb = this.getDasColorBar();
        final DasCanvas c = p.getCanvas();
        p.getDasMouseInputAdapter().setFeedback(null);
        if (c != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    c.remove(p);
                    c.remove(cb);
                }
            });
        }
    }

    private synchronized void bindTo(DasPlot p) {
        ApplicationController ac = this.dom.controller;
        this.titleConverter = new LabelConverter(this.dom, this.plot, null, null, null);
        ac.bind(this.plot, "title", p, "title", this.titleConverter);
        Converter plotContextConverter = new Converter(){

            public Object convertForward(Object s) {
                if (s == Application.DEFAULT_TIME_RANGE) {
                    return null;
                }
                return s;
            }

            public Object convertReverse(Object t) {
                if (t == null) {
                    return Application.DEFAULT_TIME_RANGE;
                }
                return t;
            }
        };
        ac.bind(this.plot, "context", p, "context", plotContextConverter);
        ac.bind(this.plot, "isotropic", p, "isotropic");
        ac.bind(this.plot, "displayTitle", p, "displayTitle");
        ac.bind(this.plot, "displayLegend", p, "displayLegend");
        ac.bind(this.plot, "fontSize", p, "fontSize");
        ac.bind(this.dom.options, "printingLogLevel", p, "printingLogLevel");
        ac.bind(this.dom.options, "displayLogLevel", p, "logLevel");
        ac.bind(this.dom.options, "logMessageTimeoutSec", p, "logTimeoutSec");
    }

    protected void removeBindings() {
        ApplicationController ac = this.dom.controller;
        DasPlot p = this.dasPlot;
        ac.unbind(this.dom.options, "drawGrid", p, "drawGrid");
        ac.unbind(this.dom.options, "drawMinorGrid", p, "drawMinorGrid");
        ac.unbind(this.dom.options, "flipColorbarLabel", this.plot.getZaxis().getController().dasAxis, "flipLabel");
        ac.unbind(this.dom.options, "flipColorbarLabel", this.plot.getYaxis().getController().dasAxis, "flipLabel");
        ac.unbind(this.dom.options, "ticklen", p.getXAxis(), "tickLength");
        ac.unbind(this.dom.options, "ticklen", p.getYAxis(), "tickLength");
        ac.unbind(this.dom.options, "ticklen", this.dasColorBar, "tickLength");
        ac.unbind(this.dom.options, "multiLineTextAlignment", p, "multiLineTextAlignment");
        ac.unbind(this.dom.options, "printingLogLevel", p, "printingLogLevel");
        ac.unbind(this.dom.options, "displayLogLevel", p, "logLevel");
        ac.unbind(this.dom.options, "logMessageTimeoutSec", p, "logTimeoutSec");
        ac.unbind(this.dom.options, "overRendering", p, "overSize");
        this.dom.options.removePropertyChangeListener("dayOfYear", this.dayOfYearListener);
        this.dom.options.removePropertyChangeListener("mouseModule", this.mouseModuleListener);
    }

    public BindingModel[] getBindings() {
        return this.dom.controller.getBindingsFor(this.plot);
    }

    public BindingModel getBindings(int index) {
        return this.getBindings()[index];
    }

    public JMenuItem getPlotElementPropsMenuItem() {
        return this.plotElementPropsMenuItem;
    }

    public void setPlotElementPropsMenuItem(JMenuItem pelePropsMenuItem) {
        JMenuItem old = this.plotElementPropsMenuItem;
        this.plotElementPropsMenuItem = pelePropsMenuItem;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOTELEMENTPROPSMENUITEM, old, pelePropsMenuItem);
    }

    public Application getApplication() {
        return this.dom;
    }

    public String toString() {
        return this.plot + " controller";
    }

    public void setTitleAutomatically(String title) {
        this.plot.setTitle(title);
        this.plot.setAutoLabel(true);
    }

    public void setExpertMenuItems(JMenuItem[] items) {
        this.expertMenuItems = Arrays.copyOf(items, items.length);
    }

    public JMenuItem[] getExpertMenuItems() {
        return Arrays.copyOf(this.expertMenuItems, this.expertMenuItems.length);
    }

    public void setExpertMode(boolean expert) {
        for (JMenuItem mi : this.expertMenuItems) {
            mi.setVisible(expert);
        }
    }

    public Row getRow() {
        return this.dom.canvases.get(0).getController().getRowFor(this.plot);
    }

    public Column getColumn() {
        return this.dom.canvases.get(0).getController().getColumnFor(this.plot);
    }

    private class MyFeedback
    implements DasMouseInputAdapter.Feedback {
        String myLastMessage = "";
        String otherLastMessage = "";

        private MyFeedback() {
        }

        @Override
        public void setMessage(String message) {
            if (message.equals("")) {
                if (PlotController.this.getApplication().getController().getStatus().equals(this.myLastMessage)) {
                    PlotController.this.getApplication().getController().setStatus(this.otherLastMessage);
                }
            } else {
                this.otherLastMessage = PlotController.this.getApplication().getController().getStatus();
                PlotController.this.getApplication().getController().setStatus(message);
            }
            this.myLastMessage = message;
        }
    }
}

