/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.autoplot.MouseModuleType;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Options;
import org.autoplot.util.TickleTimer;
import org.das2.util.LoggerManager;

public class OptionsPrefsController {
    Preferences prefs;
    Options options;
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom");
    TickleTimer flushTimer = new TickleTimer(300L, new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "flushTimer");
            try {
                OptionsPrefsController.this.prefs.flush();
            }
            catch (BackingStoreException ex) {
                logger.log(Level.FINE, ex.getMessage(), ex);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    OptionsPrefsController.this.prefs.flush();
                }
                catch (BackingStoreException ex1) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex1);
                }
            }
        }
    });
    PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "listener");
            if (evt.getPropertyName().equals("id")) {
                return;
            }
            if (evt.getNewValue() instanceof String) {
                OptionsPrefsController.this.prefs.put(evt.getPropertyName(), (String)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Boolean) {
                OptionsPrefsController.this.prefs.putBoolean(evt.getPropertyName(), (Boolean)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Color) {
                OptionsPrefsController.this.prefs.put(evt.getPropertyName(), DomUtil.encodeColor((Color)evt.getNewValue()));
            } else if (evt.getNewValue() instanceof Enum) {
                OptionsPrefsController.this.prefs.put(evt.getPropertyName(), evt.getNewValue().toString());
            } else if (evt.getNewValue() instanceof Level) {
                OptionsPrefsController.this.prefs.put(evt.getPropertyName(), evt.getNewValue().toString());
            } else if (evt.getNewValue() instanceof Integer) {
                OptionsPrefsController.this.prefs.putInt(evt.getPropertyName(), (Integer)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Double) {
                OptionsPrefsController.this.prefs.putDouble(evt.getPropertyName(), (Double)evt.getNewValue());
            } else if (evt.getNewValue() instanceof Float) {
                OptionsPrefsController.this.prefs.putFloat(evt.getPropertyName(), ((Float)evt.getNewValue()).floatValue());
            } else {
                throw new RuntimeException("unsupported property type needs to be implemented: " + evt.getPropertyName() + "  " + evt.getNewValue().getClass());
            }
            logger.log(Level.FINE, "options node change requires flush: {0}={1}", new Object[]{evt.getPropertyName(), evt.getNewValue().toString()});
            OptionsPrefsController.this.flushTimer.tickle();
        }
    };

    public OptionsPrefsController(Options options) {
        this.prefs = AutoplotSettings.settings().getPreferences(options.getClass());
        this.options = options;
        options.addPropertyChangeListener(this.listener);
    }

    public void loadPreferencesWithEvents() {
        this.options.setAutolabelling(this.prefs.getBoolean("autolabelling", this.options.autolabelling));
        this.options.setAutolayout(this.prefs.getBoolean("autolayout", this.options.autolayout));
        this.options.setAutoranging(this.prefs.getBoolean("autoranging", this.options.autoranging));
        if (!this.options.autoranging) {
            System.err.println("Autorange default was false, enabling it now.");
            this.options.setAutoranging(true);
        }
        if (!this.options.autolayout) {
            System.err.println("Autolayout default was false, enabling it now.");
            this.options.setAutolayout(true);
        }
        if (!this.options.autolabelling) {
            System.err.println("Autolabelling default was false, enabling it now.");
            this.options.setAutolabelling(true);
        }
        this.options.setBackground(Color.decode(this.prefs.get("background", DomUtil.encodeColor(this.options.background))));
        this.options.setCanvasFont(this.prefs.get("canvasFont", this.options.canvasFont));
        this.options.setColor(Color.decode(this.prefs.get("color", DomUtil.encodeColor(this.options.color))));
        this.options.setDrawAntiAlias(this.prefs.getBoolean("drawAntiAlias", this.options.drawAntiAlias));
        this.options.setDrawGrid(this.prefs.getBoolean("drawGrid", this.options.drawGrid));
        this.options.setDrawMinorGrid(this.prefs.getBoolean("drawMinorGrid", this.options.drawMinorGrid));
        this.options.setFillColor(Color.decode(this.prefs.get("fillColor", DomUtil.encodeColor(this.options.fillColor))));
        this.options.setForeground(Color.decode(this.prefs.get("foreground", DomUtil.encodeColor(this.options.foreground))));
        this.options.setLogConsoleVisible(this.prefs.getBoolean("logConsoleVisible", this.options.logConsoleVisible));
        this.options.setOverRendering(this.prefs.getBoolean("overRendering", this.options.overRendering));
        this.options.setScriptVisible(this.prefs.getBoolean("scriptVisible", this.options.scriptVisible));
        this.options.setDataVisible(this.prefs.getBoolean("dataVisible", this.options.dataVisible));
        this.options.setLayoutVisible(this.prefs.getBoolean("layoutVisible", this.options.layoutVisible));
        this.options.setServerEnabled(this.prefs.getBoolean("serverEnabled", this.options.serverEnabled));
        this.options.setSpecialEffects(this.prefs.getBoolean("specialEffects", this.options.specialEffects));
        this.options.setTextAntiAlias(this.prefs.getBoolean("textAntiAlias", this.options.textAntiAlias));
        this.options.setDayOfYear(this.prefs.getBoolean("dayOfYear", this.options.dayOfYear));
        this.options.setNearestNeighbor(this.prefs.getBoolean("nearestNeighbor", this.options.nearestNeighbor));
        try {
            this.options.setMouseModule(MouseModuleType.valueOf(this.prefs.get("mouseModule", this.options.mouseModule.toString())));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.options.setFlipColorbarLabel(this.prefs.getBoolean("flipColorbarLabel", this.options.flipColorbarLabel));
        this.options.setTicklen(this.prefs.get("ticklen", this.options.ticklen));
        this.options.setMultiLineTextAlignment(this.prefs.getFloat("multiLineTextAlignment", this.options.multiLineTextAlignment));
        this.options.setPrintingTag(this.prefs.get("printingTag", this.options.printingTag));
        this.options.setPrintingLogLevel(Level.parse(this.prefs.get("printingLogLevel", this.options.printingLogLevel.toString())));
        this.options.setDisplayLogLevel(Level.parse(this.prefs.get("displayLogLevel", this.options.displayLogLevel.toString())));
        this.options.setLogMessageTimeoutSec(this.prefs.getInt("logMessageTimeoutSec", this.options.logMessageTimeoutSec));
    }

    public void loadPreferences() {
        this.options.autolabelling = this.prefs.getBoolean("autolabelling", this.options.autolabelling);
        this.options.autolayout = this.prefs.getBoolean("autolayout", this.options.autolayout);
        this.options.autoranging = this.prefs.getBoolean("autoranging", this.options.autoranging);
        if (!this.options.autoranging) {
            System.err.println("Autorange default was false, enabling it now.");
            this.options.autoranging = true;
        }
        if (!this.options.autolayout) {
            System.err.println("Autolayout default was false, enabling it now.");
            this.options.autolayout = true;
        }
        if (!this.options.autolabelling) {
            System.err.println("Autolabelling default was false, enabling it now.");
            this.options.autolabelling = true;
        }
        this.options.background = Color.decode(this.prefs.get("background", DomUtil.encodeColor(this.options.background)));
        this.options.canvasFont = this.prefs.get("canvasFont", this.options.canvasFont);
        this.options.color = Color.decode(this.prefs.get("color", DomUtil.encodeColor(this.options.color)));
        this.options.drawAntiAlias = this.prefs.getBoolean("drawAntiAlias", this.options.drawAntiAlias);
        this.options.drawGrid = this.prefs.getBoolean("drawGrid", this.options.drawGrid);
        this.options.drawMinorGrid = this.prefs.getBoolean("drawMinorGrid", this.options.drawMinorGrid);
        this.options.fillColor = Color.decode(this.prefs.get("fillColor", DomUtil.encodeColor(this.options.fillColor)));
        this.options.foreground = Color.decode(this.prefs.get("foreground", DomUtil.encodeColor(this.options.foreground)));
        this.options.logConsoleVisible = this.prefs.getBoolean("logConsoleVisible", this.options.logConsoleVisible);
        this.options.overRendering = this.prefs.getBoolean("overRendering", this.options.overRendering);
        this.options.scriptVisible = this.prefs.getBoolean("scriptVisible", this.options.scriptVisible);
        this.options.dataVisible = this.prefs.getBoolean("dataVisible", this.options.dataVisible);
        this.options.layoutVisible = this.prefs.getBoolean("layoutVisible", this.options.layoutVisible);
        this.options.serverEnabled = this.prefs.getBoolean("serverEnabled", this.options.serverEnabled);
        this.options.specialEffects = this.prefs.getBoolean("specialEffects", this.options.specialEffects);
        this.options.textAntiAlias = this.prefs.getBoolean("textAntiAlias", this.options.textAntiAlias);
        this.options.dayOfYear = this.prefs.getBoolean("dayOfYear", this.options.dayOfYear);
        this.options.nearestNeighbor = this.prefs.getBoolean("nearestNeighbor", this.options.nearestNeighbor);
        try {
            this.options.setMouseModule(MouseModuleType.valueOf(this.prefs.get("mouseModule", this.options.mouseModule.toString())));
        }
        catch (IllegalArgumentException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.options.flipColorbarLabel = this.prefs.getBoolean("flipColorbarLabel", this.options.flipColorbarLabel);
        this.options.ticklen = this.prefs.get("ticklen", this.options.ticklen);
        this.options.multiLineTextAlignment = this.prefs.getFloat("multiLineTextAlignment", this.options.multiLineTextAlignment);
        this.options.printingTag = this.prefs.get("printingTag", this.options.printingTag);
        this.options.printingLogLevel = Level.parse(this.prefs.get("printingLogLevel", this.options.printingLogLevel.toString()));
        this.options.displayLogLevel = Level.parse(this.prefs.get("displayLogLevel", this.options.displayLogLevel.toString()));
        this.options.logMessageTimeoutSec = this.prefs.getInt("logMessageTimeoutSec", this.options.logMessageTimeoutSec);
    }
}

