/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.Axis;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementControllerUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.OrbitDatumRange;
import org.das2.datum.TimeParser;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class LabelConverter
extends Converter {
    private static Logger logger = LoggerManager.getLogger("autoplot.dom.labelConverter");
    Application dom = null;
    PlotElement plotElement = null;
    Plot plot = null;
    Annotation annotation = null;
    Axis axis = null;
    boolean multiplePEWarning = false;

    private LabelConverter() {
    }

    public LabelConverter(Application dom, Plot plot, Axis axis, PlotElement pe, Annotation an) {
        this();
        this.dom = dom;
        this.plot = plot;
        this.axis = axis;
        this.plotElement = pe;
        this.annotation = an;
    }

    private PlotElement getFocusPlotElement() {
        PlotElement pe;
        this.multiplePEWarning = false;
        if (this.plotElement != null) {
            pe = this.plotElement;
        } else {
            List<PlotElement> pes = DomUtil.getPlotElementsFor(this.dom, this.plot);
            if (pes.size() == 1) {
                pe = pes.get(0);
            } else if (pes.isEmpty()) {
                pe = null;
            } else {
                pe = pes.get(0);
                this.multiplePEWarning = true;
            }
        }
        return pe;
    }

    public Object convertForward(Object value) {
        PlotElement pe = this.getFocusPlotElement();
        String title = (String)value;
        boolean done = false;
        while (!done) {
            int newUnresolvedIndex;
            DataSourceFilter dsf;
            QDataSet dataSet;
            int unresolvedIndex = title.indexOf("%{");
            if (title.contains("CONTEXT")) {
                if (pe != null) {
                    QDataSet dataSet2;
                    int loopCount = 0;
                    if (pe.getController().isPendingChanges()) {
                        if (++loopCount > 1000) break;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(LabelConverter.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (loopCount > 1000) {
                        logger.warning("wait for isPendingChanges reached limit");
                    }
                    if ((dataSet2 = pe.getController().getDataSet()) != null) {
                        if (this.plot != null && this.plot.getXaxis() == this.axis) {
                            logger.finer("getting the CONTEXT property from DEPEND_0");
                            QDataSet d = (QDataSet)dataSet2.property("DEPEND_0");
                            if (d != null && SemanticOps.getUnits(d).isConvertibleTo(this.axis.getRange().getUnits())) {
                                dataSet2 = d;
                            }
                        }
                        String contextStr = DataSetUtil.contextAsString(dataSet2);
                        logger.log(Level.FINEST, "bug1814: context substitution success. {0}", Thread.currentThread().getName());
                        title = LabelConverter.insertString(title, "CONTEXT", contextStr);
                    } else {
                        logger.log(Level.FINEST, "bug1814: ds is null. {0}", Thread.currentThread().getName());
                        title = LabelConverter.insertString(title, "CONTEXT", "");
                    }
                } else {
                    logger.log(Level.FINEST, "bug1814: pe is null.{0}", Thread.currentThread().getName());
                    title = LabelConverter.insertString(title, "CONTEXT", "");
                }
            }
            if (title.contains("PLOT_CONTEXT")) {
                title = LabelConverter.insertString(title, "PLOT_CONTEXT", "%{CONTEXT}");
            }
            if (title.contains("USER_PROPERTIES") && pe != null && (dataSet = pe.getController().getDataSet()) != null) {
                Map props = (Map)dataSet.property("USER_PROPERTIES");
                title = DomUtil.resolveProperties(title, "USER_PROPERTIES", props);
            }
            if (title.contains("METADATA") && pe != null && (dsf = (DataSourceFilter)DomUtil.getElementById(this.dom, pe.getDataSourceFilterId())) != null) {
                Map<String, Object> props = dsf.getController().getRawProperties();
                title = DomUtil.resolveProperties(title, "METADATA", props);
            }
            if (title.contains("{PROPERTIES") && pe != null) {
                dataSet = pe.getController().getDataSet();
                int i1 = title.indexOf("{PROPERTIES") + 12;
                int i2 = title.indexOf(125, i1);
                String prop = title.substring(i1, i2);
                String[] ss = prop.split("\\.", -2);
                Object o = null;
                if (dataSet != null) {
                    for (String s : ss) {
                        o = dataSet.property(s);
                        if (o instanceof QDataSet) {
                            dataSet = (QDataSet)o;
                        }
                        if (o == null) break;
                    }
                }
                if (o == null) {
                    o = "";
                }
                title = LabelConverter.insertString(title, title.substring(i1 - 11, i2), o.toString());
            }
            if (title.contains("TIMERANGE")) {
                DatumRange tr = PlotElementControllerUtil.getTimeRange(this.dom, pe);
                if (tr == null) {
                    if (this.plot != null && UnitsUtil.isTimeLocation(this.plot.getContext().getUnits())) {
                        tr = this.plot.getContext();
                    } else if (this.axis != null && UnitsUtil.isTimeLocation(this.axis.getRange().getUnits())) {
                        tr = this.axis.getRange();
                    }
                }
                Pattern pop = Pattern.compile("(.*)\\%\\{TIMERANGE(.*?)\\}(.*)");
                String insert = tr == null ? "(no timerange)" : tr.toString();
                Matcher m = pop.matcher(title);
                if (m.matches()) {
                    String control = m.group(2);
                    if (control.equals(",NOORBIT")) {
                        if (tr != null) {
                            insert = tr instanceof OrbitDatumRange ? DatumRangeUtil.formatTimeRange(tr, false) + " (Orbit " + ((OrbitDatumRange)tr).getOrbit() + ")" : DatumRangeUtil.formatTimeRange(tr, false);
                        }
                    } else if (control.startsWith(",FORMAT=")) {
                        String format = control.substring(8);
                        if (format.equals("$o") || format.equals("%o")) {
                            insert = tr instanceof OrbitDatumRange ? ((OrbitDatumRange)tr).getOrbit() : "???";
                        } else {
                            TimeParser tp = TimeParser.create(format);
                            if (tr != null) {
                                insert = tp.format(tr);
                            }
                        }
                    }
                }
                title = LabelConverter.insertString(title, "TIMERANGE", insert);
            }
            if (title.contains("COMPONENT")) {
                String ss = "";
                if (pe != null) {
                    ss = pe.getComponent();
                }
                title = LabelConverter.insertString(title, "COMPONENT", ss);
            }
            done = (newUnresolvedIndex = title.indexOf("%{")) == -1 || newUnresolvedIndex == unresolvedIndex;
        }
        if (this.multiplePEWarning && !title.equals(value)) {
            logger.log(Level.FINE, "multiple plot elements found, using first to resolve: {0}", value);
        }
        return title;
    }

    public Object convertReverse(Object value) {
        String ptitle;
        String title = (String)value;
        if (this.annotation != null) {
            ptitle = this.annotation.getText();
        } else if (this.plotElement != null) {
            PlotElement pe = this.getFocusPlotElement();
            ptitle = pe.getLegendLabel();
        } else {
            ptitle = this.axis != null ? this.axis.getLabel() : this.plot.getTitle();
        }
        if (LabelConverter.containsString(ptitle, "CONTEXT", title)) {
            title = ptitle;
        } else if (ptitle.contains("%{PLOT_CONTEXT}")) {
            title = ptitle;
        } else if (ptitle.contains("%{USER_PROPERTIES")) {
            title = ptitle;
        } else if (ptitle.contains("%{PROPERTIES")) {
            title = ptitle;
        } else if (ptitle.contains("%{METADATA")) {
            title = ptitle;
        } else if (LabelConverter.containsString(ptitle, "TIMERANGE", title)) {
            title = ptitle;
        } else if (LabelConverter.containsString(ptitle, "COMPONENT", title)) {
            title = ptitle;
        }
        if (this.multiplePEWarning && !title.equals(value)) {
            logger.log(Level.FINE, "multiple plot elements found, using first to resolve: {0}", value);
        }
        return title;
    }

    protected static String insertString(String title, String label, String value) {
        Pattern p = Pattern.compile("(\\%\\{" + label + "(,.*?)?\\})");
        Matcher m = p.matcher(title);
        if (m.find()) {
            return title.substring(0, m.start()) + value + title.substring(m.end());
        }
        p = Pattern.compile("(\\$\\(" + label + "(,.*?)?\\))");
        m = p.matcher(title);
        if (m.find()) {
            return title.substring(0, m.start()) + value + title.substring(m.end());
        }
        return title;
    }

    protected static boolean containsString(String title, String label, String value) {
        String[] ss = null;
        Pattern p = Pattern.compile("(\\%\\{" + label + "(,.*)?\\})");
        Matcher m = p.matcher(title);
        if (m.find()) {
            ss = new String[]{title.substring(0, m.start()), title.substring(m.end())};
        } else {
            String search = "$(" + label + ")";
            if (title.contains(search)) {
                ss = title.split("\\$\\(" + label + "\\)", -2);
            }
        }
        return ss != null && value.startsWith(ss[0]) && value.endsWith(ss[1]);
    }
}

