/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Font;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Column;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.Row;
import org.das2.graph.DasRow;
import org.das2.util.LoggerManager;

public class DomOps {
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom");

    public static void swapPosition(Plot a, Plot b) {
        if (a == b) {
            return;
        }
        String trowid = a.getRowId();
        String tcolumnid = a.getColumnId();
        boolean txtv = a.getXaxis().isDrawTickLabels();
        boolean tytv = a.getYaxis().isDrawTickLabels();
        a.setRowId(b.getRowId());
        a.setColumnId(b.getColumnId());
        a.getXaxis().setDrawTickLabels(b.getXaxis().isDrawTickLabels());
        a.getYaxis().setDrawTickLabels(b.getYaxis().isDrawTickLabels());
        b.setRowId(trowid);
        b.setColumnId(tcolumnid);
        b.getXaxis().setDrawTickLabels(txtv);
        b.getYaxis().setDrawTickLabels(tytv);
    }

    public static Plot copyPlot(Plot srcPlot, boolean bindx, boolean bindy, Object direction) {
        Application application = srcPlot.getController().getApplication();
        ApplicationController ac = application.getController();
        Plot that = ac.addPlot(direction);
        that.getController().setAutoBinding(false);
        that.syncTo(srcPlot, Arrays.asList("id", "rowId", "columnId"));
        if (bindx) {
            BindingModel bb = ac.findBinding(application, "timeRange", srcPlot.getXaxis(), "range");
            if (bb == null) {
                ac.bind(srcPlot.getXaxis(), "range", that.getXaxis(), "range");
            } else {
                ac.bind(application, "timeRange", that.getXaxis(), "range");
            }
        }
        if (bindy) {
            ac.bind(srcPlot.getYaxis(), "range", that.getYaxis(), "range");
        }
        return that;
    }

    public static List<PlotElement> copyPlotElements(Plot srcPlot, Plot dstPlot) {
        ApplicationController ac = srcPlot.getController().getApplication().getController();
        List<PlotElement> srcElements = ac.getPlotElementsFor(srcPlot);
        ArrayList<PlotElement> newElements = new ArrayList<PlotElement>();
        for (PlotElement srcElement : srcElements) {
            PlotElement newp;
            if (!srcElement.getComponent().equals("")) {
                if (srcElement.getController().getParentPlotElement() != null) continue;
                newp = ac.copyPlotElement(srcElement, dstPlot, null);
                newElements.add(newp);
                continue;
            }
            newp = ac.copyPlotElement(srcElement, dstPlot, null);
            newElements.add(newp);
            List<PlotElement> srcKids = srcElement.controller.getChildPlotElements();
            DataSourceFilter dsf1 = ac.getDataSourceFilterFor(newp);
            for (PlotElement k : srcKids) {
                if (!srcElements.contains(k)) continue;
                PlotElement kidp = ac.copyPlotElement(k, dstPlot, dsf1);
                kidp.getController().setParentPlotElement(newp);
                newElements.add(kidp);
            }
        }
        return newElements;
    }

    public static Plot copyPlotAndPlotElements(Plot srcPlot, boolean copyPlotElements, boolean bindx, boolean bindy, Object direction) {
        Plot dstPlot = DomOps.copyPlot(srcPlot, bindx, bindy, direction);
        if (copyPlotElements) {
            DomOps.copyPlotElements(srcPlot, dstPlot);
        }
        return dstPlot;
    }

    public static Column getOrCreateSelectedColumn(Application dom, List<Plot> selectedPlots, boolean create) {
        HashSet<String> n = new HashSet<String>();
        for (Plot p : selectedPlots) {
            n.add(p.getColumnId());
        }
        if (n.size() == 1) {
            return (Column)DomUtil.getElementById(dom, (String)n.iterator().next());
        }
        if (create) {
            Canvas c = dom.getCanvases(0);
            Column col = c.getController().addColumn();
            col.setLeft("0%");
            col.setRight("100%");
            return col;
        }
        return null;
    }

    public static Row getOrCreateSelectedRow(Application dom, List<Plot> selectedPlots, boolean create) {
        HashSet<String> n = new HashSet<String>();
        for (Plot p : selectedPlots) {
            if (n.contains(p.getRowId())) continue;
            n.add(p.getRowId());
        }
        if (n.size() == 1) {
            return (Row)DomUtil.getElementById(dom, (String)n.iterator().next());
        }
        if (create) {
            Row r;
            Iterator iter = n.iterator();
            Row rmax = r = (Row)DomUtil.getElementById(dom.getCanvases(0), (String)iter.next());
            Row rmin = r;
            int i = 1;
            while (iter.hasNext()) {
                r = (Row)DomUtil.getElementById(dom.getCanvases(0), (String)iter.next());
                if (r.getController().getDasRow().getDMaximum() > rmax.getController().getDasRow().getDMaximum()) {
                    rmax = r;
                }
                if (r.getController().getDasRow().getDMinimum() < rmin.getController().getDasRow().getDMinimum()) {
                    rmin = r;
                }
                ++i;
            }
            Canvas c = dom.getCanvases(0);
            Row row = c.getController().addRow();
            row.setTop(rmin.getTop());
            row.setBottom(rmax.getBottom());
            return row;
        }
        return null;
    }

    public static Plot[] bottomAndTopMostPlot(Application dom, List<Plot> plots) {
        Row r;
        Plot pmax = plots.get(0);
        Plot pmin = plots.get(0);
        Row rmax = r = (Row)DomUtil.getElementById(dom.getCanvases(0), pmax.getRowId());
        Row rmin = r;
        for (Plot p : plots) {
            r = (Row)DomUtil.getElementById(dom.getCanvases(0), p.getRowId());
            if (r.getController().getDasRow().getDMaximum() > rmax.getController().getDasRow().getDMaximum()) {
                rmax = r;
                pmax = p;
            }
            if (r.getController().getDasRow().getDMinimum() >= rmin.getController().getDasRow().getDMinimum()) continue;
            rmin = r;
            pmin = p;
        }
        return new Plot[]{pmax, pmin};
    }

    public static List<Plot> getPlotsFor(Application dom, Row row, boolean visible) {
        ArrayList<Plot> result = new ArrayList<Plot>();
        for (Plot p : dom.getPlots()) {
            if (!p.getRowId().equals(row.getId())) continue;
            if (visible) {
                if (!p.isVisible()) continue;
                result.add(p);
                continue;
            }
            result.add(p);
        }
        return result;
    }

    private static int lineCount(String s) {
        int emptyLines;
        String[] ss = s.split("![cC]");
        for (emptyLines = 0; emptyLines < ss.length && ss[emptyLines].trim().length() == 0; ++emptyLines) {
        }
        return ss.length - emptyLines;
    }

    public static void fixLayout(Application dom) {
        DomOps.newCanvasLayout(dom);
    }

    public static void newCanvasLayout(Application dom) {
        Canvas canvas = dom.getCanvases(0);
        double emToPixels = Font.decode(dom.getCanvases((int)0).font).getSize();
        double pixelsToEm = 1.0 / emToPixels;
        Row[] rows = canvas.getRows();
        int nrow = rows.length;
        HashMap<String, Row> rowsCheck = new HashMap<String, Row>();
        ArrayList<Row> rm = new ArrayList<Row>();
        for (int i = 0; i < nrow; ++i) {
            List<Plot> plots = DomOps.getPlotsFor(dom, rows[i], true);
            if (plots.size() > 0) {
                if (rowsCheck.containsKey(rows[i].getId())) {
                    logger.log(Level.FINE, "duplicate row id: {0}", rows[i].getId());
                    rm.add(rows[i]);
                    continue;
                }
                rowsCheck.put(rows[i].getId(), rows[i]);
                continue;
            }
            logger.log(Level.FINE, "unused row: {0}", rows[i]);
            rm.add(rows[i]);
        }
        for (Row r : rm) {
            canvas.getController().deleteRow(r);
        }
        rows = canvas.getRows();
        nrow = rows.length;
        Arrays.sort(rows, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Row r1 = (Row)o1;
                Row r2 = (Row)o2;
                int d1 = r1.getController().getDasRow().getDMinimum();
                int d2 = r2.getController().getDasRow().getDMinimum();
                return d1 - d2;
            }
        });
        double totalPlotHeight = 0.0;
        for (int i = 0; i < nrow; ++i) {
            List<Plot> plots = DomOps.getPlotsFor(dom, rows[i], true);
            if (plots.size() <= 0) continue;
            DasRow dasRow = rows[i].getController().dasRow;
            totalPlotHeight += (double)dasRow.getHeight();
        }
        double[] MaxUp = new double[nrow];
        double[] MaxDown = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            List<Plot> plots = DomOps.getPlotsFor(dom, rows[i], true);
            for (Plot plotj : plots) {
                double MaxUpJEm;
                String title = plotj.getTitle();
                double d = MaxUpJEm = plotj.isDisplayTitle() ? (double)DomOps.lineCount(title) : 0.0;
                if (MaxUpJEm > 0.0) {
                    MaxUpJEm += 1.0;
                }
                MaxUp[i] = Math.max(MaxUp[i], MaxUpJEm * emToPixels);
                Rectangle plot = plotj.getController().getDasPlot().getBounds();
                Rectangle axis = plotj.getXaxis().getController().getDasAxis().getBounds();
                double MaxDownJ = axis.getY() + axis.getHeight() - (plot.getY() + plot.getHeight()) + emToPixels;
                MaxDown[i] = Math.max(MaxDown[i], MaxDownJ);
            }
        }
        double[] relativePlotHeight = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            DasRow dasRow = rows[i].getController().dasRow;
            relativePlotHeight[i] = 1.0 * (double)dasRow.getHeight() / totalPlotHeight;
        }
        double newPlotTotalHeight = canvas.height;
        for (int i = 0; i < nrow; ++i) {
            newPlotTotalHeight = newPlotTotalHeight - MaxUp[i] - MaxDown[i];
        }
        double[] PlotHeight = new double[nrow];
        for (int i = 0; i < nrow; ++i) {
            PlotHeight[i] = newPlotTotalHeight * relativePlotHeight[i];
        }
        double[] normalPlotHeight = new double[nrow];
        double height = dom.getCanvases(0).getMarginRow().getController().getDasRow().getHeight();
        for (int i = 0; i < nrow; ++i) {
            normalPlotHeight[i] = (PlotHeight[i] + MaxUp[i] + MaxDown[i]) / height;
        }
        double position = 0.0;
        for (int i = 0; i < nrow; ++i) {
            String newTop = String.format(Locale.US, "%.2f%%%+.1fem", 100.0 * position, MaxUp[i] * pixelsToEm);
            rows[i].setTop(newTop);
            String newBottom = String.format(Locale.US, "%.2f%%%+.1fem", 100.0 * (position += normalPlotHeight[i]), -1.0 * MaxDown[i] * pixelsToEm);
            rows[i].setBottom(newBottom);
        }
    }

    public static void aggregateAll(Application dom) {
        DataSourceFilter[] dsfs;
        Application oldDom = (Application)dom.copy();
        for (DataSourceFilter dsf : dsfs = dom.getDataSourceFilters()) {
            String agg;
            if (dsf.uri == null || dsf.uri.length() == 0 || dsf.uri.startsWith("vap+internal:") || (agg = DataSourceUtil.makeAggregation(dsf.uri)) == null) continue;
            dsf.setUri(agg);
        }
        dom.setDataSourceFilters(dsfs);
        dom.syncTo(oldDom, Collections.singletonList("dataSourceFilters"));
    }
}

