/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.List;

public class DebugPropertyChangeSupport
extends PropertyChangeSupport {
    static long t0 = System.currentTimeMillis();
    String myBean;
    public long t = System.currentTimeMillis() - t0;
    List<String> propNames = new ArrayList<String>();

    public DebugPropertyChangeSupport(Object bean) {
        super(bean);
        this.myBean = bean.toString();
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Arrays.asList(this.getPropertyChangeListeners()).contains(listener)) {
            return;
        }
        super.addPropertyChangeListener(listener);
        if (listener != null) {
            this.propNames.add(listener.toString());
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.addPropertyChangeListener(propertyName, listener);
        if (listener != null) {
            this.propNames.add(listener.toString() + " " + propertyName);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        super.removePropertyChangeListener(listener);
        if (listener != null) {
            this.propNames.remove(listener.toString());
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        super.removePropertyChangeListener(propertyName, listener);
        if (listener != null) {
            this.propNames.remove(listener.toString() + " " + propertyName);
        }
    }

    @Override
    public void firePropertyChange(PropertyChangeEvent event) {
        try {
            super.firePropertyChange(event);
        }
        catch (ConcurrentModificationException ex) {
            ex.printStackTrace();
        }
    }

    public String toString() {
        PropertyChangeListener[] listeners = this.getPropertyChangeListeners();
        StringBuilder result = new StringBuilder(super.toString());
        for (int i = 0; i < listeners.length; ++i) {
            if (listeners[i] instanceof PropertyChangeListenerProxy) {
                PropertyChangeListenerProxy proxy = (PropertyChangeListenerProxy)listeners[i];
                result.append("\n").append(proxy.getListener()).append(" (property ").append(proxy.getPropertyName()).append(")");
                continue;
            }
            result.append("\n").append(listeners[i]);
        }
        return result.toString();
    }

    public synchronized String[] getPropNames() {
        return this.propNames.toArray(new String[this.propNames.size()]);
    }
}

