/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.HtmlResponseIOException;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.Caching;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.datasource.capability.Updating;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementUtil;
import org.autoplot.dom.TimeSeriesBrowseController;
import org.autoplot.util.RunLaterListener;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.graph.DasPlot;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.RankZeroDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.AutoHistogram;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;

public class DataSourceController
extends DomNodeController {
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom.dsc");
    DataSourceFilter dsf;
    private ApplicationModel model;
    private Application dom;
    private final Object internalLock = new Object();
    private final Object uriLock = new Object();
    private final Object dscLock = new Object();
    private ProgressMonitor mon;
    private PropertyChangeListener updateSlicePropertyChangeListener = new PropertyChangeListener(){

        public String toString() {
            return "" + DataSourceController.this.dsf + " controller updateSlicePropertyChangeListener";
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt);
            if (DataSourceController.this.dataSet != null) {
                DataSourceController.this.updateFillSoon(-1);
            }
        }
    };
    private PropertyChangeListener updateMePropertyChangeListener = new PropertyChangeListener(){

        public String toString() {
            return "" + DataSourceController.this.dsf + " controller updateMePropertyChangeListener";
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt);
            if (DataSourceController.this.dataSet != null) {
                logger.fine("change in fill or valid range ->updateFillSoon()");
                DataSourceController.this.updateFillSoon(-1);
            }
        }
    };
    private PropertyChangeListener resetMePropertyChangeListener = new PropertyChangeListener(){

        public String toString() {
            return "" + DataSourceController.this.dsf + " controller resetMePropertyChangeListener";
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt);
            logger.log(Level.FINE, "resetMe: {0} {1}->{2}", new Object[]{evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            if (evt.getNewValue() != null || evt.getOldValue() != null) {
                List<Object> whoIsChanging = DataSourceController.this.changesSupport.whoIsChanging(DataSourceController.PENDING_SET_DATA_SOURCE);
                if (whoIsChanging.size() > 0) {
                    logger.log(Level.WARNING, "!!! someone is changing: {0} !!!  ignoring event.", whoIsChanging);
                    logger.log(Level.WARNING, " !! {0}", evt.getPropertyName());
                    logger.log(Level.WARNING, " !! {0}", evt.getNewValue());
                    logger.log(Level.WARNING, " !! {0}", evt.getOldValue());
                    return;
                }
                DataSourceController.this.changesSupport.registerPendingChange(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
                DataSourceController.this.setUriNeedsResolution(true);
                if (!((DataSourceController)DataSourceController.this).dom.controller.isValueAdjusting()) {
                    try {
                        DataSourceController.this.changesSupport.performingChange(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
                        DataSourceController.this.dsf.setFilters("");
                        DataSourceController.this.resolveDataSource(false, DataSourceController.this.getMonitor("resetting data source", "resetting data source"));
                    }
                    finally {
                        DataSourceController.this.changesSupport.changePerformed(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
                    }
                } else {
                    new RunLaterListener("valueAdjusting", ((DataSourceController)DataSourceController.this).dom.controller, true){

                        @Override
                        public void run() {
                            try {
                                DataSourceController.this.changesSupport.performingChange(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
                                if (DataSourceController.this.uriNeedsResolution) {
                                    DataSourceController.this.resolveDataSource(true, DataSourceController.this.getMonitor("resetting data source", "resetting data source"));
                                }
                            }
                            finally {
                                DataSourceController.this.changesSupport.changePerformed(DataSourceController.this.resetMePropertyChangeListener, DataSourceController.PENDING_RESOLVE_DATA_SOURCE);
                            }
                        }
                    };
                }
            }
        }
    };
    private TimeSeriesBrowseController timeSeriesBrowseController;
    private boolean haveCheckedInternalTsb = false;
    private static final String PENDING_DATA_SOURCE = "dataSource";
    private static final String PENDING_RESOLVE_DATA_SOURCE = "resolveDataSource";
    private static final String PENDING_SET_DATA_SOURCE = "setDataSource";
    private static final String PENDING_FILL_DATASET = "fillDataSet";
    private static final String PENDING_UPDATE = "update";
    DataSourceFilter[] parentSources;
    PropertyChangeListener parentListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt);
            String prob = DataSourceController.this.checkParents();
            if (prob != null) {
                DataSourceController.this.setStatus("warning: " + prob);
                DataSourceController.this.setDataSetInternal(null, null, ((DataSourceController)DataSourceController.this).dom.controller.isValueAdjusting());
            }
            if (!DataSourceController.this.haveCheckedInternalTsb) {
                DataSourceController.this.maybeAddInternalTimeSeriesBrowse();
            }
        }
    };
    PropertyChangeListener dsfListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt);
            DataSourceController.this.resolveParents();
        }
    };
    private Updating updating;
    private PropertyChangeListener updatesListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt);
            QDataSet ds = (QDataSet)evt.getNewValue();
            if (ds != null) {
                DataSourceController.this.setDataSetInternal(ds);
            } else {
                List<PlotElement> pelements = ((DataSourceController)DataSourceController.this).dom.controller.getPlotElementsFor(DataSourceController.this.dsf);
                for (PlotElement p : pelements) {
                    p.getController().setResetRanges(true);
                }
                DataSourceController.this.update();
            }
        }
    };
    public static final String PROP_RAWPROPERTIES = "rawProperties";
    protected Map<String, Object> rawProperties = null;
    protected TimeSeriesBrowse tsb = null;
    public static final String PROP_TSB = "tsb";
    protected String tsbSuri = null;
    public static final String PROP_TSBSURI = "tsbSuri";
    protected Caching caching = null;
    public static final String PROP_CACHING = "caching";
    public static final String PROP_DATASOURCE = "dataSource";
    protected DataSource dataSource = null;
    protected QDataSet dataSet = null;
    public static final String PROP_DATASET = "dataSet";
    protected QDataSet fillDataSet = null;
    public static final String PROP_FILLDATASET = "fillDataSet";
    protected Exception exception = null;
    public static final String PROP_EXCEPTION = "exception";
    protected QDataSet histogram = null;
    public static final String PROP_HISTOGRAM = "histogram";
    protected Map<String, Object> properties = null;
    public static final String PROP_PROPERTIES = "properties";
    protected Map<String, Object> fillProperties = null;
    public static final String PROP_FILLPROPERTIES = "fillProperties";
    protected String reduceDataSetString = "";
    public static final String PROP_REDUCEDATASETSTRING = "reduceDataSetString";
    public static final String PROP_URINEEDSRESOLUTION = "uriNeedsResolution";
    protected boolean uriNeedsResolution = false;
    public static final String PROP_DATASETNEEDSLOADING = "dataSetNeedsLoading";
    protected boolean dataSetNeedsLoading = false;
    protected boolean resetDimensions = false;
    public static final String PROP_RESETDIMENSIONS = "resetDimensions";

    public DataSourceController(ApplicationModel model, DataSourceFilter dsf) {
        super(dsf);
        this.model = model;
        this.dom = model.getDocumentModel();
        this.dsf = dsf;
        dsf.addPropertyChangeListener("filters", this.updateSlicePropertyChangeListener);
        dsf.addPropertyChangeListener("fill", this.updateMePropertyChangeListener);
        dsf.addPropertyChangeListener("validRange", this.updateMePropertyChangeListener);
        dsf.addPropertyChangeListener("uri", this.resetMePropertyChangeListener);
        dsf.addPropertyChangeListener("id", new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                if (((DataSourceController)DataSourceController.this).dom.controller.isValueAdjusting()) {
                    return;
                }
                ChangesSupport.DomLock lock = ((DataSourceController)DataSourceController.this).dom.controller.mutatorLock();
                lock.lock("Changing dsf id");
                try {
                    for (BindingModel b : DataSourceController.this.dom.getBindings()) {
                        if (b.getSrcId().equals(evt.getOldValue())) {
                            b.srcId = (String)evt.getNewValue();
                        }
                        if (!b.getDstId().equals(evt.getOldValue())) continue;
                        b.dstId = (String)evt.getNewValue();
                    }
                    for (PlotElement pe : ((DataSourceController)DataSourceController.this).dom.plotElements) {
                        if (!pe.getDataSourceFilterId().equals(evt.getOldValue())) continue;
                        pe.setDataSourceFilterId((String)evt.getNewValue());
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        });
    }

    public int getMaxSliceIndex(int i) {
        if (this.getDataSet() == null) {
            return 0;
        }
        int sliceDimension = i;
        if (sliceDimension == 0) {
            if (this.getDataSet().rank() == 0) {
                return 0;
            }
            return this.getDataSet().length();
        }
        if (sliceDimension == -1) {
            return 0;
        }
        int[] qube = DataSetUtil.qubeDims(this.getDataSet());
        if (qube == null || qube.length <= sliceDimension) {
            return 0;
        }
        return qube[sliceDimension];
    }

    private void doDimensionNames() {
        QDataSet ds = this.getDataSet();
        if (ds == null) {
            return;
        }
        String[] depNames = new String[ds.rank()];
        for (int i = 0; i < ds.rank(); ++i) {
            String dname;
            depNames[i] = "dim" + i;
            QDataSet dep0 = (QDataSet)ds.property("DEPEND_" + i);
            if (dep0 == null || (dname = (String)dep0.property("NAME")) == null) continue;
            depNames[i] = dname;
        }
        logger.log(Level.FINE, "dep names: {0}", Arrays.asList(depNames));
        this.setResetDimensions(false);
    }

    private boolean doesPlotElementSupportTsb(PlotElement plotElement) {
        Plot plot = plotElement.getController().getApplication().getController().getPlotFor(plotElement);
        if (plot == null) {
            return false;
        }
        if (UnitsUtil.isTimeLocation(plot.getXaxis().getRange().getUnits()) || UnitsUtil.isTimeLocation(plot.getContext().getUnits())) {
            return true;
        }
        return plotElement.isAutoComponent() || !plotElement.getComponent().contains("|slice0") && !plotElement.getComponent().contains("|collapse0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDataSource(boolean valueWasAdjusting, DataSource dataSource) {
        if (EventQueue.isDispatchThread()) {
            logger.fine("resetDataSource on event thread");
        }
        Object object = this.dscLock;
        synchronized (object) {
            if (dataSource == null) {
                this.setDataSetNeedsLoading(false);
            } else {
                this.setDataSetNeedsLoading(true);
            }
            if (this.timeSeriesBrowseController != null) {
                this.timeSeriesBrowseController.release();
                this.timeSeriesBrowseController = null;
            }
            DataSource oldSource = this.getDataSource();
            if (this.haveCheckedInternalTsb) {
                this.haveCheckedInternalTsb = false;
            }
            if (dataSource == null) {
                this.setCaching(null);
                this.setTsb(null);
                this.setTsbSuri(null);
                if (this.dsf.getUri().length() > 0 && !this.dsf.getUri().startsWith("vap+internal")) {
                    this.dsf.setUri("vap+internal:");
                }
            } else {
                this.changesSupport.performingChange(this, PENDING_SET_DATA_SOURCE);
                this.setCaching(dataSource.getCapability(Caching.class));
                PlotElement pe = this.getPlotElement();
                if (pe != null && this.doesPlotElementSupportTsb(pe)) {
                    this.setTsb(dataSource.getCapability(TimeSeriesBrowse.class));
                } else if (pe == null) {
                    this.setTsb(dataSource.getCapability(TimeSeriesBrowse.class));
                } else {
                    List<PlotElement> pele = this.dom.controller.getPlotElementsFor(this.dsf);
                    pe = null;
                    for (PlotElement pele1 : pele) {
                        if (!this.doesPlotElementSupportTsb(pele1)) continue;
                        pe = pele1;
                    }
                    if (pe != null) {
                        this.setTsb(dataSource.getCapability(TimeSeriesBrowse.class));
                    } else {
                        this.setTsb(null);
                    }
                }
                if (this.dsf.getUri().length() > 0) {
                    this.dsf.setUri(dataSource.getURI());
                    this.setUriNeedsResolution(false);
                }
                this.changesSupport.changePerformed(this, PENDING_SET_DATA_SOURCE);
            }
            if (valueWasAdjusting) {
                this.dataSource = dataSource;
            } else {
                this.dsf.setValidRange("");
                this.dsf.setFill("");
                this.setDataSource(dataSource);
                this.setResetDimensions(true);
            }
            if (oldSource == null || !oldSource.equals(dataSource)) {
                List<PlotElement> ps = this.dom.controller.getPlotElementsFor(this.dsf);
                if (this.getTsb() != null && !ps.isEmpty()) {
                    this.setDataSet(null);
                    if (ps.size() > 0) {
                        this.timeSeriesBrowseController = new TimeSeriesBrowseController(this, ps.get(0));
                        Plot p = this.dom.controller.getFirstPlotFor(this.dsf);
                        List<PlotElement> pes = this.dom.controller.getPlotElementsFor(p);
                        if (pes.size() > 1) {
                            boolean context = false;
                            for (PlotElement pe : pes) {
                                TimeSeriesBrowseController tsbc;
                                DataSourceFilter dsf1 = this.dom.controller.getDataSourceFilterFor(pe);
                                if (dsf1 == null || dsf1 == this.dsf || (tsbc = dsf1.getController().getTimeSeriesBrowseController()) == null || tsbc.isListeningToAxis()) continue;
                                context = true;
                            }
                            if (context) {
                                this.timeSeriesBrowseController.setupGen(p, "context");
                                this.timeSeriesBrowseController.updateTsb(false);
                            } else {
                                this.timeSeriesBrowseController.setup(valueWasAdjusting);
                            }
                        } else {
                            this.timeSeriesBrowseController.setup(valueWasAdjusting);
                        }
                    }
                } else if (this.getTsb() != null && ps.isEmpty()) {
                    String propertyName;
                    DomNode node1;
                    this.timeSeriesBrowseController = new TimeSeriesBrowseController(this, null);
                    Plot p = this.dom.controller.getFirstPlotFor(this.dsf);
                    if (p == null) {
                        logger.fine("unable to identify a plot for the dsf, binding tsb to app.timerange");
                        node1 = this.dom;
                        propertyName = "timeRange";
                    } else {
                        logger.log(Level.FINE, "binding tsb to plot.context of {0}", p.getId());
                        node1 = p;
                        propertyName = "context";
                    }
                    if (!UnitsUtil.isTimeLocation(this.dom.getTimeRange().getUnits())) {
                        List<BindingModel> bms = this.dom.getController().findBindings(this.dom, "timeRange", null, null);
                        if (bms.isEmpty()) {
                            logger.log(Level.FINE, "claiming dom timerange for TSB: {0}", this.dsf.getUri());
                            if (p != null) {
                                p.setContext(this.getTsb().getTimeRange());
                            }
                            this.dom.setTimeRange(this.getTsb().getTimeRange());
                            logger.log(Level.FINE, "about to setup Gen for {0}", this);
                            this.timeSeriesBrowseController.setupGen(node1, propertyName);
                            if (node1 != this.dom) {
                                this.dom.controller.bind(this.dom, "timeRange", p, "context");
                            }
                            this.update(true);
                        } else {
                            logger.fine("unable to use timerange as guide");
                            if (p != null) {
                                p.setContext(this.getTsb().getTimeRange());
                            }
                            this.timeSeriesBrowseController.setupGen(node1, propertyName);
                            this.update(true);
                        }
                    } else {
                        logger.log(Level.FINE, "using plot context for TSB: {0}", this.dsf.getUri());
                        this.timeSeriesBrowseController.setupGen(node1, propertyName);
                        if (node1 != this.dom && p != null) {
                            this.dom.controller.bind(this.dom, "timeRange", p, "context");
                            BindingModel bm = this.dom.controller.findBinding(this.dom, "timeRange", p.getXaxis(), "range");
                            if (bm != null) {
                                this.dom.controller.deleteBinding(bm);
                            }
                        }
                        this.update(true);
                    }
                } else {
                    this.update(true);
                }
            }
        }
    }

    public void setDataSetInternal(QDataSet ds) {
        this.setDataSetInternal(ds, null, this.dom.controller.isValueAdjusting());
    }

    public static boolean isTimeSeries(QDataSet ds) {
        Units u;
        if (ds.rank() == 0) {
            return false;
        }
        QDataSet dep0 = SemanticOps.xtagsDataSet(ds);
        return dep0 != null && UnitsUtil.isTimeLocation(u = SemanticOps.getUnits(dep0));
    }

    public void setDataSetInternal(QDataSet ds, Map<String, Object> rawProperties, boolean immediately) {
        ArrayList<String> problems = new ArrayList<String>();
        if (ds != null && !DataSetUtil.validate(ds, problems)) {
            DataSource dss = this.getDataSource();
            String uri = dss == null ? "vap+internal:" : dss.getURI();
            if (this.tsb != null) {
                uri = this.tsbSuri;
            }
            if (uri == null) {
                uri = "<null>";
            }
            if (uri.length() > 80) {
                int n = uri.length();
                uri = uri.substring(0, 48) + " ... " + uri.substring(n - 30, n);
            }
            StringBuilder message = new StringBuilder("When loading " + uri + "\ndataset is invalid:\n");
            logger.log(Level.SEVERE, "dataset is invalid", new Exception("dataset is invalid"));
            for (String s : problems) {
                message.append(s).append("\n");
            }
            if (this.dom.controller.isHeadless()) {
                throw new IllegalArgumentException(message.toString());
            }
            this.model.showMessage(message.toString(), "Data Set is Invalid", 2);
            return;
        }
        if (this.getTimeSeriesBrowseController() != null && ds != null && !DataSourceController.isTimeSeries(ds) && this.getTimeSeriesBrowseController().isListeningToAxis()) {
            this.timeSeriesBrowseController.release();
            Plot plot = this.getTimeSeriesBrowseController().getPlot();
            Axis xaxis = plot.getXaxis();
            this.dom.getController().unbind(this.dom, "timeRange", xaxis, "range");
            this.dom.setTimeRange(this.tsb.getTimeRange());
            this.timeSeriesBrowseController.setupGen(plot, "context");
        }
        ApplicationController ac = this.dom.controller;
        if (!immediately && ac.isValueAdjusting()) {
            final QDataSet fds = ds;
            new RunLaterListener("valueAdjusting", ac, false){

                @Override
                public void run() {
                    DataSourceController.this.setDataSetInternal(fds);
                }
            };
        } else {
            this.setDataSet(ds);
            this.setRawProperties(rawProperties);
            this.setDataSetNeedsLoading(false);
            if (ds == null) {
                this.setDataSet(null);
                this.setProperties(null);
                this.setFillProperties(null);
                this.setFillDataSet(null);
                return;
            }
            this.extractProperties(ds);
            this.doDimensionNames();
            if (ds.rank() <= 4 && DataSetUtil.totalLength(ds) < 200000 && UnitsUtil.isIntervalOrRatioMeasurement(SemanticOps.getUnits(ds))) {
                this.setStatus("busy: do statistics on the data...");
                try {
                    this.setHistogram(new AutoHistogram().doit(ds, null));
                }
                catch (IllegalArgumentException ex) {
                    logger.warning("runtime error during histogram usually means invalid data in data set.");
                    this.setHistogram(null);
                }
            } else {
                this.setHistogram(null);
            }
            this.setStatus("busy: apply fill");
            this.updateFill();
            this.setStatus("done, apply fill");
            List<PlotElement> pele = this.dom.controller.getPlotElementsFor(this.dsf);
            if (pele.isEmpty()) {
                this.setStatus("warning: done loading data but no plot elements are listening");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSourceFilter[] getParentSources() {
        DataSourceFilter[] parentSources1;
        if (this.parentSources == null) {
            return new DataSourceFilter[0];
        }
        Object object = this.dscLock;
        synchronized (object) {
            parentSources1 = new DataSourceFilter[this.parentSources.length];
            System.arraycopy(this.parentSources, 0, parentSources1, 0, this.parentSources.length);
        }
        return parentSources1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearParentSources() {
        Object object = this.dscLock;
        synchronized (object) {
            if (this.parentSources != null) {
                for (DataSourceFilter parentDsf : this.parentSources) {
                    if (parentDsf == null) continue;
                    parentDsf.controller.removePropertyChangeListener("fillDataSet", this.parentListener);
                }
            }
            this.parentSources = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeAddInternalTimeSeriesBrowse() {
        Object object = this.dscLock;
        synchronized (object) {
            if (this.haveCheckedInternalTsb) {
                return;
            }
            String uri = this.dsf.getUri();
            if (uri == null) {
                return;
            }
            URISplit split = URISplit.parse(uri);
            String[] ss = split.surl.split(",", -2);
            this.tsb = null;
            InternalTimeSeriesBrowse intTsb = null;
            for (int i = 0; i < ss.length; ++i) {
                DataSourceFilter parentDsf = (DataSourceFilter)DomUtil.getElementById(this.dom, ss[i]);
                if (parentDsf != null) {
                    parentDsf.controller.addPropertyChangeListener("fillDataSet", this.parentListener);
                    this.parentSources[i] = parentDsf;
                    TimeSeriesBrowse parentTsb = parentDsf.controller.getTsb();
                    if (parentTsb == null) continue;
                    if (intTsb == null) {
                        intTsb = new InternalTimeSeriesBrowse(this.dsf.getUri());
                    }
                    logger.log(Level.FINE, "adding to internal tsb: {0}", parentTsb);
                    intTsb.addTimeSeriesBrowse(parentTsb);
                    continue;
                }
                logger.log(Level.WARNING, "unable to find parent {0}", ss[i]);
                if (this.parentSources == null) {
                    logger.warning("strange case where parent sources is not resolved.");
                    return;
                }
                this.parentSources[i] = null;
            }
            if (intTsb != null) {
                this.setTsb(intTsb);
                this.timeSeriesBrowseController = new TimeSeriesBrowseController(this, null);
                Plot p = this.getApplication().getController().getFirstPlotFor(this.dsf);
                if (p != null) {
                    this.timeSeriesBrowseController.setupGen(p, "context");
                } else {
                    logger.warning("check into this case, shouldn't happen");
                }
            }
            this.haveCheckedInternalTsb = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resolveParents() {
        Object object = this.dscLock;
        synchronized (object) {
            if (this.dsf.getUri().length() == 0) {
                return;
            }
            URISplit split = URISplit.parse(this.dsf.getUri());
            if (!this.dsf.getUri().startsWith("vap+internal:")) {
                logger.fine("unbinding because this doesn't have parents.");
                this.unbind();
                return;
            }
            String[] ss = split.surl.split(",", -2);
            for (int i = 0; i < ss.length; ++i) {
                DataSourceFilter dsf1 = (DataSourceFilter)DomUtil.getElementById(this.dom, ss[i]);
                if (dsf1 != null) {
                    dsf1.controller.addPropertyChangeListener("fillDataSet", this.parentListener);
                    this.parentSources[i] = dsf1;
                    continue;
                }
                logger.log(Level.WARNING, "unable to find parent {0}", ss[i]);
                this.parentSources[i] = null;
            }
        }
    }

    private static Map maybeCopy(Map m) {
        if (m == null) {
            return new HashMap();
        }
        return new HashMap(m);
    }

    private String checkParents() {
        boolean willTrim;
        QDataSet y = null;
        QDataSet z = null;
        Map yprops = null;
        Map zprops = null;
        QDataSet ds = null;
        Map props = null;
        DataSourceFilter[] lparentSources = this.getParentSources();
        boolean bl = willTrim = this.tsb != null && this.tsb instanceof InternalTimeSeriesBrowse;
        if (lparentSources.length == 0) {
            return "no parent sources";
        }
        if (lparentSources[0] == null) {
            return "first parent is null";
        }
        QDataSet x = lparentSources[0].controller.getFillDataSet();
        Map xprops = DataSourceController.maybeCopy(lparentSources[0].controller.getFillProperties());
        if (lparentSources.length > 1) {
            if (lparentSources[1] == null) {
                return "second parent is null";
            }
            y = lparentSources[1].controller.getFillDataSet();
            yprops = DataSourceController.maybeCopy(lparentSources[1].controller.getFillProperties());
        }
        if (lparentSources.length > 2) {
            if (lparentSources[2] == null) {
                return "third parent is null";
            }
            z = lparentSources[2].controller.getFillDataSet();
            zprops = DataSourceController.maybeCopy(lparentSources[2].controller.getFillProperties());
        }
        switch (lparentSources.length) {
            case 1: {
                if (x == null) {
                    return "parent dataset is null";
                }
                if (!DataSetUtil.validate(x, null)) break;
                ds = x;
                props = xprops;
                break;
            }
            case 2: {
                if (x == null || y == null) {
                    return "first or second dataset is null";
                }
                ArrayDataSet yds = ArrayDataSet.copy(y);
                assert (yprops != null);
                if (DataSetUtil.validate(x, yds, null)) {
                    boolean dep0mismatch = false;
                    if (willTrim) {
                        QDataSet xdep0 = (QDataSet)x.property("DEPEND_0");
                        QDataSet ydep0 = (QDataSet)y.property("DEPEND_0");
                        if (xdep0 != null && ydep0 != null && xdep0.length() > 0 && Ops.eq(xdep0.slice(0), ydep0.slice(0)).value() == 0.0) {
                            dep0mismatch = true;
                        }
                    }
                    if (dep0mismatch) {
                        return "dataset DEPEND_0 do not line up";
                    }
                    yds.putProperty("DEPEND_0", x);
                    yprops.put("DEPEND_0", xprops);
                    if (!DataSetUtil.validate(yds, null)) break;
                    ds = yds;
                    props = yprops;
                    break;
                }
                return "linked data doesn''t validate: " + x + " and " + y;
            }
            case 3: {
                ArrayDataSet yds;
                if (x == null || y == null || z == null) {
                    return "at least one of the three datasets is null";
                }
                assert (yprops != null);
                assert (zprops != null);
                if (z.rank() == 1) {
                    yds = ArrayDataSet.copy(y);
                    yds.putProperty("RENDER_TYPE", null);
                    yds.putProperty("DEPEND_0", x);
                    yds.putProperty("PLANE_0", z);
                    yprops.put("DEPEND_0", xprops);
                    yprops.put("PLANE_0", zprops);
                    if (DataSetUtil.validate(yds, null)) {
                        ds = yds;
                        props = yprops;
                        break;
                    }
                    return "linked data doesn't validate";
                }
                ArrayDataSet zds = ArrayDataSet.copy(z);
                zds.putProperty("DEPEND_0", x);
                zds.putProperty("DEPEND_1", y);
                if (DataSetUtil.validate(x, y, z, null)) {
                    zprops.put("DEPEND_0", xprops);
                    zprops.put("DEPEND_1", yprops);
                    ds = zds;
                    props = zprops;
                    break;
                }
                return "linked data doesn't validate";
            }
        }
        logger.log(Level.FINE, "checkParents resolves {0}", ds);
        if (ds != null) {
            QDataSet xxds;
            QDataSet xds;
            if (this.tsb != null && this.tsb instanceof InternalTimeSeriesBrowse && (xds = (QDataSet)ds.property("DEPEND_0")) != null && (xxds = (QDataSet)xds.property("DEPEND_0")) != null && UnitsUtil.isTimeLocation(SemanticOps.getUnits(xxds)) && SemanticOps.isMonotonic(xxds)) {
                DatumRange dr = this.tsb.getTimeRange();
                int idx0 = DataSetUtil.getPreviousIndex(xxds, dr.min());
                int idx1 = DataSetUtil.getNextIndex(xxds, dr.max());
                if (idx1 < xxds.length() + 1) {
                    ++idx1;
                }
                logger.log(Level.FINE, "checkParents trimming parents ds.trim({0},{1})", new Object[]{idx0, idx1});
                if (idx0 == idx1) {
                    ds = null;
                } else if (idx0 > idx1) {
                    logger.warning("non mono error?");
                    ds = null;
                } else {
                    QDataSet trim = ds.trim(idx0, idx1);
                    if (DataSetUtil.validate(trim, null)) {
                        ds = trim;
                    } else {
                        return "data doesn't validate after trimming";
                    }
                }
            }
            this.setDataSetInternal(ds, props, this.dom.controller.isValueAdjusting());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doInternal(String path) {
        Object object = this.internalLock;
        synchronized (object) {
            if (this.parentSources != null) {
                for (DataSourceFilter parentSource : this.parentSources) {
                    if (parentSource == null) continue;
                    parentSource.controller.removePropertyChangeListener("fillDataSet", this.parentListener);
                }
            }
            if (path.trim().length() == 0) {
                return true;
            }
            String[] ss = path.split(",", -2);
            this.parentSources = new DataSourceFilter[ss.length];
            this.resolveParents();
            String prob = this.checkParents();
            if (prob != null) {
                this.setStatus("warning: " + prob);
                return false;
            }
            this.dom.addPropertyChangeListener("dataSourceFilters", this.dsfListener);
        }
        return true;
    }

    protected void unbind() {
        this.dom.removePropertyChangeListener("dataSourceFilters", this.dsfListener);
    }

    private void extractProperties(QDataSet ds) {
        Map<String, Object> props = AutoplotUtil.extractProperties(ds);
        DataSource dss = this.getDataSource();
        if (dss != null) {
            props = AutoplotUtil.mergeProperties(dss.getProperties(), props);
        }
        this.setProperties(props);
    }

    public void doFillValidRange() {
        Map<String, Object> props = this.getProperties();
        Object v = props.get("FILL_VALUE");
        if (v != null) {
            this.dsf.setFill(String.valueOf(v));
        }
        Number vmin = (Number)props.get("VALID_MIN");
        Number vmax = (Number)props.get("VALID_MAX");
        if (vmin != null || vmax != null) {
            if (vmin == null) {
                vmin = -1.0E38;
            }
            if (vmax == null) {
                vmax = 1.0E38;
            }
            this.dsf.setValidRange("" + vmin + " to " + vmax);
        } else {
            this.dsf.setValidRange("");
        }
    }

    private static void applyFillValidRange(MutablePropertyDataSet ds, double vmin, double vmax, double fill) {
        if (vmin > -1.7976931348623157E308) {
            ds.putProperty("VALID_MIN", vmin);
        }
        if (vmax < Double.MAX_VALUE) {
            ds.putProperty("VALID_MAX", vmax);
        }
        if (!Double.isNaN(fill)) {
            ds.putProperty("FILL_VALUE", fill);
        }
    }

    private void updateFillSoon(final int delay) {
        this.changesSupport.registerPendingChange(this, "fillDataSet");
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    DataSourceController.this.changesSupport.performingChange(DataSourceController.this, "fillDataSet");
                    if (delay > 0) {
                        try {
                            Thread.sleep(delay);
                        }
                        catch (InterruptedException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    DataSourceController.this.updateFill();
                }
                finally {
                    DataSourceController.this.changesSupport.changePerformed(DataSourceController.this, "fillDataSet");
                }
            }
        };
        if (delay == 0) {
            logger.finest("delay=0 means I should update fill in this thread");
            run.run();
        } else {
            RequestProcessor.invokeLater(run);
        }
    }

    private static void guessCadence(MutablePropertyDataSet xds, QDataSet fillDs) {
        if (xds.length() < 2) {
            return;
        }
        RankZeroDataSet cadence = DataSetUtil.guessCadenceNew(xds, fillDs);
        if (cadence != null && "log".equals(cadence.property("SCALE_TYPE"))) {
            xds.putProperty("SCALE_TYPE", "log");
        }
        if (cadence != null) {
            xds.putProperty("CADENCE", cadence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFill() {
        logger.fine("enter updateFill");
        QDataSet ds = this.getDataSet();
        if (ds == null) {
            return;
        }
        this.changesSupport.performingChange(this, "fillDataSet");
        try {
            MutablePropertyDataSet fillDs;
            boolean doSlice;
            Map<String, Object> props = this.getProperties();
            String filters = this.dsf.getFilters();
            boolean bl = doSlice = filters.length() > 0;
            if (doSlice) {
                try {
                    ds = DataSetOps.sprocess(filters, ds, new AlertNullProgressMonitor("sprocess " + filters));
                    this.setAppliedFiltersString(filters);
                }
                catch (Exception ex) {
                    this.setException(ex);
                    throw new RuntimeException(ex);
                }
                fillDs = DataSetOps.makePropertiesMutable(ds);
            } else {
                fillDs = DataSetOps.makePropertiesMutable(ds);
                this.setAppliedFiltersString(null);
            }
            for (int i = 0; i < fillDs.rank(); ++i) {
                QDataSet dep = (QDataSet)fillDs.property("DEPEND_" + i);
                if (dep == null) continue;
                dep = DataSetOps.makePropertiesMutable(dep);
                if (i == 0 && dep.rank() == 1) {
                    DataSourceController.guessCadence((MutablePropertyDataSet)dep, fillDs);
                } else if (dep.rank() == 1) {
                    DataSourceController.guessCadence((MutablePropertyDataSet)dep, null);
                }
                fillDs = Ops.putProperty(fillDs, "DEPEND_" + i, (Object)dep);
            }
            double vmin = Double.NEGATIVE_INFINITY;
            double vmax = Double.POSITIVE_INFINITY;
            double fill = Double.NaN;
            try {
                double[] vminMaxFill = PlotElementUtil.parseFillValidRangeInternal(this.dsf.getValidRange(), this.dsf.getFill());
                vmin = vminMaxFill[0];
                vmax = vminMaxFill[1];
                fill = vminMaxFill[2];
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            DataSourceController.applyFillValidRange(fillDs, vmin, vmax, fill);
            this.setFillProperties(props);
            if (fillDs == ds) {
                this.fillDataSet = null;
            }
            fillDs.makeImmutable();
            this.setFillDataSet(fillDs);
        }
        finally {
            this.changesSupport.changePerformed(this, "fillDataSet");
        }
    }

    private void updateImmediately(Exception parentException) {
        try {
            DataSource dss = this.getDataSource();
            if (dss != null) {
                this.setStatus("busy: loading dataset");
                logger.log(Level.FINE, "loading dataset {0}", dss);
                if (this.tsb != null) {
                    logger.log(Level.FINE, "   tsb= {0}", this.tsb.getURI());
                }
                this.loadDataSet(parentException);
                if (this.dataSet != null) {
                    this.setStatus("done loading dataset");
                    if (this.dsf.getUri().length() == 0) {
                        logger.fine("dsf.getUri was null");
                        return;
                    }
                } else if (!this.dom.controller.getStatus().startsWith("warning:")) {
                    this.setStatus("no data returned");
                }
            } else if (this.parentSources == null) {
                this.setDataSetInternal(null);
            } else {
                String prob = this.checkParents();
                if (prob != null) {
                    logger.warning(prob);
                }
            }
            if (this.dataSet != null) {
                this.setStatus("ready");
            }
        }
        catch (RuntimeException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.setStatus("error: " + ex);
            this.model.getExceptionHandler().handleUncaught(ex);
        }
    }

    public void cancel() {
        ProgressMonitor monitor;
        DataSource dss = this.getDataSource();
        if (dss != null && dss.asynchronousLoad() && !this.dom.controller.isHeadless() && (monitor = this.getMonitor()) != null) {
            logger.fine("cancel running request");
            monitor.cancel();
        }
    }

    public void update() {
        this.update(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(boolean user) {
        Object object = this.dscLock;
        synchronized (object) {
            this.changesSupport.registerPendingChange(this, PENDING_UPDATE);
            this.changesSupport.performingChange(this, PENDING_UPDATE);
            DataSource dss = this.getDataSource();
            logger.log(Level.FINE, "request update {0}", dss);
            this.setDataSet(null);
            final RuntimeException fe = new RuntimeException("attempt to load " + (dss != null ? dss.toString() : "(null)"));
            Runnable run = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = DataSourceController.this.dscLock;
                        synchronized (object) {
                            DataSourceController.this.updateImmediately(fe);
                            if (DataSourceController.this.dataSource != null) {
                                if (DataSourceController.this.updating != null) {
                                    DataSourceController.this.updating.removePropertyChangeListener(DataSourceController.this.updatesListener);
                                }
                                DataSourceController.this.updating = DataSourceController.this.dataSource.getCapability(Updating.class);
                                if (DataSourceController.this.updating != null) {
                                    DataSourceController.this.updating.addPropertyChangeListener(DataSourceController.this.updatesListener);
                                }
                            }
                        }
                    }
                    finally {
                        DataSourceController.this.changesSupport.changePerformed(DataSourceController.this, DataSourceController.PENDING_UPDATE);
                    }
                }

                public String toString() {
                    return "load " + String.valueOf(DataSourceController.this.dataSource);
                }
            };
            if (dss != null && dss.asynchronousLoad() && !this.dom.controller.isHeadless()) {
                logger.fine("invoke later do load");
                ProgressMonitor monitor = this.getMonitor();
                if (monitor != null) {
                    logger.warning("double load!");
                    monitor.cancel();
                }
                RequestProcessor.invokeLater(run);
            } else {
                run.run();
            }
        }
    }

    public Map<String, Object> getRawProperties() {
        return this.rawProperties;
    }

    public void setRawProperties(Map<String, Object> rawProperties) {
        Map<String, Object> oldRawProperties = this.rawProperties;
        this.rawProperties = rawProperties;
        this.propertyChangeSupport.firePropertyChange(PROP_RAWPROPERTIES, oldRawProperties, rawProperties);
    }

    public TimeSeriesBrowse getTsb() {
        return this.tsb;
    }

    public void setTsb(TimeSeriesBrowse tsb) {
        TimeSeriesBrowse oldTsb = this.tsb;
        this.tsb = tsb;
        this.propertyChangeSupport.firePropertyChange(PROP_TSB, oldTsb, tsb);
    }

    public String getTsbSuri() {
        return this.tsbSuri;
    }

    public void setTsbSuri(String tsbSuri) {
        String oldTsbSuri = this.tsbSuri;
        this.tsbSuri = tsbSuri;
        this.propertyChangeSupport.firePropertyChange(PROP_TSBSURI, oldTsbSuri, tsbSuri);
    }

    public Caching getCaching() {
        return this.caching;
    }

    public void setCaching(Caching caching) {
        Caching oldCaching = this.caching;
        this.caching = caching;
        this.propertyChangeSupport.firePropertyChange(PROP_CACHING, oldCaching, caching);
    }

    public DataSource getDataSource() {
        logger.log(Level.FINER, "accessing data source");
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataSource(DataSource dataSource) {
        DataSource oldDataSource;
        Object object = this.dscLock;
        synchronized (object) {
            oldDataSource = this.dataSource;
            this.dataSource = dataSource;
        }
        this.propertyChangeSupport.firePropertyChange("dataSource", oldDataSource, dataSource);
    }

    public QDataSet getDataSet() {
        return this.dataSet;
    }

    public void setDataSet(QDataSet dataSet) {
        QDataSet oldDataSet = this.dataSet;
        this.dataSet = dataSet;
        try {
            this.propertyChangeSupport.firePropertyChange(PROP_DATASET, oldDataSet, dataSet);
        }
        catch (NullPointerException ex) {
            logger.log(Level.WARNING, "https://sourceforge.net/p/autoplot/bugs/1770/", ex);
        }
    }

    public QDataSet getFillDataSet() {
        return this.fillDataSet;
    }

    public void setFillDataSet(QDataSet fillDataSet) {
        QDataSet oldFillDataSet = this.fillDataSet;
        this.fillDataSet = fillDataSet;
        this.propertyChangeSupport.firePropertyChange("fillDataSet", oldFillDataSet, fillDataSet);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        Exception oldException = this.exception;
        this.exception = exception;
        this.propertyChangeSupport.firePropertyChange(PROP_EXCEPTION, oldException, exception);
    }

    public QDataSet getHistogram() {
        return this.histogram;
    }

    public void setHistogram(QDataSet histogram) {
        QDataSet oldHistogram = this.histogram;
        this.histogram = histogram;
        this.propertyChangeSupport.firePropertyChange(PROP_HISTOGRAM, oldHistogram, histogram);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        Map<String, Object> oldProperties = this.properties;
        this.properties = properties;
        this.propertyChangeSupport.firePropertyChange(PROP_PROPERTIES, oldProperties, properties);
    }

    public Map<String, Object> getFillProperties() {
        return this.fillProperties;
    }

    public void setFillProperties(Map<String, Object> fillProperties) {
        Map<String, Object> oldFillProperties = this.fillProperties;
        this.fillProperties = fillProperties;
        this.propertyChangeSupport.firePropertyChange(PROP_FILLPROPERTIES, oldFillProperties, fillProperties);
    }

    public String getAppliedFiltersString() {
        return this.reduceDataSetString;
    }

    public void setAppliedFiltersString(String appliedFilters) {
        assert (appliedFilters != null);
        String oldReduceDataSetString = this.reduceDataSetString;
        this.reduceDataSetString = appliedFilters;
        this.propertyChangeSupport.firePropertyChange(PROP_REDUCEDATASETSTRING, oldReduceDataSetString, appliedFilters);
    }

    private static String addHtmlBreaks(String message) {
        if (message.startsWith("<html>")) {
            return message;
        }
        String[] ss = message.split(": ");
        if (ss.length == 1) {
            return message;
        }
        StringBuilder result = new StringBuilder("<html>");
        result.append(ss[0]);
        for (int i = 1; i < ss.length; ++i) {
            result.append(": <br>").append(ss[i]);
        }
        return result.toString();
    }

    private ProgressMonitor getMonitor() {
        return this.mon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QDataSet loadDataSet(Exception parentException) {
        Object object = this.dscLock;
        synchronized (object) {
            ProgressMonitor mymon;
            QDataSet result = null;
            DataSource dss = this.getDataSource();
            this.mon = mymon = this.getMonitor("loading data", "loading " + dss);
            try {
                logger.log(Level.FINE, "load {0}", dss);
                result = dss.getDataSet(mymon);
                logger.log(Level.FINE, "{0} read dataset: {1}", new Object[]{dss, result});
                Map<String, Object> props = dss.getMetadata(new AlertNullProgressMonitor("getMetadata"));
                TimeSeriesBrowse ltsb = this.getTsb();
                TimeSeriesBrowseController ltsbc = this.getTimeSeriesBrowseController();
                if (result != null && ltsb != null && ltsbc != null && result.rank() > 0 && !UnitsUtil.isTimeLocation(SemanticOps.getUnits(SemanticOps.xtagsDataSet(result)))) {
                    Plot p = ltsbc.getPlot();
                    if (p == null) {
                        logger.warning("unexpected timeSeriesBrowseController.domPlot==null");
                    } else if (UnitsUtil.isTimeLocation(p.getXaxis().getRange().getUnits())) {
                        p.getXaxis().setAutoRange(true);
                    }
                    result = DataSourceUtil.trimScatterToTimeRange(result, ltsb.getTimeRange());
                }
                this.setDataSetInternal(result, props, this.dom.controller.isValueAdjusting());
                if (ltsb == null && dss.getCapability(TimeSeriesBrowse.class) != null) {
                    TimeSeriesBrowse tsb1 = dss.getCapability(TimeSeriesBrowse.class);
                    PlotElement pe = this.getPlotElement();
                    if (pe != null && this.doesPlotElementSupportTsb(pe)) {
                        this.setTsb(tsb1);
                        this.timeSeriesBrowseController = ltsbc = new TimeSeriesBrowseController(this, pe);
                        ltsbc.setup(false);
                    }
                }
            }
            catch (InterruptedIOException ex) {
                this.setException(ex);
                this.setDataSet(null);
                this.setStatus("interrupted");
                if (this.dsf.getUri().length() > 0) {
                    this.model.addException(this.dsf.getUri(), ex);
                }
            }
            catch (org.das2.CancelledOperationException | CancelledOperationException ex) {
                this.setException(ex);
                this.setDataSet(null);
                this.setStatus("operation cancelled");
                if (this.dsf.getUri().length() > 0) {
                    this.model.addException(this.dsf.getUri(), ex);
                }
            }
            catch (NoDataInIntervalException ex) {
                this.setException(ex);
                this.setDataSet(null);
                this.setStatus("warning: " + ex.getMessage());
                if (this.getTsb() == null) {
                    String title = "no data in interval";
                    this.model.showMessage("" + ex.getMessage(), title, 1);
                }
                if (this.dsf.getUri().length() > 0) {
                    this.model.addException(this.dsf.getUri(), ex);
                }
            }
            catch (HtmlResponseIOException ex) {
                final HtmlResponseIOException htmlEx = ex;
                if (this.dom.controller.isHeadless()) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                } else if (htmlEx.getURL() != null) {
                    final String link = htmlEx.getURL().toString();
                    JPanel p = new JPanel(new BorderLayout());
                    p.add((Component)new JLabel("<html>Unable to open URI: <br>" + this.dsf.getUri() + "<br><br>Downloaded file appears to be HTML.<br><a href=\"" + link + "\">" + link + "</a><br>"), "Center");
                    JPanel p1 = new JPanel(new FlowLayout(2));
                    p1.add(new JButton(new AbstractAction("Details"){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            LoggerManager.logGuiEvent(ev);
                            DataSourceController.this.getApplication().controller.getApplicationModel().getExceptionHandler().handle(htmlEx);
                        }
                    }));
                    p1.add(new JButton(new AbstractAction("View Page"){

                        @Override
                        public void actionPerformed(ActionEvent ev) {
                            LoggerManager.logGuiEvent(ev);
                            AutoplotUtil.openBrowser(link);
                        }
                    }));
                    p.add((Component)p1, "South");
                    JOptionPane.showMessageDialog(this.model.getCanvas(), p);
                } else {
                    JOptionPane.showMessageDialog(this.model.getCanvas(), "<html>Unable to open URI: <br>" + this.dsf.getUri() + "<br><br>" + ex);
                }
                if (this.dsf.getUri().length() > 0) {
                    this.model.addException(this.dsf.getUri(), ex);
                }
            }
            catch (IOException ex) {
                if (ex instanceof FileNotFoundException || ex.getMessage() != null && (ex.getMessage().contains("No such file") || ex.getMessage().contains("timed out"))) {
                    String title;
                    String message = ex.getMessage();
                    if (message.startsWith("550 ")) {
                        message = message.substring(4);
                    }
                    if (message.startsWith("file:/") || message.startsWith("http://") || message.startsWith("https://")) {
                        message = "File not found: " + message;
                    }
                    this.setException(ex);
                    this.setDataSet(null);
                    this.setStatus("warning: " + message);
                    String string = title = ex.getMessage().contains("No such file") || ex instanceof FileNotFoundException ? "File not found" : ex.getMessage();
                    if (title.contains("\n")) {
                        title = title.substring(0, title.indexOf("\n"));
                    }
                    if (!message.contains("No files in interval")) {
                        this.model.showMessage(DataSourceController.addHtmlBreaks(message), title, 2);
                    }
                } else if (ex.getMessage() != null && ex.getMessage().contains("root does not exist")) {
                    this.setException(ex);
                    this.setDataSet(null);
                    this.setStatus("warning: " + ex.getMessage());
                    String title = ex.getMessage().contains("No such file") ? "Root does not exist" : ex.getMessage();
                    this.model.showMessage(DataSourceController.addHtmlBreaks(ex.getMessage()), title, 2);
                } else if (ex.getMessage() == null) {
                    this.setException(ex);
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                    this.setDataSet(null);
                    this.setStatus("error: " + ex.getClass());
                    this.handleException(ex);
                } else {
                    this.setException(ex);
                    this.setDataSet(null);
                    this.setStatus("error: " + ex.getMessage());
                    this.handleException(ex);
                }
                if (this.dsf.getUri().length() > 0) {
                    this.model.addException(this.dsf.getUri(), ex);
                }
            }
            catch (Exception ex) {
                this.setException(ex);
                this.setDataSet(null);
                logger.log(Level.WARNING, ex.getMessage(), ex);
                this.setStatus("error: " + ex.getMessage());
                if (ex.getCause() == null) {
                    try {
                        ex.initCause(parentException);
                    }
                    catch (RuntimeException ex2) {
                        logger.fine("unable to preserve the initial stack trace");
                    }
                }
                this.handleException(ex);
                if (this.dsf.getUri().length() > 0) {
                    this.model.addException(this.dsf.getUri(), ex);
                }
            }
            finally {
                if (!mymon.isFinished()) {
                    mymon.finished();
                }
                if (mymon == this.mon) {
                    this.mon = null;
                } else {
                    logger.warning("not my mon, somebody better delete it!");
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSuri(String suri, ProgressMonitor mon) {
        Object object = this.dscLock;
        synchronized (object) {
            suri = URISplit.makeCanonical(suri);
            Object object2 = this.uriLock;
            synchronized (object2) {
                this.dsf.setUri(suri);
                this.setUriNeedsResolution(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSuri(String suri, ProgressMonitor mon) {
        String old = this.dsf.getUri();
        suri = URISplit.makeCanonical(suri);
        Object object = this.uriLock;
        synchronized (object) {
            if (old.length() > 0 && old.equals(suri)) {
                this.dsf.setUri("");
            }
            this.dsf.setFilters("");
            this.setSuri(suri, mon);
        }
    }

    protected void resolveDataSource(boolean valueWasAdjusting, ProgressMonitor mon) {
        String surl;
        Caching cache1 = this.getCaching();
        if (this.dom.getController().isValueAdjusting()) {
            logger.log(Level.WARNING, "return of bug first demoed by test033: where the adjusting property is breifly cleared. {0}", this.dom.getController().changesSupport.isValueAdjusting());
            logger.warning("See https://sourceforge.net/tracker/?func=detail&aid=3409414&group_id=199733&atid=970682");
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        if ((surl = this.dsf.getUri()).length() == 0) {
            this.getApplication().getController().deleteAnyParentsOfDataSourceFilter(this.dsf);
            this.clearParentSources();
            this.resetDataSource(valueWasAdjusting, null);
            this.setUriNeedsResolution(false);
            this.setDataSetNeedsLoading(false);
        } else {
            this.getApplication().getController().deleteAnyParentsOfDataSourceFilter(this.dsf);
            URISplit split = URISplit.parse(surl);
            surl = URISplit.format(split);
            try {
                mon.started();
                mon.setProgressMessage("getting " + surl);
                if (cache1 != null && cache1.satisfies(surl)) {
                    cache1.resetURI(surl);
                    this.propertyChangeSupport.firePropertyChange("dataSource", null, this.getDataSource());
                    this.update();
                    return;
                }
                if (URISplit.implicitVapScheme(split).equals("vap+internal")) {
                    this.clearParentSources();
                    this.resetDataSource(valueWasAdjusting, null);
                    boolean ok = this.doInternal(split.path);
                    String msg = null;
                    if (!ok) {
                        msg = this.dom.controller.getStatus();
                    }
                    if (!ok) {
                        this.dom.controller.setStatus(msg);
                    }
                } else {
                    DataSource source = DataSetURI.getDataSource(surl);
                    this.clearParentSources();
                    this.resetDataSource(valueWasAdjusting, source);
                }
                this.setUriNeedsResolution(false);
                mon.setProgressMessage("done getting data source");
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
                throw new RuntimeException(e);
            }
            finally {
                mon.finished();
            }
        }
    }

    public boolean isUriNeedsResolution() {
        return this.uriNeedsResolution;
    }

    public void setUriNeedsResolution(boolean uriNeedsResolution) {
        boolean oldUriNeedsResolution = this.uriNeedsResolution;
        this.uriNeedsResolution = uriNeedsResolution;
        this.propertyChangeSupport.firePropertyChange(PROP_URINEEDSRESOLUTION, oldUriNeedsResolution, uriNeedsResolution);
    }

    public boolean isDataSetNeedsLoading() {
        return this.dataSetNeedsLoading;
    }

    public void setDataSetNeedsLoading(boolean dataSetNeedsLoading) {
        boolean oldDataSetNeedsLoading = this.dataSetNeedsLoading;
        this.dataSetNeedsLoading = dataSetNeedsLoading;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASETNEEDSLOADING, oldDataSetNeedsLoading, dataSetNeedsLoading);
    }

    public boolean isResetDimensions() {
        return this.resetDimensions;
    }

    public void setResetDimensions(boolean resetDimensions) {
        boolean oldResetDimensions = this.resetDimensions;
        this.resetDimensions = resetDimensions;
        this.propertyChangeSupport.firePropertyChange(PROP_RESETDIMENSIONS, oldResetDimensions, resetDimensions);
    }

    public Application getApplication() {
        return this.dom;
    }

    public TimeSeriesBrowseController getTimeSeriesBrowseController() {
        return this.timeSeriesBrowseController;
    }

    protected void releaseTimeSeriesBrowseController() {
        this.timeSeriesBrowseController = null;
    }

    @Override
    public boolean isPendingChanges() {
        TimeSeriesBrowseController tsbc = this.timeSeriesBrowseController;
        if (tsbc != null && tsbc.isPendingChanges()) {
            return true;
        }
        return super.isPendingChanges();
    }

    @Override
    public void pendingChanges(Map<Object, Object> changes) {
        super.pendingChanges(changes);
        TimeSeriesBrowseController tsbc = this.timeSeriesBrowseController;
        if (tsbc != null && tsbc.isPendingChanges()) {
            tsbc.pendingChanges(changes);
        }
    }

    private void handleException(Exception e) {
        if (this.model.getExceptionHandler() == null) {
            logger.log(Level.WARNING, e.getMessage(), e);
        } else if (e.getMessage() != null && e.getMessage().contains("nsupported protocol")) {
            this.model.showMessage(e.getMessage(), "Unsupported Protocol", 0);
        } else {
            logger.log(Level.WARNING, "model.getExceptionHandler: {0}", this.model.getExceptionHandler());
            this.model.getExceptionHandler().handle(e);
        }
    }

    private PlotElement getPlotElement() {
        List<PlotElement> pele = this.dom.controller.getPlotElementsFor(this.dsf);
        if (pele.isEmpty()) {
            return null;
        }
        return pele.get(0);
    }

    private ProgressMonitor getMonitor(String label, String description) {
        PlotElement pele = this.getPlotElement();
        DasPlot p = null;
        if (pele != null) {
            Plot plot = this.dom.controller.getPlotFor(pele);
            if (plot != null) {
                p = plot.controller.getDasPlot();
            }
        } else {
            Plot plot = this.dom.controller.getFirstPlotFor(this.dsf);
            if (plot != null) {
                p = plot.controller.getDasPlot();
            }
        }
        if (p != null) {
            return this.dom.controller.getMonitorFactory().getMonitor(p, label, description);
        }
        return this.dom.controller.getMonitorFactory().getMonitor(label, description);
    }

    private void setStatus(String string) {
        this.dom.controller.setStatus(string);
    }

    public String toString() {
        return this.dsf + " controller";
    }

    class InternalTimeSeriesBrowse
    implements TimeSeriesBrowse {
        String uri;
        DatumRange timerange;
        List<TimeSeriesBrowse> parentTsbs = new ArrayList<TimeSeriesBrowse>();

        private InternalTimeSeriesBrowse(String uri) {
            this.uri = uri;
        }

        public void addTimeSeriesBrowse(TimeSeriesBrowse tsb) {
            this.parentTsbs.add(tsb);
            if (this.parentTsbs.size() == 1) {
                this.setTimeRange(tsb.getTimeRange());
                this.setTimeResolution(tsb.getTimeResolution());
            }
        }

        @Override
        public void setTimeRange(DatumRange dr) {
            for (TimeSeriesBrowse tsb : this.parentTsbs) {
                tsb.setTimeRange(dr);
            }
            this.timerange = dr;
            DataSourceController.this.checkParents();
        }

        @Override
        public DatumRange getTimeRange() {
            return this.timerange;
        }

        @Override
        public void setTimeResolution(Datum d) {
            for (TimeSeriesBrowse tsb : this.parentTsbs) {
                tsb.setTimeResolution(d);
            }
        }

        @Override
        public Datum getTimeResolution() {
            return this.parentTsbs.get(0).getTimeResolution();
        }

        @Override
        public String getURI() {
            Datum res = this.getTimeResolution();
            return this.uri + "?range=" + this.getTimeRange() + (res == null ? "" : "&resolution=" + res);
        }

        public String toString() {
            Datum res = this.getTimeResolution();
            return "inttsb: " + this.getTimeRange() + " " + (res == null ? "" : "&resolution=" + res);
        }

        @Override
        public void setURI(String suri) throws ParseException {
            throw new IllegalArgumentException("not implemented");
        }

        @Override
        public String blurURI() {
            return this.uri;
        }
    }
}

