/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.Column;
import org.autoplot.dom.DomNodeController;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.util.LoggerManager;

public class ColumnController
extends DomNodeController {
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom");
    Column column;
    DasColumn dasColumn;
    Canvas canvas;

    ColumnController(Column column) {
        super(column);
        this.column = column;
        column.controller = this;
    }

    protected void createDasPeer(Canvas canvas, DasColumn parent) {
        DasCanvas c = canvas.controller.getDasCanvas();
        this.dasColumn = DasColumn.create(c, parent, this.column.getLeft(), this.column.getRight());
        final List<String> minList = Arrays.asList("minimum", "emMinimum", "ptMinimum");
        final List<String> maxList = Arrays.asList("maximum", "emMaximum", "ptMaximum");
        PropertyChangeListener list = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                if (maxList.contains(evt.getPropertyName())) {
                    ColumnController.this.column.setRight(DasDevicePosition.formatLayoutStr(ColumnController.this.dasColumn, false));
                } else if (minList.contains(evt.getPropertyName())) {
                    ColumnController.this.column.setLeft(DasDevicePosition.formatLayoutStr(ColumnController.this.dasColumn, true));
                }
            }
        };
        this.dasColumn.addPropertyChangeListener(list);
        list = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr((String)evt.getNewValue());
                    if (evt.getPropertyName().equals("left")) {
                        ColumnController.this.dasColumn.setMin(dd[0], dd[1], (int)dd[2]);
                    } else if (evt.getPropertyName().equals("right")) {
                        ColumnController.this.dasColumn.setMax(dd[0], dd[1], (int)dd[2]);
                    }
                }
                catch (ParseException ex) {
                    logger.log(Level.WARNING, "parse exception: {0}", ex);
                    ColumnController.this.column.setLeft(DasDevicePosition.formatLayoutStr(ColumnController.this.dasColumn, true));
                    ColumnController.this.column.setRight(DasDevicePosition.formatLayoutStr(ColumnController.this.dasColumn, false));
                }
            }
        };
        this.column.addPropertyChangeListener("left", list);
        this.column.addPropertyChangeListener("right", list);
        this.canvas = canvas;
    }

    public boolean isLayoutEqual(String spec) throws ParseException {
        String[] ss = spec.split(",");
        String s1 = DasDevicePosition.formatFormatStr(DasDevicePosition.parseLayoutStr(ss[0]));
        if (!this.column.left.equals(s1)) {
            return false;
        }
        s1 = DasDevicePosition.formatFormatStr(DasDevicePosition.parseLayoutStr(ss[1]));
        return this.column.right.equals(s1);
    }

    public DasColumn getDasColumn() {
        return this.dasColumn;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }
}

