/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;

public final class ChangesSupport {
    Map<Object, Object> changesPending;
    Map<Object, Integer> changeCount;
    Map<Object, String> threads;
    WeakReference<Object> parent;
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom");
    public static final String PROP_PENDINGCHANGES = "pendingChanges";
    public static final String PROP_VALUEADJUSTING = "valueAdjusting";
    private String valueIsAdjusting = null;
    private final DomLock mutatorLock = new DomLock();
    private final PropertyChangeSupport propertyChangeSupport;

    ChangesSupport(PropertyChangeSupport pcs, Object parent) {
        this.parent = new WeakReference<Object>(parent);
        this.changesPending = new HashMap<Object, Object>();
        this.changeCount = new HashMap<Object, Integer>();
        this.threads = new HashMap<Object, String>();
        if (pcs == null) {
            pcs = new PropertyChangeSupport(parent);
        }
        this.propertyChangeSupport = pcs;
    }

    synchronized List<Object> whoIsChanging(Object lockObject) {
        String msg = "whoIsChanging " + lockObject;
        logger.fine(msg);
        Object client = this.changesPending.get(lockObject);
        if (client == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(client);
    }

    synchronized void registerPendingChange(Object client, Object lockObject) {
        String msg = "registerPendingChange " + lockObject + " by " + client + "  in " + this.parent.get();
        logger.fine(msg);
        Object existingClient = this.changesPending.get(lockObject);
        if (existingClient != null) {
            if (existingClient != client) {
                throw new IllegalStateException("lock object in use: " + lockObject + ", by " + this.changesPending.get(lockObject));
            }
            if (existingClient == client) {
                logger.log(Level.FINE, "bug 1075: second change registered but the first was not done.");
            } else {
                return;
            }
        }
        boolean oldVal = this.isPendingChanges();
        this.changesPending.put(lockObject, client);
        this.threads.put(lockObject, Thread.currentThread().toString());
        this.propertyChangeSupport.firePropertyChange(PROP_PENDINGCHANGES, oldVal, this.isPendingChanges());
    }

    synchronized void performingChange(Object client, Object lockObject) {
        Integer count;
        Object ownerClient = this.changesPending.get(lockObject);
        if (ownerClient == null || ownerClient != client) {
            if (ownerClient != null && ownerClient != client) {
                logger.log(Level.INFO, "performingChange by client object is not owner {0}", client);
            }
            this.registerPendingChange(client, lockObject);
        }
        if ((count = this.changeCount.get(lockObject)) == null) {
            this.changeCount.put(lockObject, 1);
        } else {
            this.changeCount.put(lockObject, count + 1);
        }
        logger.log(Level.FINE, "performingChange {0} by {1}  in {2}", new Object[]{lockObject, client, this.parent});
    }

    synchronized void changePerformed(Object client, Object lockObject) {
        logger.log(Level.FINE, "clearPendingChange {0} by {1}  in {2}", new Object[]{lockObject, client, this.parent});
        Integer count = this.changeCount.get(lockObject);
        Object ownerClient = this.changesPending.get(lockObject);
        if (ownerClient == null) {
            logger.log(Level.INFO, "no lock object found for {0}", lockObject);
        } else if (ownerClient != client) {
            logger.log(Level.INFO, "change performed client object is not owner {0}", ownerClient);
        }
        boolean oldVal = this.isPendingChanges();
        if (count == null) {
            logger.log(Level.INFO, "expect value for changeCount {0}, was performingChange called?", lockObject);
            count = 0;
        } else {
            count = count - 1;
        }
        if (count == 0) {
            this.changesPending.remove(lockObject);
            this.threads.remove(lockObject);
            this.changeCount.remove(lockObject);
        } else if (count > 0) {
            this.changeCount.put(lockObject, count);
        } else {
            throw new IllegalStateException("what happened here--changeCount<0!");
        }
        this.propertyChangeSupport.firePropertyChange(PROP_PENDINGCHANGES, oldVal, this.isPendingChanges());
    }

    public boolean isPendingChanges() {
        return this.changesPending.size() > 0;
    }

    public boolean isPendingChanges(Object lockObject) {
        return this.changesPending.containsKey(lockObject);
    }

    public synchronized Map getChangesPending() {
        if (this.changesPending.isEmpty()) {
            return Collections.emptyMap();
        }
        return new HashMap<Object, Object>(this.changesPending);
    }

    public String isValueAdjusting() {
        return this.valueIsAdjusting;
    }

    protected synchronized DomLock mutatorLock() {
        return this.mutatorLock;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public String toString() {
        return "changeSupport: " + this.changesPending;
    }

    public class DomLock
    extends ReentrantLock {
        public void lock(String description) {
            super.lock();
            if (ChangesSupport.this.valueIsAdjusting == null) {
                ChangesSupport.this.valueIsAdjusting = description;
                ChangesSupport.this.propertyChangeSupport.firePropertyChange(ChangesSupport.PROP_VALUEADJUSTING, null, description);
            }
        }

        @Override
        public void lock() {
            this.lock("");
        }

        @Override
        public void unlock() {
            super.unlock();
            if (!super.isLocked()) {
                String old = ChangesSupport.this.valueIsAdjusting;
                ChangesSupport.this.valueIsAdjusting = null;
                ChangesSupport.this.propertyChangeSupport.firePropertyChange(ChangesSupport.PROP_VALUEADJUSTING, old, ChangesSupport.this.valueIsAdjusting);
            }
        }
    }
}

