/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.logging.Level;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Axis;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.LabelConverter;
import org.autoplot.dom.Plot;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.graph.DasAxis;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class AxisController
extends DomNodeController {
    DasAxis dasAxis;
    private Application dom;
    Plot plot;
    Axis axis;
    private static final Object PENDING_RANGE_TWEAK = "pendingRangeTweak";
    private boolean defaultOppositeRight = false;
    private final PropertyChangeListener rangeChangeListener = new PropertyChangeListener(){

        private DatumRange logCheckRange(DatumRange range, boolean log) {
            Units u = range.getUnits();
            double dmin = range.min().doubleValue(u);
            double dmax = range.max().doubleValue(u);
            boolean changed = false;
            if (log && dmax <= 0.0) {
                dmax = 1000.0;
                changed = true;
            }
            if (log && dmin <= 0.0) {
                dmin = dmax / 10000.0;
                changed = true;
            }
            if (changed) {
                return new DatumRange(dmin, dmax, u);
            }
            return range;
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt);
            if (((AxisController)AxisController.this).dom.controller.isValueAdjusting() || AxisController.this.valueIsAdjusting()) {
                return;
            }
            if (evt.getPropertyName().equals("range") || evt.getPropertyName().equals("log")) {
                AxisController.this.axis.setAutoRange(false);
            }
            switch (evt.getPropertyName()) {
                case "label": {
                    AxisController.this.axis.setAutoLabel(false);
                    break;
                }
                case "log": {
                    if (AxisController.this.isPendingChanges()) {
                        return;
                    }
                    DatumRange oldRange = AxisController.this.axis.range;
                    DatumRange range = this.logCheckRange(AxisController.this.axis.range, AxisController.this.axis.log);
                    if (range.equals(oldRange)) break;
                    if (new Exception().getStackTrace().length > 280) {
                        AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                        AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                        AxisController.this.axis.setLog(false);
                        AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                        break;
                    }
                    AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                    AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                    AxisController.this.axis.setRange(range);
                    AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                    break;
                }
                case "range": {
                    if (AxisController.this.isPendingChanges()) {
                        return;
                    }
                    DatumRange oldRange = AxisController.this.axis.range;
                    DatumRange range = this.logCheckRange(AxisController.this.axis.range, AxisController.this.axis.log);
                    if (range.equals(oldRange)) break;
                    if (new Exception().getStackTrace().length > 280) {
                        AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                        AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                        AxisController.this.axis.setLog(false);
                        AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                        break;
                    }
                    AxisController.this.changesSupport.registerPendingChange(this, PENDING_RANGE_TWEAK);
                    AxisController.this.changesSupport.performingChange(this, PENDING_RANGE_TWEAK);
                    if (AxisController.this.axis.isLog()) {
                        AxisController.this.axis.setLog(false);
                    }
                    AxisController.this.axis.setRange(range);
                    AxisController.this.changesSupport.changePerformed(this, PENDING_RANGE_TWEAK);
                    break;
                }
                case "scale": {
                    DatumRange otherRange;
                    Datum otherw;
                    Datum otherScale;
                    Datum scale;
                    double expand;
                    if (AxisController.this.dasAxis == null) break;
                    int npixels = AxisController.this.dasAxis.isHorizontal() ? AxisController.this.dasAxis.getColumn().getWidth() : AxisController.this.dasAxis.getRow().getHeight();
                    Units u = AxisController.this.dasAxis.getUnits();
                    Datum w = u != u.getOffsetUnits() ? AxisController.this.axis.getRange().width() : (AxisController.this.dasAxis.isLog() ? Units.log10Ratio.createDatum(Math.log10(AxisController.this.axis.getRange().max().divide(AxisController.this.axis.getRange().min()).value())) : AxisController.this.axis.getRange().width());
                    Datum oldScale = w.divide(npixels);
                    Datum newScale = (Datum)evt.getNewValue();
                    if (!oldScale.getUnits().isConvertibleTo(newScale.getUnits())) {
                        return;
                    }
                    if (oldScale.equals(newScale) || !(Math.abs(expand = ((scale = (Datum)evt.getNewValue()).divide(otherScale = (otherw = (u = (otherRange = AxisController.this.dasAxis.getDatumRange()).getUnits()) != u.getOffsetUnits() ? otherRange.width() : (AxisController.this.dasAxis.isLog() ? Units.log10Ratio.createDatum(Math.log10(otherRange.max().divide(otherRange.min()).value())) : otherRange.width())).divide(npixels)).value() - 1.0) / 2.0) > 1.0E-4)) break;
                    DomNodeController.logger.log(Level.FINER, "expand={0} scale={1} otherScale={2}", new Object[]{expand, scale, otherScale});
                    try {
                        DatumRange newOtherRange = AxisController.this.dasAxis.isLog() ? DatumRangeUtil.rescaleLog(otherRange, 0.0 - expand, 1.0 + expand) : DatumRangeUtil.rescale(otherRange, 0.0 - expand, 1.0 + expand);
                        AxisController.this.axis.setRange(newOtherRange);
                    }
                    catch (IllegalArgumentException ex) {
                        System.err.println("here129");
                    }
                    break;
                }
            }
        }
    };
    protected LabelConverter labelConverter;
    private final PropertyChangeListener scaleListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            int npixels = AxisController.this.dasAxis.isHorizontal() ? AxisController.this.dasAxis.getColumn().getWidth() : AxisController.this.dasAxis.getRow().getHeight();
            Units u = AxisController.this.dasAxis.getUnits();
            Datum w = u.getOffsetUnits() != u ? AxisController.this.axis.getRange().width() : (AxisController.this.dasAxis.isLog() ? Units.log10Ratio.createDatum(Math.log10(AxisController.this.axis.getRange().max().divide(AxisController.this.axis.getRange().min()).value())) : AxisController.this.axis.getRange().width());
            Datum scale = w.divide(npixels);
            AxisController.this.axis.setScale(scale);
        }
    };

    public AxisController(Application dom, Plot plot, Axis axis, DasAxis dasAxis) {
        super(axis);
        this.dom = dom;
        this.dasAxis = dasAxis;
        this.plot = plot;
        this.axis = axis;
        axis.controller = this;
        if (plot.zaxis == axis) {
            this.defaultOppositeRight = true;
        }
        this.bindTo(dasAxis);
        axis.addPropertyChangeListener(this.rangeChangeListener);
    }

    public boolean valueIsAdjusting() {
        return super.isValueAdjusting() || this.dasAxis.valueIsAdjusting();
    }

    public void setRangeAutomatically(DatumRange range, boolean log) {
        boolean oldAutoRange = this.axis.autoRange;
        this.axis.setRange(range);
        this.axis.setLog(log);
        this.axis.autoRange = oldAutoRange;
    }

    public void setLabelAutomatically(String label) {
        if (this.axis.getLabel().contains("%{RANGE}") && !label.contains("%{RANGE}")) {
            return;
        }
        this.axis.setLabel(label);
        this.axis.setAutoLabel(true);
    }

    public void resetAxisUnits(Units nu) {
        DatumRange oldRange = this.dasAxis.getDatumRange();
        DatumRange newRange = DatumRange.newDatumRange(oldRange.min().doubleValue(nu), oldRange.max().doubleValue(nu), nu);
        this.dasAxis.resetRange(newRange);
    }

    private Converter getOppositeConverter(Axis axis, final DasAxis dasAxis) {
        return new Converter(){

            public Object convertForward(Object s) {
                int orientation = dasAxis.isHorizontal() ? (s.equals(Boolean.TRUE) ? 1 : 2) : (AxisController.this.defaultOppositeRight ? (s.equals(Boolean.TRUE) ? 3 : 4) : (s.equals(Boolean.TRUE) ? 4 : 3));
                return orientation;
            }

            public Object convertReverse(Object t) {
                int orientation = (Integer)t;
                return orientation == 1 || orientation == 4;
            }
        };
    }

    public final synchronized void bindTo(DasAxis p) {
        ApplicationController ac = this.dom.controller;
        ac.bind(this.axis, "range", p, "datumRange");
        ac.bind(this.axis, "log", p, "log");
        this.labelConverter = new LabelConverter(this.dom, this.plot, this.axis, null, null);
        ac.bind(this.axis, "label", p, "label", this.labelConverter);
        ac.bind(this.axis, "fontSize", p, "fontSize");
        ac.bind(this.axis, "drawTickLabels", p, "tickLabelsVisible");
        ac.bind(this.axis, "flipped", p, "flipped");
        ac.bind(this.axis, "visible", p, "visible");
        ac.bind(this.axis, "opposite", p, "orientation", this.getOppositeConverter(this.axis, this.dasAxis));
        if (p.isHorizontal()) {
            p.getColumn().addPropertyChangeListener(this.scaleListener);
        } else {
            p.getRow().addPropertyChangeListener(this.scaleListener);
        }
        this.axis.addPropertyChangeListener("range", this.scaleListener);
        this.axis.addPropertyChangeListener("log", this.scaleListener);
    }

    public DasAxis getDasAxis() {
        return this.dasAxis;
    }

    void syncTo(DomNode n, List<String> exclude) {
        DasAxis.Lock lock = null;
        if (this.dasAxis != null) {
            lock = this.dasAxis.mutatorLock();
            lock.lock();
        }
        Axis that = (Axis)n;
        if (!exclude.contains("log")) {
            this.axis.setLog(that.isLog());
        }
        if (!exclude.contains("flipped")) {
            this.axis.setFlipped(that.isFlipped());
        }
        if (!exclude.contains("opposite")) {
            this.axis.setOpposite(that.isOpposite());
        }
        if (!exclude.contains("range")) {
            this.axis.setRange(that.getRange());
        }
        if (!exclude.contains("label")) {
            this.axis.setLabel(that.getLabel());
        }
        if (!exclude.contains("fontSize")) {
            this.axis.setFontSize(that.getFontSize());
        }
        if (!exclude.contains("autoRange")) {
            this.axis.setAutoRange(that.isAutoRange());
        }
        if (!exclude.contains("autoLabel")) {
            this.axis.setAutoLabel(that.isAutoLabel());
        }
        if (!exclude.contains("autoRangeHints")) {
            this.axis.setAutoRangeHints(that.getAutoRangeHints());
        }
        if (!exclude.contains("drawTickLabels")) {
            this.axis.setDrawTickLabels(that.isDrawTickLabels());
        }
        if (!exclude.contains("visible")) {
            this.axis.setVisible(that.isVisible());
        }
        if (lock != null) {
            lock.unlock();
        }
    }
}

