/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.autoplot.dom.AxisController;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.PropertyChangeDiff;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.Units;

public class Axis
extends DomNode {
    public static final DatumRange DEFAULT_RANGE = new DatumRange(0.0, 100.0, Units.dimensionless);
    protected DatumRange range = DEFAULT_RANGE;
    public static final String PROP_RANGE = "range";
    private Datum scale = Units.dimensionless.createDatum(0.1);
    public static final String PROP_SCALE = "scale";
    protected boolean log = false;
    public static final String PROP_LOG = "log";
    protected String label = "";
    public static final String PROP_LABEL = "label";
    private String fontSize = "1em";
    public static final String PROP_FONTSIZE = "fontSize";
    protected boolean drawTickLabels = true;
    public static final String PROP_DRAWTICKLABELS = "drawTickLabels";
    private boolean opposite = false;
    public static final String PROP_OPPOSITE = "opposite";
    public static final String PROP_VISIBLE = "visible";
    protected boolean visible = true;
    public static final String PROP_AUTORANGE = "autoRange";
    protected boolean autoRange = false;
    private String autoRangeHints = "";
    public static final String PROP_AUTORANGEHINTS = "autoRangeHints";
    public static final String PROP_AUTOLABEL = "autoLabel";
    protected boolean autoLabel = false;
    private boolean flipped = false;
    public static final String PROP_FLIPPED = "flipped";
    AxisController controller;

    public DatumRange getRange() {
        return this.range;
    }

    public void setRange(DatumRange range) {
        if (range == null) {
            logger.log(Level.WARNING, "range set to null!");
            return;
        }
        DatumRange oldRange = this.range;
        this.range = range;
        this.propertyChangeSupport.firePropertyChange(PROP_RANGE, oldRange, range);
    }

    public Datum getScale() {
        return this.scale;
    }

    public void setScale(Datum scale) {
        Datum oldScale = this.scale;
        this.scale = scale;
        this.propertyChangeSupport.firePropertyChange(PROP_SCALE, oldScale, scale);
    }

    public boolean isLog() {
        return this.log;
    }

    public void setLog(boolean log) {
        boolean oldLog = this.log;
        this.log = log;
        this.propertyChangeSupport.firePropertyChange(PROP_LOG, oldLog, log);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        String oldLabel = this.label;
        this.label = label;
        this.propertyChangeSupport.firePropertyChange(PROP_LABEL, oldLabel, label);
    }

    public String getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(String fontSize) {
        String oldFontSize = this.fontSize;
        this.fontSize = fontSize;
        this.propertyChangeSupport.firePropertyChange(PROP_FONTSIZE, oldFontSize, fontSize);
    }

    public boolean isDrawTickLabels() {
        return this.drawTickLabels;
    }

    public void setDrawTickLabels(boolean drawTickLabels) {
        boolean oldDrawTickLabels = this.drawTickLabels;
        this.drawTickLabels = drawTickLabels;
        this.propertyChangeSupport.firePropertyChange(PROP_DRAWTICKLABELS, oldDrawTickLabels, drawTickLabels);
    }

    public boolean isOpposite() {
        return this.opposite;
    }

    public void setOpposite(boolean opposite) {
        boolean oldOpposite = this.opposite;
        this.opposite = opposite;
        this.propertyChangeSupport.firePropertyChange(PROP_OPPOSITE, oldOpposite, opposite);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldVisible = this.visible;
        this.visible = visible;
        this.propertyChangeSupport.firePropertyChange(PROP_VISIBLE, oldVisible, visible);
    }

    public boolean isAutoRange() {
        return this.autoRange;
    }

    public void setAutoRange(boolean autorange) {
        if (this.controller != null) {
            logger.log(Level.FINEST, "{0}.setAutoRange({1})", new Object[]{this.id, autorange});
        }
        boolean oldAutorange = this.autoRange;
        this.autoRange = autorange;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTORANGE, oldAutorange, autorange);
    }

    public String getAutoRangeHints() {
        return this.autoRangeHints;
    }

    public void setAutoRangeHints(String autoRangeHints) {
        String oldAutoRangeHints = this.autoRangeHints;
        this.autoRangeHints = autoRangeHints;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTORANGEHINTS, oldAutoRangeHints, autoRangeHints);
    }

    public boolean isAutoLabel() {
        return this.autoLabel;
    }

    public void setAutoLabel(boolean autolabel) {
        boolean oldAutolabel = this.autoLabel;
        this.autoLabel = autolabel;
        this.propertyChangeSupport.firePropertyChange(PROP_AUTOLABEL, oldAutolabel, autolabel);
    }

    public boolean isFlipped() {
        return this.flipped;
    }

    public void setFlipped(boolean flipped) {
        boolean oldFlipped = this.flipped;
        this.flipped = flipped;
        this.propertyChangeSupport.firePropertyChange(PROP_FLIPPED, oldFlipped, flipped);
    }

    public AxisController getController() {
        return this.controller;
    }

    @Override
    public void syncTo(DomNode n) {
        super.syncTo(n);
        if (!(n instanceof Axis)) {
            throw new IllegalArgumentException("node should be an Axis");
        }
        if (this.controller != null) {
            this.controller.syncTo(n, new ArrayList<String>());
        } else {
            this.syncTo(n, new ArrayList<String>());
        }
    }

    @Override
    public void syncTo(DomNode n, List<String> exclude) {
        super.syncTo(n, exclude);
        if (!(n instanceof Axis)) {
            throw new IllegalArgumentException("node should be an Axis");
        }
        if (this.controller != null) {
            this.controller.syncTo(n, exclude);
        } else {
            Axis that = (Axis)n;
            if (!exclude.contains(PROP_LOG)) {
                this.setLog(that.isLog());
            }
            if (!exclude.contains(PROP_FLIPPED)) {
                this.setFlipped(that.isFlipped());
            }
            if (!exclude.contains(PROP_OPPOSITE)) {
                this.setOpposite(that.isOpposite());
            }
            if (!exclude.contains(PROP_RANGE)) {
                this.setRange(that.getRange());
            }
            if (!exclude.contains(PROP_SCALE)) {
                this.setScale(that.getScale());
            }
            if (!exclude.contains(PROP_LABEL)) {
                this.setLabel(that.getLabel());
            }
            if (!exclude.contains(PROP_FONTSIZE)) {
                this.setFontSize(that.getFontSize());
            }
            if (!exclude.contains(PROP_AUTORANGE)) {
                this.setAutoRange(that.isAutoRange());
            }
            if (!exclude.contains(PROP_AUTORANGEHINTS)) {
                this.setAutoRangeHints(that.getAutoRangeHints());
            }
            if (!exclude.contains(PROP_AUTOLABEL)) {
                this.setAutoLabel(that.isAutoLabel());
            }
            if (!exclude.contains(PROP_DRAWTICKLABELS)) {
                this.setDrawTickLabels(that.isDrawTickLabels());
            }
            if (!exclude.contains(PROP_VISIBLE)) {
                this.setVisible(that.isVisible());
            }
        }
    }

    @Override
    public DomNode copy() {
        Axis result = (Axis)super.copy();
        result.controller = null;
        return result;
    }

    @Override
    public List<Diff> diffs(DomNode node) {
        boolean b;
        if (!(node instanceof Axis)) {
            throw new IllegalArgumentException("node should be an Axis");
        }
        Axis that = (Axis)node;
        ArrayList<Diff> result = new ArrayList<Diff>();
        boolean bl = b = that.log == this.log;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_LOG, that.log, this.log));
        }
        boolean bl2 = b = that.flipped == this.flipped;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_FLIPPED, that.flipped, this.flipped));
        }
        boolean bl3 = b = that.opposite == this.opposite;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_OPPOSITE, that.opposite, this.opposite));
        }
        if (!(b = that.range.equals(this.range))) {
            result.add(new PropertyChangeDiff(PROP_RANGE, that.range, this.range));
        }
        if (!(b = that.scale.equals(this.scale))) {
            result.add(new PropertyChangeDiff(PROP_SCALE, that.scale, this.scale));
        }
        if (!(b = that.label.equals(this.label))) {
            result.add(new PropertyChangeDiff(PROP_LABEL, that.label, this.label));
        }
        if (!(b = that.fontSize.equals(this.fontSize))) {
            result.add(new PropertyChangeDiff(PROP_FONTSIZE, that.fontSize, this.fontSize));
        }
        boolean bl4 = b = that.autoRange == this.autoRange;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_AUTORANGE, that.autoRange, this.autoRange));
        }
        if (!(b = that.autoRangeHints.equals(this.autoRangeHints))) {
            result.add(new PropertyChangeDiff(PROP_AUTORANGEHINTS, that.autoRangeHints, this.autoRangeHints));
        }
        boolean bl5 = b = that.autoLabel == this.autoLabel;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_AUTOLABEL, that.autoLabel, this.autoLabel));
        }
        boolean bl6 = b = that.drawTickLabels == this.drawTickLabels;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_DRAWTICKLABELS, that.drawTickLabels, this.drawTickLabels));
        }
        boolean bl7 = b = that.visible == this.visible;
        if (!b) {
            result.add(new PropertyChangeDiff(PROP_VISIBLE, that.visible, this.visible));
        }
        return result;
    }
}

