/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.ColumnColumnConnectorMouseModule;
import org.autoplot.GuiSupport;
import org.autoplot.LayoutListener;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.AnnotationController;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationControllerSupport;
import org.autoplot.dom.ApplicationControllerSyncSupport;
import org.autoplot.dom.Axis;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.BindingSupport;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.CanvasController;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.Column;
import org.autoplot.dom.ColumnController;
import org.autoplot.dom.Connector;
import org.autoplot.dom.ConnectorController;
import org.autoplot.dom.DataSourceController;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DebugPropertyChangeSupport;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.DomOps;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotController;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementController;
import org.autoplot.dom.Row;
import org.autoplot.dom.RowController;
import org.autoplot.dom.TimeSeriesBrowseController;
import org.autoplot.layout.LayoutConstants;
import org.autoplot.util.RunLaterListener;
import org.das2.DasApplication;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRangeUtil;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.ColumnColumnConnector;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Renderer;
import org.das2.system.DefaultMonitorFactory;
import org.das2.system.MonitorFactory;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;

public class ApplicationController
extends DomNodeController
implements RunLaterListener.PropertyChange {
    Application application;
    ApplicationModel model;
    DasRow outerRow;
    DasColumn outerColumn;
    LayoutListener layoutListener;
    boolean headless;
    final Map<Object, BindingGroup> bindingContexts;
    protected BindingSupport bindingSupport = new BindingSupport();
    final Map<BindingModel, Binding> bindingImpls;
    final Map<Connector, ColumnColumnConnector> connectorImpls;
    final Map<Annotation, DasAnnotation> annotationImpls;
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom");
    private static final AtomicInteger canvasIdNum = new AtomicInteger(0);
    private static final AtomicInteger plotIdNum = new AtomicInteger(0);
    private static final AtomicInteger plotElementIdNum = new AtomicInteger(0);
    private static final AtomicInteger dsfIdNum = new AtomicInteger(0);
    private static final AtomicInteger rowIdNum = new AtomicInteger(0);
    private static final AtomicInteger columnIdNum = new AtomicInteger(0);
    private static final AtomicInteger annotationNum = new AtomicInteger(0);
    private static final AtomicInteger appIdNum = new AtomicInteger(0);
    ApplicationControllerSyncSupport syncSupport;
    ApplicationControllerSupport support;
    ActionListener eventListener;
    private static final String PENDING_BREAK_APART = "breakApart";
    public static final String VALUE_BLUR_FOCUS = "";
    PropertyChangeSupport das2PeerListenerSupport = new DebugPropertyChangeSupport(this);
    AtomicInteger eventId = new AtomicInteger();
    PropertyChangeListener controllerListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "controllerListener");
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "controller change: {0}.{1} ({2}->{3})", new Object[]{evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
            }
        }
    };
    PropertyChangeListener domListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            block17: {
                Object newValue;
                DomNodeController c;
                block18: {
                    DomNode d;
                    Object oldValue;
                    Object src;
                    LoggerManager.logPropertyChangeEvent(evt, "domListener");
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "dom change: {0}.{1} ({2}->{3})", new Object[]{evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()});
                    }
                    if ((src = evt.getSource()) instanceof DomNode) {
                        DomNodeController domNodeController = DomNodeController.getController((DomNode)src);
                    }
                    if (!ApplicationController.this.isValueAdjusting()) {
                        ApplicationController.this.fireActionEvent(new ActionEvent(evt.getSource(), ApplicationController.this.eventId.incrementAndGet(), evt.getPropertyName()));
                    }
                    if ((oldValue = evt.getOldValue()) != null) {
                        if (oldValue instanceof DomNode) {
                            DomNode d2 = (DomNode)oldValue;
                            d2.removePropertyChangeListener(ApplicationController.this.domListener);
                            c = DomNodeController.getController(d2);
                            if (c != null) {
                                c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                            }
                            for (DomNode domNode : d2.childNodes()) {
                                domNode.removePropertyChangeListener(ApplicationController.this.domListener);
                                c = DomNodeController.getController(domNode);
                                if (c == null) continue;
                                c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                            }
                        } else if (oldValue.getClass().isArray() && DomNode.class.isAssignableFrom(oldValue.getClass().getComponentType())) {
                            for (int i = 0; i < Array.getLength(oldValue); ++i) {
                                d = (DomNode)Array.get(oldValue, i);
                                d.removePropertyChangeListener(ApplicationController.this.domListener);
                                c = DomNodeController.getController(d);
                                if (c != null) {
                                    c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                                }
                                for (DomNode k : d.childNodes()) {
                                    k.removePropertyChangeListener(ApplicationController.this.domListener);
                                    c = DomNodeController.getController(k);
                                    if (c == null) continue;
                                    c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                                }
                            }
                        }
                    }
                    if ((newValue = evt.getNewValue()) == null) break block17;
                    if (!(newValue instanceof DomNode)) break block18;
                    d = (DomNode)newValue;
                    d.addPropertyChangeListener(ApplicationController.this.domListener);
                    c = DomNodeController.getController(d);
                    if (c != null) {
                        c.addPropertyChangeListener(ApplicationController.this.controllerListener);
                    }
                    for (DomNode k : d.childNodes()) {
                        k.addPropertyChangeListener(ApplicationController.this.domListener);
                        c = DomNodeController.getController(k);
                        if (c == null) continue;
                        c.addPropertyChangeListener(ApplicationController.this.controllerListener);
                    }
                    break block17;
                }
                if (!newValue.getClass().isArray() || !DomNode.class.isAssignableFrom(newValue.getClass().getComponentType())) break block17;
                for (int i = 0; i < Array.getLength(newValue); ++i) {
                    DomNode domNode = (DomNode)Array.get(newValue, i);
                    domNode.addPropertyChangeListener(ApplicationController.this.domListener);
                    c = DomNodeController.getController(domNode);
                    if (c != null) {
                        c.addPropertyChangeListener(ApplicationController.this.controllerListener);
                    }
                    for (DomNode k : domNode.childNodes()) {
                        k.addPropertyChangeListener(ApplicationController.this.domListener);
                        c = DomNodeController.getController(k);
                        if (c == null) continue;
                        c.removePropertyChangeListener(ApplicationController.this.controllerListener);
                    }
                }
            }
        }
    };
    FocusAdapter focusAdapter = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            PlotElement fp;
            LoggerManager.logGuiEvent(e);
            super.focusGained(e);
            Plot domPlot = ApplicationController.this.getPlotFor(e.getComponent());
            if (domPlot == null) {
                return;
            }
            DasPlot dasPlot = domPlot.controller.getDasPlot();
            PlotElement p = null;
            Renderer r = dasPlot.getFocusRenderer();
            if (r != null) {
                try {
                    p = ApplicationController.this.findPlotElement(r);
                    ApplicationController.this.setPlotElement(p);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            List<PlotElement> ps = ApplicationController.this.getPlotElementsFor(domPlot);
            if (p == null && ps.size() == 1) {
                ApplicationController.this.setFocusUri(ApplicationController.getFocusUriFor(ps.get(0)));
            }
            if (p == null && ps.size() > 0) {
                for (int i = ps.size() - 1; i >= 0; --i) {
                    PlotElement pe1 = ps.get(i);
                    if (pe1.isActive()) continue;
                    p = pe1;
                    break;
                }
            }
            final Plot fdomPlot = domPlot;
            if (p != null) {
                logger.log(Level.FINE, "focus due to plot getting focus: {0}", p);
                ApplicationController.this.setFocusUri(ApplicationController.getFocusUriFor(p));
                fp = p;
                if (ApplicationController.this.getPlotElement() != p) {
                    ApplicationController.this.setStatus(ApplicationController.VALUE_BLUR_FOCUS + domPlot + ", " + p + " selected");
                    if (ApplicationController.this.getApplication().getPlotElements().length > 1) {
                        Canvas c = ApplicationController.this.getCanvas();
                        c.controller.indicateSelection(Collections.singletonList(p));
                    }
                }
            } else {
                ApplicationController.this.setStatus(ApplicationController.VALUE_BLUR_FOCUS + domPlot + " selected");
                fp = null;
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ApplicationController.this.setPlot(fdomPlot);
                    if (fp != null) {
                        ApplicationController.this.setPlotElement(fp);
                    }
                }
            };
            new Thread(run, "focusPlot").start();
            LoggerManager.logExitGuiEvent(e);
        }
    };
    PropertyChangeListener plotIdListener = new PropertyChangeListener(){

        public String toString() {
            return ApplicationController.VALUE_BLUR_FOCUS + ApplicationController.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Plot dst;
            LoggerManager.logPropertyChangeEvent(evt, "plotIdListener");
            PlotElement p = (PlotElement)evt.getSource();
            String srcid = (String)evt.getOldValue();
            String dstid = (String)evt.getNewValue();
            if (srcid == null) {
                srcid = ApplicationController.VALUE_BLUR_FOCUS;
            }
            if (dstid == null) {
                dstid = ApplicationController.VALUE_BLUR_FOCUS;
            }
            Plot src = srcid.length() == 0 ? null : (Plot)DomUtil.getElementById(ApplicationController.this.application, srcid);
            Plot plot = dst = dstid.length() == 0 ? null : (Plot)DomUtil.getElementById(ApplicationController.this.application, dstid);
            if (src == null) {
                if (dst != null) {
                    dst.getController().addPlotElement(p, false);
                } else {
                    return;
                }
            }
            if (dst == null) {
                assert (src != null);
                src.getController().removePlotElement(p);
                return;
            }
            if (src != null) {
                ApplicationController.this.movePlotElement(p, src, dst);
                if (ApplicationController.this.getPlotElementsFor(dst).size() == 1) {
                    dst.syncTo(p.plotDefaults, Arrays.asList("id", "rowId", "columnId", "xaxis", "yaxis"));
                    List<BindingModel> bb = ApplicationController.this.findBindings(dst.getXaxis(), "range");
                    if (bb.isEmpty()) {
                        dst.getXaxis().syncTo(p.getPlotDefaults().getXaxis(), Arrays.asList("id"));
                    }
                    if ((bb = ApplicationController.this.findBindings(dst.getYaxis(), "range")).isEmpty()) {
                        dst.getYaxis().syncTo(p.getPlotDefaults().getYaxis(), Arrays.asList("id"));
                    }
                }
            }
        }
    };
    PropertyChangeListener rendererFocusListener = new PropertyChangeListener(){

        public String toString() {
            return ApplicationController.VALUE_BLUR_FOCUS + ApplicationController.this;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            LoggerManager.logPropertyChangeEvent(evt, "renderFocusListener");
            DasPlot dasPlot = (DasPlot)evt.getSource();
            Renderer r = dasPlot.getFocusRenderer();
            if (r == null) {
                return;
            }
            try {
                PlotElement p = ApplicationController.this.findPlotElement(r);
                if (ApplicationController.this.getPlotElement() != p) {
                    ApplicationController.this.setPlotElement(p);
                }
            }
            catch (IllegalArgumentException ex) {
                logger.fine("unable to find the plot element, assuming transitional state...");
            }
        }
    };
    protected String status = "";
    public static final String PROP_STATUS = "status";
    protected String focusUri = "";
    public static final String PROP_FOCUSURI = "focusUri";
    protected PlotElement plotElement;
    public static final String PROP_PLOT_ELEMENT = "plotElement";
    protected Plot plot;
    public static final String PROP_PLOT = "plot";
    protected Canvas canvas;
    public static final String PROP_CANVAS = "canvas";
    protected DataSourceFilter dataSourceFilter;
    public static final String PROP_DATASOURCEFILTER = "dataSourceFilter";
    private int pendingChangeCount = 0;
    public static final String PROP_PENDINGCHANGECOUNT = "pendingChangeCount";

    public ApplicationController(ApplicationModel model, Application application) {
        super(application);
        this.changesSupport.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                if (evt.getPropertyName().equals(ApplicationController.PROP_STATUS) && "ready".equals(evt.getNewValue())) {
                    ApplicationController.this.fireActionEvent(new ActionEvent(this, 0, "ready"));
                }
                if (evt.getPropertyName().equals("valueAdjusting") && evt.getNewValue() == null) {
                    String description = (String)evt.getOldValue();
                    if (description == null) {
                        logger.severe("description is null");
                    } else if (description.length() > 0) {
                        ApplicationController.this.fireActionEvent(new ActionEvent(this, 0, "label: " + description));
                    } else {
                        ApplicationController.this.fireActionEvent(new ActionEvent(this, 0, "ready"));
                    }
                }
            }
        });
        this.application = application;
        this.syncSupport = new ApplicationControllerSyncSupport(this);
        this.support = new ApplicationControllerSupport(this);
        int i = appIdNum.getAndIncrement();
        application.setId("app_" + i);
        application.getOptions().setId("options_" + i);
        application.addPropertyChangeListener(this.domListener);
        for (DomNode n : application.childNodes()) {
            n.addPropertyChangeListener(this.domListener);
        }
        this.model = model;
        application.controller = this;
        this.bindingContexts = new HashMap<Object, BindingGroup>();
        this.bindingImpls = new HashMap<BindingModel, Binding>();
        this.connectorImpls = new HashMap<Connector, ColumnColumnConnector>();
        this.annotationImpls = new HashMap<Annotation, DasAnnotation>();
        this.addListeners();
    }

    public void addActionListener(ActionListener list) {
        this.eventListener = AWTEventMulticaster.add(this.eventListener, list);
    }

    public Application getApplication() {
        return this.application;
    }

    public ApplicationModel getApplicationModel() {
        return this.model;
    }

    public void removeActionListener(ActionListener list) {
        ActionListener l = AWTEventMulticaster.remove(this.eventListener, list);
        logger.log(Level.FINEST, "removed {0}", l);
    }

    public synchronized void addDas2PeerChangeListener(PropertyChangeListener listener) {
        this.das2PeerListenerSupport.addPropertyChangeListener(listener);
        if (this.application.getPlots(0).getController() != null) {
            this.das2PeerListenerSupport.firePropertyChange("das2peer", null, this.application.getPlots(0).getController());
        }
    }

    void maybeAddContextMenus(PlotController aThis) {
        this.das2PeerListenerSupport.firePropertyChange("das2peer", null, aThis);
    }

    private void fireActionEvent(ActionEvent e) {
        ActionListener listener = this.eventListener;
        if (listener != null) {
            listener.actionPerformed(e);
        }
    }

    private static String getFocusUriFor(PlotElement p) {
        DataSourceFilter dsf = p.controller.getDataSourceFilter();
        if (dsf != null) {
            return dsf.getUri();
        }
        return VALUE_BLUR_FOCUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void breakIntoStackPlot(Plot domPlot) {
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("Break into Stack of Plots");
        Lock clock = this.canvas.controller.dasCanvas.mutatorLock();
        clock.lock();
        try {
            List<PlotElement> peles = this.getPlotElementsFor(domPlot);
            for (PlotElement pele : peles) {
                if (pele.isActive()) continue;
                this.deletePlotElement(pele);
            }
            peles = this.getPlotElementsFor(domPlot);
            if (peles.size() < 2) {
                this.setStatus("Only one plot element...");
            } else if (peles.size() > 12) {
                this.setStatus("Too many plots...");
            } else {
                Application dom = this.getApplication();
                peles = this.getPlotElementsFor(domPlot);
                PlotElement firstPE = peles.get(0);
                PlotElement lastPE = peles.get(peles.size() - 1);
                Iterator<PlotElement> iterator = peles.iterator();
                while (iterator.hasNext()) {
                    PlotElement pele;
                    PlotElement pelement = pele = iterator.next();
                    Plot dstPlot = this.addPlot(LayoutConstants.ABOVE);
                    pelement.setPlotId(dstPlot.getId());
                    if (pele == lastPE) {
                        dstPlot.getXaxis().setDrawTickLabels(true);
                    } else {
                        dstPlot.getXaxis().setDrawTickLabels(false);
                    }
                    if (pele == firstPE) {
                        dstPlot.setDisplayTitle(true);
                    } else {
                        dstPlot.setDisplayTitle(false);
                    }
                    dstPlot.getXaxis().setLog(false);
                    this.bind(dstPlot.getXaxis(), "range", dom, "timeRange");
                    DataSourceFilter dsf = this.getDataSourceFilterFor(pele);
                    TimeSeriesBrowseController tsbc = dsf.getController().getTimeSeriesBrowseController();
                    if (tsbc == null || !tsbc.isListeningToAxis() || tsbc.getPlot() != domPlot) continue;
                    tsbc.release();
                    tsbc.setupAxis(dstPlot, dstPlot.getXaxis());
                }
                this.deletePlot(domPlot);
                DomOps.newCanvasLayout(dom);
            }
        }
        finally {
            lock.unlock();
            clock.unlock();
        }
    }

    public void fillEditPlotMenu(final JMenu editPlotMenu, final Plot domPlot) {
        JMenuItem item = new JMenuItem(new AbstractAction("Delete Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (ApplicationController.this.application.getPlots().length > 1) {
                    List<PlotElement> plotElements = ApplicationController.this.getPlotElementsFor(domPlot);
                    for (PlotElement pele : plotElements) {
                        if (ApplicationController.this.application.getPlotElements().length > 1) {
                            ApplicationController.this.deletePlotElement(pele);
                            continue;
                        }
                        ApplicationController.this.setStatus("warning: the last plot element may not be deleted");
                    }
                    ApplicationController.this.deletePlot(domPlot);
                } else {
                    ArrayList<PlotElement> pes = new ArrayList<PlotElement>(ApplicationController.this.getPlotElementsFor(domPlot));
                    Collections.reverse(pes);
                    for (PlotElement pe : pes) {
                        ApplicationController.this.deletePlotElement(pe);
                    }
                    domPlot.syncTo(new Plot(), Arrays.asList("id", "rowId", "columnId"));
                }
            }
        });
        editPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Break into Stack of Plots"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                ApplicationController.this.registerPendingChange(ApplicationController.this, ApplicationController.PENDING_BREAK_APART);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        ApplicationController.this.performingChange(ApplicationController.this, ApplicationController.PENDING_BREAK_APART);
                        ApplicationController.this.breakIntoStackPlot(domPlot);
                        ApplicationController.this.changePerformed(ApplicationController.this, ApplicationController.PENDING_BREAK_APART);
                    }
                };
                RequestProcessor.invokeLater(run);
            }
        });
        item.setToolTipText("Replace the focus plot with stack of plots.");
        editPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Copy Plot to Clipboard"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = DomUtil.getPlotAsString(ApplicationController.this.application, domPlot);
                StringSelection stringSelection = new StringSelection(s);
                Clipboard clpbrd = Toolkit.getDefaultToolkit().getSystemClipboard();
                clpbrd.setContents(stringSelection, null);
            }
        });
        editPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Replace Plot with Clipboard Plot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiSupport.pasteClipboardIntoPlot(editPlotMenu, ApplicationController.this, domPlot);
            }
        });
        editPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Remove Bindings"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                ArrayList<BindingModel> bms = new ArrayList<BindingModel>();
                List<PlotElement> peles = ApplicationController.this.getPlotElementsFor(domPlot);
                for (PlotElement pele : peles) {
                    bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(pele)));
                    ApplicationController.this.unbind(pele);
                }
                bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(domPlot)));
                ApplicationController.this.unbind(domPlot);
                bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(domPlot.xaxis)));
                ApplicationController.this.unbind(domPlot.xaxis);
                bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(domPlot.yaxis)));
                ApplicationController.this.unbind(domPlot.yaxis);
                bms.addAll(Arrays.asList(ApplicationController.this.getBindingsFor(domPlot.zaxis)));
                ApplicationController.this.unbind(domPlot.zaxis);
                ApplicationController.this.setStatus("removed " + bms.size() + " bindings");
            }
        });
        item.setToolTipText("remove any plot and plot element property bindings");
        editPlotMenu.add(item);
        item = new JMenuItem(new AbstractAction("Bind Plot Context to Application Time Range"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                ApplicationController.this.bind(ApplicationController.this.application, "timeRange", ApplicationController.this.plot, "context");
            }
        });
        item.setToolTipText("bind the plot's context property to the application timerange, for example when browsing histograms of data.");
        editPlotMenu.add(item);
    }

    public Plot getPlotFor(Component c) {
        Plot plot1 = null;
        for (Plot p : this.application.getPlots()) {
            if (p.controller != null) {
                DasPlot p1 = p.controller.getDasPlot();
                if (p1 != null && (p1 == c || p1.getXAxis() == c || p1.getYAxis() == c)) {
                    plot1 = p;
                    break;
                }
                if (p.controller.getDasColorBar() != c) continue;
                plot1 = p;
                break;
            }
            logger.warning("application contains plot without controller (rte_0492573640)");
        }
        return plot1;
    }

    public PlotElement doplot(Plot plot, PlotElement pele, String secondaryUri, String teriaryUri, String primaryUri) {
        return this.support.plot(plot, pele, secondaryUri, teriaryUri, primaryUri);
    }

    public PlotElement doplot(Plot plot, PlotElement pele, String secondaryUri, String primaryUri) {
        return this.support.plot(plot, pele, secondaryUri, primaryUri);
    }

    public PlotElement doplot(Plot plot, PlotElement pele, String primaryUri) {
        return this.support.plot(plot, pele, primaryUri);
    }

    public void plotUri(String suri, boolean resetPlot) {
        ChangesSupport.DomLock lock = null;
        if (!resetPlot) {
            lock = this.application.controller.changesSupport.mutatorLock();
            lock.lock("plotUriWithoutChanges");
        }
        DataSourceFilter dsf = this.getDataSourceFilter();
        dsf.getController().setSuri(suri, new NullProgressMonitor());
        dsf.getController().update(true);
        if (!resetPlot) {
            assert (lock != null);
            lock.unlock();
        }
    }

    public void waitUntilIdle() {
        int checkCount = 0;
        Logger domLogger = LoggerManager.getLogger("autoplot.dom");
        while (this.isPendingChanges()) {
            ++checkCount;
            try {
                if (domLogger.isLoggable(Level.FINE)) {
                    Thread.sleep(470L);
                }
                Thread.sleep(30L);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        logger.log(Level.FINE, "waitUntilIdle checkCount={0}", checkCount);
    }

    public synchronized DataSourceFilter addDataSourceFilter() {
        DataSourceController dsfc;
        DataSourceFilter dsf = new DataSourceFilter();
        dsf.controller = dsfc = new DataSourceController(this.model, dsf);
        this.assignId(dsf);
        ArrayList<DataSourceFilter> dataSourceFilters = new ArrayList<DataSourceFilter>(Arrays.asList(this.application.getDataSourceFilters()));
        dataSourceFilters.add(dsf);
        this.application.setDataSourceFilters(dataSourceFilters.toArray(new DataSourceFilter[dataSourceFilters.size()]));
        dsf.addPropertyChangeListener(this.domListener);
        return dsf;
    }

    private void addListeners() {
        this.addPropertyChangeListener(PROP_PLOT_ELEMENT, new PropertyChangeListener(){

            public String toString() {
                return ApplicationController.VALUE_BLUR_FOCUS + ApplicationController.this;
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                if (!ApplicationController.this.isValueAdjusting()) {
                    PlotElement p = ApplicationController.this.getPlotElement();
                    if (p != null) {
                        DataSourceFilter dsf = ApplicationController.this.getDataSourceFilterFor(p);
                        if (dsf != null) {
                            ApplicationController.this.setDataSourceFilter(dsf);
                        }
                        ApplicationController.this.setPlot(ApplicationController.this.getPlotFor(p));
                    } else {
                        ApplicationController.this.setDataSourceFilter(null);
                    }
                }
            }
        });
        this.application.addPropertyChangeListener("plotElements", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                if (ApplicationController.this.application.getPlotElements().length > 1) {
                    ApplicationController.this.application.options.setLayoutVisible(true);
                }
            }
        });
        this.application.addPropertyChangeListener("bindings", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BindingModel[] bms;
                LoggerManager.logPropertyChangeEvent(evt);
                if (ApplicationController.this.isValueAdjusting()) {
                    return;
                }
                boolean noOneListening = true;
                for (BindingModel bm : bms = ApplicationController.this.application.getBindings()) {
                    if (!bm.getSrcId().equals(ApplicationController.this.application.getId()) || !bm.srcProperty.equals("timeRange")) continue;
                    noOneListening = false;
                }
                if (noOneListening) {
                    logger.fine("we used to reset application to default time range");
                }
            }
        });
    }

    public synchronized DasCanvas addCanvas() {
        logger.fine("enter addCanvas");
        DasCanvas.setDisableActions(true);
        Canvas lcanvas = new Canvas();
        DasCanvas dasCanvas = new DasCanvas(lcanvas.getWidth(), lcanvas.getHeight());
        dasCanvas.setScaleFonts(false);
        this.assignId(lcanvas);
        new CanvasController(this.application, lcanvas).setDasCanvas(dasCanvas);
        new RowController(lcanvas.getMarginRow()).createDasPeer(lcanvas, null);
        new ColumnController(lcanvas.getMarginColumn()).createDasPeer(lcanvas, null);
        this.layoutListener = new LayoutListener(this.model);
        this.application.setCanvases(new Canvas[]{lcanvas});
        this.setCanvas(lcanvas);
        this.bindTo(dasCanvas);
        lcanvas.addPropertyChangeListener(this.domListener);
        dasCanvas.setPrintingTag(VALUE_BLUR_FOCUS);
        return dasCanvas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlotElement(PlotElement pelement) {
        logger.log(Level.FINE, "deletePlotElement({0})", pelement);
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Delete Plot Element");
        int currentIdx = this.application.plotElements.indexOf(pelement);
        if (currentIdx == -1) {
            logger.warning("deletePlotElement but plot element isn't part of application, ignoring");
            lock.unlock();
            return;
        }
        try {
            List<PlotElement> dsfElements;
            String id = pelement.getId();
            if (this.application.plotElements.size() > 1) {
                DasPlot p = pelement.controller.getDasPlot();
                Renderer r = pelement.controller.getRenderer();
                if (p != null && r != null) {
                    p.removeRenderer(r);
                }
                Plot domplot = this.getPlotFor(pelement);
                pelement.removePropertyChangeListener(this.domListener);
                pelement.getStyle().removePropertyChangeListener(this.domListener);
                this.unbind(pelement);
                this.unbind(pelement.getStyle());
                this.unbindImpl(pelement);
                this.unbindImpl(pelement.getStyle());
                pelement.controller.unbindDsf();
                pelement.controller.disconnect();
                pelement.controller.dataSet = null;
                if (r != null) {
                    r.setColorBar(null);
                }
                if (domplot != null) {
                    domplot.controller.pdListen.remove(pelement);
                }
                if (r != null) {
                    r.setDataSet(null);
                }
                pelement.controller.deleted = true;
                pelement.removePropertyChangeListener(this.plotIdListener);
                PlotElement parent = pelement.controller.getParentPlotElement();
                if (parent != null) {
                    parent.getStyle().removePropertyChangeListener(pelement.controller.parentStyleListener);
                }
            }
            DataSourceFilter dsf = this.getDataSourceFilterFor(pelement);
            ArrayList<PlotElement> elements = new ArrayList<PlotElement>(Arrays.asList(this.application.getPlotElements()));
            elements.remove(pelement);
            PlotElement selected = this.getPlotElement();
            if (elements.size() > 0) {
                if (selected != null && !elements.contains(selected)) {
                    if (elements.isEmpty()) {
                        this.setPlotElement(null);
                    } else {
                        this.setPlotElement(elements.get(0));
                    }
                }
                this.application.setPlotElements(elements.toArray(new PlotElement[elements.size()]));
            } else {
                dsf.setUri(VALUE_BLUR_FOCUS);
                pelement.setLegendLabelAutomatically(VALUE_BLUR_FOCUS);
                pelement.setActive(true);
            }
            if (dsf != null && (dsfElements = this.getPlotElementsFor(dsf)).isEmpty() && this.application.getDataSourceFilters().length > 1) {
                this.deleteDataSourceFilter(dsf);
            }
            for (PlotElement p : this.application.plotElements) {
                if (!p.getParent().equals(id)) continue;
                p.setParent(VALUE_BLUR_FOCUS);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public void addConnector(Plot upperPlot, Plot lowerPlot) {
        logger.log(Level.FINE, "addConnector({0},{1})", new Object[]{upperPlot, lowerPlot});
        ArrayList<Connector> connectors = new ArrayList<Connector>(Arrays.asList(this.application.getConnectors()));
        Connector connector = new Connector(upperPlot.getId(), lowerPlot.getId());
        connectors.add(connector);
        connector.setController(new ConnectorController(this.application, connector));
        this.application.setConnectors(connectors.toArray(new Connector[connectors.size()]));
        DasCanvas lcanvas = this.getDasCanvas();
        DasPlot upper = upperPlot.controller.getDasPlot();
        DasPlot lower = lowerPlot.controller.getDasPlot();
        ColumnColumnConnector overviewPlotConnector = new ColumnColumnConnector(lcanvas, upper, DasRow.create(null, upper.getRow(), "0%", "100%+2em"), lower);
        this.connectorImpls.put(connector, overviewPlotConnector);
        overviewPlotConnector.setBottomCurtain(true);
        overviewPlotConnector.setCurtainOpacityPercent(80);
        connector.getController().bindTo(overviewPlotConnector);
        ColumnColumnConnectorMouseModule mm = new ColumnColumnConnectorMouseModule(upper, lower);
        overviewPlotConnector.getDasMouseInputAdapter().setSecondaryModule(mm);
        overviewPlotConnector.getDasMouseInputAdapter().setPrimaryModule(mm);
        lcanvas.add(overviewPlotConnector);
        lcanvas.revalidate();
    }

    public void deleteConnector(Connector connector) {
        logger.log(Level.FINE, "deleteConnector({0})", connector);
        ColumnColumnConnector impl = this.connectorImpls.get(connector);
        if (impl != null) {
            this.getDasCanvas().remove(impl);
        }
        ArrayList<Connector> connectors = DomUtil.asArrayList(this.application.getConnectors());
        connectors.remove(connector);
        this.connectorImpls.remove(connector);
        connector.getController().removeBindings();
        this.application.setConnectors(connectors.toArray(new Connector[connectors.size()]));
    }

    public Annotation addAnnotation(final Annotation annotation) {
        Column c;
        Row r;
        if (annotation.getPlotId().length() == 0) {
            annotation.setPlotId(this.getApplication().getPlots(0).getId());
        }
        Plot p = (Plot)DomUtil.getElementById(this.getApplication(), annotation.getPlotId());
        if (annotation.getRowId().length() > 0) {
            r = (Row)DomUtil.getElementById(this.getApplication().getCanvases(0), annotation.getRowId());
            if (r == null) {
                logger.log(Level.WARNING, "unable to find row with id=\"{0}\"", annotation.getRowId());
                r = p == null ? this.application.getCanvases(0).getMarginRow() : p.getController().getRow();
            }
        } else {
            r = p == null ? this.application.getCanvases(0).getMarginRow() : p.getController().getRow();
        }
        if (annotation.getRowId().length() > 0) {
            c = (Column)DomUtil.getElementById(this.getApplication().getCanvases(0), annotation.getColumnId());
            if (c == null) {
                logger.log(Level.WARNING, "unable to find column with id=\"{0}\"", annotation.getColumnId());
                c = p == null ? this.application.getCanvases(0).getMarginColumn() : p.getController().getColumn();
            }
        } else {
            c = p == null ? this.application.getCanvases(0).getMarginColumn() : p.getController().getColumn();
        }
        final DasAnnotation impl = new DasAnnotation(VALUE_BLUR_FOCUS);
        this.assignId(annotation);
        if (p != null) {
            impl.setPlot(p.controller.getDasPlot());
        }
        JMenuItem mi = new JMenuItem(new AbstractAction("Annotation Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PropertyEditor pp = new PropertyEditor(annotation);
                pp.showDialog(ApplicationController.this.application.getCanvases(0).getController().getDasCanvas());
            }
        });
        impl.getDasMouseInputAdapter().addMenuItem(mi);
        mi = new JMenuItem(new AbstractAction("Delete Annotation"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                ApplicationController.this.deleteAnnotation(annotation);
            }
        });
        impl.getDasMouseInputAdapter().addMenuItem(mi);
        JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(new AbstractAction("Anchor to Data"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                    Rectangle r = impl.getActiveRegion().getBounds();
                    Datum x = ApplicationController.this.plot.getController().getDasPlot().getXAxis().invTransform(r.x);
                    Datum y = ApplicationController.this.plot.getController().getDasPlot().getYAxis().invTransform(r.y);
                    Datum x2 = ApplicationController.this.plot.getController().getDasPlot().getXAxis().invTransform(r.x + r.width);
                    Datum y2 = ApplicationController.this.plot.getController().getDasPlot().getYAxis().invTransform(r.y + r.height);
                    annotation.setXrange(DatumRangeUtil.union(x, x2));
                    annotation.setYrange(DatumRangeUtil.union(y, y2));
                    annotation.setAnchorOffset(ApplicationController.VALUE_BLUR_FOCUS);
                    annotation.setAnchorType(AnchorType.DATA);
                } else {
                    annotation.setAnchorType(AnchorType.CANVAS);
                    annotation.setAnchorOffset("1em,1em");
                    annotation.setAnchorPosition(AnchorPosition.NE);
                }
            }
        });
        impl.getDasMouseInputAdapter().addMenuItem(cbmi);
        this.bind(annotation, "anchorType", cbmi, "selected", new Converter(){

            public Object convertForward(Object s) {
                return !s.equals((Object)AnchorType.CANVAS);
            }

            public Object convertReverse(Object t) {
                if (((Boolean)t).booleanValue()) {
                    return AnchorType.DATA;
                }
                return AnchorType.CANVAS;
            }
        });
        impl.getDasMouseInputAdapter().addMenuItem(mi);
        impl.getDasMouseInputAdapter().removeMenuItem("Properties");
        impl.getDasMouseInputAdapter().removeMenuItem("remove arrow");
        impl.getDasMouseInputAdapter().removeMenuItem("remove");
        impl.getDasMouseInputAdapter().setSecondaryModuleByLabel("Move Annotation");
        this.annotationImpls.put(annotation, impl);
        ArrayList<Annotation> annotations = DomUtil.asArrayList(this.application.getAnnotations());
        annotations.add(annotation);
        this.application.setAnnotations(annotations.toArray(new Annotation[annotations.size()]));
        DasCanvas lcanvas = this.getDasCanvas();
        annotation.setColumnId(c.getId());
        annotation.setRowId(r.getId());
        lcanvas.add(impl, r.controller.dasRow, c.controller.dasColumn);
        new AnnotationController(this.application, annotation, impl);
        return annotation;
    }

    public Annotation addAnnotation(Plot p, String text) {
        Row r = p.getController().getRow();
        Column c = p.getController().getColumn();
        Annotation a = this.addAnnotation(r, c, text);
        a.setPlotId(p.getId());
        return a;
    }

    public Annotation addAnnotation(Row row, Column column, String text) {
        if (row == null) {
            row = this.application.getCanvases(0).getMarginRow();
        }
        if (column == null) {
            column = this.application.getCanvases(0).getMarginColumn();
        }
        Annotation annotation = new Annotation();
        annotation.setRowId(row.getId());
        annotation.setColumnId(column.getId());
        annotation.setText(text);
        this.addAnnotation(annotation);
        return annotation;
    }

    public void deleteAnnotation(Annotation c) {
        logger.log(Level.FINE, "deleteAnnotation({0})", c);
        DasAnnotation impl = this.annotationImpls.get(c);
        if (impl != null) {
            this.getDasCanvas().remove(impl);
        }
        ArrayList<Annotation> annotations = DomUtil.asArrayList(this.application.getAnnotations());
        annotations.remove(c);
        this.annotationImpls.remove(c);
        c.getController().removeBindings();
        c.controller.node = null;
        c.controller = null;
        this.application.setAnnotations(annotations.toArray(new Annotation[annotations.size()]));
    }

    private void movePlotElement(PlotElement p, Plot src, Plot dst) {
        assert (src == null || p.getPlotId().equals(src.getId()) || p.getPlotId().equals(dst.getId()));
        if (src == dst) {
            return;
        }
        if (src != null) {
            src.getController().removePlotElement(p);
        }
        dst.getController().addPlotElement(p, false);
        p.setPlotId(dst.getId());
    }

    public PlotElement addPlotElement(Plot domPlot, DataSourceFilter dsf) {
        return this.addPlotElement(domPlot, null, dsf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotElement addPlotElement(Plot domPlot, PlotElement parent, DataSourceFilter dsf) {
        PlotElementController pec;
        logger.log(Level.FINE, "enter addPlotElement({0},{1})", new Object[]{domPlot, dsf});
        PlotElement pele1 = new PlotElement();
        if (dsf == null) {
            dsf = this.addDataSourceFilter();
        }
        pele1.controller = pec = new PlotElementController(this.model, this.application, pele1);
        if (domPlot == null) {
            domPlot = this.addPlot(LayoutConstants.BELOW);
        }
        this.assignId(pele1);
        pele1.getStyle().setColor(this.application.getOptions().getColor());
        pele1.getStyle().setFillColor(this.application.getOptions().getFillColor());
        pele1.getStyle().setAntiAliased(this.application.getOptions().isDrawAntiAlias());
        pele1.addPropertyChangeListener("plotId", this.plotIdListener);
        if (parent != null) {
            pele1.setParent(parent.getId());
            pele1.setRenderType(parent.getRenderType());
        }
        pele1.setPlotId(domPlot.getId());
        pele1.setDataSourceFilterId(dsf.getId());
        pele1.setAutoLabel(true);
        ApplicationController applicationController = this;
        synchronized (applicationController) {
            PlotElement[] p = this.application.getPlotElements();
            PlotElement[] temp = new PlotElement[p.length + 1];
            System.arraycopy(p, 0, temp, 0, p.length);
            temp[p.length] = pele1;
            this.application.setPlotElements(temp);
            pele1.addPropertyChangeListener(this.domListener);
            pele1.getStyle().addPropertyChangeListener(this.domListener);
            if (this.plotElement == null) {
                this.setPlotElement(pele1);
            }
        }
        if (domPlot.getController() != null) {
            domPlot.controller.addPlotElement(pele1);
        }
        return pele1;
    }

    public synchronized Plot addPlot(Object direction) {
        Plot focus = this.getPlot();
        return this.addPlot(focus, direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Plot addPlot(Plot focus, Object direction) {
        if (!SwingUtilities.isEventDispatchThread()) {
            logger.fine("SF Bug 3516412: addPlot is called off the event thread!!!");
        }
        logger.fine("enter addPlot");
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Add Plot");
        final Plot domPlot = new Plot();
        try {
            Column domColumn;
            Row domRow;
            final Canvas c = this.getCanvas();
            CanvasController ccontroller = c.controller;
            if (focus != null && ccontroller.getRowFor(focus) == c.marginRow) {
                String srcRow;
                if (c.getRows().length > 0) {
                    srcRow = c.getRows(0).getId();
                } else {
                    ccontroller.addRows(2);
                    srcRow = c.getRows(0).getId();
                }
                domRow = c.getRows().length > 1 ? c.getRows(1) : ccontroller.addInsertRow(ccontroller.getRowFor(focus), direction);
                focus.setRowId(srcRow);
            } else {
                domRow = c.getRows().length == 0 && (direction == LayoutConstants.BELOW || direction == LayoutConstants.ABOVE) ? ccontroller.addRow() : (direction == null || direction == LayoutConstants.LEFT || direction == LayoutConstants.RIGHT ? ccontroller.getRowFor(focus) : ccontroller.addInsertRow(ccontroller.getRowFor(focus), direction));
            }
            if (direction == null || direction == LayoutConstants.ABOVE || direction == LayoutConstants.BELOW) {
                domColumn = c.marginColumn;
            } else if (focus != null && ccontroller.getColumnFor(focus) == c.marginColumn) {
                String srcColumn;
                if (c.getColumns().length > 0) {
                    srcColumn = c.getColumns(0).getId();
                } else {
                    ccontroller.addColumns(2);
                    srcColumn = c.getColumns(0).getId();
                }
                domColumn = c.getColumns().length > 1 ? c.getColumns(1) : ccontroller.addInsertColumn(ccontroller.getColumnFor(focus), direction);
                focus.setColumnId(srcColumn);
            } else {
                domColumn = ccontroller.addInsertColumn(ccontroller.getColumnFor(focus), direction);
            }
            this.assignId(domPlot);
            final Column fcol = domColumn;
            final Row frow = domRow;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    new PlotController(ApplicationController.this.application, domPlot).createDasPeer(c, frow, fcol);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            domPlot.getXaxis().setAutoRange(true);
            domPlot.getYaxis().setAutoRange(true);
            domPlot.getZaxis().setAutoRange(true);
            domPlot.getXaxis().setAutoLabel(true);
            domPlot.getYaxis().setAutoLabel(true);
            domPlot.getZaxis().setAutoLabel(true);
            domPlot.setAutoLabel(true);
            domPlot.setAutoBinding(true);
            domPlot.getZaxis().setVisible(false);
            domPlot.setRowId(domRow.getId());
            domPlot.setColumnId(domColumn.getId());
            ArrayList<Plot> plots = new ArrayList<Plot>(Arrays.asList(this.application.getPlots()));
            if (focus != null) {
                int idx = plots.indexOf(focus);
                if (direction == null || direction == LayoutConstants.BELOW) {
                    ++idx;
                }
                plots.add(idx, domPlot);
            } else {
                plots.add(domPlot);
            }
            this.application.setPlots(plots.toArray(new Plot[plots.size()]));
            if (this.getPlot() == null) {
                this.setPlot(domPlot);
            }
            domPlot.addPropertyChangeListener(this.domListener);
        }
        finally {
            lock.unlock();
        }
        return domPlot;
    }

    public Plot addPlot(Row row, Column column) {
        Plot p = this.addPlot(null);
        p.setRowId(row.getId());
        p.setColumnId(column.getId());
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot addPlot(String xpos, String ypos) {
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("addPlot");
        try {
            CanvasController ccontroller = this.getCanvas().getController();
            Column c = ccontroller.addColumn();
            String[] ss = xpos.split(",");
            c.setLeft(ss[0]);
            c.setRight(ss[1]);
            Row r = ccontroller.addRow();
            ss = ypos.split(",");
            r.setTop(ss[0]);
            r.setBottom(ss[1]);
            Plot p = this.addPlot(r, c);
            this.addPlotElement(p, null);
            Plot plot = p;
            return plot;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Plot> addPlots(int nrow, int ncol, Object dir) {
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock(String.format("addPlots(%d,%d,%s)", nrow, ncol, dir));
        try {
            ArrayList<Plot> result = new ArrayList<Plot>(nrow * ncol);
            CanvasController ccontroller = this.getCanvas().getController();
            List<Column> cols = ncol > 1 ? ccontroller.addColumns(ncol) : Collections.singletonList(this.getCanvas().getMarginColumn());
            List<Row> rows = dir == null && nrow == 1 ? Collections.singletonList(ccontroller.getRowFor(this.plot)) : (dir == null ? ccontroller.addRows(nrow, LayoutConstants.BELOW) : ccontroller.addRows(nrow, dir));
            for (int i = 0; i < nrow; ++i) {
                for (int j = 0; j < ncol; ++j) {
                    Plot p = this.addPlot(rows.get(i), cols.get(j));
                    result.add(p);
                    this.addPlotElement(p, null);
                }
            }
            ArrayList<Plot> arrayList = result;
            return arrayList;
        }
        finally {
            lock.unlock();
        }
    }

    protected PlotElement findPlotElement(Renderer rend) {
        for (PlotElement p : this.application.getPlotElements()) {
            PlotElementController pc = p.controller;
            if (pc.getRenderer() != rend) continue;
            return p;
        }
        throw new IllegalArgumentException("unable to find plot element for das renderer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plot copyPlotAndPlotElements(Plot domPlot, DataSourceFilter dsf, boolean bindx, boolean bindy) {
        Plot newPlot;
        List<PlotElement> srcElements = this.getPlotElementsFor(domPlot);
        ChangesSupport.DomLock lock = this.mutatorLock();
        lock.lock("Copy Plot and Plot Elements");
        try {
            newPlot = this.copyPlot(domPlot, bindx, bindy, false);
            if (srcElements.isEmpty()) {
                Plot plot = newPlot;
                return plot;
            }
            ArrayList<PlotElement> newElements = new ArrayList<PlotElement>();
            for (PlotElement srcElement : srcElements) {
                PlotElement newp;
                if (!srcElement.getComponent().equals(VALUE_BLUR_FOCUS)) {
                    if (srcElement.getController().getParentPlotElement() != null) continue;
                    newp = this.copyPlotElement(srcElement, newPlot, dsf);
                    newElements.add(newp);
                    continue;
                }
                newp = this.copyPlotElement(srcElement, newPlot, dsf);
                newElements.add(newp);
                List<PlotElement> srcKids = srcElement.controller.getChildPlotElements();
                DataSourceFilter dsf1 = this.getDataSourceFilterFor(newp);
                for (PlotElement k : srcKids) {
                    if (!srcElements.contains(k)) continue;
                    PlotElement kidp = this.copyPlotElement(k, newPlot, dsf1);
                    kidp.getController().setParentPlotElement(newp);
                    newElements.add(kidp);
                }
            }
            for (PlotElement newp : newElements) {
                newp.getController().setResetRanges(false);
                newp.getController().setResetComponent(false);
                newp.getController().setResetPlotElement(false);
                newp.getController().setResetRenderType(false);
                newp.getController().setDsfReset(true);
            }
            List<BindingModel> bms = this.findBindings(domPlot, "context");
            for (BindingModel bm : bms) {
                DomNode other;
                if (bm.srcId.equals(domPlot.id)) {
                    other = DomUtil.getElementById(this.node, bm.dstId);
                    if (other == null) continue;
                    this.bind(newPlot, "context", other, bm.dstProperty);
                    continue;
                }
                other = DomUtil.getElementById(this.node, bm.srcId);
                if (other == null) continue;
                this.bind(other, bm.srcProperty, newPlot, "context");
            }
        }
        finally {
            lock.unlock();
        }
        return newPlot;
    }

    protected PlotElement copyPlotElement(PlotElement srcElement, Plot domPlot, DataSourceFilter dsf) {
        logger.log(Level.FINER, "copyPlotElement({0},{1},{2})", new Object[]{srcElement, domPlot, dsf});
        PlotElement newp = this.addPlotElement(domPlot, dsf);
        newp.getController().setResetPlotElement(false);
        newp.getController().setResetRanges(false);
        newp.getController().setDsfReset(false);
        newp.syncTo(srcElement, Arrays.asList("id", "plotId", "dataSourceFilterId"));
        newp.getController().setResetRanges(false);
        if (dsf == null) {
            DataSourceFilter dsfnew = newp.controller.getDataSourceFilter();
            DataSourceFilter dsfsrc = srcElement.controller.getDataSourceFilter();
            this.copyDataSourceFilter(dsfsrc, dsfnew);
        }
        return newp;
    }

    protected PlotElement makeChildPlotElement(PlotElement srcElement, Plot domPlot, DataSourceFilter dsf) {
        logger.log(Level.FINER, "makeChildPlotElement({0},{1},{2})", new Object[]{srcElement, domPlot, dsf});
        PlotElement newp = this.addPlotElement(domPlot, srcElement, dsf);
        newp.getController().setResetPlotElement(false);
        newp.getController().setDsfReset(false);
        newp.syncTo(srcElement, Arrays.asList("id", "plotId", "dataSourceFilterId"));
        if (dsf == null) {
            DataSourceFilter dsfnew = newp.controller.getDataSourceFilter();
            DataSourceFilter dsfsrc = srcElement.controller.getDataSourceFilter();
            this.copyDataSourceFilter(dsfsrc, dsfnew);
        }
        return newp;
    }

    public Plot copyPlot(Plot srcPlot, boolean bindx, boolean bindy, boolean addPlotElement) {
        Plot that = this.addPlot(LayoutConstants.BELOW);
        that.setAutoBinding(false);
        that.getController().setAutoBinding(false);
        if (addPlotElement) {
            this.addPlotElement(that, null);
        }
        that.syncTo(srcPlot, Arrays.asList("id", "rowId", "columnId"));
        if (bindx) {
            BindingModel bb = this.findBinding(this.application, "timeRange", srcPlot.getXaxis(), "range");
            if (bb == null) {
                this.bind(srcPlot.getXaxis(), "range", that.getXaxis(), "range");
            } else {
                this.bind(this.application, "timeRange", that.getXaxis(), "range");
            }
            that.xaxis.setAutoRange(false);
        }
        if (bindy) {
            this.bind(srcPlot.getYaxis(), "range", that.getYaxis(), "range");
            that.yaxis.setAutoRange(false);
        }
        return that;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyDataSourceFilter(DataSourceFilter dsfsrc, DataSourceFilter dsfnew) {
        ChangesSupport.DomLock lock = dsfnew.getController().mutatorLock();
        lock.lock("Copy Data Source Filter");
        try {
            boolean dataSetNeedsLoading = dsfsrc.controller.isDataSetNeedsLoading();
            dsfnew.controller.setResetDimensions(false);
            if (dsfsrc.getUri().length() > 0) {
                dsfnew.setUri(dsfsrc.getUri());
            }
            if (!dataSetNeedsLoading) {
                dsfnew.controller.setUriNeedsResolution(false);
                dsfnew.controller.resetDataSource(true, dsfsrc.controller.getDataSource());
                dsfnew.controller.setDataSetNeedsLoading(false);
                dsfnew.controller.setResetDimensions(false);
                dsfnew.controller.setDataSetInternal(dsfsrc.controller.getDataSet(), dsfsrc.controller.getRawProperties(), this.isValueAdjusting());
                dsfnew.controller.setProperties(dsfsrc.controller.getProperties());
                dsfnew.setFilters(dsfsrc.getFilters());
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlot(Plot domPlot) {
        if (domPlot == null) {
            throw new NullPointerException("plot is null");
        }
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Delete Plot");
        try {
            if (!this.application.plots.contains(domPlot)) {
                throw new IllegalArgumentException("plot is not in this application");
            }
            if (this.application.plots.size() < 2) {
                throw new IllegalArgumentException("last plot cannot be deleted");
            }
            List<PlotElement> elements = this.getPlotElementsFor(domPlot);
            if (elements.size() > 0) {
                for (PlotElement p : elements) {
                    if (this.application.plotElements.size() <= 1) continue;
                    this.deletePlotElement(p);
                }
            }
            for (Connector c : DomUtil.asArrayList(this.application.getConnectors())) {
                if (!c.getPlotA().equals(domPlot.getId()) && !c.getPlotB().equals(domPlot.getId())) continue;
                this.deleteConnector(c);
            }
            Row deleteRow = null;
            Row row = (Row)DomUtil.getElementById(this.application, domPlot.getRowId());
            if (row != null) {
                List<DomNode> plotsUsingRow = DomUtil.rowUsages(this.application, row.getId());
                plotsUsingRow.remove(domPlot);
                if (plotsUsingRow.isEmpty()) {
                    deleteRow = row;
                }
            }
            domPlot.removePropertyChangeListener(this.domListener);
            this.unbind(domPlot);
            this.unbind(domPlot.getXaxis());
            this.unbind(domPlot.getYaxis());
            this.unbind(domPlot.getZaxis());
            this.unbindImpl(domPlot);
            this.unbindImpl(domPlot.getXaxis());
            this.unbindImpl(domPlot.getYaxis());
            this.unbindImpl(domPlot.getZaxis());
            if (domPlot.controller == null) {
                logger.warning("domPlot.controller is null, this shouldn't happen");
            } else {
                domPlot.controller.removeBindings();
                DasPlot p = domPlot.controller.getDasPlot();
                p.getDasMouseInputAdapter().releaseAll();
                p.getXAxis().getDasMouseInputAdapter().releaseAll();
                p.getYAxis().getDasMouseInputAdapter().releaseAll();
                DasColorBar cb = domPlot.controller.getDasColorBar();
                cb.getDasMouseInputAdapter().releaseAll();
                final DasCanvas lcanvas = this.getDasCanvas();
                final ArrayList<DasCanvasComponent> deleteKids = new ArrayList<DasCanvasComponent>();
                deleteKids.add(p);
                deleteKids.add(cb);
                deleteKids.add(domPlot.controller.getDasPlot().getXAxis());
                deleteKids.add(domPlot.controller.getDasPlot().getYAxis());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (Component c : deleteKids) {
                            lcanvas.remove(c);
                        }
                    }
                });
            }
            ApplicationController applicationController = this;
            synchronized (applicationController) {
                ArrayList<Plot> plots = new ArrayList<Plot>(Arrays.asList(this.application.getPlots()));
                plots.remove(domPlot);
                if (!plots.contains(this.getPlot())) {
                    if (plots.isEmpty()) {
                        this.setPlot(null);
                    } else {
                        this.setPlot((Plot)plots.get(0));
                    }
                }
                this.application.setPlots(plots.toArray(new Plot[plots.size()]));
                if (deleteRow != null) {
                    assert (row != null);
                    CanvasController cc = row.controller.getCanvas().controller;
                    cc.deleteRow(deleteRow);
                    if (this.application.getOptions().isAutolayout()) {
                        cc.removeGaps();
                    }
                }
            }
            if (domPlot.controller == null) {
                domPlot.getController().getDasPlot().releaseAll();
            }
        }
        finally {
            lock.unlock();
        }
    }

    protected synchronized void deleteAnyParentsOfDataSourceFilter(DataSourceFilter dsf) {
        DataSourceFilter[] parents = dsf.controller.getParentSources();
        ArrayList<DataSourceFilter> alsoRemove = new ArrayList<DataSourceFilter>();
        for (DataSourceFilter pdf : parents) {
            if (pdf == null) continue;
            String dsfId = pdf.getId();
            List<DomNode> usages = DomUtil.dataSourceUsages(this.application, dsfId);
            usages.remove(dsf);
            if (!usages.isEmpty()) continue;
            alsoRemove.add(pdf);
        }
        if (alsoRemove.size() > 0) {
            ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>(Arrays.asList(this.application.getDataSourceFilters()));
            dsfs.removeAll(alsoRemove);
            this.application.setDataSourceFilters(dsfs.toArray(new DataSourceFilter[dsfs.size()]));
            for (DataSourceFilter alsoRemove1 : alsoRemove) {
                TimeSeriesBrowseController tsbc = alsoRemove1.controller.getTimeSeriesBrowseController();
                if (tsbc == null) continue;
                tsbc.release();
            }
        }
    }

    public synchronized void deleteDataSourceFilter(DataSourceFilter dsf) {
        if (!this.application.dataSourceFilters.contains(dsf)) {
            logger.fine("dsf wasn't part of the application");
            return;
        }
        if (this.application.dataSourceFilters.size() < 2) {
            throw new IllegalArgumentException("last plot cannot be deleted");
        }
        List<PlotElement> plotElements = this.getPlotElementsFor(dsf);
        if (plotElements.size() > 0) {
            throw new IllegalArgumentException("dsf must not have plot elements before deleting");
        }
        dsf.removePropertyChangeListener(this.domListener);
        this.unbind(dsf);
        dsf.controller.unbind();
        DataSourceFilter[] parents = dsf.controller.getParentSources();
        ArrayList<DataSourceFilter> alsoRemove = new ArrayList<DataSourceFilter>();
        for (DataSourceFilter pdf : parents) {
            if (pdf == null) continue;
            String dsfId = pdf.getId();
            List<DomNode> usages = DomUtil.dataSourceUsages(this.application, dsfId);
            usages.remove(dsf);
            if (!usages.isEmpty()) continue;
            alsoRemove.add(pdf);
        }
        ArrayList<DataSourceFilter> dsfs = new ArrayList<DataSourceFilter>(Arrays.asList(this.application.getDataSourceFilters()));
        dsfs.remove(dsf);
        dsfs.removeAll(alsoRemove);
        if (!dsfs.contains(this.getDataSourceFilter())) {
            if (dsfs.isEmpty()) {
                this.setDataSourceFilter(null);
            } else {
                this.setDataSourceFilter((DataSourceFilter)dsfs.get(0));
            }
        }
        this.application.setDataSourceFilters(dsfs.toArray(new DataSourceFilter[dsfs.size()]));
        TimeSeriesBrowseController tsbc = dsf.getController().getTimeSeriesBrowseController();
        if (tsbc != null) {
            tsbc.releaseAll();
        }
        for (DataSourceFilter alsoRemove1 : alsoRemove) {
            tsbc = alsoRemove1.controller.getTimeSeriesBrowseController();
            if (tsbc == null) continue;
            tsbc.releaseAll();
        }
    }

    public void cancelAllPendingTasks() {
        MonitorFactory mf = this.application.controller.getMonitorFactory();
        if (mf instanceof DefaultMonitorFactory) {
            DefaultMonitorFactory.MonitorEntry[] mes;
            DefaultMonitorFactory dmf = (DefaultMonitorFactory)mf;
            for (DefaultMonitorFactory.MonitorEntry me : mes = dmf.getMonitors()) {
                ProgressMonitor m = me.getMonitor();
                if (m.isCancelled() || m.isFinished()) continue;
                m.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void reset() {
        logger.fine("Resetting application...");
        this.setStatus("resetting...");
        ChangesSupport.DomLock lock = this.mutatorLock();
        long t0 = System.currentTimeMillis();
        while (lock.isLocked()) {
            logger.log(Level.INFO, "lock is not available: {0}", lock.toString());
            logger.finer(this.changesSupport.isValueAdjusting());
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            if (System.currentTimeMillis() - t0 <= 10000L) continue;
            logger.log(Level.WARNING, "Unable to get canvas lock to reset application because of lock: {0}", this.changesSupport.isValueAdjusting());
        }
        lock.lock("Reset");
        Lock canvasLock = this.getCanvas().controller.getDasCanvas().mutatorLock();
        canvasLock.lock();
        logger.fine("got locks to reset application...");
        try {
            void var13_28;
            int i;
            List<Annotation> annos = Arrays.asList(this.application.getAnnotations());
            for (Annotation anno : annos) {
                this.application.controller.deleteAnnotation(anno);
            }
            this.application.controller.setPlot(this.application.getPlots(0));
            List<PlotElement> peles = this.application.controller.getPlotElementsFor(this.plot);
            if (peles.size() > 0) {
                this.application.controller.setPlotElement(peles.get(0));
            } else {
                this.application.controller.setPlotElement(this.application.getPlotElements(0));
            }
            for (int i3 = this.application.getPlots().length - 1; i3 > 0; --i3) {
                this.deletePlot(this.application.getPlots(i3));
            }
            Plot p0 = this.application.getPlots(0);
            if (p0 == null) {
                throw new NullPointerException("p0 is null");
            }
            if (p0.getXaxis() == null) {
                throw new NullPointerException("p0.getXaxis() is null");
            }
            if (p0.getXaxis().getController() == null) {
                throw new NullPointerException("p0.getXaxis().getController() is null");
            }
            if (p0.getXaxis().getController().getDasAxis() == null) {
                throw new NullPointerException("p0.getXaxis().getController().getDasAxis() is null");
            }
            p0.getXaxis().getController().getDasAxis().setTcaFunction(null);
            p0.getXaxis().getController().getDasAxis().setReference(VALUE_BLUR_FOCUS);
            p0.getYaxis().getController().getDasAxis().setReference(VALUE_BLUR_FOCUS);
            for (int i2 = this.application.getPlotElements().length - 1; i2 > 0; --i2) {
                this.deletePlotElement(this.application.getPlotElements(i2));
            }
            this.application.getDataSourceFilters(0).setId("data_0");
            this.application.getPlotElements(0).setDataSourceFilterId("data_0");
            if (p0 != this.application.getPlots(0)) {
                this.movePlotElement(this.application.getPlotElements(0), p0, this.application.getPlots(0));
            }
            this.application.getPlots(0).setId("plot_0");
            this.application.getPlotElements(0).setPlotId("plot_0");
            this.application.controller.setPlotElement(this.application.getPlotElements(0));
            this.application.controller.setPlot(this.application.getPlots(0));
            for (int i2 = this.application.getDataSourceFilters().length - 1; i2 > 0; --i2) {
                this.deleteDataSourceFilter(this.application.getDataSourceFilters(i2));
            }
            TimeSeriesBrowseController tsbc = this.application.getDataSourceFilters(0).getController().getTimeSeriesBrowseController();
            if (tsbc != null) {
                tsbc.releaseAll();
            }
            this.application.getPlotElements(0).setId("plotElement_0");
            this.application.getPlots(0).getXaxis().setLog(false);
            this.application.getPlots(0).getYaxis().setLog(false);
            this.application.getPlots(0).getZaxis().setLog(false);
            this.application.getPlots(0).syncTo(new Plot(), Arrays.asList("id", "rowId", "columnId"));
            this.application.getPlots(0).getXaxis().setAutoRange(true);
            this.application.getPlots(0).getYaxis().setAutoRange(true);
            this.application.getPlots(0).getZaxis().setAutoRange(true);
            this.application.getPlots(0).getXaxis().setAutoRangeHints(VALUE_BLUR_FOCUS);
            this.application.getPlots(0).getYaxis().setAutoRangeHints(VALUE_BLUR_FOCUS);
            this.application.getPlots(0).getZaxis().setAutoRangeHints(VALUE_BLUR_FOCUS);
            for (int i4 = this.application.getBindings().length - 1; i4 >= 0; --i4) {
                this.deleteBinding(this.application.getBindings(i4));
            }
            Canvas c = this.application.getCanvases(0);
            this.application.getPlots(0).setColumnId(c.getMarginColumn().getId());
            this.application.getPlots(0).setRowId(c.getRows(0).getId());
            for (i = c.getRows().length - 1; i >= 1; --i) {
                c.getController().deleteRow(c.getRows(i));
            }
            if (c.getRows().length > 0) {
                c.getRows(0).syncTo(new Row(), Arrays.asList("id", "top", "bottom", "parent"));
                c.getRows(0).setTop("+2em");
                c.getRows(0).setBottom("+100%-2em");
            }
            c.getMarginRow().setTop("2em");
            c.getMarginRow().setBottom("100%-3em");
            c.getMarginColumn().setLeft("+7.0em");
            c.getMarginColumn().setRight("100%-7.0em");
            for (i = c.getColumns().length - 1; i >= 0; --i) {
                c.getController().deleteColumn(c.getColumns(i));
            }
            c.setFitted(true);
            this.application.getDataSourceFilters(0).syncTo(new DataSourceFilter(), Collections.singletonList("id"));
            this.application.getDataSourceFilters(0).getController().setDataSetInternal(null, null, true);
            this.application.getPlots(0).syncTo(new Plot(), Arrays.asList("id", "columnId", "rowId"));
            this.application.getPlotElements(0).syncTo(new PlotElement(), Arrays.asList("id", "plotId", "dataSourceFilterId", "renderType"));
            this.application.getPlots(0).syncTo(new Plot(), Arrays.asList("id", "columnId", "rowId"));
            this.application.getPlots(0).setAutoLabel(true);
            this.application.getPlotElements(0).syncTo(new PlotElement(), Arrays.asList("id", "plotId", "dataSourceFilterId"));
            this.application.getPlotElements(0).setAutoLabel(true);
            this.application.getPlotElements(0).getPlotDefaults().setId("plot_defaults_0");
            this.application.getPlotElements(0).getStyle().setId("style_0");
            this.application.getPlotElements(0).getStyle().setFillColor(Color.decode("#404040"));
            this.application.getPlotElements(0).getStyle().setColor(this.application.getOptions().getColor());
            if (!this.application.getCanvases(0).getController().getDasCanvas().getBackground().equals(this.application.getOptions().getBackground())) {
                this.application.getCanvases(0).getController().getDasCanvas().setBackground(this.application.getOptions().getBackground());
            }
            this.application.getPlots(0).getXaxis().setAutoLabel(true);
            this.application.getPlots(0).getYaxis().setAutoLabel(true);
            this.application.getPlots(0).getZaxis().setAutoLabel(true);
            this.application.getPlots(0).getXaxis().setAutoRange(true);
            this.application.getPlots(0).getYaxis().setAutoRange(true);
            this.application.getPlots(0).getZaxis().setAutoRange(true);
            this.application.getPlotElements((int)0).controller.setDsfReset(true);
            this.application.getPlots(0).getZaxis().setVisible(false);
            this.application.setTimeRange(Application.DEFAULT_TIME_RANGE);
            this.application.getPlots(0).setTicksURI(VALUE_BLUR_FOCUS);
            this.application.getPlots(0).setContext(this.application.getPlots(0).getXaxis().getRange());
            this.application.setEventsListUri(VALUE_BLUR_FOCUS);
            this.resetIdSequenceNumbers();
            for (PlotElement plotElement : this.application.getPlotElements()) {
                plotElement.getController().dataSet = null;
                plotElement.getController().getRenderer().setDataSet(null);
            }
            for (DomNode domNode : this.application.getDataSourceFilters()) {
                ((DataSourceFilter)domNode).getController().dataSet = null;
                ((DataSourceFilter)domNode).getController().fillDataSet = null;
                ((DataSourceFilter)domNode).getController().histogram = null;
            }
            this.unbind(this.application);
            this.bind(this.application, "timeRange", this.plot, "context");
            c.controller.getDasCanvas().removeBottomDecorators();
            c.controller.getDasCanvas().removeTopDecorators();
            ArrayList<DasCanvasComponent> extraCC = new ArrayList<DasCanvasComponent>();
            DasCanvasComponent[] dasCanvasComponentArray = c.controller.getDasCanvas().getCanvasComponents();
            int n = dasCanvasComponentArray.length;
            boolean bl = false;
            while (var13_28 < n) {
                DasCanvasComponent cc = dasCanvasComponentArray[var13_28];
                if (!(cc instanceof DasPlot || cc instanceof DasAxis || cc instanceof ColumnColumnConnector || cc instanceof DasAnnotation)) {
                    extraCC.add(cc);
                }
                ++var13_28;
            }
            for (DasCanvasComponent cc : extraCC) {
                c.controller.getDasCanvas().remove(cc);
            }
            boolean resetFonts = false;
            if (resetFonts) {
                try {
                    File f = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "config");
                    f = new File(f, "defaults.vap");
                    if (f.exists()) {
                        Application application = ScriptContext.loadVap(f.toString());
                        this.application.options.syncTo(application.options);
                    } else {
                        logger.info("saving initial vap to HOME/autoplot_data/config/defaults.vap");
                        ScriptContext.save(f.toString());
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    DasCanvasComponent[] dccs;
                    Canvas c = ApplicationController.this.getCanvas();
                    for (DasCanvasComponent dcc : dccs = c.controller.getDasCanvas().getCanvasComponents()) {
                        if (dcc instanceof DasPlot) {
                            Renderer[] rr;
                            DasPlot p = (DasPlot)dcc;
                            boolean okay = false;
                            for (Plot pp : ApplicationController.this.application.getPlots()) {
                                if (pp.getController().getDasPlot() != p) continue;
                                okay = true;
                            }
                            if (!okay) {
                                c.controller.getDasCanvas().remove(p);
                                continue;
                            }
                            for (Renderer rr1 : rr = p.getRenderers()) {
                                okay = false;
                                for (PlotElement pes : ApplicationController.this.application.getPlotElements()) {
                                    if (pes.getController().getRenderer() != rr1) continue;
                                    okay = true;
                                }
                                if (!okay) {
                                    p.removeRenderer(rr1);
                                }
                                rr1.setTopDecorator(null);
                            }
                            p.getXAxis().setTickV(null);
                            p.getYAxis().setTickV(null);
                            continue;
                        }
                        if (!(dcc instanceof DasColorBar)) continue;
                        ((DasColorBar)dcc).setTickV(null);
                    }
                }
            };
            try {
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeAndWait(run);
                }
            }
            catch (InterruptedException | InvocationTargetException exception) {
                logger.log(Level.SEVERE, exception.getMessage(), exception);
            }
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    ApplicationController.this.cancelAllPendingTasks();
                }
            };
            new Thread(runnable).start();
        }
        finally {
            canvasLock.unlock();
            lock.unlock();
        }
        ArrayList<String> problems = new ArrayList<String>();
        if (!DomUtil.validateDom(this.application, problems)) {
            logger.warning(problems.toString());
        }
        logger.fine("done..");
        this.setStatus("ready");
    }

    public BindingSupport peekBindingSupport() {
        return this.bindingSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(DomNode src, String srcProp, Object dst, String dstProp, Converter converter) {
        BindingGroup bc;
        BindingModel bindingModel;
        logger.log(Level.FINER, "bind {0}.{1} to {2}.{3}", new Object[]{src, srcProp, dst, dstProp});
        String srcId = src.getId();
        String dstId = "???";
        if (dst instanceof DomNode) {
            dstId = ((DomNode)dst).getId();
        }
        if (dst instanceof DasCanvasComponent) {
            dstId = "das2:" + ((DasCanvasComponent)dst).getDasName();
        }
        if (this.application.bindings.contains(bindingModel = new BindingModel(srcId, srcId, srcProp, dstId, dstProp))) {
            if (this.application.controller.isValueAdjusting()) {
                logger.finest("binding already exists, ignoring");
                return;
            }
            logger.finest("binding already exists, ignoring");
            this.setStatus("binding already exists: " + bindingModel);
            return;
        }
        try {
            DomUtil.getPropertyType(src, srcProp);
            if (dst instanceof DomNode) {
                DomUtil.getPropertyType((DomNode)dst, dstProp);
            }
        }
        catch (IllegalAccessException | InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
        Map<Object, BindingGroup> map = this.bindingContexts;
        synchronized (map) {
            bc = this.bindingContexts.get(src);
            if (bc == null) {
                bc = new BindingGroup();
                this.bindingContexts.put(src, bc);
            }
        }
        if (!dstId.equals("???") && !dstId.startsWith("das2:")) {
            Binding binding = this.hasBinding(src, srcProp, dst, dstProp);
            if (binding != null) {
                logger.fine("binding already exists...");
            } else {
                binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)BeanProperty.create((String)srcProp), (Object)dst, (Property)BeanProperty.create((String)dstProp));
                if (converter != null) {
                    binding.setConverter(converter);
                }
                ArrayList<BindingModel> bindings = new ArrayList<BindingModel>(Arrays.asList(this.application.getBindings()));
                bindings.add(bindingModel);
                this.application.setBindings(bindings.toArray(new BindingModel[bindings.size()]));
                bc.addBinding(binding);
                binding.bind();
                this.bindingImpls.put(bindingModel, binding);
            }
        } else {
            this.bindingSupport.bind(src, srcProp, dst, dstProp, converter);
        }
    }

    public void bind(DomNode src, String srcProp, Object dst, String dstProp) {
        this.bind(src, srcProp, dst, dstProp, null);
    }

    public void unbind(DomNode src, String srcProp, Object dst, String dstProp) {
        String dstId = "???";
        if (dst instanceof DomNode) {
            dstId = ((DomNode)dst).getId();
        }
        if (dst instanceof DasCanvasComponent) {
            dstId = "das2:" + ((DasCanvasComponent)dst).getDasName();
        }
        if (!dstId.equals("???") && !dstId.startsWith("das2:")) {
            BindingModel bm = this.findBinding(src, srcProp, (DomNode)dst, dstProp);
            Binding binding = this.bindingImpls.get(bm);
            if (binding != null) {
                this.deleteBinding(bm);
            } else {
                logger.log(Level.FINE, "expected to find binding for {0}.{1} to {2}.{3}", new Object[]{src.getId(), srcProp, ((DomNode)dst).getId(), dstProp});
            }
        } else {
            this.bindingSupport.unbind(src, srcProp, dst, dstProp);
        }
    }

    private static String propname(Property p) {
        String srcProp = p.toString();
        int i1 = srcProp.indexOf(91);
        int i2 = srcProp.indexOf(93, i1);
        if (i1 > -1 && i2 > i1) {
            srcProp = srcProp.substring(i1 + 1, i2);
        }
        return srcProp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showBindings() {
        Map<Object, BindingGroup> map = this.bindingContexts;
        synchronized (map) {
            for (Map.Entry<Object, BindingGroup> e : this.bindingContexts.entrySet()) {
                List bs = e.getValue().getBindings();
                System.err.println("=== " + e.getKey() + " -> " + e.getValue() + " (size=" + bs.size() + ")");
                if (bs.size() <= 0) continue;
                for (Binding b : bs) {
                    System.err.println(String.format(" %s.%s->%s.%s", b.getSourceObject(), ApplicationController.propname(b.getSourceProperty()), b.getTargetObject(), ApplicationController.propname(b.getTargetProperty())));
                }
                System.err.println(VALUE_BLUR_FOCUS);
            }
        }
    }

    private Binding hasBinding(Object s, String sp, Object t, String tp) {
        BindingGroup bc = this.bindingContexts.get(s);
        List bs = bc.getBindings();
        String lookfor = String.format("%s.%s->%s.%s", s, sp, t, tp);
        for (Binding b : bs) {
            String test = String.format("%s.%s->%s.%s", b.getSourceObject(), ApplicationController.propname(b.getSourceProperty()), b.getTargetObject(), ApplicationController.propname(b.getTargetProperty()));
            if (!test.equals(lookfor)) continue;
            return b;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(DomNode src) {
        Map<Object, Object> map = this.bindingImpls;
        synchronized (map) {
            ArrayList<BindingModel> bb = new ArrayList<BindingModel>(Arrays.asList(this.application.getBindings()));
            boolean changed = false;
            for (BindingModel b : this.application.getBindings()) {
                if (!b.getSrcId().equals(src.getId()) && !b.getDstId().equals(src.getId())) continue;
                bb.remove(b);
                Binding bimpl = this.bindingImpls.get(b);
                if (bimpl != null) {
                    try {
                        bimpl.unbind();
                    }
                    catch (IllegalStateException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                    this.bindingImpls.remove(b);
                    logger.log(Level.FINE, "bindingImpls.size()={0}", this.bindingImpls.size());
                }
                changed = true;
            }
            if (changed) {
                this.application.setBindings(bb.toArray(new BindingModel[bb.size()]));
            }
        }
        map = this.bindingContexts;
        synchronized (map) {
            BindingGroup bc = this.bindingContexts.get(src);
            if (bc != null) {
                bc.unbind();
                this.bindingContexts.remove(src);
                String bcid = src.getId();
                ArrayList<BindingModel> bindings = DomUtil.asArrayList(this.application.getBindings());
                ArrayList<BindingModel> remove = new ArrayList<BindingModel>();
                boolean changed = false;
                for (BindingModel bb : bindings) {
                    if (!bb.getBindingContextId().equals(bcid)) continue;
                    remove.add(bb);
                    changed = true;
                }
                if (changed) {
                    bindings.removeAll(remove);
                    this.application.setBindings(bindings.toArray(new BindingModel[bindings.size()]));
                }
            }
            for (Map.Entry<Object, BindingGroup> e : this.bindingContexts.entrySet()) {
                BindingGroup bg = e.getValue();
                ArrayList<BindingModel> remove = new ArrayList<BindingModel>();
                for (BindingModel b : bg.getBindings()) {
                    if (!b.getTargetObject().equals(src)) continue;
                    remove.add(b);
                }
                for (BindingModel b : remove) {
                    bg.removeBinding((Binding)b);
                }
            }
        }
    }

    protected void unbindImpl(DomNode src) {
        this.bindingSupport.unbind(src);
    }

    public void deleteBinding(BindingModel binding) {
        Binding b = this.bindingImpls.get(binding);
        if (b == null) {
            logger.log(Level.SEVERE, "didn''t find the binding implementation for {0}, ignoring", binding);
        } else if (b.isBound()) {
            b.unbind();
        }
        this.bindingImpls.remove(binding);
        logger.log(Level.FINE, "bindingImpls.size()={0}", this.bindingImpls.size());
        BindingGroup bc = this.bindingContexts.get(DomUtil.getElementById(this.application, binding.srcId));
        if (bc != null) {
            try {
                bc.removeBinding(b);
            }
            catch (Exception e) {
                logger.fine("deleteBinding still needs attention.");
            }
        }
        logger.log(Level.FINER, "dstId binding={0}", String.valueOf(this.bindingContexts.get(binding.dstId)));
        ArrayList<BindingModel> bindings = DomUtil.asArrayList(this.application.getBindings());
        bindings.remove(binding);
        this.application.setBindings(bindings.toArray(new BindingModel[bindings.size()]));
    }

    public BindingModel findBinding(DomNode src, String srcProp, DomNode dst, String dstProp) {
        return DomUtil.findBinding(this.application, src, srcProp, dst, dstProp);
    }

    public List<BindingModel> findBindings(DomNode src, String srcProp) {
        return DomUtil.findBindings(this.application, src, srcProp);
    }

    public List<BindingModel> findBindings(DomNode src, String srcProp, DomNode dst, String dstProp) {
        return DomUtil.findBindings(this.application, src, srcProp, dst, dstProp);
    }

    public BindingModel[] getBindingsFor(DomNode node) {
        List<BindingModel> results = this.findBindings(node, null, null, null);
        return results.toArray(new BindingModel[results.size()]);
    }

    public DomNode getElementById(String id) {
        return DomUtil.getElementById(this.application, id);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        logger.log(Level.FINE, "{0} (status message)", status);
        String oldStatus = this.status;
        this.status = status;
        this.propertyChangeSupport.firePropertyChange(PROP_STATUS, oldStatus, status);
    }

    public String getFocusUri() {
        return this.focusUri;
    }

    public void setFocusUri(String focusUri) {
        logger.log(Level.FINE, "setFocusUri({0})", focusUri);
        if (focusUri == null) {
            focusUri = VALUE_BLUR_FOCUS;
        }
        String oldFocusUri = this.focusUri;
        this.focusUri = focusUri;
        this.propertyChangeSupport.firePropertyChange(PROP_FOCUSURI, oldFocusUri, focusUri);
    }

    public Plot getPlotAbove(Plot p) {
        return this.getPlot(p, LayoutConstants.ABOVE);
    }

    public Plot getPlotBelow(Plot p) {
        return this.getPlot(p, LayoutConstants.BELOW);
    }

    public Plot getNextPlotHoriz(Plot p, Object dir) {
        Column r = this.getCanvas().getController().getColumnFor(p);
        Column left = this.getCanvas().getController().getColumn(r, dir);
        if (left == null) {
            return null;
        }
        int n = this.application.getPlots().length;
        Plot best = null;
        for (int i = 0; i < n; ++i) {
            Plot p1 = this.application.getPlots(i);
            if (!p1.getColumnId().equals(left.getId())) continue;
            if (best == null) {
                best = p1;
                continue;
            }
            if (!p1.getRowId().equals(p.getRowId())) continue;
            best = p1;
        }
        return best;
    }

    public Plot getPlot(Plot p, Object dir) {
        Row r = this.getCanvas().getController().getRowFor(p);
        Row above = this.getCanvas().getController().getRow(r, dir);
        if (above == null) {
            return null;
        }
        int n = this.application.getPlots().length;
        Plot best = null;
        for (int i = 0; i < n; ++i) {
            Plot p1 = this.application.getPlots(i);
            if (!p1.getRowId().equals(above.getId())) continue;
            if (best == null) {
                best = p1;
                continue;
            }
            if (!p1.getColumnId().equals(p.getColumnId())) continue;
            best = p1;
        }
        return best;
    }

    public Plot getPlotFor(PlotElement element) {
        String id = element.getPlotId();
        Plot result = null;
        for (Plot p : this.application.getPlots()) {
            if (!p.getId().equals(id)) continue;
            result = p;
        }
        return result;
    }

    public List<PlotElement> getPlotElementsFor(Plot plot) {
        return DomUtil.getPlotElementsFor(this.application, plot);
    }

    public DataSourceFilter getDataSourceFilterFor(PlotElement element) {
        String id = element.getDataSourceFilterId();
        DataSourceFilter result = null;
        for (DataSourceFilter dsf : this.application.getDataSourceFilters()) {
            if (!dsf.getId().equals(id)) continue;
            result = dsf;
        }
        return result;
    }

    public List<PlotElement> getPlotElementsFor(DataSourceFilter dsf) {
        String id = dsf.getId();
        ArrayList<PlotElement> result = new ArrayList<PlotElement>();
        for (PlotElement p : this.application.getPlotElements()) {
            if (!p.getDataSourceFilterId().equals(id)) continue;
            result.add(p);
        }
        return result;
    }

    public Plot getFirstPlotFor(DataSourceFilter dsf) {
        String lookFor = dsf.getId();
        PlotElement f = null;
        for (PlotElement pe : this.application.plotElements) {
            if (!pe.getDataSourceFilterId().equals(lookFor)) continue;
            f = pe;
        }
        Pattern p = Pattern.compile("vap\\+internal:([a-z][a-z_0-9]*)(,([a-z][a-z_0-9]*))*");
        if (f == null) {
            for (DataSourceFilter dsf1 : this.application.getDataSourceFilters()) {
                Matcher m;
                if (dsf1.getUri().length() <= 0 || !(m = p.matcher(dsf1.getUri())).matches()) continue;
                int n = m.groupCount() + 1;
                for (int i = 1; i < n; i += 2) {
                    if (!m.group(i).equals(dsf.getId())) continue;
                    if (Thread.currentThread().getStackTrace().length < 100) {
                        return this.getFirstPlotFor(dsf1);
                    }
                    throw new IllegalArgumentException("circular references in dsfs");
                }
            }
            return null;
        }
        return this.getPlotFor(f);
    }

    protected void assignId(DomNode node) {
        if (node instanceof Row) {
            node.setId("row_" + rowIdNum.getAndIncrement());
        } else if (node instanceof Column) {
            node.setId("column_" + columnIdNum.getAndIncrement());
        } else if (node instanceof Annotation) {
            node.setId("annotation_" + annotationNum);
            annotationNum.getAndIncrement();
        } else if (node instanceof DataSourceFilter) {
            node.setId("data_" + dsfIdNum);
            dsfIdNum.getAndIncrement();
        } else if (node instanceof Canvas) {
            int i = canvasIdNum.getAndIncrement();
            node.setId("canvas_" + i);
            Canvas ca = (Canvas)node;
            ca.getMarginColumn().setId("marginColumn_" + i);
            ca.getMarginRow().setId("marginRow_" + i);
        } else if (node instanceof PlotElement) {
            int i = plotElementIdNum.getAndIncrement();
            node.setId("plotElement_" + i);
            ((PlotElement)node).getStyle().setId("style_" + i);
            ((PlotElement)node).getPlotDefaults().setId("plot_defaults_" + i);
        } else if (node instanceof Plot) {
            int num = plotIdNum.getAndIncrement();
            Plot domPlot = (Plot)node;
            domPlot.setId("plot_" + num);
            domPlot.getXaxis().setId("xaxis_" + num);
            domPlot.getYaxis().setId("yaxis_" + num);
            domPlot.getZaxis().setId("zaxis_" + num);
        } else {
            throw new IllegalArgumentException("unsupported type: " + node.getClass().getName());
        }
    }

    private int maxIdNum(List<DomNode> nodes, String pattern) {
        int min = -1;
        Pattern p = Pattern.compile(pattern);
        for (DomNode n : nodes) {
            int idNum;
            Matcher m = p.matcher(n.getId());
            if (!m.matches() || (idNum = Integer.parseInt(m.group(1))) <= min) continue;
            min = idNum;
        }
        return min;
    }

    private void resetIdSequenceNumbers() {
        List<DomNode> nodes = DomUtil.findElementsById(this.application, ".+_(\\d+)");
        rowIdNum.set(this.maxIdNum(nodes, "row_(\\d+)") + 1);
        columnIdNum.set(this.maxIdNum(nodes, "column_(\\d+)") + 1);
        dsfIdNum.set(this.maxIdNum(nodes, "data_(\\d+)") + 1);
        canvasIdNum.set(this.maxIdNum(nodes, "canvas_(\\d+)") + 1);
        plotElementIdNum.set(this.maxIdNum(nodes, "plotElement_(\\d+)") + 1);
        plotIdNum.set(this.maxIdNum(nodes, "plot_(\\d+)") + 1);
    }

    public PlotElement getPlotElement() {
        return this.plotElement;
    }

    public void setPlotElement(PlotElement plotElement) {
        PlotElement oldPlotElement = this.plotElement;
        if (plotElement == null) {
            this.setStatus("no plot element selected");
        } else {
            JMenuItem mi;
            Plot lplot;
            this.setStatus(plotElement + " selected");
            if (plotElement != oldPlotElement) {
                this.getCanvas().controller.indicateSelection(Collections.singletonList(plotElement));
            }
            if (plotElement != oldPlotElement && (lplot = this.getPlotFor(plotElement)) != null && lplot.getController() != null && (mi = lplot.getController().getPlotElementPropsMenuItem()) != null && plotElement.getController() != null && plotElement.getController().getRenderer() != null) {
                mi.setIcon(plotElement.getController().getRenderer().getListIcon());
            }
        }
        if (SwingUtilities.isEventDispatchThread() && oldPlotElement != plotElement) {
            Logger.getLogger("gui").log(Level.FINE, "set plotElement {0}", plotElement);
        }
        this.plotElement = plotElement;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT_ELEMENT, oldPlotElement, plotElement);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        if (plot == null) {
            logger.warning("setPlot(null)");
        }
        Plot oldPlot = this.plot;
        if (SwingUtilities.isEventDispatchThread() && oldPlot != plot) {
            Logger.getLogger("gui").log(Level.FINE, "set plot {0}", plot);
        }
        this.plot = plot;
        this.propertyChangeSupport.firePropertyChange(PROP_PLOT, oldPlot, plot);
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(Canvas canvas) {
        Canvas oldCanvas = this.getCanvas();
        if (SwingUtilities.isEventDispatchThread() && oldCanvas != canvas) {
            Logger.getLogger("gui").log(Level.FINE, "set canvas {0}", canvas);
        }
        this.canvas = canvas;
        this.propertyChangeSupport.firePropertyChange(PROP_CANVAS, oldCanvas, canvas);
    }

    public DataSourceFilter getDataSourceFilter() {
        return this.dataSourceFilter;
    }

    public void setDataSourceFilter(DataSourceFilter dataSourceFilter) {
        DataSourceFilter oldDataSourceFilter = this.dataSourceFilter;
        this.dataSourceFilter = dataSourceFilter;
        this.propertyChangeSupport.firePropertyChange(PROP_DATASOURCEFILTER, oldDataSourceFilter, dataSourceFilter);
    }

    private void bindTo(DasCanvas canvas) {
        ApplicationController ac = this;
        ac.bind(this.application.options, "background", canvas, "background");
        ac.bind(this.application.options, "foreground", canvas, "foreground");
        ac.bind(this.application.options, "canvasFont", canvas, "baseFont", DomUtil.STRING_TO_FONT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void syncTo(Application that, List<String> exclude) {
        ChangesSupport.DomLock lock = this.changesSupport.mutatorLock();
        lock.lock("Sync to Application");
        Lock canvasLock = this.getCanvas().controller.getDasCanvas().mutatorLock();
        canvasLock.lock();
        try {
            if (!exclude.contains("options")) {
                this.application.getOptions().syncTo(that.getOptions(), Arrays.asList("overRendering", "logConsoleVisible", "scriptVisible", "serverEnabled"));
            }
            HashMap<String, String> nameMap = new HashMap<String, String>(){

                @Override
                public String get(Object key) {
                    String result = (String)super.get(key);
                    return result == null ? (String)key : result;
                }
            };
            if (!this.application.id.equals(that.id)) {
                nameMap.put(that.id, this.application.id);
            }
            if (!exclude.contains("canvases")) {
                this.syncSupport.syncToCanvases(that.getCanvases(), (Map<String, String>)nameMap);
            }
            if (!exclude.contains("plots")) {
                this.syncSupport.syncToPlots(that.getPlots(), (Map<String, String>)nameMap);
            }
            if (!exclude.contains("dataSourceFilters")) {
                this.syncSupport.syncToDataSourceFilters(that.getDataSourceFilters(), (Map<String, String>)nameMap);
            }
            if (!exclude.contains("plotElements")) {
                this.syncSupport.syncToPlotElements(that.getPlotElements(), (Map<String, String>)nameMap);
            }
            this.application.setTimeRange(that.getTimeRange());
            this.application.setEventsListUri(that.getEventsListUri());
            this.syncSupport.syncBindings(that.getBindings(), (Map<String, String>)nameMap);
            this.syncSupport.syncConnectors(that.getConnectors());
            this.syncSupport.syncAnnotations(that.getAnnotations());
            this.resetIdSequenceNumbers();
        }
        finally {
            canvasLock.unlock();
            lock.unlock();
        }
        for (PlotElement plotElement : this.application.getPlotElements()) {
            plotElement.controller.setResetPlotElement(false);
            plotElement.controller.setResetComponent(false);
            plotElement.controller.setResetRenderType(false);
            plotElement.controller.setDsfReset(true);
        }
        for (DomNode domNode : this.application.getDataSourceFilters()) {
            ((DataSourceFilter)domNode).controller.setResetDimensions(false);
        }
    }

    public boolean isHeadless() {
        return this.headless;
    }

    public DasCanvas getDasCanvas() {
        return this.getCanvas().controller.getDasCanvas();
    }

    public DasRow getRow() {
        return this.getCanvas().getMarginRow().getController().getDasRow();
    }

    public DasColumn getColumn() {
        return this.getCanvas().getMarginColumn().getController().getDasColumn();
    }

    public MonitorFactory getMonitorFactory() {
        return DasApplication.getDefaultApplication().getMonitorFactory();
    }

    boolean isConnected(Plot plot) {
        Connector[] connectors;
        for (Connector connector : connectors = this.application.getConnectors()) {
            if (connector.getPlotB().equals(plot.getId())) {
                return true;
            }
            if (!connector.getPlotA().equals(plot.getId())) continue;
            return true;
        }
        return false;
    }

    protected boolean isBoundAxis(Axis a) {
        BindingModel[] bms = this.getBindingsFor(a);
        return bms.length > 0;
    }

    public boolean isTimeSeriesBrowse(Plot p) {
        List<DataSourceFilter> dsfs = DomUtil.getDataSourceFiltersFor(this.application, p);
        for (DataSourceFilter dsf : dsfs) {
            if (dsf != null) {
                DataSourceController dsfc = dsf.getController();
                if (dsfc == null || dsfc.getTsb() == null) continue;
                return true;
            }
            logger.log(Level.FINE, "bad dataset id for plot: {0}", p.getId());
        }
        return false;
    }

    public int getPendingChangeCount() {
        return this.pendingChangeCount;
    }

    public void setPendingChangeCount(int pendingChangeCount) {
        int oldPendingChangeCount = this.pendingChangeCount;
        this.pendingChangeCount = pendingChangeCount;
        this.propertyChangeSupport.firePropertyChange(PROP_PENDINGCHANGECOUNT, oldPendingChangeCount, pendingChangeCount);
    }
}

