/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.awt.Font;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.util.Locale;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.ApplicationController;
import org.autoplot.dom.Column;
import org.autoplot.dom.DomNodeController;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.LabelConverter;
import org.autoplot.dom.Plot;
import org.autoplot.dom.Row;
import org.das2.graph.DasAnnotation;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColumn;
import org.das2.graph.DasDevicePosition;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class AnnotationController
extends DomNodeController {
    private final Annotation annotation;
    private final Application dom;
    private final DasAnnotation dasAnnotation;
    private DasRow allRow;
    private DasColumn allColumn;

    public AnnotationController(Application dom, Annotation annotation, DasAnnotation dasAnnotation) {
        super(annotation);
        this.dom = dom;
        this.annotation = annotation;
        this.bindTo(dasAnnotation);
        this.dasAnnotation = dasAnnotation;
        this.allRow = new DasRow(dasAnnotation.getCanvas(), 0.0, 1.0);
        this.allColumn = new DasColumn(dasAnnotation.getCanvas(), 0.0, 1.0);
        annotation.controller = this;
    }

    public Converter getFontConverter(final DasCanvasComponent dcc) {
        return new Converter(){

            public Object convertForward(Object s) {
                try {
                    double[] dd = DasDevicePosition.parseLayoutStr((String)s);
                    if (dd[1] == 1.0 && dd[2] == 0.0) {
                        return Float.valueOf(0.0f);
                    }
                    Font f = dcc.getFont();
                    if (f == null) {
                        f = Font.decode(AnnotationController.this.dom.getOptions().getCanvasFont());
                    }
                    double parentSize = f.getSize2D();
                    double newSize = dd[1] * parentSize + dd[2];
                    return Float.valueOf((float)newSize);
                }
                catch (ParseException ex) {
                    ex.printStackTrace();
                    return Float.valueOf(0.0f);
                }
            }

            public Object convertReverse(Object t) {
                float size = ((Float)t).floatValue();
                if (size == 0.0f) {
                    return "1em";
                }
                Font f = dcc.getFont();
                if (f == null) {
                    f = Font.decode(AnnotationController.this.dom.getOptions().getCanvasFont());
                }
                double parentSize = f.getSize2D();
                double relativeSize = (double)size / parentSize;
                return String.format(Locale.US, "%.2fem", relativeSize);
            }
        };
    }

    private void bindTo(final DasAnnotation p) {
        ApplicationController ac = this.dom.controller;
        p.setFontSize(0.0f);
        String plotId = this.annotation.getPlotId();
        if (plotId != null && plotId.length() > 0) {
            LabelConverter lc = new LabelConverter(this.dom, (Plot)DomUtil.getElementById(this.dom, plotId), null, null, this.annotation);
            ac.bind(this.annotation, "text", p, "text", lc);
        } else {
            ac.bind(this.annotation, "text", p, "text");
        }
        ac.bind(this.annotation, "url", p, "url");
        ac.bind(this.annotation, "fontSize", p, "fontSize", this.getFontConverter(p));
        ac.bind(this.annotation, "borderType", p, "borderType");
        ac.bind(this.annotation, "anchorPosition", p, "anchorPosition");
        ac.bind(this.annotation, "anchorType", p, "anchorType");
        ac.bind(this.annotation, "anchorOffset", p, "anchorOffset");
        ac.bind(this.annotation, "anchorBorderType", p, "anchorBorderType");
        ac.bind(this.annotation, "xrange", p, "xrange");
        ac.bind(this.annotation, "yrange", p, "yrange");
        ac.bind(this.annotation, "pointAtX", p, "pointAtX");
        ac.bind(this.annotation, "pointAtY", p, "pointAtY");
        ac.bind(this.annotation, "showArrow", p, "showArrow");
        ac.bind(this.annotation, "overrideColors", p, "overrideColors");
        ac.bind(this.annotation, "textColor", p, "textColor");
        ac.bind(this.annotation, "foreground", p, "foreground");
        ac.bind(this.annotation, "background", p, "background");
        this.annotation.addPropertyChangeListener("rowId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                DomNodeController.logger.finer("propertyChange rowId");
                String id = (String)evt.getNewValue();
                Row r = null;
                if (id.length() > 0) {
                    r = (Row)DomUtil.getElementById(AnnotationController.this.dom.getCanvases(0), (String)evt.getNewValue());
                }
                if (r != null) {
                    p.setRow(r.controller.getDasRow());
                } else {
                    p.setRow(AnnotationController.this.allRow);
                }
            }
        });
        this.annotation.addPropertyChangeListener("columnId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                String id = (String)evt.getNewValue();
                Column r = null;
                if (id.length() > 0) {
                    r = (Column)DomUtil.getElementById(AnnotationController.this.dom.getCanvases(0), (String)evt.getNewValue());
                }
                if (r != null) {
                    p.setColumn(r.controller.getDasColumn());
                } else {
                    p.setColumn(AnnotationController.this.allColumn);
                }
            }
        });
        this.annotation.addPropertyChangeListener("plotId", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                Plot pl = (Plot)DomUtil.getElementById(AnnotationController.this.dom, (String)evt.getNewValue());
                if (pl != null) {
                    DasPlot dasPlot = pl.getController().getDasPlot();
                    p.setPlot(dasPlot);
                }
            }
        });
        this.dom.getCanvases(0).addPropertyChangeListener("font", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LoggerManager.logPropertyChangeEvent(evt);
                ((AnnotationController)AnnotationController.this).annotation.propertyChangeSupport.firePropertyChange("fontSize", null, AnnotationController.this.annotation.getFontSize());
                AnnotationController.this.dasAnnotation.resize();
            }
        });
    }

    protected void removeBindings() {
        ApplicationController ac = this.dom.controller;
        ac.unbind(this.annotation);
    }

    public DasAnnotation getDasAnnotation() {
        return this.dasAnnotation;
    }
}

