/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dods;

import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.logging.Logger;
import opendap.dap.BaseType;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DString;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.Slice0DataSet;
import org.das2.qds.TrimDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.util.LoggerManager;

public abstract class DodsVarDataSet
implements WritableDataSet {
    private static final Logger logger = LoggerManager.getLogger("apdss.opendap");
    int rank;
    int[] dimSizes = new int[4];
    HashMap properties;
    boolean immutable = false;

    public DodsVarDataSet(DArray array) {
        int idim = 0;
        Enumeration enumm = array.getDimensions();
        while (enumm.hasMoreElements()) {
            DArrayDimension dd = (DArrayDimension)enumm.nextElement();
            this.dimSizes[idim++] = dd.getSize();
        }
        this.rank = array.numDimensions();
        this.properties = new HashMap();
        if (this.rank > 1) {
            this.properties.put("QUBE", Boolean.TRUE);
        }
        this.properties.put("NAME", array.getName());
    }

    public String toString() {
        StringBuilder dimStr = new StringBuilder("" + this.dimSizes[0]);
        for (int i = 1; i < this.rank; ++i) {
            dimStr.append(",").append(this.dimSizes[i]);
        }
        String u = String.valueOf(this.properties.get("UNITS"));
        if ("null".equals(u) || "".equals(u)) {
            u = "dimensionless";
        }
        return "dataSet[" + dimStr.toString() + "] (" + u + ")";
    }

    @Override
    public int rank() {
        return this.rank;
    }

    @Override
    public abstract double value(int var1);

    @Override
    public abstract double value(int var1, int var2);

    @Override
    public abstract double value(int var1, int var2, int var3);

    @Override
    public abstract double value(int var1, int var2, int var3, int var4);

    @Override
    public void putValue(int i0, int i1, int i2, int i3, double v) {
        throw new IllegalArgumentException("rank limit");
    }

    @Override
    public Object property(String name) {
        return this.properties.get(name);
    }

    @Override
    public Object property(String name, int i) {
        return this.property(name);
    }

    @Override
    public void putProperty(String name, Object value) {
        this.checkImmutable();
        this.properties.put(name, value);
    }

    @Override
    public void putProperty(String name, int i, Object value) {
        this.putProperty(name, value);
    }

    @Override
    public int length() {
        return this.dimSizes[0];
    }

    @Override
    public int length(int i) {
        return this.dimSizes[1];
    }

    @Override
    public int length(int i0, int i1) {
        return this.dimSizes[2];
    }

    @Override
    public int length(int i0, int i1, int i2) {
        return this.dimSizes[3];
    }

    @Override
    public <T> T capability(Class<T> clazz) {
        return null;
    }

    @Override
    public QDataSet slice(int i) {
        return new Slice0DataSet(this, i);
    }

    @Override
    public QDataSet trim(int start, int end) {
        return new TrimDataSet(this, start, end);
    }

    @Override
    public void makeImmutable() {
        this.immutable = true;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    protected final void checkImmutable() {
        if (this.immutable) {
            logger.warning("dataset has been marked as immutable, this will soon throw an exception");
        }
    }

    protected static DodsVarDataSet newDataSet(DArray z, HashMap properties) {
        Object o = z.getPrimitiveVector().getInternalStorage();
        if (o instanceof double[]) {
            DDataSet.wrap((double[])o);
            return new DoubleArray(z, properties);
        }
        if (o instanceof float[]) {
            return new FloatArray(z, properties);
        }
        if (o instanceof short[]) {
            return new Int16Array(z, properties);
        }
        if (o instanceof int[]) {
            return new Int32Array(z, properties);
        }
        if (o instanceof BaseType[]) {
            BaseType[] bta = (BaseType[])o;
            BaseType bt1 = bta[0];
            if (bt1 instanceof DString) {
                if (properties.get("UNITS") == null) {
                    return new NominalStringArray(z, properties);
                }
                return new EpochStringArray(z, properties);
            }
            throw new IllegalArgumentException("not supported: " + o);
        }
        throw new IllegalArgumentException("not supported: " + o);
    }

    public static class DoubleArray
    extends DodsVarDataSet {
        double[] back;

        public DoubleArray(DArray array, HashMap properties) {
            super(array);
            this.back = (double[])array.getPrimitiveVector().getInternalStorage();
            this.properties.putAll(properties);
        }

        @Override
        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public double value(int i) {
            return this.back[i];
        }

        @Override
        public double value(int i0, int i1) {
            return this.back[i0 * this.dimSizes[1] + i1];
        }

        @Override
        public double value(int i0, int i1, int i2) {
            return this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2];
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            return this.back[i0 * this.dimSizes[1] * this.dimSizes[2] * this.dimSizes[3] + i1 * this.dimSizes[1] * this.dimSizes[2] + i2 * this.dimSizes[2] + i3];
        }

        @Override
        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public void putValue(int i0, double d) {
            this.checkImmutable();
            this.back[i0] = d;
        }

        @Override
        public void putValue(int i0, int i1, double d) {
            this.checkImmutable();
            this.back[i0 * this.dimSizes[1] + i1] = d;
        }

        @Override
        public void putValue(int i0, int i1, int i2, double d) {
            this.checkImmutable();
            this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2] = d;
        }
    }

    public static class EpochStringArray
    extends DodsVarDataSet {
        BaseType[] back;
        Units u;

        public EpochStringArray(DArray array, HashMap properties) {
            super(array);
            this.back = (BaseType[])array.getPrimitiveVector().getInternalStorage();
            this.properties.putAll(properties);
            this.u = Units.us2000;
            this.properties.put("UNITS", this.u);
        }

        @Override
        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public double value(int i) {
            try {
                return this.u.parse(((DString)this.back[i]).getValue()).doubleValue(this.u);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public double value(int i0, int i1) {
            throw new IllegalArgumentException("not supported");
        }

        @Override
        public double value(int i0, int i1, int i2) {
            throw new IllegalArgumentException("not supported");
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            throw new IllegalArgumentException("not supported");
        }

        @Override
        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public void putValue(int i0, double d) {
            this.checkImmutable();
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putValue(int i0, int i1, double d) {
            this.checkImmutable();
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putValue(int i0, int i1, int i2, double d) {
            this.checkImmutable();
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    public static class FloatArray
    extends DodsVarDataSet {
        float[] back;
        double validMin;
        double validMax;

        public FloatArray(DArray array, HashMap properties) {
            super(array);
            this.back = (float[])array.getPrimitiveVector().getInternalStorage();
            this.validMin = Double.NEGATIVE_INFINITY;
            this.validMax = Double.POSITIVE_INFINITY;
            if (properties.get("VALID_MIN") != null) {
                this.validMin = (Double)properties.get("VALID_MIN");
            }
            if (properties.get("VALID_MAX") != null) {
                this.validMax = (Double)properties.get("VALID_MAX");
            }
            if (properties.get("valid_range") != null) {
                String s = (String)properties.get("valid_range");
                String[] ss = s.split(",");
                this.validMin = Double.parseDouble(ss[0]);
                this.validMax = Double.parseDouble(ss[1]);
            }
            this.properties.putAll(properties);
        }

        private double doubleValue(float val) {
            double r = val;
            return r >= this.validMin && r <= this.validMax ? r : Units.dimensionless.getFillDouble();
        }

        private float putFloatValue(double val) {
            return (float)val;
        }

        @Override
        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public double value(int i) {
            return this.doubleValue(this.back[i]);
        }

        @Override
        public double value(int i0, int i1) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] + i1]);
        }

        @Override
        public double value(int i0, int i1, int i2) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2]);
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            int index = i0 * this.dimSizes[1] * this.dimSizes[2] * this.dimSizes[3] + i1 * this.dimSizes[2] * this.dimSizes[3] + i2 * this.dimSizes[3] + i3;
            return this.doubleValue(this.back[index]);
        }

        @Override
        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public void putValue(int i0, double d) {
            this.checkImmutable();
            this.back[i0] = this.putFloatValue(d);
        }

        @Override
        public void putValue(int i0, int i1, double d) {
            this.checkImmutable();
            this.back[i0 * this.dimSizes[1] + i1] = this.putFloatValue(d);
        }

        @Override
        public void putValue(int i0, int i1, int i2, double d) {
            this.checkImmutable();
            this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2] = this.putFloatValue(d);
        }
    }

    public static class Int16Array
    extends DodsVarDataSet {
        short[] back;
        double scaleFactor = 1.0;
        double addOffset = 0.0;
        double validMin;
        double validMax;

        public Int16Array(DArray array, HashMap properties) {
            super(array);
            this.back = (short[])array.getPrimitiveVector().getInternalStorage();
            if (properties.get("add_offset") != null) {
                this.addOffset = (Double)properties.get("add_offset");
            }
            if (properties.get("scale_factor") != null) {
                this.scaleFactor = (Double)properties.get("scale_factor");
            }
            this.validMin = Double.NEGATIVE_INFINITY;
            this.validMax = Double.POSITIVE_INFINITY;
            if (properties.get("VALID_MIN") != null) {
                this.validMin = (Double)properties.get("VALID_MIN");
            }
            if (properties.get("VALID_MAX") != null) {
                this.validMax = (Double)properties.get("VALID_MAX");
            }
            if (properties.get("valid_range") != null) {
                String s = (String)properties.get("valid_range");
                String[] ss = s.split(",");
                this.validMin = Double.parseDouble(ss[0]);
                this.validMax = Double.parseDouble(ss[1]);
            }
            this.properties.putAll(properties);
        }

        private double doubleValue(short val) {
            double r = (double)val * this.scaleFactor + this.addOffset;
            return r >= this.validMin && r <= this.validMax ? r : Units.dimensionless.getFillDouble();
        }

        @Override
        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public double value(int i) {
            return this.doubleValue(this.back[i]);
        }

        @Override
        public double value(int i0, int i1) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] + i1]);
        }

        @Override
        public double value(int i0, int i1, int i2) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2]);
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] * this.dimSizes[3] + i1 * this.dimSizes[1] * this.dimSizes[2] + i2 * this.dimSizes[2] + i3]);
        }

        private short putIntValue(double val) {
            return (short)((val - this.addOffset) / this.scaleFactor);
        }

        @Override
        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public void putValue(int i0, double d) {
            this.checkImmutable();
            this.back[i0] = this.putIntValue(d);
        }

        @Override
        public void putValue(int i0, int i1, double d) {
            this.checkImmutable();
            this.back[i0 * this.dimSizes[1] + i1] = this.putIntValue(d);
        }

        @Override
        public void putValue(int i0, int i1, int i2, double d) {
            this.checkImmutable();
            this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2] = this.putIntValue(d);
        }
    }

    public static class Int32Array
    extends DodsVarDataSet {
        int[] back;
        double scaleFactor = 1.0;
        double addOffset = 0.0;
        double validMin;
        double validMax;

        public Int32Array(DArray array, HashMap properties) {
            super(array);
            this.back = (int[])array.getPrimitiveVector().getInternalStorage();
            if (properties.get("add_offset") != null) {
                this.addOffset = (Double)properties.get("add_offset");
            }
            if (properties.get("scale_factor") != null) {
                this.scaleFactor = (Double)properties.get("scale_factor");
            }
            this.validMin = Double.NEGATIVE_INFINITY;
            this.validMax = Double.POSITIVE_INFINITY;
            if (properties.get("VALID_MIN") != null) {
                this.validMin = (Double)properties.get("VALID_MIN");
            }
            if (properties.get("VALID_MAX") != null) {
                this.validMax = (Double)properties.get("VALID_MAX");
            }
            if (properties.get("valid_range") != null) {
                String s = (String)properties.get("valid_range");
                String[] ss = s.split(",");
                this.validMin = Double.parseDouble(ss[0]);
                this.validMax = Double.parseDouble(ss[1]);
            }
            this.properties.putAll(properties);
        }

        private double doubleValue(int val) {
            double r = (double)val * this.scaleFactor + this.addOffset;
            return r >= this.validMin && r <= this.validMax ? r : Units.dimensionless.getFillDouble();
        }

        @Override
        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public double value(int i) {
            return this.doubleValue(this.back[i]);
        }

        @Override
        public double value(int i0, int i1) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] + i1]);
        }

        @Override
        public double value(int i0, int i1, int i2) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2]);
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            return this.doubleValue(this.back[i0 * this.dimSizes[1] * this.dimSizes[2] * this.dimSizes[3] + i1 * this.dimSizes[1] * this.dimSizes[2] + i2 * this.dimSizes[2] + i3]);
        }

        private int putIntValue(double val) {
            return (int)((val - this.addOffset) / this.scaleFactor);
        }

        @Override
        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public void putValue(int i0, double d) {
            this.checkImmutable();
            this.back[i0] = this.putIntValue(d);
        }

        @Override
        public void putValue(int i0, int i1, double d) {
            this.checkImmutable();
            this.back[i0 * this.dimSizes[1] + i1] = this.putIntValue(d);
        }

        @Override
        public void putValue(int i0, int i1, int i2, double d) {
            this.checkImmutable();
            this.back[i0 * this.dimSizes[1] * this.dimSizes[2] + i1 * this.dimSizes[2] + i2] = this.putIntValue(d);
        }
    }

    public static class NominalStringArray
    extends DodsVarDataSet {
        BaseType[] back;
        EnumerationUnits u;

        public NominalStringArray(DArray array, HashMap properties) {
            super(array);
            this.back = (BaseType[])array.getPrimitiveVector().getInternalStorage();
            this.properties.putAll(properties);
            this.u = new EnumerationUnits("dods");
            for (int i = 0; i < this.back.length; ++i) {
                DString bt1 = (DString)this.back[i];
                this.u.createDatum(bt1.getValue());
            }
            this.properties.put("UNITS", this.u);
        }

        @Override
        public double value() {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public double value(int i) {
            return this.u.createDatum(((DString)this.back[i]).getValue()).doubleValue(this.u);
        }

        @Override
        public double value(int i0, int i1) {
            throw new IllegalArgumentException("not supported");
        }

        @Override
        public double value(int i0, int i1, int i2) {
            throw new IllegalArgumentException("not supported");
        }

        @Override
        public double value(int i0, int i1, int i2, int i3) {
            throw new IllegalArgumentException("not supported");
        }

        @Override
        public void putValue(double d) {
            throw new IllegalArgumentException("rank 0 not supported");
        }

        @Override
        public void putValue(int i0, double d) {
            this.checkImmutable();
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putValue(int i0, int i1, double d) {
            this.checkImmutable();
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void putValue(int i0, int i1, int i2, double d) {
            this.checkImmutable();
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

