/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dods;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import opendap.dap.DDSException;
import opendap.dap.NoSuchVariableException;
import opendap.dap.Server.InvalidParameterException;
import opendap.dap.parser.ParseException;
import opendap.dap.parser.TokenMgrError;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.URISplit;
import org.autoplot.dods.DodsDataSource;
import org.autoplot.dods.MyDDSParser;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;

public class DodsDataSourceFactory
extends AbstractDataSourceFactory
implements DataSourceFactory {
    private static final Logger logger = LoggerManager.getLogger("apdss.opendap");

    @Override
    public DataSource getDataSource(URI uri) throws IOException {
        try {
            return new DodsDataSource(uri);
        }
        catch (NoSuchElementException ex) {
            throw new RuntimeException("Does not appear to be a DDS: " + uri, ex);
        }
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            String file = CompletionContext.get(CompletionContext.CONTEXT_FILE, cc);
            return this.getVars(file);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        if (surl.contains("?")) {
            return false;
        }
        try {
            URISplit split = URISplit.parse(surl);
            List<CompletionContext> cc = this.getVars(split.file);
            return cc.size() > 1;
        }
        catch (IOException | DDSException | ParseException ex) {
            logger.log(Level.WARNING, null, ex);
            return true;
        }
    }

    private List<CompletionContext> getVars(String file) throws DDSException, IOException, MalformedURLException, ParseException {
        String[] vars;
        logger.entering("org.virbo.dods.DodsDataSourceFactory", "getVars {0}", file);
        ArrayList<CompletionContext> result = new ArrayList<CompletionContext>();
        int i = file.lastIndexOf(46);
        String sMyUrl = file.substring(0, i);
        MyDDSParser parser = new MyDDSParser();
        URL url = new URL(sMyUrl + ".dds");
        logger.log(Level.FINE, "getVars opening {0}", url);
        try {
            String[] stringArray = null;
            try (InputStream in = url.openStream();){
                parser.parse(in);
            }
            catch (Throwable object) {
                stringArray = object;
                throw object;
            }
        }
        catch (RuntimeException | TokenMgrError ex) {
            throw new ParseException("Does not appear to be a DDS: " + url);
        }
        for (String var : vars = parser.getVariableNames()) {
            StringBuilder label = new StringBuilder(var);
            try {
                String[] deps = parser.getDepends(var);
                if (deps != null) {
                    label.append("[").append(deps[0]);
                    for (int k = 1; k < deps.length; ++k) {
                        label.append(",").append(deps[k]);
                    }
                    label.append("]");
                }
            }
            catch (NoSuchVariableException | InvalidParameterException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            result.add(new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, var, this, "arg_0", null, label.toString(), true));
        }
        logger.exiting("org.virbo.dods.DodsDataSourceFactory", "getVars {0}", file);
        return result;
    }
}

