/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dods;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DASException;
import opendap.dap.DDSException;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.Server.InvalidParameterException;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.URISplit;
import org.autoplot.dods.DodsAdapter;
import org.autoplot.dods.MyDASParser;
import org.autoplot.dods.MyDDSParser;
import org.autoplot.metatree.IstpMetadataModel;
import org.das2.datum.Units;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.util.TransposeRankNDataSet;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.ProgressMonitor;

public class DodsDataSource
extends AbstractDataSource {
    DodsAdapter adapter;
    String variable;
    String sMyUrl;
    String constraint;
    Map<String, Object> metadata;
    DAS das;
    private static final Logger logger = Logger.getLogger("apdss.opendap");

    private MutablePropertyDataSet checkLatLon(MutablePropertyDataSet v) {
        int lat = -1;
        int lon = -1;
        for (int i = 0; i < v.rank(); ++i) {
            QDataSet dep = (QDataSet)v.property("DEPEND_" + i);
            if (dep == null) continue;
            String name = (String)dep.property("NAME");
            if ("lon".equals(name)) {
                lon = i;
            }
            if (!"lat".equals(name)) continue;
            lat = i;
        }
        if (lat > -1 && lon > -1 && lat < lon) {
            int[] order = new int[v.rank()];
            for (int i = 0; i < v.rank(); ++i) {
                order[i] = i;
            }
            int t = order[lat];
            order[lat] = order[lon];
            order[lon] = t;
            TransposeRankNDataSet transpose = new TransposeRankNDataSet(v, order);
            return transpose;
        }
        return v;
    }

    public DodsDataSource(URI uri) throws IOException {
        super(uri);
        logger.entering("org.virbo.dods.DodsDataSource", "DodsDataSource {0}", uri);
        String surl = uri.getRawSchemeSpecificPart();
        int k = surl.lastIndexOf("?");
        int i = k == -1 ? surl.lastIndexOf(46) : surl.lastIndexOf(46, k);
        this.sMyUrl = surl.substring(0, i);
        i = surl.indexOf(63);
        if (i != -1) {
            String s = surl.substring(i + 1);
            s = DataSetURI.maybePlusToSpace(s);
            String variableConstraint = URISplit.uriDecode(s);
            StringTokenizer tok = new StringTokenizer(variableConstraint, "[<>", true);
            String name = tok.nextToken();
            if (tok.hasMoreTokens()) {
                String delim = tok.nextToken();
                if (delim.equals("[")) {
                    this.variable = name;
                }
                this.constraint = "?" + variableConstraint;
            } else {
                this.variable = name;
            }
        }
        try {
            URL myUrl = new URL(this.sMyUrl);
            this.adapter = new DodsAdapter(myUrl, this.variable);
            if (this.constraint != null) {
                this.adapter.setConstraint(this.constraint);
            }
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
        logger.exiting("org.virbo.dods.DodsDataSource", "DodsDataSource {0}", uri);
    }

    private String getIstpConstraint(DodsAdapter da, Map meta, MyDDSParser parser, String variable) throws DDSException {
        int i;
        StringBuilder constraint1 = new StringBuilder("?");
        constraint1.append(variable);
        String dimsStr = null;
        if (da.getConstraint() != null) {
            i = da.getConstraint().indexOf(91);
            if (i != -1) {
                dimsStr = da.getConstraint().substring(i);
                constraint1.append(dimsStr);
            }
        } else {
            int[] ii = parser.getRecDims(variable);
            if (ii != null) {
                for (int i2 = 0; i2 < ii.length; ++i2) {
                    dimsStr = "";
                    constraint1.append(dimsStr);
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            String dkey = "DEPEND_" + i;
            if (!meta.containsKey(dkey)) continue;
            Map val = (Map)meta.get(dkey);
            String var = (String)val.get("NAME");
            constraint1.append(",").append(var);
            if (dimsStr != null) {
                constraint1.append(dimsStr);
            }
            da.setDependName(i, var);
            Map<String, Object> depMeta = this.getMetaData(var);
            Map<String, Object> m = new IstpMetadataModel().properties(depMeta);
            if (m.containsKey("UNITS")) {
                da.setDimUnits(i, (Units)m.get("UNITS"));
            }
            da.setDimProperties(i, m);
        }
        da.setConstraint(constraint1.toString());
        return constraint1.toString();
    }

    private String getDependsConstraint(DodsAdapter da, Map meta, MyDDSParser parser, String variable, String[] depVars) throws DDSException {
        int i;
        StringBuilder constraint1 = new StringBuilder("?");
        constraint1.append(variable);
        String dimsStr = null;
        if (da.getConstraint() != null) {
            i = da.getConstraint().indexOf(91);
            if (i != -1) {
                dimsStr = da.getConstraint().substring(i);
                constraint1.append(dimsStr);
            }
        } else {
            int[] ii = parser.getRecDims(variable);
            if (ii != null) {
                for (int i2 = 0; i2 < ii.length; ++i2) {
                    dimsStr = "";
                    constraint1.append(dimsStr);
                }
            }
        }
        for (i = 0; i < depVars.length; ++i) {
            String var = depVars[i];
            constraint1.append(",").append(var);
            if (dimsStr != null && i == 0) {
                int i2 = dimsStr.indexOf("]");
                constraint1.append(dimsStr.substring(0, i2 + 1));
            }
            da.setDependName(i, var);
        }
        da.setConstraint(constraint1.toString());
        return constraint1.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws FileNotFoundException, MalformedURLException, IOException, opendap.dap.parser.ParseException, DDSException, CancelledOperationException, DASException, InvalidParameterException, DAP2Exception {
        logger.entering("org.virbo.dods.DodsDataSource", "getDataSet");
        mon.setTaskSize(-1L);
        mon.started();
        String surl = this.adapter.getSource().toString();
        if (surl == null) {
            throw new NullPointerException("adapter to URL failed");
        }
        mon.setProgressMessage("parse " + surl + ".dds");
        try {
            String sunits;
            MyDDSParser parser = new MyDDSParser();
            URL url = new URL(surl + ".dds");
            logger.log(Level.FINE, "getDataSet opening {0}", url);
            try (InputStream in = url.openStream();){
                parser.parse(in);
            }
            catch (FileNotFoundException ex) {
                throw new FileNotFoundException("OpenDAP Server unavailable, file not found: \n" + ex.getMessage());
            }
            this.getMetadata(mon.getSubtaskMonitor("metadata"));
            Map<String, Object> interpretedMetadata = null;
            boolean isIstp = surl.endsWith(".cdf");
            if (isIstp) {
                Map<String, Object> m;
                interpretedMetadata = m = new IstpMetadataModel().properties(this.metadata);
            }
            if (isIstp) {
                String constraint1 = this.getIstpConstraint(this.adapter, this.metadata, parser, this.variable);
                this.adapter.setConstraint(constraint1);
            } else {
                CharSequence constraint1;
                String[] deps = parser.getDepends(this.variable);
                if (deps != null) {
                    constraint1 = this.getDependsConstraint(this.adapter, this.metadata, parser, this.variable, deps);
                    this.adapter.setConstraint((String)constraint1);
                } else if (this.constraint == null && this.adapter.getVariable() != null) {
                    int[] ii;
                    constraint1 = new StringBuilder("?");
                    ((StringBuilder)constraint1).append(this.adapter.getVariable());
                    if (!this.adapter.getVariable().contains("[") && (ii = parser.getRecDims(this.adapter.getVariable())) != null) {
                        for (int i = 0; i < ii.length; ++i) {
                            ((StringBuilder)constraint1).append("[0:1:").append(ii[i]).append("]");
                        }
                    }
                    this.adapter.setConstraint(((StringBuilder)constraint1).toString());
                }
            }
            try {
                this.adapter.loadDataset(mon.getSubtaskMonitor("loadDataset"), this.metadata);
            }
            catch (NullPointerException ex) {
                RuntimeException n = new RuntimeException("Strange NullPointerException occurs with Java 8 Webstart.  This will be resolved, but use the single-jar version of Autoplot instead.", ex);
                throw n;
            }
            MutablePropertyDataSet ds = (MutablePropertyDataSet)this.adapter.getDataSet(this.metadata);
            ds = this.checkLatLon(ds);
            Object val = this.metadata.get("missing_value");
            if (val != null) {
                try {
                    double check;
                    double dfill = Double.parseDouble((String)val);
                    ds.putProperty("FILL_VALUE", dfill);
                    if (dfill != 0.0 && (check = Math.abs((ds.value(0, 0) - dfill) / dfill)) < 1.0E-5) {
                        ds.putProperty("FILL_VALUE", ds.value(0, 0));
                    }
                }
                catch (NumberFormatException ex) {
                    logger.log(Level.INFO, "When parsing missing_value", ex);
                }
            }
            if ((val = this.metadata.get("title")) != null) {
                ds.putProperty("TITLE", String.valueOf(val));
            }
            if ((sunits = (String)this.metadata.get("units")) != null && sunits.contains("since")) {
                try {
                    Units u = Units.lookupTimeUnits(sunits);
                    ds.putProperty("UNITS", u);
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if (isIstp) {
                assert (interpretedMetadata != null);
                interpretedMetadata.remove("DEPEND_0");
                interpretedMetadata.remove("DEPEND_1");
                interpretedMetadata.remove("DEPEND_2");
                DataSetUtil.putProperties(interpretedMetadata, ds);
            }
            try {
                AttributeTable at = this.das.getAttributeTable(this.variable);
                ds.putProperty("METADATA", at);
            }
            catch (NoSuchAttributeException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
            if (DataSetURI.fromUri(this.uri).contains(".cdf.dds")) {
                ds.putProperty("METADATA_MODEL", "ISTP-CDF");
            }
            MutablePropertyDataSet mutablePropertyDataSet = ds;
            return mutablePropertyDataSet;
        }
        finally {
            logger.exiting("org.virbo.dods.DodsDataSource", "getDataSet");
            mon.finished();
        }
    }

    @Override
    public MetadataModel getMetadataModel() {
        if (DataSetURI.fromUri(this.uri).contains(".cdf.dds")) {
            return new IstpMetadataModel();
        }
        return super.getMetadataModel();
    }

    protected Map<String, Object> getMetaData(String variable) {
        try {
            AttributeTable at = this.das.getAttributeTable(variable);
            return this.getMetadata(at);
        }
        catch (NoSuchAttributeException ex) {
            return Collections.emptyMap();
        }
    }

    private Map<String, Object> getMetadata(AttributeTable at) {
        if (at == null) {
            return new HashMap<String, Object>();
        }
        Pattern p = Pattern.compile("DEPEND_[0-9]");
        Pattern p2 = Pattern.compile("LABL_PTR_([0-9])");
        Enumeration n = at.getNames();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (n.hasMoreElements()) {
            Object key = n.nextElement();
            Attribute att = at.getAttribute((String)key);
            try {
                Map<String, Object> newVal;
                Object name;
                Object val;
                int type = att.getType();
                if (type == 2) {
                    val = this.getMetadata(att.getContainer());
                    result.put(att.getName(), val);
                    continue;
                }
                val = att.getValueAt(0);
                val = DataSourceUtil.unquote((String)val);
                if (p.matcher(att.getName()).matches()) {
                    name = val;
                    newVal = this.getMetaData((String)name);
                    newVal.put("NAME", name);
                    result.put(att.getName(), newVal);
                    continue;
                }
                Matcher m = p2.matcher(att.getName());
                if (m.matches()) {
                    name = val;
                    newVal = this.getMetaData((String)name);
                    newVal.put("NAME", name);
                    result.put("DEPEND_" + m.group(1), newVal);
                    continue;
                }
                if (((String)val).length() > 0) {
                    result.put(att.getName(), val);
                    continue;
                }
                logger.log(Level.FINE, "skipping {0}  because length=0", att.getName());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, null, e);
            }
        }
        return result;
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws IOException, DASException, opendap.dap.parser.ParseException {
        if (this.metadata == null) {
            MyDASParser parser = new MyDASParser();
            URL url = new URL(this.adapter.getSource().toString() + ".das");
            logger.log(Level.FINE, "getMetadata opening {0}", url);
            try (InputStream in = url.openStream();){
                parser.parse(in);
                this.das = parser.getDAS();
                if (this.variable == null) {
                    this.variable = (String)this.das.getNames().nextElement();
                    this.adapter.setVariable(this.variable);
                }
                this.metadata = this.getMetaData(this.variable);
            }
        }
        return this.metadata;
    }
}

